#ifndef _GS_H
#define _GS_H

/* RWPUBLIC */

/* Set of #defines to make the gs code more readable */

/* General purpose registers */
#define GS_PRIM     0x00
#define GS_RGBAQ    0x01
#define GS_ST       0x02
#define GS_UV       0x03
#define GS_XYZF2    0x04
#define GS_XYZ2     0x05
#define GS_TEX0_1   0x06
#define GS_TEX0_2   0x07
#define GS_CLAMP_1  0x08
#define GS_CLAMP_2  0x09
#define GS_FOG      0x0a
#define GS_XYZF3    0x0c
#define GS_XYZ3     0x0d
#define GS_TEX1_1   0x14
#define GS_TEX1_2   0x15
#define GS_TEX2_1   0x16
#define GS_TEX2_2   0x17
#define GS_XYOFFSET_1   0x18
#define GS_XYOFFSET_2   0x19
#define GS_PRMODECONT   0x1a
#define GS_PRMODE   0x1b
#define GS_TEXCLUT  0x1c
#define GS_SCANMSK  0x22
#define GS_MIPTBP1_1    0x34
#define GS_MIPTBP1_2    0x35
#define GS_MIPTBP2_1    0x36
#define GS_MIPTBP2_2    0x37
#define GS_TEXA     0x3b
#define GS_FOGCOL   0x3d
#define GS_TEXFLUSH 0x3f
#define GS_SCISSOR_1    0x40
#define GS_SCISSOR_2    0x41
#define GS_ALPHA_1  0x42
#define GS_ALPHA_2  0x43
#define GS_DIMX     0x44
#define GS_DTHE     0x45
#define GS_COLCLAMP 0x46
#define GS_TEST_1   0x47
#define GS_TEST_2   0x48
#define GS_PABE     0x49
#define GS_FBA_1    0x4a
#define GS_FBA_2    0x4b
#define GS_FRAME_1  0x4c
#define GS_FRAME_2  0x4d
#define GS_ZBUF_1   0x4e
#define GS_ZBUF_2   0x4f
#define GS_BITBLTBUF    0x50
#define GS_TRXPOS   0x51
#define GS_TRXREG   0x52
#define GS_TRXDIR   0x53
#define GS_HWREG    0x54
#define GS_SIGNAL   0x60
#define GS_FINISH   0x61
#define GS_LABEL    0x62
/*  Only present in sim */
#define GS_RFSHWIN  0x7f

/*  pixel modes */
#define PSMCT32     0x00
#define PSMCT24     0x01
#define PSMCT16     0x02
#define PSMCT16S    0x0a
#define PSMT8       0x13
#define PSMT4       0x14
#define PSMT8H      0x1b
#define PSMT4HL     0x24
#define PSMT4HH     0x2c
#define PSMZ32      0x30
#define PSMZ24      0x31
#define PSMZ16      0x32
#define PSMZ16S     0x3a

/* Note that in PSMCT16, PDMZ16 mode, only PSMZ16 zbuffers may be configured
   In all other modes only PSMZ16 zbuffers may not be configured */

/* RWPUBLICEND */

#if defined(GSB) && defined(GSPLUS)
#define GS_TEX3_1   0x20
#define GS_TEX3_2   0x21
#define GS_MIPTBP3_1    0x38
#define GS_MIPTBP3_2    0x39
#define GS_MIPTBP4_1    0x3a
#define GS_MIPTBP4_2    0x3c
#define GS_FRAME2_1  0x55
#define GS_FRAME2_2  0x56
#define GS_ZBUF2_1   0x57
#define GS_ZBUF2_2   0x58
#define GS_BITBLTBUF2    0x59
#endif /* defined(GSB) && defined(GSPLUS) */

/* RWPUBLIC */
#if (!defined(RXPIPELINE))
#define RXPIPELINE
#endif /* (!defined(RXPIPELINE)) */
/* RWPUBLICEND */

#endif /* _GS_H */
