//	===========================================================================
//	mwUtils_PS2AT.c			2000 Metrowerks Inc. All rights reserved.
//	===========================================================================
//
//	Metrowerks Utilities
//
//	Version.1.0
//
//	10/20/2000	kashima,	new

/*******************************************************************************
	INCLUDE
*******************************************************************************/
/*	OS dependent header	*/
//#include <eekernel.h>
//#include <eeregs.h>
#include <sifdev.h>
/*	STANDARD header	*/
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#ifdef __IOP__
#include <stdio.h>
#include <file.h>
#endif

/*	PROJECT header	*/
#include "mwUtils_PS2AT.h"

/*******************************************************************************
	DEFINE
*******************************************************************************/

#define	FILENAME_FOR_PRINTF	"mwAtLog.txt"	//	must not change this file name

/*******************************************************************************
	TYPEDEF
*******************************************************************************/

/*******************************************************************************
	PROTOTYPE
*******************************************************************************/

/*******************************************************************************
	EXTERN
*******************************************************************************/

#ifdef __cplusplus
extern	"C"	{
#endif

#ifdef __cplusplus
}
#endif	/* __cplusplus */

/*******************************************************************************
	VARIABLE
*******************************************************************************/

static	char	mwAtRFPPrefix[24];
static	int		mwAtStdIOPort;

/*******************************************************************************
	FUNCTION
*******************************************************************************/

/*------------------------------------------------------------------------------
 *	mwAtInit
 *	initialize MW artist tool utility
------------------------------------------------------------------------------*/
void
mwAtInit(const char *argv0)
{
	//	get RFP server information
	char*	pStr	= strtok((char*)argv0, ",");
	if (pStr == NULL)
		strcpy(mwAtRFPPrefix, "");	//	to avoid crash
	else
		strcpy(mwAtRFPPrefix, pStr);
	//	initialize the port for printf
#ifdef __IOP__
	mwAtStdIOPort   = mwAtOpen(FILENAME_FOR_PRINTF, O_RDWR|O_CREAT|O_TRUNC);
#else
	mwAtStdIOPort	= mwAtOpen(FILENAME_FOR_PRINTF, SCE_CREAT|SCE_TRUNC|SCE_RDWR);
#endif

}


/*------------------------------------------------------------------------------
 *	mwAtExit
 *	cleanup MW artist tool utility
------------------------------------------------------------------------------*/
void
mwAtExit(void)
{
	mwAtClose    (mwAtStdIOPort);
}

#pragma	mark	-

/*------------------------------------------------------------------------------
 *	mwAtOpen
 *	open file
------------------------------------------------------------------------------*/
int
mwAtOpen(char *filename, int flag)
{
	char	path[512];
	sprintf(path, "%s,%s", mwAtRFPPrefix, filename);
#ifdef __IOP__
	return	open(path, flag);
#else
	return	sceOpen(path, flag);
#endif
}

/*------------------------------------------------------------------------------
 *	mwAtPrintf
 *	printf for artist tool monitor
------------------------------------------------------------------------------*/
void
mwAtPrintf(const char *fmt, ...)
{
#ifdef __IOP__
#pragma unused (fmt)
#else
	char	str[512];
	va_list	arg;

//	make the string to write
	va_start(arg, fmt);
	vsprintf(str, fmt, arg);
	va_end(ap);
	
//	write to the port
	mwAtWrite(mwAtStdIOPort, str, (int)(strlen(str)+1));
#endif
}

/*------------------------------------------------------------------------------
 *	mwAtClose
 *	close file
------------------------------------------------------------------------------*/
void
mwAtClose()
{
#ifdef __IOP__
	close(mwAtStdIOPort);
#else
	sceClose(mwAtStdIOPort);
#endif
}

/*------------------------------------------------------------------------------
 *	mwAtGetFd
 *	return fd of log file (used only for IOP)
------------------------------------------------------------------------------*/
int mwAtGetFd()
{
	return mwAtStdIOPort;
}
