function OnAfterSceneLoaded(self)
  self.map = Input:CreateMap("CameraMap")
  self.w, self.h = Screen:GetViewportSize()
  
  -- touch triggers
  self.map:MapTrigger("Orbit", {0, 0, self.w, self.h}, "CT_TOUCH_ANY")
  self.map:MapTrigger("X", {0, 0, self.w, self.h}, "CT_TOUCH_NORM_X")
  self.map:MapTrigger("Y", {0, 0, self.w, self.h}, "CT_TOUCH_NORM_Y")
    
  -- mouse input (windows)
  self.map:MapTrigger("X", "MOUSE", "CT_MOUSE_NORM_X")
  self.map:MapTrigger("Y", "MOUSE", "CT_MOUSE_NORM_Y")
  self.map:MapTrigger("Orbit", "MOUSE", "CT_MOUSE_LEFT_BUTTON")
  
  -- trigger for WASD keys
  self.map:MapTrigger("UP", "KEYBOARD", "CT_KB_W")
  self.map:MapTrigger("LEFT", "KEYBOARD", "CT_KB_A")
  self.map:MapTrigger("DOWN", "KEYBOARD", "CT_KB_S")
  self.map:MapTrigger("RIGHT", "KEYBOARD", "CT_KB_D")
end

function OnBeforeSceneUnloaded(self)
  Input:DestroyMap(self.map);
end

function OnThink(self)
  
  local orbitTouch = self.map:GetTrigger("Orbit")>0
  local orbitKB = self.map:GetTrigger("RIGHT")>0 or 
    self.map:GetTrigger("LEFT")>0 or
    self.map:GetTrigger("UP")>0 or
    self.map:GetTrigger("DOWN")>0

  if orbitTouch or orbitKB then

    local speed = 80 * Timer:GetTimeDiff()
    local x = self.map:GetTrigger("X")
    local y = self.map:GetTrigger("Y")
    local orientation = self:GetOrientation()

    if (orbitTouch and x > 0.85) or (orbitKB and self.map:GetTrigger("RIGHT")>0) then
      orientation.x = orientation.x + speed
    end
    if (orbitTouch and x  < 0.15) or (orbitKB and self.map:GetTrigger("LEFT")>0) then
      orientation.x = orientation.x - speed
    end
    if (orbitTouch and y < 0.15 and orientation.y < 55) or (orbitKB and self.map:GetTrigger("UP")>0) then
      orientation.y = orientation.y + speed
    end
    if (orbitTouch and y > 0.85 and orientation.y > 15) or (orbitKB and self.map:GetTrigger("DOWN")>0) then
      orientation.y = orientation.y - speed
    end
    
    self:SetOrientation(orientation)
  end

end
