#
# Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
# prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
# Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
#

#! /usr/bin/env python

###

import os
import re
import sys
from havokDomClass import hkcToDom
import generateReflections
import reflectionDatabase
from havokDomClass import domToClass
import warnings
import util

_tkbms = """// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : %s
// PRODUCT    : %s
// VISIBILITY : %s
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Compat/hkCompat.h>
#include <Common/Base/Reflection/hkClass.h>
#include <Common/Base/Reflection/hkInternalClassMember.h>

#include <Common/Compat/Deprecated/Compat/hkHavokAllClasses.h>

namespace %s
{
\tconst char VersionString[] = \"hk_%s\";
\tconst int ClassVersion = %i;
"""

def processDir(where, options):

    projectList = generateReflections.findProjectsDown(where)
    
##
    nfile = 0
    cpplist = []

    manifest = hkcToDom.Document("Manifest")
    manifest.file = hkcToDom.File()
    manifest.file.visibility = "PUBLIC"

    #reflected_docs = []
    for project_dir in projectList:
        DBObject = reflectionDatabase.createDatabase(project_dir)
        for doc in [doc for doc in DBObject.getDocuments() if doc.file.product != "NONE" and doc.file.platform != "NONE" and doc.origfilename.find("UnitTest") == -1]:
            manifest.file.mergeWith(doc.file)

    cpplist.append( domToClass.domToClass(manifest, collectAll=True))
            
    if options.output:
        outfile = open(options.output,"w")
    else:
        outfile = None
    cpptxt = "\n".join(cpplist)
    symbols = [ s for s in re.findall(r"^hkClass\s+([^\(]+)\s*\($(?m)", cpptxt) ]
    symbols.sort()
    cpptxt = re.sub("\s*//.*(?m)","", cpptxt)
    cpptxt = re.sub("^extern\s+hkClass\s+.*(?m)","", cpptxt)
    cpptxt = re.sub("\n\s*\n","\n", cpptxt)
    namespace = "hkHavok%sClasses" % options.version_suffix.replace("_","")

    # e.g. options.version_suffix = "_201010r1"    
    versionNumString = "%s.%s.%s" % (options.version_suffix[1:5], options.version_suffix[5], options.version_suffix[6] )
    versionStage = options.version_suffix[7:9]
    if versionStage is not "":
        versionNumString = "-".join( [versionNumString, versionStage] )

    listname = "Classes"
    print >>outfile, _tkbms % ("ALL","ALL","PUBLIC",namespace,versionNumString,int(options.class_version))
    print >>outfile, "\n".join( ["\textern hkClass %s;"%s.replace("(",";") for s in symbols])
    print >>outfile, cpptxt.replace("\n","\n\t")[:-1]
    print >>outfile, "\tstatic hkClass* const %s[] =\n\t{\n%s\n\t\tHK_NULL\n\t}; " % ( listname,
        "\n".join(["\t\t&%s,"%s for s in symbols] ) )
    print >>outfile, "\tconst hkStaticClassNameRegistry hkHavokDefaultClassRegistry\n\t(\n\t\tClasses,\n\t\tClassVersion,\n\t\tVersionString\n\t);"
    print >>outfile, "".join( ["\n} // namespace ", namespace, "\n" ] )
    if not options.quiet:
        print >>sys.stderr, "DONE", where, nfile, "files processed"

USAGE = """%prog <WHERE>...

Recursively searches WHERE for class information.
Generates FILE.hkclass for each file found."""

def main(argv):
    import optparse
    parser = optparse.OptionParser(usage=USAGE)
    parser.add_option("-v", "--verbose", action="store_true", default=False, help="Verbose execution")
    parser.add_option("-q", "--quiet", action="store_true", default=False, help="Quiet execution")
    parser.add_option("-o", "--output", action="store", default=None, help="Output filename")
    parser.add_option("--version-suffix", default="", help="Enable versioning mode")
    parser.add_option("--class-version", default="-1", help="Class version number")

    options, args = parser.parse_args(argv)
    if not options.version_suffix:
        parser.error("No version suffix given.")

    for arg in args:
        if os.path.isdir(arg):
            processDir(arg, options)
        else:
            warnings.warn("'%s' is not a directory, skipping." % arg)
    if len(args) == 0:
        parser.error("No search path given.")

if __name__=="__main__":
    main(sys.argv[1:])


#
# Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
# 
# Confidential Information of Havok.  (C) Copyright 1999-2010
# Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
# Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
# rights, and intellectual property rights in the Havok software remain in
# Havok and/or its suppliers.
# 
# Use of this software for evaluation purposes is subject to and indicates
# acceptance of the End User licence Agreement for this product. A copy of
# the license is included with this software and is also available at www.havok.com/tryhavok.
# 
#
