

' This script processes all XSI files in the chosen directory and its subdirectories

Sub processFile( file, log )

	' open the scene
	OpenScene file.Path, false

    ' override HKO file if required
    Dim batchHkoFile
    batchHkoFile = "D:/Dropbox/ProjectWater/3DSMax/Collision.hko"
    If Len(batchHkoFile) > 0 Then
            Dim optionsNode
            Set optionsNode = hkCmdGetExportOptions()
            optionsNode.Parameters( "useHko" ).Value = true
            optionsNode.Parameters( "hkoFile" ).Value = batchHkoFile            
    End If

    ' export in batch mode
    If hkCmdExportScene( true ) Then
            log.WriteLine( "Processed: " & file.Path )
            
            ' May need to save any changes
            If 0 Then
                SaveScene
            End If
        Else
            log.WriteLine( "Failed to process: " & file.Path )
        End If

End Sub

Sub processFolder( folder, log )

    ' process any XSI scene files
    Dim files: Set Files = folder.Files
    Dim file
    For Each file In files
            If StrComp( file.Type, "XSI Scene file", 1 ) = 0 Then
                processFile file, log
            End If
            Next

    ' process any subfolders
    Dim subFolders: Set subFolders = folder.SubFolders
    Dim subFolder
    For Each subFolder In subFolders
            processFolder subFolder, log
            Next

End Sub

Sub hkxBatchProcess( rootPath )
	
	LogMessage( "Parsing directory tree for XSI files" )
	
	Dim fso, log
	Set fso = CreateObject( "Scripting.FileSystemObject" )
	Set log = fso.CreateTextFile( "xsiScriptOutput.txt" )
	
	processFolder fso.GetFolder( rootPath ), log
	
	LogMessage( "Processing complete" )
	
End Sub

' process the contents of the specified directory
hkxBatchProcess "D:/Dropbox/ProjectWater/3DSMax/collision"

' shut down XSI
Quit

