

-- This script processes all 3ds Max files in the chosen directory and its subdirectories.

-- A list of all the directories that may contain 3ds Max files.
global directoryArray = #("D:/Dropbox/ProjectWater/3DSMax/collision")

-- Search the specified root directory and its subdirectories for 3ds Max files.
fn getAllDirectoriesRecursive root = 
( 
	-- Get a list of immediate directories (i.e. those in the current directory).
	immDirectories = getDirectories ( root + "/*" )
	
	-- Create an empty list to fill with immediate directories with the trailing '\' removed.
	subStringArray = #()
	
	-- If there are any directories in our list...
	if( immDirectories.count != 0 ) then
	(
		-- Remove any trailing '\' characters and add the directory to the list.
		for d in immDirectories do
		(
			dirNameLength = d.count
			directorySubString = substring d 1 ( dirNameLength-1 )
			append subStringArray directorySubString
		)
	
		-- Add the list of directories to the overall list.
		join directoryArray subStringArray
	
		-- Look for more directories in all the directories that were just found.
		for d in subStringArray do
		(
			getAllDirectoriesRecursive( d )
		)
	)
)

-- Create a log file to show which files were processed.
outlog = createFile "maxBatchScriptOutput.txt"
format "\nThe following .max files were processed:" to:outlog
format "\n----------------------------------------\n" to:outlog

-- Get a list of all the directories to look for 3ds Max files in.
print "Generating directory list ...\n"
getAllDirectoriesRecursive "D:/Dropbox/ProjectWater/3DSMax/collision"

-- Process any 3ds Max files found in the directories.
print "Searching for Max files in directory list ...\n"

-- Check each directory for 3ds Max files.
for d in directoryArray do
(
	-- Look for files that end in '.max'.
	for fileName in getFiles ( d + "/*.max" ) do
	(
		name = getFileNameFile fileName
		format "Found file '%' in directory '%'\n" name d to:outlog
	)
	
	-- Process files that end in '.max'.
	for fileName in getFiles ( d + "/*.max" ) do
	(
		-- filename without extension
		name = getFileNameFile fileName

		-- Load the file.
		loadMaxFile fileName useFileUnits:true

		-- Set HKO file if required
		optionsFile = "D:/Dropbox/ProjectWater/3DSMax/Collision.hko"
		if( optionsFile.count > 0 ) then
		(
			hkSceneExportUtility.useOptionsFile = TRUE
			hkSceneExportUtility.optionsFile = optionsFile
		)

		-- Export the file and display the results (true == batchMode)
		if ( ( hkSceneExportUtility.exportScene true ) == TRUE ) then
		(
			format "Processed file '%' in directory '%'\n" fileName d to:outlog

			-- Save any changes to the asset file (caused by specifying a separate options file of using a hkupgrade.hko file).
			if ( 0 != 0 ) then
			(
				saveMaxFile filename
			)
		)
		else
		(
			format "Failed to process file '%' in directory '%'\n" fileName d to:outlog
		)
	)
)

-- Processing complete ... close 3ds Max.
quitMax() #noprompt

