/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

// Destruction specific product patches.
// This file is #included by hkdPatches.cpp

//=======
// 650b1
//=======

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdRemoveWeakConnectionsAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED_REAL("minRelativeArea", 0.100000f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdRaycastGun", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkpFirstPersonGun")
	HK_PATCH_MEMBER_ADDED_REAL("destructionRadius", 0.600000f)
	HK_PATCH_MEMBER_ADDED("forceRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("mass", 1000.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("velocity", 20.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("angImpulseFactor", 0.400000f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkpFirstPersonGun", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdMissileGun", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkpProjectileGun")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkpFirstPersonGun", 0)
	HK_PATCH_DEPENDS("hkpProjectileGun", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdFlexibleJointController", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdController")
	HK_PATCH_MEMBER_ADDED_REAL("activationStrength", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("inertiaMultiplier", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxInertiaRatio", 10.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("connectToType", 1)
	HK_PATCH_MEMBER_ADDED("supportJoints", TYPE_STRUCT, "hkdFlexibleJointControllerJointDef", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdFlexibleJointControllerJointDef", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdController", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdGrenadeGun", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkpProjectileGun")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkpFirstPersonGun", 0)
	HK_PATCH_DEPENDS("hkpProjectileGun", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdExplosionForceAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED_VEC_4("explosionCenter", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("velocity", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("expandingVelocity", 20.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("virtMass", 1000.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("angularImpulseFactor", 0.200000f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDebrisFracture", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdFracture")
	HK_PATCH_MEMBER_ADDED_REAL("gap", 0.000000f)
	HK_PATCH_MEMBER_ADDED("templateDebris", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_DEPENDS("hkdFracture", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdSplitInHalfController", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdController")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdController", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdFlexibleJointControllerJointDef", 0)
	HK_PATCH_MEMBER_ADDED_REAL("coneAngle", 20.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("twistAngle", 20.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("planeAngle", 3.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("relBendingStrength", 20.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("limitStiffness", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("relBreakingStrength", 10.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("dropConstraintOnBreakage", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdSphereGun", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkpProjectileGun")
	HK_PATCH_MEMBER_ADDED("sphereGeometry", TYPE_OBJECT, "hkdGeometry", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdGeometry", 0)
	HK_PATCH_DEPENDS("hkpFirstPersonGun", 0)
	HK_PATCH_DEPENDS("hkpProjectileGun", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdVoronoiFracture", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdFracture")
	HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkdGeometry", 0)
	HK_PATCH_MEMBER_ADDED("pivots", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkdFracture", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdGeometry", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdStickyGun", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkpProjectileGun")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkpFirstPersonGun", 0)
	HK_PATCH_DEPENDS("hkpProjectileGun", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdGrenadeGunBlueprint", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkdWeaponBlueprint", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("maxProjectiles", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("reloadTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdWeaponBlueprint", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdWeaponBlueprint", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("keyboardKey", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBallGunBlueprint", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkdWeaponBlueprint", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("bulletRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("bulletVelocity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("bulletMass", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("damageMultiplier", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("maxBulletsInWorld", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdWeaponBlueprint", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdCompoundBreakableBodyBlueprint", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("attachToNearbyObjects", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("controller", TYPE_OBJECT, "hkdController", 0)
	HK_PATCH_MEMBER_REMOVED("groupName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdController", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdGravityGunBlueprint", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkdWeaponBlueprint", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("maxNumObjectsPicked", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("maxMassOfObjectPicked", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("maxDistOfObjectPicked", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("impulseAppliedWhenObjectNotPicked", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("throwVelocity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("capturedObjectPosition", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("capturedObjectsOffset", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdWeaponBlueprint", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdChangeMassGunBlueprint", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkdWeaponBlueprint", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("massChangeRatio", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("maxDistOfObjectPicked", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdWeaponBlueprint", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBody", 0, "hkdBody", 1)
	HK_PATCH_MEMBER_REMOVED("findInitialContactPoints", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBody", 1, "hkdBody", 2)
	HK_PATCH_MEMBER_ADDED("attributes", TYPE_ARRAY_STRUCT, "hkxAttribute", 0)
	HK_PATCH_DEPENDS("hkxAttribute", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableBodyBlueprint", 0, "hkdBreakableBodyBlueprint", 1)
	HK_PATCH_MEMBER_REMOVED("findInitialContactPoints", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableBody", 0, "hkdBreakableBody", 1)
	HK_PATCH_PARENT_SET("hkReferencedObject", "hkpBreakableBody")
	HK_PATCH_MEMBER_ADDED("properties", TYPE_STRUCT, "hkdProperties", 0)
	HK_PATCH_DEPENDS("hkdProperties", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableShape", 0, "hkdBreakableShape", 1)
	HK_PATCH_MEMBER_RENAMED("breakingPropogationRate", "breakingPropagationRate")
	HK_PATCH_MEMBER_ADDED_BYTE("flexibleJointType", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("qualityType", 0)
	HK_PATCH_MEMBER_ADDED("properties", TYPE_STRUCT, "hkdProperties", 0)
	HK_PATCH_MEMBER_ADDED("actions", TYPE_ARRAY_OBJECT, "hkdAction", 0)
	HK_PATCH_MEMBER_ADDED_INT("userData", 0)
	HK_PATCH_DEPENDS("hkdProperties", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdWoodFracture", 0, "hkdWoodFracture", 1)
	HK_PATCH_MEMBER_RENAMED("flattenHierarchy", "old_flattenHierarchy")
	HK_PATCH_FUNCTION(hkdWoodFracture_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_flattenHierarchy", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkdFracture", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdWoodFracture", 1, "hkdWoodFracture", 2)
	HK_PATCH_DEPENDS("hkdWoodFractureSplittingData", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdWoodFractureSplittingData", 0, "hkdWoodFractureSplittingData", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("rotateSplitGeom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdShape", 0, "hkdShape", 1)
	HK_PATCH_MEMBER_RENAMED("breakingPropogationRate", "breakingPropagationRate")
	HK_PATCH_MEMBER_ADDED_BOOL("flattenChildCompounds", true)
	HK_PATCH_MEMBER_ADDED_BYTE("bodyQualityType", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("flexibleJointType", 0)
	HK_PATCH_MEMBER_ADDED("attributes", TYPE_ARRAY_STRUCT, "hkxAttribute", 0)
	HK_PATCH_DEPENDS("hkxAttribute", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdSliceFracture", 0, "hkdSliceFracture", 1)
	HK_PATCH_MEMBER_RENAMED("childFracture", "old_childFracture")
	HK_PATCH_FUNCTION(hkdSliceFracture_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_childFracture", TYPE_OBJECT, "hkdFracture", 0)
	HK_PATCH_DEPENDS("hkdFracture", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdFracture", 0, "hkdFracture", 1)
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_BYTE("flattenHierarchy", 0)
	HK_PATCH_MEMBER_ADDED("childFracture", TYPE_OBJECT, "hkdFracture", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdSplitInHalfFracture", 0, "hkdSplitInHalfFracture", 1)
	HK_PATCH_MEMBER_RENAMED("flattenHierarchy", "old_flattenHierarchy")
	HK_PATCH_FUNCTION(hkdSplitInHalfFracture_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_flattenHierarchy", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkdFracture", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDeformationController", 0, "hkdDeformationController", 1)
	HK_PATCH_MEMBER_ADDED_REAL("strength", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionFractureFaceInfo2", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdDecorateFractureFaceActionFractureFaceInfo")
	HK_PATCH_MEMBER_ADDED("maxSlope", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionFractureFaceInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_MEMBER_ADDED("decorations", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED_REAL("density", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("gap", 0.000000f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceAction", 0)
	HK_PATCH_MEMBER_ADDED_VEC_4("upDir", 0.000000f,1.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED("frontDir", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("vertGridDist", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("vertGridOffset", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("horGridDist", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("horGridOffset", 0.000000f)
	HK_PATCH_MEMBER_ADDED("top", TYPE_STRUCT, "hkdDecorateFractureFaceActionFractureFaceInfo2", 0)
	HK_PATCH_MEMBER_ADDED("bottom", TYPE_STRUCT, "hkdDecorateFractureFaceActionFractureFaceInfo2", 0)
	HK_PATCH_MEMBER_ADDED("right", TYPE_STRUCT, "hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_MEMBER_ADDED("left", TYPE_STRUCT, "hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionFractureFaceInfo2", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdFlexibleJointControllerJointDef", 0, "hkdFlexibleJointControllerJointDef", 1)
	HK_PATCH_MEMBER_ADDED_REAL("relPullingStrength", 1000.0f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDeformationController", 1, "hkdDeformationController", 2)
	HK_PATCH_MEMBER_ADDED_REAL("deformationRadius", 1.0f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdVoronoiFracture", 0, "hkdVoronoiFracture", 1)
	HK_PATCH_MEMBER_ADDED_REAL("graphicsOverlap", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceAction", 0, "hkdDecorateFractureFaceAction", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED_BYTE("decorationPivot", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdCutOutFracture", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdFracture")
	HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkdGeometry", 0)
	HK_PATCH_MEMBER_ADDED_REAL("expandShape", 0.001000f)
	HK_PATCH_MEMBER_ADDED("cutoutShapes", TYPE_ARRAY_OBJECT, "hkpEntity", 0)
	HK_PATCH_DEPENDS("hkpEntity", 1)
	HK_PATCH_DEPENDS("hkdFracture", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdGeometry", 0)
	HK_PATCH_DEPENDS("hkpWorldObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdShapeInstanceInfoRuntimeInfo", 0, "hkdShapeInstanceInfoRuntimeInfo", 1)
	HK_PATCH_MEMBER_REMOVED("oldChildIdx", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDeformableBreakableShape", 0, "hkdDeformableBreakableShape", 1)
	HK_PATCH_MEMBER_ADDED("childKeys", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkdDeformableBreakableShape_addChildKeys)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecomposeFracture", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdFracture")
	HK_PATCH_MEMBER_ADDED("splittingGeometry", TYPE_OBJECT, "hkdGeometry", 0)
	HK_PATCH_MEMBER_ADDED_REAL("shiftToSmallerCrossSection", 0.100000f)
	HK_PATCH_MEMBER_ADDED_REAL("clipZoneWidth", 0.300000f)
	HK_PATCH_DEPENDS("hkdFracture", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdGeometry", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdRemoveDebrisAction", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
        HK_PATCH_MEMBER_ADDED_REAL("removeInSeconds", 10.000000f)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkdAction", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdBreakableShapeContactArea", 0)
	HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDebrisFracture", 0, "hkdDebrisFracture", 1)
		HK_PATCH_MEMBER_ADDED_BYTE("insertType", 2)
		HK_PATCH_MEMBER_ADDED_REAL("density", 1.0f)
		HK_PATCH_MEMBER_ADDED_INT("maxNumPieces", 100)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableShapeConnection", 0, "hkdBreakableShapeConnection",	   1)
		HK_PATCH_MEMBER_ADDED("contactAreaDetails", TYPE_OBJECT, "hkdBreakableShapeContactArea", 0)
		HK_PATCH_DEPENDS("hkdBreakableShapeContactArea", 0)
		HK_PATCH_FUNCTION(hkdBreakableShapeConnection_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdSetRigidBodyPropertiesAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED_BYTE("setCollisionFilter", 0)
	HK_PATCH_MEMBER_ADDED_INT("collisionFilterInfo", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("setDamping", 0)
	HK_PATCH_MEMBER_ADDED_REAL("linearDamping", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("angularDamping", 0.500000f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdShockWaveAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED("center", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("initialRadius", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxRadius", 100.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("thickness", 10.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("expandingVelocity", 30.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("damageMultiplier", 1.000000f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdSimpleShockWaveAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdShockWaveAction")
	HK_PATCH_MEMBER_ADDED_REAL("virtualMass", 100000.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("appliedVelocity", 100.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("forceFallOff", 1.400000f)
	HK_PATCH_MEMBER_ADDED_REAL("relCounterForce", 0.500000f)
	HK_PATCH_DEPENDS("hkdShockWaveAction", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDestructionDemoConfig", 0, "hkdDestructionDemoConfig", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("addFloor", 0)
	HK_PATCH_MEMBER_ADDED_INT("maxNumTimeoutDebrisPieces", (int)1000000)
	HK_PATCH_MEMBER_REMOVED("rotateLights", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDestructionDemoConfig", 1, "hkdDestructionDemoConfig", 2)
	HK_PATCH_MEMBER_ADDED_BOOL("createSharedVertexBuffer", true)
	HK_PATCH_MEMBER_ADDED_BYTE("enableInstancing", 0)
	HK_PATCH_MEMBER_ADDED_INT("minNumTimeoutDebrisPieces", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDestructionDemoConfig", 2, "hkdDestructionDemoConfig", 3)
	HK_PATCH_MEMBER_ADDED_BYTE("enableSSAO", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("enableBloom", 0)
	HK_PATCH_MEMBER_ADDED_REAL("fogDensity", 0.000000f)
	HK_PATCH_MEMBER_ADDED_CSTRING("skyBoxName", HK_NULL)
	HK_PATCH_MEMBER_ADDED_VEC_4("initialCharacterDirection", 0.0f, 0.0f, 1.0f, 0.0f)
	HK_PATCH_MEMBER_ADDED_VEC_4("lightFillColor", 0.3f, 0.3f, 0.3f, 1.0f)
	HK_PATCH_MEMBER_ADDED_VEC_4("lightRimColor", 0.2f, 0.2f, 0.2f, 1.0f)
	HK_PATCH_MEMBER_ADDED_VEC_4("clearColor", 0.53f,0.55f,0.61f, 1.0f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdBreakableBodyMemento", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED_INT("bodyId", 65535)
	HK_PATCH_MEMBER_ADDED_VEC_4("rotation", 0.000000f,0.000000f,0.000000f,1.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("translation", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("linearVelocity", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("angularVelocity", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdSimpleBreakableBodyMemento", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdBreakableBodyMemento")
	HK_PATCH_MEMBER_ADDED("path", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableBodyMemento", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdMeshSimplifierAction", 0, "hkdMeshSimplifierAction", 1)
	HK_PATCH_MEMBER_REMOVED("maxNumberOfVertices", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("minNumberOfVerticesPerShape", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_INT("maxNumberOfTriangles", 1000)
	HK_PATCH_MEMBER_ADDED_INT("minNumberOfTrianglesPerShape", 4)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdMeshSimplifierAction", 1, "hkdMeshSimplifierAction", 2)
	HK_PATCH_MEMBER_ADDED_BYTE("allowRootShapeSimplification", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDeformableBreakableBodyMemento", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdBreakableBodyMemento")
	HK_PATCH_MEMBER_ADDED("shapeIndices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transforms", TYPE_ARRAY_VEC_16, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableBodyMemento", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdCompoundBreakableBodyMemento", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdBreakableBodyMemento")
	HK_PATCH_MEMBER_ADDED("paths", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transforms", TYPE_ARRAY_VEC_16, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableBodyMemento", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableBodyBlueprint", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("rigidBodyName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("compoundId", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("fracture", TYPE_OBJECT, "hkdFracture", 0)
	HK_PATCH_MEMBER_REMOVED("dynamicFracture", TYPE_OBJECT, "hkdFracture", 0)
	HK_PATCH_MEMBER_REMOVED("controller", TYPE_OBJECT, "hkdController", 0)
	HK_PATCH_MEMBER_REMOVED("strength", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("relativeSubpieceStrength", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("breakingPropogationRate", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("attachToNearbyObjects", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("mergeCoplanarTriangles", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("destructionRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdFracture", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdController", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdShape", 1, "hkdShape", 2)
	HK_PATCH_FUNCTION(hkdShape_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdRemoveDebrisAction", 0, "hkdRemoveDebrisAction", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("removeOnTimeout", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdShapeInstanceInfoRuntimeInfo", 1, "hkdShapeInstanceInfoRuntimeInfo", 2)
	HK_PATCH_MEMBER_ADDED("parentUid", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdVoronoiFracture", 1, "hkdVoronoiFracture", 2)
	HK_PATCH_MEMBER_ADDED_INT("seed", 180673)
	HK_PATCH_MEMBER_ADDED_INT("numPointsToGenerate", 0)
	HK_PATCH_MEMBER_ADDED_INT("numIterations", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdRaycastGun", 0, "hkdRaycastGun", 1)
	// forceRadius was not used before so safe to just ignore
	HK_PATCH_MEMBER_REMOVED("forceRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("beamRadius", 0.1f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdControllerSmallArraySerializeOverrideType", 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("size", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("capacityAndFlags", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdIntegrityAnalyzerAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdMeshSimplifierAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED("maxNumberOfVertices", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("preferChildSimplification", 0.000000f)
	HK_PATCH_MEMBER_ADDED("minNumberOfVerticesPerShape", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_BYTE("allowRemovingShapes", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("avoidGaps", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdIntegrityAnalyzerAction", 0, "hkdIntegrityAnalyzerAction", 1)
	HK_PATCH_MEMBER_ADDED_REAL("breakingLength", 8.0f)
	HK_PATCH_MEMBER_ADDED_REAL("fracturePosition", 0.4f)
	HK_PATCH_MEMBER_ADDED_REAL("destructionRadius", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("delay", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("refineRadius", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDestructionDemoConfig", 3, "hkdDestructionDemoConfig", 4)
	HK_PATCH_MEMBER_ADDED_REAL("simplyfierPercentToRemove", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdShareVerticesAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED_INT("maxNumVerticesPerBuffer", 65535)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableBodySmallArraySerializeOverrideType", 0, "hkdBreakableBodySmallArraySerializeOverrideType", 1)
	HK_PATCH_MEMBER_REMOVED("data", TYPE_OBJECT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdControllerSmallArraySerializeOverrideType", 0, "hkdControllerSmallArraySerializeOverrideType", 1)
	HK_PATCH_MEMBER_REMOVED("data", TYPE_OBJECT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableShapeContactArea", 0, "hkdBreakableShapeContactArea", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDestructionDemoConfig", 4, "hkdDestructionDemoConfig", 5)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkdFracture", 1, "hkdFracture", 2)
	HK_PATCH_MEMBER_REMOVED("connectivityType", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableShape", 1, "hkdBreakableShape", 2)
	HK_PATCH_MEMBER_REMOVED("parent", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED("parent", TYPE_VOID, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdGeometry", 0, "hkdGeometry", 1)
	HK_PATCH_MEMBER_REMOVED("parent", TYPE_OBJECT, "hkdGeometry", 0)
	HK_PATCH_MEMBER_ADDED("parent", TYPE_VOID, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdCompoundBreakableShape", 0, "hkdCompoundBreakableShape", 1)
	HK_PATCH_MEMBER_REMOVED("rootBreakableShape", TYPE_OBJECT, "hkdCompoundBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED("rootBreakableShape", TYPE_VOID, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdSetRigidBodyPropertiesAction", 0, "hkdSetRigidBodyPropertiesAction", 1)
	HK_PATCH_MEMBER_ADDED_REAL("gravityFactor", 1.0f)
	HK_PATCH_MEMBER_ADDED_REAL("friction", 1.0f)
	HK_PATCH_MEMBER_ADDED_REAL("restitution", 0.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("setDeactivation", 0)
	HK_PATCH_MEMBER_ADDED_BOOL("enableDeactivation", true)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdBuildingController", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdController")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdController", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionDecorationPlacement", 0)
	HK_PATCH_MEMBER_ADDED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("rotation", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("graphicsSource", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 2)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionConnectionDecorationInfo", 0)
	HK_PATCH_MEMBER_ADDED("owningAction", TYPE_OBJECT, "hkdAction", 0)
	HK_PATCH_MEMBER_ADDED("otherShape", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED("decorations", TYPE_ARRAY_STRUCT, "hkdDecorateFractureFaceActionDecorationPlacement", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionDecorationPlacement", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 2)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdObjectPropertiesProperty", 0)
	HK_PATCH_MEMBER_ADDED("key", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("object", TYPE_OBJECT, "hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdObjectProperties", 0)
	HK_PATCH_MEMBER_ADDED("properties", TYPE_ARRAY_STRUCT, "hkdObjectPropertiesProperty", 0)
	HK_PATCH_DEPENDS("hkdObjectPropertiesProperty", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionShapeDecorationInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("connectionDecorations", TYPE_ARRAY_OBJECT, "hkdDecorateFractureFaceActionConnectionDecorationInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionConnectionDecorationInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableShape", 2, "hkdBreakableShape", 3)
	HK_PATCH_MEMBER_ADDED("objectProperties", TYPE_STRUCT, "hkdObjectProperties", 0)
	HK_PATCH_DEPENDS("hkdObjectProperties", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdShapeInstanceInfo", 0, "hkdShapeInstanceInfo", 1)
	HK_PATCH_MEMBER_ADDED("tempControllerData", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceAction", 1, "hkdDecorateFractureFaceAction", 2)
	HK_PATCH_MEMBER_REMOVED("frontDir", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("right", TYPE_STRUCT, "hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_MEMBER_REMOVED("left", TYPE_STRUCT, "hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_MEMBER_ADDED_REAL("minFractureLength", 0.1f)
	HK_PATCH_MEMBER_ADDED_BYTE("decorateWhat", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("alignDecorations", 0)
	HK_PATCH_MEMBER_ADDED("frontDirPolicy", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("controlShapes", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED_VEC_4("frontDirection", 1.0f, 0.0f, 0.0f, 0.0f)
	HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY("controlShapesTransform")
	HK_PATCH_MEMBER_ADDED("side", TYPE_STRUCT, "hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_MEMBER_ADDED("flat", TYPE_STRUCT, "hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdBreakableBodyShapeKeyToChild", 0)
	HK_PATCH_MEMBER_ADDED("keys", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("child", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 3)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableBody", 1, "hkdBreakableBody", 2)
	HK_PATCH_MEMBER_ADDED("shapeKeyToChild", TYPE_ARRAY_OBJECT, "hkdBreakableBodyShapeKeyToChild", 0)
	HK_PATCH_DEPENDS("hkdBreakableBodyShapeKeyToChild", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBody", 2, "hkdBody", 3)
	HK_PATCH_MEMBER_ADDED_BYTE("bodyType", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableBody", 2, "hkdBreakableBody", 3)
	HK_PATCH_MEMBER_ADDED("bodyType", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdGraphicsBody", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdGraphicsShape", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numChildTransforms", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdConvexDecompositionAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED_BYTE("method", 0)
	HK_PATCH_MEMBER_ADDED_REAL("tolerance", 0.010000f)
	HK_PATCH_MEMBER_ADDED_BYTE("reduce", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("self", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("recurse", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDebugLinesDebugLine", 0)
	HK_PATCH_MEMBER_ADDED("start", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("end", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("color", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdInfo")
	HK_PATCH_MEMBER_ADDED_BYTE("enableDecorations", 1)
	HK_PATCH_MEMBER_ADDED_INT("priority", 1)
	HK_PATCH_MEMBER_ADDED("decorations", TYPE_STRUCT, "hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionFractureFaceInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdGlueFixedPiecesAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED_REAL("allowedVolumeIncrease", 0.050000f)
	HK_PATCH_MEMBER_ADDED_REAL("minEdgeLength", 0.005000f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDebugLines", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("lines", TYPE_ARRAY_STRUCT, "hkdDebugLinesDebugLine", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdDebugLinesDebugLine", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionForwarder", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED("child", TYPE_OBJECT, "hkdDecorateFractureFaceAction", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceAction", 2)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionFractureFaceInfo2", 0, "hkdDecorateFractureFaceActionFractureFaceInfo2", 1)
	HK_PATCH_MEMBER_REMOVED("maxSlope", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceAction", 2, "hkdDecorateFractureFaceAction", 3)
	HK_PATCH_MEMBER_ADDED_REAL("maxProtrusion", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("fixupDistance", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("borderOverlap", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionFractureFaceInfo", 0, "hkdDecorateFractureFaceActionFractureFaceInfo", 1)
	HK_PATCH_MEMBER_ADDED_REAL("spinAngle", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("xShift", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("xRandomShift", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdCutOutFracture", 0, "hkdCutOutFracture", 1)
	HK_PATCH_MEMBER_REMOVED("cutoutShapes", TYPE_ARRAY_OBJECT, "hkpEntity", 0)
	HK_PATCH_MEMBER_ADDED("cutoutShapes", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED_BOOL("setFrameShapeFixed", true)
	HK_PATCH_MEMBER_ADDED_REAL("minPhysicsThickness", 0.01f)
	HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY("cutoutShapesTransform")
	HK_PATCH_MEMBER_ADDED_BOOL("copyDataFromCutouts", true)
	HK_PATCH_MEMBER_ADDED_BYTE("splitType", 0)
	HK_PATCH_DEPENDS("hkpEntity", 2)
	HK_PATCH_DEPENDS("hkpWorldObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdVoronoiFracture", 2, "hkdVoronoiFracture", 3)
	HK_PATCH_MEMBER_ADDED_BYTE("fixupOverlaps", 0)
	HK_PATCH_MEMBER_ADDED("voronoiSiteShapes", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY("voronoiSiteShapesTransform")
	HK_PATCH_MEMBER_ADDED_BOOL("copyDataFromSites", true)
	HK_PATCH_MEMBER_RENAMED("numPointsToGenerate", "numSitesToGenerate")
	HK_PATCH_DEPENDS("hkdBreakableShape", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableBody", 3, "hkdBreakableBody", 4)
	HK_PATCH_MEMBER_ADDED("objectProperties", TYPE_STRUCT, "hkdObjectProperties", 0)
	HK_PATCH_DEPENDS("hkdObjectProperties", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdSetRigidBodyPropertiesAction", 1, "hkdSetRigidBodyPropertiesAction", 2)
	HK_PATCH_MEMBER_ADDED_REAL("inertiaFactor", 1.0f)
	HK_PATCH_MEMBER_ADDED_BYTE("setMass", 0)
	HK_PATCH_MEMBER_ADDED_REAL("mass", 0.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("setFriction", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("setRestitution", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdShapeInstanceInfo", 1, "hkdShapeInstanceInfo", 2)
	HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdFlexibleJointControllerWatchConstraintAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkpBinaryAction")
	HK_PATCH_DEPENDS("hkpAction", 0)
	HK_PATCH_DEPENDS("hkpBinaryAction", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdConvexDecompositionAction", 0, "hkdConvexDecompositionAction", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("hollow", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("refine", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("moppThreshold", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionControlShape", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("controlBreakableShape", TYPE_STRUCT, "hkdShapeInstanceInfo", 0)
	HK_PATCH_MEMBER_ADDED("fractureInfo", TYPE_OBJECT, "hkdDecorateFractureFaceInfo", 0)
	HK_PATCH_MEMBER_ADDED("decorations", TYPE_ARRAY_STRUCT, "hkdShapeInstanceInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdShapeInstanceInfo", 2)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceInfo", 0)
	HK_PATCH_DEPENDS("hkdInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionControlShapes", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("rootPhysicsShape", TYPE_OBJECT, "hkpShape", 0)
	HK_PATCH_MEMBER_ADDED("rootControlShape", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED("rootControlShapeTransform", TYPE_VEC_16, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("controlShapes", TYPE_ARRAY_OBJECT, "hkdDecorateFractureFaceActionControlShape", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkpShape", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionControlShape", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 3)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionControlShapesCache", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("controlShapes", TYPE_ARRAY_OBJECT, "hkdDecorateFractureFaceActionControlShapes", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionControlShapes", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionConnections", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("connections", TYPE_ARRAY_STRUCT, "hkdBreakableShapeConnection", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShapeConnection", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecalMapActionDecalMap", 0)
	HK_PATCH_MEMBER_ADDED("textureW", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("textureH", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_ARRAY_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecalMapActionDecalMapData", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("decals", TYPE_ARRAY_OBJECT, "hkdDecalMapActionDecalMap", 0)
	HK_PATCH_MEMBER_ADDED("decors", TYPE_ARRAY_OBJECT, "hkdDecalMapActionDecalMap", 0)
	HK_PATCH_MEMBER_ADDED("decorInfo", TYPE_ARRAY_OBJECT, "hkdDecalMapActionDecorMapInfo", 0)
	HK_PATCH_MEMBER_ADDED("decorMapBaseIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdDecalMapActionDecalMap", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdDecalMapActionDecorMapInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecalMapActionDecorMapInfo", 0)
	HK_PATCH_MEMBER_ADDED("intersectingMaps", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecalMapAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdAction")
	HK_PATCH_MEMBER_ADDED_INT("xResolution", 64)
	HK_PATCH_MEMBER_ADDED_INT("yResolution", 64)
	HK_PATCH_MEMBER_ADDED_INT("uvChannel", 0)
	HK_PATCH_MEMBER_ADDED_REAL("extraRadius", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("softRadius", 1.000000f)
	HK_PATCH_MEMBER_ADDED("decorationShape", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED("decorationShapeTransform", TYPE_VEC_16, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_INT("xResolutionDecoration", 64)
	HK_PATCH_MEMBER_ADDED_INT("yResolutionDecoration", 64)
	HK_PATCH_MEMBER_ADDED_INT("uvChannelDecoration", 0)
	HK_PATCH_MEMBER_ADDED_REAL("extraRadiusDecoration", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("softRadiusDecoration", 1.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("enableDebugBitmapGeneration", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 3)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDebugLinesDebugText", 0)
        HK_PATCH_MEMBER_ADDED("pos", TYPE_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("string", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("color", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDebugLines", 0, "hkdDebugLines", 1)
	HK_PATCH_MEMBER_ADDED("texts", TYPE_ARRAY_STRUCT, "hkdDebugLinesDebugText", 0)
	HK_PATCH_DEPENDS("hkdDebugLinesDebugText", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdShape", 2, "hkdShape", 3)
	HK_PATCH_MEMBER_REMOVED("integrityType", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tensionLength", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableShape", 3, "hkdBreakableShape", 4)
	HK_PATCH_MEMBER_REMOVED("integrityType", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tensionLength", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDeformableBreakableShape", 1, "hkdDeformableBreakableShape", 2)
	HK_PATCH_MEMBER_ADDED("origChildTransformRotations", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("origChildTransformTranslations", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkdDeformableBreakableShape_1_to_2)
	HK_PATCH_MEMBER_REMOVED("origChildTransforms", TYPE_ARRAY_VEC_16, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdShapeInstanceInfo", 2, "hkdShapeInstanceInfo", 3)
	HK_PATCH_MEMBER_ADDED("translation", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("rotation", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkdShapeInstanceInfo_2_to_3)
	HK_PATCH_MEMBER_REMOVED("transform", TYPE_VEC_16, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdBreakableShapeConnectionList", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("connections", TYPE_ARRAY_STRUCT, "hkdBreakableShapeConnection", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShapeConnection", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdBreakableShapeActionList", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("actions", TYPE_ARRAY_OBJECT, "hkdAction", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdPropertyFlagSet", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("properties", TYPE_STRUCT, "hkdProperties", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdProperties", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdStringObject", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("string", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableShape", 4, "hkdBreakableShape", 5)
	HK_PATCH_MEMBER_ADDED_VEC_4("comAndMass", 0.000000f,0.000000f,0.000000f,1.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("typeAndFlags", 0)
	HK_PATCH_MEMBER_ADDED("inertiaAndValues", TYPE_STRUCT, "hkHalf8", 0)
	HK_PATCH_MEMBER_ADDED("majorAxisSpace", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkdBreakableShape_4_to_5)
	HK_PATCH_MEMBER_REMOVED("connections", TYPE_ARRAY_STRUCT, "hkdBreakableShapeConnection", 0)
	HK_PATCH_MEMBER_REMOVED("actions", TYPE_ARRAY_OBJECT, "hkdAction", 0)
	HK_PATCH_MEMBER_REMOVED("dynamicFracture", TYPE_OBJECT, "hkdFracture", 0)
	HK_PATCH_MEMBER_REMOVED("massProps", TYPE_STRUCT, "hkpMassProperties", 0)
	HK_PATCH_MEMBER_REMOVED("properties", TYPE_STRUCT, "hkdProperties", 0)
	HK_PATCH_MEMBER_REMOVED("graphicsShapeName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("flags", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("relativeSubpieceStrength", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("referenceShapeVolume", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("minDestructionRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("breakingPropagationRate", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkHalf8", 0)
	HK_PATCH_DEPENDS("hkdBreakableShapeConnectionList", 0)
	HK_PATCH_DEPENDS("hkdBreakableShapeActionList", 0)
	HK_PATCH_DEPENDS("hkpMassProperties", 0)
	HK_PATCH_DEPENDS("hkdBreakableShapeConnection", 1)
	HK_PATCH_DEPENDS("hkdAction", 0)
	HK_PATCH_DEPENDS("hkdFracture", 2)
	HK_PATCH_DEPENDS("hkdProperties", 0)
	HK_PATCH_DEPENDS("hkdObjectProperties", 0)
	HK_PATCH_DEPENDS("hkdStringObject", 0)
	HK_PATCH_DEPENDS("hkdPropertyFlagSet", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdBreakableBodyShapeKeyToChildMap", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("shapeKeyToChild", TYPE_ARRAY_OBJECT, "hkdBreakableBodyShapeKeyToChild", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableBodyShapeKeyToChild", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdBreakableBody", 4, "hkdBreakableBody", 5)
	HK_PATCH_MEMBER_ADDED_BYTE("bodyTypeAndFlags", 0)
	HK_PATCH_FUNCTION(hkdBreakableBody_4_to_5)
	HK_PATCH_MEMBER_REMOVED("attachToNearbyObjects", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("ancesterIntegrityUid", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("bodyType", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("properties", TYPE_STRUCT, "hkdProperties", 0)
	HK_PATCH_MEMBER_REMOVED("shapeKeyToChild", TYPE_ARRAY_OBJECT, "hkdBreakableBodyShapeKeyToChild", 0)
	HK_PATCH_DEPENDS("hkdBreakableBodyShapeKeyToChild", 0)
	HK_PATCH_DEPENDS("hkdBreakableBodyShapeKeyToChildMap", 0)
	HK_PATCH_DEPENDS("hkdProperties", 0)
	HK_PATCH_DEPENDS("hkdObjectProperties", 0)
	HK_PATCH_DEPENDS("hkdPropertyFlagSet", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionCornerDecorationInfo", 0)
	HK_PATCH_MEMBER_ADDED("decorations", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED_REAL("density", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("minimumDistance", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maximumVerticalShift", 0.000010f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 3)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateCornerInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkdInfo")
	HK_PATCH_MEMBER_ADDED_BYTE("enableCornerDecorations", 1)
	HK_PATCH_MEMBER_ADDED("cornerTemplates", TYPE_STRUCT, "hkdDecorateFractureFaceActionCornerDecorationInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionCornerDecorationInfo", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateCornerInfoContainer", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("infos", TYPE_ARRAY_OBJECT, "hkdDecorateCornerInfo", 0)
	HK_PATCH_DEPENDS("hkdDecorateCornerInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionControlShape", 0, "hkdDecorateFractureFaceActionControlShape", 1)
	HK_PATCH_MEMBER_ADDED("cornerInfos", TYPE_OBJECT, "hkdDecorateCornerInfoContainer", 0)
	HK_PATCH_DEPENDS("hkdDecorateCornerInfoContainer", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionCompressedDecorationPlacement", 0)
	HK_PATCH_MEMBER_ADDED("graphicsIdx", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pos", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("rot", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionConnections", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("connections", TYPE_ARRAY_STRUCT, "hkdBreakableShapeConnection", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShapeConnection", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionControlShape", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("controlBreakableShape", TYPE_STRUCT, "hkdShapeInstanceInfo", 0)
	HK_PATCH_MEMBER_REMOVED("fractureInfo", TYPE_OBJECT, "hkdDecorateFractureFaceInfo", 0)
	HK_PATCH_MEMBER_REMOVED("decorations", TYPE_ARRAY_STRUCT, "hkdShapeInstanceInfo", 0)
	HK_PATCH_MEMBER_REMOVED("cornerInfos", TYPE_OBJECT, "hkdDecorateCornerInfoContainer", 0)
	HK_PATCH_DEPENDS("hkdDecorateCornerInfoContainer", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdShapeInstanceInfo", 2)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceInfo", 0)
	HK_PATCH_DEPENDS("hkdInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionControlShapes", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("rootPhysicsShape", TYPE_OBJECT, "hkpShape", 0)
	HK_PATCH_MEMBER_REMOVED("rootControlShape", TYPE_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_REMOVED("rootControlShapeTransform", TYPE_VEC_16, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("controlShapes", TYPE_ARRAY_OBJECT, "hkdDecorateFractureFaceActionControlShape", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkpShape", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionControlShape", 1)
	HK_PATCH_DEPENDS("hkdBreakableShape", 4)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionControlShapesCache", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("controlShapes", TYPE_ARRAY_OBJECT, "hkdDecorateFractureFaceActionControlShapes", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionControlShapes", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDecorateFractureFaceActionGlobalDecorationData", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("templates", TYPE_ARRAY_OBJECT, "hkdBreakableShape", 0)
	HK_PATCH_MEMBER_ADDED("boundingBoxes", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdBreakableShape", 4)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionDecorationPlacement", 0, "hkdDecorateFractureFaceActionDecorationPlacement", 1)
	HK_PATCH_MEMBER_ADDED("rot", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkdDecorateFractureFaceActionDecorationPlacement_0_to_1)
	HK_PATCH_MEMBER_RENAMED("position", "pos")
	HK_PATCH_MEMBER_REMOVED("rotation", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("graphicsSource", TYPE_OBJECT, "hkdBreakableShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionConnectionDecorationInfo", 0, "hkdDecorateFractureFaceActionConnectionDecorationInfo", 1)
	HK_PATCH_MEMBER_ADDED("boxIndices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("compressedPlacements", TYPE_ARRAY_STRUCT, "hkdDecorateFractureFaceActionCompressedDecorationPlacement", 0)
	HK_PATCH_MEMBER_RENAMED("decorations", "placements")
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionCompressedDecorationPlacement", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionDecorationPlacement", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceActionShapeDecorationInfo", 0, "hkdDecorateFractureFaceActionShapeDecorationInfo", 1)
	HK_PATCH_MEMBER_ADDED("sharedData", TYPE_OBJECT, "hkdDecorateFractureFaceActionGlobalDecorationData", 0)
	HK_PATCH_FUNCTION(hkdDecorateFractureFaceActionShapeDecorationInfo_0_to_1)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionGlobalDecorationData", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionConnectionDecorationInfo", 1)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionDecorationPlacement", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceAction", 3, "hkdDecorateFractureFaceAction", 4)
	HK_PATCH_MEMBER_ADDED("corner", TYPE_STRUCT, "hkdDecorateFractureFaceActionCornerDecorationInfo", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("equalizeGaps", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("protrusionTest", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("compressDecorations", 1)
	HK_PATCH_FUNCTION(hkdDecorateFractureFaceAction_3_to_4)
	HK_PATCH_MEMBER_REMOVED("frontDirection", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("frontDirPolicy", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionCornerDecorationInfo", 0)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionShapeDecorationInfo", 1)
	HK_PATCH_DEPENDS("hkdDecorateFractureFaceActionDecorationPlacement", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdVoronoiFracture", 3, "hkdVoronoiFracture", 4)
	HK_PATCH_MEMBER_REMOVED("pivots", TYPE_ARRAY_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdRandomSplitFracture", 0, "hkdRandomSplitFracture", 1)
	HK_PATCH_MEMBER_ADDED_INT("randomSeed1", 123)
	HK_PATCH_MEMBER_ADDED_INT("randomSeed2", 456)
	HK_PATCH_MEMBER_ADDED_INT("randomSeed3", 789)
	HK_PATCH_MEMBER_ADDED_INT("randomSeed4", 101112)
	HK_PATCH_MEMBER_ADDED_REAL("randomRange", 1.000000f)
	HK_PATCH_FUNCTION(hkdRandomSplitFracture_0_to_1)
	HK_PATCH_MEMBER_REMOVED("randomSeed", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceAction", 4, "hkdDecorateFractureFaceAction", 5)
	HK_PATCH_MEMBER_ADDED_REAL("linearTolerance", 0.000100f)
	HK_PATCH_MEMBER_ADDED_REAL("angularTolerance", 0.000100f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDeformableBreakableShapeSkinShapeSection", 0)
	HK_PATCH_MEMBER_ADDED("indexBuffer", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDeformableBreakableShapeSkinShapeSectionInstance", 0)
	HK_PATCH_MEMBER_ADDED("key", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hkpShape", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkpShape", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDeformableBreakableShapeBoneDeformationData", 0)
	HK_PATCH_MEMBER_ADDED("weight", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("index", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDeformableBreakableShapeBoneInfo", 0)
	HK_PATCH_MEMBER_ADDED("modelSpaceBindPoseTransform", TYPE_STRUCT, "hkQTransform", 0)
	HK_PATCH_MEMBER_ADDED("softness", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkQTransform", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDeformableBreakableShapePhysicsSkinShape", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("bones", TYPE_ARRAY_STRUCT, "hkdDeformableBreakableShapeBoneInfo", 0)
	HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("deformationData", TYPE_ARRAY_STRUCT, "hkdDeformableBreakableShapeBoneDeformationData", 0)
	HK_PATCH_MEMBER_ADDED("sections", TYPE_ARRAY_OBJECT, "hkdDeformableBreakableShapeSkinShapeSection", 0)
	HK_PATCH_DEPENDS("hkQTransform", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkdDeformableBreakableShapeBoneInfo", 0)
	HK_PATCH_DEPENDS("hkdDeformableBreakableShapeSkinShapeSection", 0)
	HK_PATCH_DEPENDS("hkdDeformableBreakableShapeBoneDeformationData", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkdDeformableBreakableShapePhysicsSkinInstance", 0)
	HK_PATCH_PARENT_SET("hkReferencedObject", "hkpShapeModifier")
	HK_PATCH_MEMBER_ADDED("modelSpaceBoneTransforms", TYPE_ARRAY_STRUCT, "hkQTransform", 0)
	HK_PATCH_MEMBER_ADDED("physicsShape", TYPE_OBJECT, "hkpShape", 0)
	HK_PATCH_MEMBER_ADDED("skinShape", TYPE_OBJECT, "hkdDeformableBreakableShapePhysicsSkinShape", 0)
	HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("sections", TYPE_ARRAY_STRUCT, "hkdDeformableBreakableShapeSkinShapeSectionInstance", 0)
	HK_PATCH_DEPENDS("hkQTransform", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkpShape", 0)
	HK_PATCH_DEPENDS("hkdDeformableBreakableShapePhysicsSkinShape", 0)
	HK_PATCH_DEPENDS("hkdDeformableBreakableShapeSkinShapeSectionInstance", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDeformableBreakableBodyMemento", 0, "hkdDeformableBreakableBodyMemento", 1)
	HK_PATCH_MEMBER_REMOVED("shapeIndices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("transforms", TYPE_ARRAY_VEC_16, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transforms", TYPE_ARRAY_STRUCT, "hkQTransform", 0)
	HK_PATCH_DEPENDS("hkQTransform", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDeformableBreakableShape", 2, "hkdDeformableBreakableShape", 3)
	HK_PATCH_MEMBER_REMOVED("childKeys", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("origChildTransformRotations", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("origChildTransformTranslations", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("physicsSkinShape", TYPE_OBJECT, "hkdDeformableBreakableShapePhysicsSkinShape", 0)
	HK_PATCH_DEPENDS("hkdDeformableBreakableShapePhysicsSkinShape", 0)
	//HK_PATCH_FUNCTION(hkdDeformableBreakableShape_2_to_3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDeformationController", 2, "hkdDeformationController", 3)
	HK_PATCH_MEMBER_ADDED_REAL("constraintStrength", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("constraintBreakingLimit", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxDeformationAngle", 90.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdShapeInstanceInfo", 3, "hkdShapeInstanceInfo", 4)
	HK_PATCH_MEMBER_ADDED("transform", TYPE_STRUCT, "hkQTransform", 0)
	HK_PATCH_FUNCTION(hkdShapeInstanceInfo_3_to_4)
	HK_PATCH_MEMBER_REMOVED("translation", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("rotation", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkQTransform", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdExplosionForceAction", 0, "hkdExplosionForceAction", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("explosionCenterSpace", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkdDecorateFractureFaceAction", 5, "hkdDecorateFractureFaceAction", 6)
	HK_PATCH_MEMBER_ADDED_INT("numCornerDecorationAttempts", -1)
HK_PATCH_END()

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
