/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

// Behavior specific product patches.
// This file is #included by hkbPatches.cpp

//=======
// 650b1
//=======

HK_PATCH_BEGIN("hkbPredicate", 0, "hkbCondition", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStringPredicate", 0, "hkbStringCondition", 0)
	HK_PATCH_MEMBER_RENAMED("predicateString", "conditionString")
HK_PATCH_END()

HK_PATCH_BEGIN("hkbClimbMountingPredicate", 0, "hkbClimbMountingCondition", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbExpressionData", 0)
	HK_PATCH_MEMBER_ADDED_CSTRING("expression", HK_NULL)
	HK_PATCH_MEMBER_ADDED("assignmentVariableIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("assignmentEventIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_INT("eventMode", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbRealEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEventPayload")
	HK_PATCH_MEMBER_ADDED("data", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSceneModifierList", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED("sceneModifierEntries", TYPE_ARRAY_STRUCT, "hkbSceneModifierListSceneModifierEntry", 0)
	HK_PATCH_DEPENDS("hkbNode", 0)
	HK_PATCH_DEPENDS("hkbSceneModifierListSceneModifierEntry", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbClipTriggerArray", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("triggers", TYPE_ARRAY_STRUCT, "hkbClipTrigger", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbClipTrigger", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbNamedRealEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbNamedEventPayload")
	HK_PATCH_MEMBER_ADDED("data", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbNamedEventPayload", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbRoleAttribute", 0)
	HK_PATCH_MEMBER_ADDED("role", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbIntEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEventPayload")
	HK_PATCH_MEMBER_ADDED("data", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbComputeRotationToTargetModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED_VEC_4("rotationOut", 0.000000f,0.000000f,0.000000f,1.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("targetPosition", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("currentPosition", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("currentRotation", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("localAxisOfRotation", 0.000000f,0.000000f,1.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("localFacingDirection", 1.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("resultIsDelta", 0)
	HK_PATCH_DEPENDS("hkbNode", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventPayloadList", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEventPayload")
	HK_PATCH_MEMBER_ADDED("payloads", TYPE_ARRAY_OBJECT, "hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbComputeRotationFromAxisAngleModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED_VEC_4("rotationOut", 0.000000f,0.000000f,0.000000f,1.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("axis", 1.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("angleDegrees", 0.000000f)
	HK_PATCH_DEPENDS("hkbNode", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbExpressionDataArray", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("expressionsData", TYPE_ARRAY_STRUCT, "hkbExpressionData", 0)
	HK_PATCH_DEPENDS("hkbExpressionData", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCompiledExpressionSet", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("rpn", TYPE_ARRAY_STRUCT, "hkbCompiledExpressionSetToken", 0)
	HK_PATCH_MEMBER_ADDED("numExpressions", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbCompiledExpressionSetToken", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCombineTransformsModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED_VEC_4("translationOut", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("rotationOut", 0.000000f,0.000000f,0.000000f,1.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("leftTranslation", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("leftRotation", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("rightTranslation", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("rightRotation", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("invertLeftTransform", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("invertRightTransform", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("invertResult", 0)
	HK_PATCH_DEPENDS("hkbNode", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbExpressionCondition", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbCondition")
	HK_PATCH_MEMBER_ADDED("expression", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("compiledExpressionSet", TYPE_OBJECT, "hkbCompiledExpressionSet", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbCompiledExpressionSet", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbCondition", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBoneWeightArray", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbBindable")
	HK_PATCH_MEMBER_ADDED("boneWeights", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSenseHandleModifierRange", 0)
	HK_PATCH_MEMBER_ADDED("event", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_ADDED_REAL("minDistance", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxDistance", 1.000000f)
	HK_PATCH_MEMBER_ADDED("ignoreHandle", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBindable", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("variableBindingSet", TYPE_OBJECT, "hkbVariableBindingSet", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbVariableBindingSet", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSillyEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEventPayload")
	HK_PATCH_MEMBER_ADDED("sillyMessage", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("sillyGain", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("sillyIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("sillyEnum", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBoneIndexArray", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbBindable")
	HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbNamedStringEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbNamedEventPayload")
	HK_PATCH_MEMBER_ADDED("data", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbNamedEventPayload", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbNamedIntEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbNamedEventPayload")
	HK_PATCH_MEMBER_ADDED("data", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbNamedEventPayload", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventProperty", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEvent")
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEvaluateExpressionModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED("expressions", TYPE_OBJECT, "hkbExpressionDataArray", 0)
	HK_PATCH_MEMBER_ADDED("compiledExpressionSet", TYPE_OBJECT, "hkbCompiledExpressionSet", 0)
	HK_PATCH_DEPENDS("hkbNode", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkbExpressionDataArray", 0)
	HK_PATCH_DEPENDS("hkbCompiledExpressionSet", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbNamedEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEventPayload")
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbVariableValueSet", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("wordVariableValues", TYPE_ARRAY_STRUCT, "hkbVariableValue", 0)
	HK_PATCH_MEMBER_ADDED("quadVariableValues", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("variantVariableValues", TYPE_ARRAY_OBJECT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbVariableValue", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbStateMachineTransitionInfoArray", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("transitions", TYPE_ARRAY_STRUCT, "hkbStateMachineTransitionInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbStateMachineTransitionInfo", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbStringEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEventPayload")
	HK_PATCH_MEMBER_ADDED("data", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbExtractRagdollPoseModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_DEPENDS("hkbNode", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbStateListener", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCompiledExpressionSetToken", 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("operator", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSceneModifierListSceneModifierEntry", 0)
	HK_PATCH_MEMBER_ADDED("sceneModifier", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("postSceneModifier", TYPE_OBJECT, "hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbNode", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBallModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED("velocity", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("applyForceEventId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("applyForce", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbNode", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbMoveBoneTowardTargetModifier", 0, "hkbMoveBoneTowardTargetModifier", 1)
	HK_PATCH_MEMBER_RENAMED("eventToSendWhenTargetReached", "old_eventToSendWhenTargetReached")
	HK_PATCH_MEMBER_ADDED("eventToSendWhenTargetReached", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbMoveBoneTowardTargetModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_eventToSendWhenTargetReached", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterStringData", 0, "hkbCharacterStringData", 1)
	HK_PATCH_MEMBER_ADDED("characterPropertyNames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSplinePathGenerator", 0, "hkbSplinePathGenerator", 1)
	HK_PATCH_MEMBER_ADDED("pathEndEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbSplinePathGenerator_0_to_1)
	HK_PATCH_MEMBER_REMOVED("pathEndEventId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbHandIkControlData", 0, "hkbHandIkControlData", 1)
	HK_PATCH_MEMBER_ADDED_VEC_4("targetRotation", 0.000000f,0.000000f,0.000000f,1.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSenseHandleModifier", 0, "hkbSenseHandleModifier", 1)
	HK_PATCH_MEMBER_ADDED("ranges", TYPE_ARRAY_STRUCT, "hkbSenseHandleModifierRange", 0)
	HK_PATCH_MEMBER_ADDED_REAL("minDistance", 0.000000f)
	HK_PATCH_DEPENDS("hkbSenseHandleModifierRange", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbAttachmentModifier", 0, "hkbAttachmentModifier", 1)
	HK_PATCH_MEMBER_RENAMED("sendToAttacherOnAttach", "old_sendToAttacherOnAttach")
	HK_PATCH_MEMBER_ADDED("sendToAttacherOnAttach", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_RENAMED("sendToAttacheeOnAttach", "old_sendToAttacheeOnAttach")
	HK_PATCH_MEMBER_ADDED("sendToAttacheeOnAttach", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_RENAMED("sendToAttacherOnDetach", "old_sendToAttacherOnDetach")
	HK_PATCH_MEMBER_ADDED("sendToAttacherOnDetach", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_RENAMED("sendToAttacheeOnDetach", "old_sendToAttacheeOnDetach")
	HK_PATCH_MEMBER_ADDED("sendToAttacheeOnDetach", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbAttachmentModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_sendToAttacherOnAttach", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("old_sendToAttacheeOnAttach", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("old_sendToAttacherOnDetach", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("old_sendToAttacheeOnDetach", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbTimerModifier", 0, "hkbTimerModifier", 1)
	HK_PATCH_MEMBER_ADDED("alarmEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbTimerModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("eventIdToSend", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBehaviorGraphStringData", 0, "hkbBehaviorGraphStringData", 1)
	HK_PATCH_MEMBER_ADDED("characterPropertyNames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbTargetRigidBodyModifier", 0, "hkbTargetRigidBodyModifier", 1)
	HK_PATCH_MEMBER_RENAMED("eventToSend", "old_eventToSend")
	HK_PATCH_MEMBER_ADDED("eventToSend", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_RENAMED("eventToSendToTarget", "old_eventToSendToTarget")
	HK_PATCH_MEMBER_ADDED("eventToSendToTarget", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_ADDED("closeToTargetEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbTargetRigidBodyModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_eventToSend", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("old_eventToSendToTarget", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("closeToTargetEventId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineProspectiveTransitionInfo", 0, "hkbStateMachineProspectiveTransitionInfo", 1)
	HK_PATCH_MEMBER_REMOVED("transitionInfo", TYPE_OBJECT, "hkbStateMachineTransitionInfo", 0)
	HK_PATCH_MEMBER_REMOVED("transitionEffect", TYPE_OBJECT, "hkbTransitionEffect", 0)
	HK_PATCH_MEMBER_REMOVED("toStateId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("isGlobalWildcard", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbNode", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbGenerator", 0)
	HK_PATCH_DEPENDS("hkbTransitionEffect", 0)
	HK_PATCH_DEPENDS("hkbStateMachineTransitionInfo", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbEvaluateHandleModifier", 0, "hkbEvaluateHandleModifier", 1)
	HK_PATCH_MEMBER_ADDED_REAL("extrapolationTimeStep", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDetectCloseToGroundModifier", 0, "hkbDetectCloseToGroundModifier", 1)
	HK_PATCH_MEMBER_ADDED("closeToGroundEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbDetectCloseToGroundModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("closeToGroundEventId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbAttachmentSetup", 0, "hkbAttachmentSetup", 1)
	HK_PATCH_MEMBER_ADDED_REAL("extrapolationTimeStep", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("fixUpGain", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxLinearDistance", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxAngularDistance", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFootIkModifierInternalLegData", 0, "hkbFootIkModifierInternalLegData", 1)
	HK_PATCH_MEMBER_REMOVED("verticalError", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("hitSomething", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("isPlanted", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbLookAtModifier", 0, "hkbLookAtModifier", 1)
	HK_PATCH_MEMBER_REMOVED("lookUp", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("lookUpAngleDegrees", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("individualLimitsOn", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("limitAngleLeft", 90.0f)
	HK_PATCH_MEMBER_ADDED_REAL("limitAngleRight", -90.0f)
	HK_PATCH_MEMBER_ADDED_REAL("limitAngleUp", 30.0f)
	HK_PATCH_MEMBER_ADDED_REAL("limitAngleDown", -30.0f)
	//HK_PATCH_FUNCTION(hkbLookAtModifier_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbVariableBindingSetBinding", 0, "hkbVariableBindingSetBinding", 1)
	HK_PATCH_MEMBER_ADDED("bindingType", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkbVariableBindingSetBinding_0_to_1)
	HK_PATCH_MEMBER_REMOVED("object", TYPE_OBJECT, "hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbVariableBindingSet", 0)
	// The following should include all class that existed in version 0 and were made subclasses of hkbBindable in version 1.
	// It also includes any objects that were converted to using hkbBoneIndexArray or hkbBoneWeightArray.
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkbJigglerGroup", 1)
	HK_PATCH_DEPENDS("hkbBlenderGeneratorChild", 1)
	HK_PATCH_DEPENDS("hkbRegisteredGenerator", 1)
	HK_PATCH_DEPENDS("hkbPoweredRagdollControlsModifier", 1)
	HK_PATCH_DEPENDS("hkbKeyframeBonesModifier", 1)
	HK_PATCH_DEPENDS("hkbRigidBodyRagdollModifier", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbVariableBindingSet", 0, "hkbVariableBindingSet", 1 )
	HK_PATCH_FUNCTION(hkbVariableBindingSet_0_to_1)
	HK_PATCH_DEPENDS("hkbVariableBindingSetBinding", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbNode", 0, "hkbNode", 1)
	HK_PATCH_MEMBER_RENAMED( "variableBindingSet", "old_variableBindingSet" )
	HK_PATCH_PARENT_SET("hkReferencedObject", "hkbBindable")
	HK_PATCH_FUNCTION(hkbNode_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_variableBindingSet", TYPE_OBJECT, "hkbVariableBindingSet", 0)
	HK_PATCH_DEPENDS("hkbVariableBindingSet", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbHandIkModifierHand", 0, "hkbHandIkModifierHand", 1)
	HK_PATCH_MEMBER_ADDED_VEC_4("handOffsetLS", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY("handOrienationOffsetLS")
	HK_PATCH_MEMBER_ADDED_BOOL("enforceEndPosition", true)
	HK_PATCH_MEMBER_ADDED_BYTE("enforceEndRotation", 0)
	HK_PATCH_MEMBER_ADDED_CSTRING("localFrameName", HK_NULL)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbVariableInfo", 0, "hkbVariableInfo", 1)
	HK_PATCH_MEMBER_REMOVED("initialValue", TYPE_STRUCT, "hkbVariableValue", 0)
	HK_PATCH_MEMBER_ADDED("role", TYPE_STRUCT, "hkbRoleAttribute", 0)
	HK_PATCH_DEPENDS("hkbVariableValue", 0)
	HK_PATCH_DEPENDS("hkbRoleAttribute", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPositionRelativeSelectorGenerator", 0, "hkbPositionRelativeSelectorGenerator", 1)
	HK_PATCH_MEMBER_ADDED("fixPositionEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbPositionRelativeSelectorGenerator_0_to_1)
	HK_PATCH_MEMBER_REMOVED("fixPositionEventId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCheckRagdollSpeedModifier", 0, "hkbCheckRagdollSpeedModifier", 1)
	HK_PATCH_MEMBER_RENAMED("eventToSend", "old_eventToSend")
	HK_PATCH_MEMBER_ADDED("eventToSend", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbCheckRagdollSpeedModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_eventToSend", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterData", 0, "hkbCharacterData", 1)
	HK_PATCH_MEMBER_ADDED("characterPropertyInfos", TYPE_ARRAY_STRUCT, "hkbVariableInfo", 0)
	HK_PATCH_MEMBER_ADDED("characterPropertyValues", TYPE_OBJECT, "hkbVariableValueSet", 0)
	HK_PATCH_DEPENDS("hkbVariableInfo", 1)
	HK_PATCH_DEPENDS("hkbVariableValueSet", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFootIkModifierLeg", 0, "hkbFootIkModifierLeg", 1)
	HK_PATCH_MEMBER_ADDED("ungroundedEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbFootIkModifierLeg_0_to_1)
	HK_PATCH_MEMBER_ADDED_REAL("verticalError", 0.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("hitSomething", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("isPlantedMS", 0)
	HK_PATCH_MEMBER_REMOVED("ungroundedEventId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbClipTrigger", 0, "hkbClipTrigger", 1)
	HK_PATCH_MEMBER_RENAMED("event", "old_event")
	HK_PATCH_MEMBER_ADDED("event", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbClipTrigger_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_event", TYPE_STRUCT, "hkbEvent", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbClipGenerator", 0, "hkbClipGenerator", 1)
	HK_PATCH_MEMBER_RENAMED("triggers", "old_triggers")
	HK_PATCH_MEMBER_ADDED("triggers", TYPE_OBJECT, "hkbClipTriggerArray", 0)
	HK_PATCH_MEMBER_ADDED_INT("animationBindingIndex", -1)
	HK_PATCH_FUNCTION(hkbClipGenerator_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_triggers", TYPE_ARRAY_STRUCT, "hkbClipTrigger", 0)
	HK_PATCH_DEPENDS("hkbClipTrigger", 0)
	HK_PATCH_DEPENDS("hkbClipTriggerArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFootIkModifier", 0, "hkbFootIkModifier", 1)
	HK_PATCH_MEMBER_ADDED_REAL("verticalOffset", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCatchFallModifier", 0, "hkbCatchFallModifier", 1)
	HK_PATCH_MEMBER_RENAMED("spineIndices", "old_spineIndices")
	HK_PATCH_MEMBER_ADDED("spineIndices", TYPE_OBJECT, "hkbBoneIndexArray", 0)
	HK_PATCH_MEMBER_ADDED("catchFallDoneEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_FUNCTION(hkbCatchFallModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_spineIndices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("catchFallDoneEventId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbBoneIndexArray", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineStateInfo", 0, "hkbStateMachineStateInfo", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_RENAMED("enterNotifyEvent", "old_enterNotifyEvent")
	HK_PATCH_MEMBER_ADDED("enterNotifyEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_RENAMED("exitNotifyEvent", "old_exitNotifyEvent")
	HK_PATCH_MEMBER_ADDED("exitNotifyEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_ADDED("listeners", TYPE_ARRAY_OBJECT, "hkbStateListener", 0)
	HK_PATCH_FUNCTION(hkbStateMachineStateInfo_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_enterNotifyEvent", TYPE_STRUCT, "hkbEvent", 0)
	HK_PATCH_MEMBER_REMOVED("old_exitNotifyEvent", TYPE_STRUCT, "hkbEvent", 0)
	HK_PATCH_MEMBER_REMOVED("inPackfile", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbStateListener", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBehaviorGraphData", 0, "hkbBehaviorGraphData", 1)
	HK_PATCH_MEMBER_ADDED("characterPropertyInfos", TYPE_ARRAY_STRUCT, "hkbVariableInfo", 0)
	HK_PATCH_MEMBER_ADDED("variableInitialValues", TYPE_OBJECT, "hkbVariableValueSet", 0)
	HK_PATCH_FUNCTION(hkbBehaviorGraphData_0_to_1)
	HK_PATCH_MEMBER_REMOVED("quadVariableInitialValues", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbVariableInfo", 0)
	HK_PATCH_DEPENDS("hkbVariableValueSet", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineTransitionInfo", 0, "hkbStateMachineTransitionInfo", 1)
	HK_PATCH_MEMBER_RENAMED("predicate", "condition")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbCondition", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollControlsModifier", 0, "hkbPoweredRagdollControlsModifier", 1)
	HK_PATCH_MEMBER_RENAMED("boneWeights", "old_boneWeights")
	HK_PATCH_MEMBER_ADDED("boneWeights", TYPE_OBJECT, "hkbBoneWeightArray", 0)
	HK_PATCH_FUNCTION(hkbPoweredRagdollControlsModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_boneWeights", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbBoneWeightArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachine", 0, "hkbStateMachine", 1)
	HK_PATCH_MEMBER_ADDED("wildcardTransitions", TYPE_OBJECT, "hkbStateMachineTransitionInfoArray", 0)
	HK_PATCH_FUNCTION(hkbStateMachine_0_to_1)
	HK_PATCH_MEMBER_REMOVED("globalTransitions", TYPE_ARRAY_STRUCT, "hkbStateMachineTransitionInfo", 0)
	HK_PATCH_DEPENDS("hkbStateMachineTransitionInfo", 0)
	HK_PATCH_DEPENDS("hkbStateMachineTransitionInfoArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbKeyframeBonesModifier", 0, "hkbKeyframeBonesModifier", 1)
	HK_PATCH_MEMBER_RENAMED("keyframedBonesList", "old_keyframedBonesList")
	HK_PATCH_MEMBER_ADDED("keyframedBonesList", TYPE_OBJECT, "hkbBoneIndexArray", 0)
	HK_PATCH_FUNCTION(hkbKeyframeBonesModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_keyframedBonesList", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbBoneIndexArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBlenderGeneratorChild", 0, "hkbBlenderGeneratorChild", 1)
	HK_PATCH_PARENT_SET("hkReferencedObject", "hkbBindable")
	HK_PATCH_MEMBER_RENAMED("boneWeights", "old_boneWeights")
	HK_PATCH_MEMBER_ADDED("boneWeights", TYPE_OBJECT, "hkbBoneWeightArray", 0)
	HK_PATCH_FUNCTION(hkbBlenderGeneratorChild_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_boneWeights", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbBoneWeightArray", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRigidBodyRagdollModifier", 0, "hkbRigidBodyRagdollModifier", 1)
	HK_PATCH_MEMBER_RENAMED("keyframedBonesList", "old_keyframedBonesList")
	HK_PATCH_MEMBER_ADDED("keyframedBonesList", TYPE_OBJECT, "hkbBoneIndexArray", 0)
	HK_PATCH_FUNCTION(hkbRigidBodyRagdollModifier_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_keyframedBonesList", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbBoneIndexArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbJigglerGroup", 0, "hkbJigglerGroup", 1)
	HK_PATCH_PARENT_SET("hkReferencedObject", "hkbBindable")
	HK_PATCH_MEMBER_RENAMED("boneIndices", "old_boneIndices")
	HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_OBJECT, "hkbBoneIndexArray", 0)
	HK_PATCH_FUNCTION(hkbJigglerGroup_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_boneIndices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbBoneIndexArray", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRegisteredGenerator", 0, "hkbRegisteredGenerator", 1)
	HK_PATCH_PARENT_SET("hkReferencedObject", "hkbBindable")
	HK_PATCH_DEPENDS("hkbBindable", 0)
HK_PATCH_END()

//=======
// 650r1
//=======

HK_PATCH_BEGIN("hkbSillyEventPayload", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbEventPayload", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("sillyMessage", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("sillyGain", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("sillyIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("sillyEnum", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineStateInfo", 1, "hkbStateMachineStateInfo", 2)
	HK_PATCH_PARENT_SET("hkReferencedObject", "hkbBindable")
	HK_PATCH_MEMBER_RENAMED("transitions","old_transitions")
	HK_PATCH_MEMBER_ADDED("transitions", TYPE_OBJECT, "hkbStateMachineTransitionInfoArray", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("enable", 1)
	HK_PATCH_DEPENDS("hkbStateMachineTransitionInfo", 1)
	HK_PATCH_DEPENDS("hkbStateMachineTransitionInfoArray", 0)
	HK_PATCH_FUNCTION(hkbStateMachineStateInfo_1_to_2)
	HK_PATCH_MEMBER_REMOVED("old_transitions", TYPE_ARRAY_STRUCT, "hkbStateMachineTransitionInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRotateCharacterModifier", 0, "hkbRotateCharacterModifier", 1)
	HK_PATCH_MEMBER_ADDED_REAL("speedMultiplier", 1.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCompiledExpressionSet", 0, "hkbCompiledExpressionSet", 1)
	HK_PATCH_MEMBER_ADDED("expressionToRpnIndex", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterData", 1, "hkbCharacterData", 2)
        HK_PATCH_MEMBER_ADDED_REAL("scale", 1.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfigStickVariableInfo", 0, "hkbDemoConfigStickVariableInfo", 1)
	HK_PATCH_MEMBER_ADDED_REAL("minStickValue", -1.0f)
	HK_PATCH_MEMBER_ADDED_REAL("maxStickValue", 1.0f)
	HK_PATCH_MEMBER_ADDED("stickAxis", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("stick", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("complimentVariableValue", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("negateVariableValue", TYPE_BYTE, HK_NULL, 0)
	//HK_PATCH_FUNCTION(hkbDemoConfigStickVariableInfo_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfig", 0, "hkbDemoConfig", 1)
	HK_PATCH_MEMBER_RENAMED("stickVariables", "old_stickVariables")
	HK_PATCH_MEMBER_ADDED("stickVariables", TYPE_TUPLE_STRUCT, "hkbDemoConfigStickVariableInfo", 12)
	HK_PATCH_FUNCTION(hkbDemoConfig_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_stickVariables", TYPE_TUPLE_STRUCT, "hkbDemoConfigStickVariableInfo", 4)
	HK_PATCH_DEPENDS("hkbDemoConfigStickVariableInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbProxyModifier", 0, "hkbProxyModifier", 1)
	HK_PATCH_MEMBER_ADDED_BOOL("includeDownwardMomentum", true)
	HK_PATCH_MEMBER_ADDED_BOOL("followWorldFromModel", true)
	HK_PATCH_MEMBER_ADDED_BYTE("isTouchingGround", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDampingModifier", 0, "hkbDampingModifier", 1)
	HK_PATCH_MEMBER_ADDED_BOOL("enableScalarDamping", true)
	HK_PATCH_MEMBER_ADDED_BYTE("enableVectorDamping", 0)
	HK_PATCH_MEMBER_ADDED_VEC_4("rawVector", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("dampedVector", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("vecErrorSum", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("vecPreviousError", 0.000000f,0.000000f,0.000000f,0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbVariableBindingSet", 1, "hkbVariableBindingSet", 2)
	HK_PATCH_MEMBER_ADDED_INT("indexOfBindingToEnable", -1)
	HK_PATCH_FUNCTION(hkbVariableBindingSet_1_to_2)
HK_PATCH_END()

//==========
// post-6.5
//==========

// Note that these targetting modifiers are being versioned but the behavior graphs
// That used them will not work.  In particular, there may be variables bound to the members
// that were removed.  If we really want to version such behavior graphs we'll have
// to change some of the variable types from int to hkbTarget* and change the
// bindings to point to the new members.

HK_PATCH_BEGIN("hkbMoveBoneTowardTargetModifier", 1, "hkbMoveBoneTowardTargetModifier", 2)
	HK_PATCH_MEMBER_REMOVED("target", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("clearTargetData", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("currentBoneIsValidIn", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("behaviorTarget", TYPE_OBJECT, "hkbTarget", 0)
	HK_PATCH_MEMBER_ADDED_POINTER("targetIn", "hkbTarget", 0)
	HK_PATCH_DEPENDS("hkbTarget", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFaceTargetModifier", 0, "hkbFaceTargetModifier", 1)
	HK_PATCH_MEMBER_REMOVED("target", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("behaviorTarget", TYPE_OBJECT, "hkbTarget", 0)
	HK_PATCH_MEMBER_ADDED_POINTER("targetIn", "hkbTarget", 0)
	HK_PATCH_DEPENDS("hkbTarget", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollModifierKeyframeInfo", 0, "hkbPoweredRagdollModifierKeyframeInfo", 1)
	HK_PATCH_MEMBER_REMOVED("isValidOut", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachTowardTargetModifier", 0, "hkbReachTowardTargetModifier", 1)
	HK_PATCH_MEMBER_REMOVED("target", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("clearTargetData", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("behaviorTarget", TYPE_OBJECT, "hkbTarget", 0)
	HK_PATCH_MEMBER_ADDED_POINTER("targetIn", "hkbTarget", 0)
	HK_PATCH_DEPENDS("hkbTarget", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbTargetRigidBodyModifier", 1, "hkbTargetRigidBodyModifier", 2)
	HK_PATCH_MEMBER_REMOVED("target", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("targetIn", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_POINTER("targetOut", "hkbTarget", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("isCloseToTargetOut", 0)
	HK_PATCH_DEPENDS("hkbTarget", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbConstrainRigidBodyModifier", 0, "hkbConstrainRigidBodyModifier", 1)
	HK_PATCH_MEMBER_REMOVED("target", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("behaviorTarget", TYPE_OBJECT, "hkbTarget", 0)
	HK_PATCH_MEMBER_ADDED_POINTER("targetIn", "hkbTarget", 0)
	HK_PATCH_DEPENDS("hkbTarget", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbTargetRigidBodyModifier", 2, "hkbTargetRigidBodyModifier", 3)
	HK_PATCH_MEMBER_REMOVED("behaviorTarget", TYPE_OBJECT, "hkbTarget", 0)
	HK_PATCH_MEMBER_REMOVED("closeToTargetEventHasBeenSent", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbTarget", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbTarget", 0, "hkbTarget", 1)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbClimbMountingCondition", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbCondition", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("maxTargetDistance", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("sensingForLeftHand", TYPE_OBJECT, "hkbTargetRigidBodyModifier", 0)
	HK_PATCH_MEMBER_REMOVED("sensingForRightHand", TYPE_OBJECT, "hkbTargetRigidBodyModifier", 0)
	HK_PATCH_MEMBER_REMOVED("targetForLeftHand", TYPE_OBJECT, "hkbTarget", 0)
	HK_PATCH_MEMBER_REMOVED("targetForRightHand", TYPE_OBJECT, "hkbTarget",	0)
	HK_PATCH_DEPENDS("hkbTarget", 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbTargetRigidBodyModifier", 3)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbCondition", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBlenderGeneratorChild", 1, "hkbBlenderGeneratorChild", 2)
	HK_PATCH_MEMBER_REMOVED("operandType", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBlenderGenerator", 0, "hkbBlenderGenerator", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("subtractLastChild", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGeneratorOutputTrackHeader", 0, "hkbGeneratorOutputTrackHeader", 1)
	HK_PATCH_MEMBER_REMOVED("format", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isPoseAdditive", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineStateInfo", 2, "hkbStateMachineStateInfo", 3)
	HK_PATCH_MEMBER_ADDED_REAL("probability", 1.0f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterStringData", 1, "hkbCharacterStringData", 2)
	HK_PATCH_MEMBER_ADDED("behaviorFilename", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfigCharacterInfo", 0, "hkbDemoConfigCharacterInfo", 1)
	HK_PATCH_MEMBER_REMOVED("rigFilename", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("skinFilenames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("behaviorFilename", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("attachmentsFilename", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollDriverModifier", 0, "hkbRagdollDriverModifier", 1)
	HK_PATCH_MEMBER_ADDED_REAL("blendRagdollPoseFraction", 1.0f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSimpleCharacter", 0, "hkbSimpleCharacter", 1)
	HK_PATCH_MEMBER_ADDED("ragdollWorldFromModel", TYPE_VEC_12, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbDefaultMessageLog", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbMessageLog", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbEvaluateHandleModifier", 1, "hkbEvaluateHandleModifier", 2)
	HK_PATCH_MEMBER_ADDED_REAL("handleChangeSpeed", 1.0f)
	HK_PATCH_MEMBER_ADDED_INT("handleChangeMode", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollDriverModifier", 1, "hkbRagdollDriverModifier", 2)
	HK_PATCH_MEMBER_REMOVED("isRagdollForceModifierActive", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("ragdollBlendOutTime", 0.25f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventsFromRangeModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED("inputValue", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("lowerBound", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("eventRanges", TYPE_OBJECT, "hkbEventRangeDataArray", 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbEventRangeDataArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventRangeData", 0)
	HK_PATCH_MEMBER_ADDED("upperBound", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("event", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_ADDED_INT("eventMode", 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEvent", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventRangeDataArray", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("eventData", TYPE_ARRAY_STRUCT, "hkbEventRangeData", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbEventRangeData", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbRagdollController", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("ragdollBlendOutTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("poseMatchingBone0", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("poseMatchingBone1", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("poseMatchingBone2", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("worldFromModelMode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("character", TYPE_OBJECT, "hkbCharacter", 0)
	HK_PATCH_MEMBER_ADDED("ragdollInstance", TYPE_OBJECT, "hkaRagdollInstance", 0)
	HK_PATCH_MEMBER_ADDED("ragdollPoseWS", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("rigidBodyControllerBlendTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("firstGenerateAfterRagdollIsAddedToWorld", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("firstGenerateAfterRigidBodyControllerActive", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("autoAddRemoveRagdollToWorld", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isPoweredControllerEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isRigidBodyControllerEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbCharacter", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaRagdollInstance", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbRagdollModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED("poweredControlData", TYPE_STRUCT, "hkbPoweredRagdollControlData", 0)
	HK_PATCH_MEMBER_ADDED("rigidBodyControlData", TYPE_STRUCT, "hkaKeyFrameHierarchyUtilityControlData", 0)
	HK_PATCH_MEMBER_ADDED("poweredBoneWeights", TYPE_OBJECT, "hkbBoneWeightArray", 0)
	HK_PATCH_MEMBER_ADDED("rigidBodyBoneWeights", TYPE_OBJECT, "hkbBoneWeightArray", 0)
	HK_PATCH_MEMBER_ADDED("rigidBodyControllerBlendTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("enablePoweredController", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("enableRigidBodyController", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("setTargetPose", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("justSetTargetPose", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaKeyFrameHierarchyUtilityControlData", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkbPoweredRagdollControlData", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbBoneWeightArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbExtractRagdollPoseModifier", 0, "hkbExtractRagdollPoseModifier", 1)
	HK_PATCH_MEMBER_ADDED_INT("poseMatchingBone0", -1)
	HK_PATCH_MEMBER_ADDED_INT("poseMatchingBone1", -1)
	HK_PATCH_MEMBER_ADDED_INT("poseMatchingBone2", -1)
	HK_PATCH_MEMBER_ADDED_BOOL("enableComputeWorldFromModel", false)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSimpleCharacter", 1, "hkbSimpleCharacter", 2)
	HK_PATCH_MEMBER_REMOVED("ragdollInstance", TYPE_OBJECT, "hkaRagdollInstance", 0)
	HK_PATCH_MEMBER_ADDED("ragdollController", TYPE_OBJECT, "hkbRagdollController", 0)
	HK_PATCH_DEPENDS("hkaRagdollInstance", 0)
	HK_PATCH_DEPENDS("hkbRagdollController", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBalanceControllerModifier", 0, "hkbBalanceControllerModifier" , 1)
	HK_PATCH_MEMBER_ADDED_INT("pelvisIndex", -1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterData", 2, "hkbCharacterData", 3)
	HK_PATCH_MEMBER_REMOVED("animationBoneInfo", TYPE_STRUCT, "hkbCharacterBoneInfo", 0)
	HK_PATCH_MEMBER_REMOVED("ragdollBoneInfo", TYPE_STRUCT, "hkbCharacterBoneInfo", 0)
	HK_PATCH_DEPENDS("hkbCharacterBoneInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachTowardTargetModifierHand", 0, "hkbReachTowardTargetModifierHand", 1)
	HK_PATCH_MEMBER_REMOVED("handIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCatchFallModifierHand", 0, "hkbCatchFallModifierHand", 1)
	HK_PATCH_MEMBER_REMOVED("handIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFootIkModifierLeg", 1, "hkbFootIkModifierLeg", 2)
	HK_PATCH_MEMBER_REMOVED("legIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbHandIkModifierHand", 1, "hkbHandIkModifierHand", 2)
	HK_PATCH_MEMBER_REMOVED("handIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterBoneInfo", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("clavicleIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("shoulderIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("elbowIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("wristIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("hipIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("kneeIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("ankleIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("spineIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("pelvisIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("neckIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("headIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingRootBoneIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingOtherBoneIndex", TYPE_INT, HK_NULL,  0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingAnotherBoneIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBehaviorGraphData", 1, "hkbBehaviorGraphData", 2)
	HK_PATCH_MEMBER_ADDED("wordMinVariableValues", TYPE_ARRAY_STRUCT, "hkbVariableValue", 0)
	HK_PATCH_MEMBER_ADDED("wordMaxVariableValues", TYPE_ARRAY_STRUCT, "hkbVariableValue", 0)
	HK_PATCH_DEPENDS("hkbVariableValue", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDetectCloseToGroundModifier", 1, "hkbDetectCloseToGroundModifier", 2)
	HK_PATCH_MEMBER_ADDED_INT("animBoneIndex", -1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbKeyframeBonesModifier", 1, "hkbKeyframeBonesModifier", 2)
	HK_PATCH_MEMBER_REMOVED("keyframedBones", TYPE_STRUCT, "hkBitField", 0)
	HK_PATCH_DEPENDS("hkBitField", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSenseHandleModifier", 1, "hkbSenseHandleModifier", 2)
        HK_PATCH_MEMBER_ADDED_INT("collisionFilterInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGeneratorTransitionEffect", 0, "hkbGeneratorTransitionEffect", 1)
        HK_PATCH_MEMBER_ADDED_BOOL("syncToGeneratorStartTime", true)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbKeyframeBonesModifierKeyframeInfo", 0)
	HK_PATCH_MEMBER_ADDED_VEC_4("keyframedPosition", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("keyframedRotation", 0.000000f,0.000000f,0.000000f,1.000000f)
	HK_PATCH_MEMBER_ADDED_INT("boneIndex", -1)
	HK_PATCH_MEMBER_ADDED_BYTE("isValid", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollDriverModifier", 2, "hkbRagdollDriverModifier", 3)
	HK_PATCH_MEMBER_REMOVED("addRagdollToWorld", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("removeRagdollFromWorld", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poweredRagdollModifier", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("rigidBodyRagdollModifier", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("ragdollForceModifier", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("blendRagdollPoseFraction", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("ragdollBlendOutTime", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollModifierKeyframeInfo", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("keyframedPosition", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("keyframedRotation", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("boneIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("isValid", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollForceModifier", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("boneForces", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRigidBodyRagdollModifier", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("controlDataPalette", TYPE_ARRAY_STRUCT, "hkaKeyFrameHierarchyUtilityControlData", 0)
	HK_PATCH_MEMBER_REMOVED("bodyIndexToPaletteIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("keyframedBones", TYPE_STRUCT, "hkBitField", 0)
	HK_PATCH_MEMBER_REMOVED("keyframedBonesList", TYPE_OBJECT, "hkbBoneIndexArray", 0)
	HK_PATCH_DEPENDS("hkBitField", 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaKeyFrameHierarchyUtilityControlData", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkbBoneIndexArray", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollModifier", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("floorRaycastLayer", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("controls", TYPE_STRUCT, "hkbPoweredRagdollControlData", 0)
	HK_PATCH_MEMBER_REMOVED("blendInTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("computeWorldFromModelMode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("fixConstraintsTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("useLocking", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("keyframeInfo", TYPE_ARRAY_STRUCT, "hkbPoweredRagdollModifierKeyframeInfo", 0)
	HK_PATCH_MEMBER_REMOVED("rootBoneIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("otherBoneIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("anotherBoneIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("keyframedBones", TYPE_STRUCT, "hkBitField", 0)
	HK_PATCH_MEMBER_REMOVED("boneWeights", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBitField", 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkbPoweredRagdollModifierKeyframeInfo", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkbPoweredRagdollControlData", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbKeyframeBonesModifier", 2, "hkbKeyframeBonesModifier", 3)
	HK_PATCH_MEMBER_ADDED("keyframeInfo", TYPE_ARRAY_STRUCT, "hkbKeyframeBonesModifierKeyframeInfo", 0)
	HK_PATCH_DEPENDS("hkbKeyframeBonesModifierKeyframeInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRigidBodyRagdollControlsModifier", 0, "hkbRigidBodyRagdollControlsModifier", 1)
	HK_PATCH_MEMBER_ADDED("bones", TYPE_OBJECT, "hkbBoneIndexArray", 0)
	HK_PATCH_DEPENDS("hkbBoneIndexArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollControlsModifier", 1, "hkbPoweredRagdollControlsModifier", 2)
	HK_PATCH_MEMBER_ADDED("setTargetPose", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRigidBodyRagdollControlsModifier", 1, "hkbRigidBodyRagdollControlsModifier", 2)
	HK_PATCH_MEMBER_ADDED("setTargetPose", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollModifier", 0, "hkbRagdollModifier", 1)
	HK_PATCH_MEMBER_ADDED("poseMatchingBone0", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("poseMatchingBone1", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("poseMatchingBone2", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("worldFromModelMode", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollControlsModifier", 2, "hkbPoweredRagdollControlsModifier", 3)
	HK_PATCH_MEMBER_ADDED("poseMatchingBone0", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("poseMatchingBone1", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("poseMatchingBone2", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("worldFromModelMode", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbClipGenerator", 1, "hkbClipGenerator", 2)
	HK_PATCH_FUNCTION(hkbClipGenerator_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFootIkModifier", 1, "hkbFootIkModifier", 2)
	HK_PATCH_MEMBER_ADDED_INT("alignMode", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGeneratorOutputTrackMasterHeader", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("numBytes", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("numTracks", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("unused", TYPE_TUPLE_INT, HK_NULL, 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGeneratorOutputConstTrack", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("header", TYPE_OBJECT, "hkbGeneratorOutputTrackHeader", 0)
	HK_PATCH_MEMBER_REMOVED("data", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbGeneratorOutputTrackHeader", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGeneratorOutput", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("skeleton", TYPE_OBJECT, "hkaSkeleton", 0)
	HK_PATCH_MEMBER_REMOVED("deleteTracks", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaSkeleton", 2)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGeneratorOutputTrackHeader", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("numData", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("dataOffset", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("onFraction", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("id", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("type", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("isPoseAdditive", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGeneratorOutputTracks", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("masterHeader", TYPE_STRUCT, "hkbGeneratorOutputTrackMasterHeader", 0)
	HK_PATCH_MEMBER_REMOVED("trackHeaders", TYPE_TUPLE_STRUCT, "hkbGeneratorOutputTrackHeader", 1)
	HK_PATCH_DEPENDS("hkbGeneratorOutputTrackHeader", 1)
	HK_PATCH_DEPENDS("hkbGeneratorOutputTrackMasterHeader", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGeneratorOutputTrack", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbGeneratorOutputConstTrack", HK_NULL)
	HK_PATCH_DEPENDS("hkbGeneratorOutputConstTrack", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbHandle", 0, "hkbHandle", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkbTarget", 1, "hkbTarget", 2)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachine", 1, "hkbStateMachine", 2)
	HK_PATCH_MEMBER_REMOVED("enableGlobalTransitions", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("enableNestedTransitions", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFootIkModifier", 2, "hkbFootIkModifier", 3)
	HK_PATCH_MEMBER_ADDED_REAL("forwardAlignFraction", 1.0f)
	HK_PATCH_MEMBER_ADDED_REAL("sidewaysAlignFraction", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("sidewaysSampleWidth", 0.2f) // Changed from 0.2f
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSimpleCharacter", 2, "hkbSimpleCharacter", 3)
	HK_PATCH_MEMBER_ADDED("behaviorGraph", TYPE_OBJECT, "hkbBehaviorGraph", 0)
	HK_PATCH_MEMBER_ADDED("projectData", TYPE_OBJECT, "hkbProjectData", 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkbGenerator", 0)
	HK_PATCH_DEPENDS("hkbProjectData", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkbBehaviorGraph", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBalanceControllerModifier", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("proportionalGain", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("derivativeGain", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("integralGain", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("checkBalanceModifier", TYPE_OBJECT, "hkbCheckBalanceModifier", 0)
	HK_PATCH_MEMBER_REMOVED("boneForces", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("pelvisIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkbCheckBalanceModifier", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbWorldFromModelModeData", 0)
	HK_PATCH_MEMBER_ADDED_INT("poseMatchingBone0", -1)
	HK_PATCH_MEMBER_ADDED_INT("poseMatchingBone1", -1)
	HK_PATCH_MEMBER_ADDED_INT("poseMatchingBone2", -1)
	HK_PATCH_MEMBER_ADDED_INT("mode", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollController", 0, "hkbRagdollController", 1)
	HK_PATCH_MEMBER_REMOVED("poseMatchingBone0", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingBone1", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingBone2", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("worldFromModelMode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("worldFromModelModeData", TYPE_STRUCT, "hkbWorldFromModelModeData", 0)
	HK_PATCH_DEPENDS("hkbWorldFromModelModeData", 0)
	HK_PATCH_FUNCTION(hkbRagdollController_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollModifier", 1, "hkbRagdollModifier", 2)
	HK_PATCH_MEMBER_REMOVED("poseMatchingBone0", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingBone1", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingBone2", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("worldFromModelMode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("worldFromModelModeData", TYPE_STRUCT, "hkbWorldFromModelModeData", 0)
	HK_PATCH_DEPENDS("hkbWorldFromModelModeData", 0)
	HK_PATCH_FUNCTION(hkbRagdollModifier_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollControlsModifier", 3, "hkbPoweredRagdollControlsModifier", 4)
	HK_PATCH_MEMBER_REMOVED("setTargetPose", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingBone0", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingBone1", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseMatchingBone2", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("worldFromModelMode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("worldFromModelModeData", TYPE_STRUCT, "hkbWorldFromModelModeData", 0)
	HK_PATCH_DEPENDS("hkbWorldFromModelModeData", 0)
	HK_PATCH_FUNCTION(hkbPoweredRagdollControlsModifier_3_to_4)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRigidBodyRagdollControlsModifier", 2, "hkbRigidBodyRagdollControlsModifier", 3)
	HK_PATCH_MEMBER_REMOVED("setTargetPose", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollModifier", 2, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("poweredControlData", TYPE_STRUCT, "hkbPoweredRagdollControlData", 0)
	HK_PATCH_MEMBER_REMOVED("rigidBodyControlData", TYPE_STRUCT, "hkaKeyFrameHierarchyUtilityControlData", 0)
	HK_PATCH_MEMBER_REMOVED("poweredBoneWeights", TYPE_OBJECT, "hkbBoneWeightArray", 0)
	HK_PATCH_MEMBER_REMOVED("rigidBodyBoneWeights", TYPE_OBJECT, "hkbBoneWeightArray", 0)
	HK_PATCH_MEMBER_REMOVED("rigidBodyControllerBlendTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("enablePoweredController", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("enableRigidBodyController", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("setTargetPose", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("justSetTargetPose", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("worldFromModelModeData", TYPE_STRUCT, "hkbWorldFromModelModeData", 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkaKeyFrameHierarchyUtilityControlData", 0)
	HK_PATCH_DEPENDS("hkbPoweredRagdollControlData", 0)
	HK_PATCH_DEPENDS("hkbWorldFromModelModeData", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbBoneWeightArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollDriverModifier", 3, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollController", 1, "hkbRagdollController", 2)
	HK_PATCH_MEMBER_REMOVED("rigidBodyControllerBlendTime", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterStringData", 2, "hkbCharacterStringData", 3)
	HK_PATCH_MEMBER_ADDED("retargetingSkeletonMapperFilenames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterSetup", 0, "hkbCharacterSetup", 1)
	HK_PATCH_MEMBER_ADDED("retargetingSkeletonMappers", TYPE_ARRAY_OBJECT, "hkaSkeletonMapper", 0)
	HK_PATCH_DEPENDS("hkaSkeletonMapper", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollControlsModifier", 4, "hkbPoweredRagdollControlsModifier", 5)
	HK_PATCH_MEMBER_ADDED("bones", TYPE_OBJECT, "hkbBoneIndexArray", 0)
	HK_PATCH_DEPENDS("hkbBoneIndexArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollController", 2, "hkbRagdollController", 3)
	HK_PATCH_MEMBER_ADDED("useAsynchronousStepping", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGetUpModifier", 0, "hkbGetUpModifier", 1)
	HK_PATCH_MEMBER_ADDED("correctToGroundTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("surfaceNormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("surfacePosition", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfig", 1, "hkbDemoConfig", 2)
	HK_PATCH_MEMBER_RENAMED("stickVariables", "old_stickVariables")
	HK_PATCH_MEMBER_ADDED("stickVariables", TYPE_ARRAY_STRUCT, "hkbDemoConfigStickVariableInfo", 0)
	HK_PATCH_FUNCTION(hkbDemoConfig_1_to_2)
	HK_PATCH_MEMBER_REMOVED("old_stickVariables", TYPE_TUPLE_STRUCT, "hkbDemoConfigStickVariableInfo", 12)
	HK_PATCH_DEPENDS("hkbDemoConfigStickVariableInfo", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterStringData", 3, "hkbCharacterStringData", 4)
	HK_PATCH_MEMBER_ADDED("lodNames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterData", 3, "hkbCharacterData", 4)
	HK_PATCH_MEMBER_ADDED("numBonesPerLod", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoseMatchingGenerator", 0, "hkbPoseMatchingGenerator", 1)
	HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY("worldFromModelRotation")
HK_PATCH_END()

HK_PATCH_BEGIN("hkbGetUpModifier", 1, "hkbGetUpModifier", 2)
	HK_PATCH_MEMBER_ADDED_VEC_4("groundNormal", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("alignWithGroundDuration", 0.000000f)
	HK_PATCH_FUNCTION(hkbGetUpModifier_1_to_2)
	HK_PATCH_MEMBER_REMOVED("correctToGroundTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("surfaceNormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("surfacePosition", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSetWorldFromModelModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED_VEC_4("translation", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("rotation", 0.000000f,0.000000f,0.000000f,1.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("setTranslation", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("setRotation", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfig", 2, "hkbDemoConfig", 3)
	HK_PATCH_MEMBER_ADDED_BYTE("forceLoad", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfigCharacterInfo", 1, "hkbDemoConfigCharacterInfo", 2)
	HK_PATCH_MEMBER_ADDED_CSTRING("behaviorFilename", HK_NULL)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbGetWorldFromModelModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
	HK_PATCH_MEMBER_ADDED_VEC_4("translationOut", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("rotationOut", 0.000000f,0.000000f,0.000000f,1.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterDataCharacterControllerInfo", 0)
	HK_PATCH_MEMBER_ADDED_REAL("capsuleHeight", 1.700000f)
	HK_PATCH_MEMBER_ADDED_REAL("capsuleRadius", 0.400000f)
	HK_PATCH_MEMBER_ADDED_INT("collisionFilterInfo", 1)
	HK_PATCH_MEMBER_ADDED("characterControllerCinfo", TYPE_OBJECT, "hkpCharacterControllerCinfo", 0)
	HK_PATCH_DEPENDS("hkpCharacterControllerCinfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterData", 4, "hkbCharacterData", 5)
	HK_PATCH_MEMBER_ADDED("characterControllerInfo", TYPE_STRUCT, "hkbCharacterDataCharacterControllerInfo", 0)
	HK_PATCH_DEPENDS("hkbCharacterDataCharacterControllerInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBehaviorGraphInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("nodeInternalStateInfos", TYPE_ARRAY_OBJECT, "hkbNodeInternalStateInfo", 0)
	HK_PATCH_MEMBER_ADDED("variableValueSet", TYPE_OBJECT, "hkbVariableValueSet", 0)
	HK_PATCH_DEPENDS("hkbNodeInternalStateInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbVariableValueSet", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbNodeInternalStateInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("syncInfo", TYPE_STRUCT, "hkbGeneratorSyncInfo", 0)
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("internalState", TYPE_OBJECT, "hkReferencedObject", 0)
	HK_PATCH_MEMBER_ADDED("nodeId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("hasActivateBeenCalled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbGeneratorSyncInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbClipGeneratorEcho", 0)
    HK_PATCH_MEMBER_ADDED("offsetLocalTime", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("weight", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("dwdt", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbStateMachineDelayedTransitionInfo", 0)
    HK_PATCH_MEMBER_ADDED("delayedTransition", TYPE_STRUCT, "hkbStateMachineProspectiveTransitionInfo", 0)
    HK_PATCH_MEMBER_ADDED("isDelayedTransitionReturnToPreviousState", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wasInAbutRangeLastFrame", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbStateMachineProspectiveTransitionInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbStateMachineTransitionInfoReference", 0)
	HK_PATCH_MEMBER_ADDED("fromStateIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transitionIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineProspectiveTransitionInfo", 1, "hkbStateMachineProspectiveTransitionInfo", 2)
	HK_PATCH_MEMBER_ADDED("transitionInfoReference", TYPE_STRUCT, "hkbStateMachineTransitionInfoReference", 0)
	HK_PATCH_MEMBER_ADDED("transitionInfoReferenceForTE", TYPE_STRUCT, "hkbStateMachineTransitionInfoReference", 0)
	HK_PATCH_MEMBER_ADDED("toStateId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbStateMachineTransitionInfoReference", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineActiveTransitionInfo", 0, "hkbStateMachineActiveTransitionInfo", 1)
    HK_PATCH_MEMBER_REMOVED("transitionInfo", TYPE_OBJECT, "hkbStateMachineTransitionInfo", 0)
    HK_PATCH_MEMBER_REMOVED("transitionEffect", TYPE_OBJECT, "hkbTransitionEffect", 0)
    HK_PATCH_MEMBER_ADDED("transitionEffectInternalStateInfo", TYPE_OBJECT, "hkbNodeInternalStateInfo", 0)
    HK_PATCH_MEMBER_ADDED("transitionInfoReference", TYPE_STRUCT, "hkbStateMachineTransitionInfoReference", 0)
    HK_PATCH_MEMBER_ADDED("transitionInfoReferenceForTE", TYPE_STRUCT, "hkbStateMachineTransitionInfoReference", 0)
    HK_PATCH_DEPENDS("hkbNode", 1)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbGenerator", 0)
    HK_PATCH_DEPENDS("hkbTransitionEffect", 0)
    HK_PATCH_DEPENDS("hkbBindable", 0)
    HK_PATCH_DEPENDS("hkbStateMachineTransitionInfo", 1)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkbStateMachineTransitionInfoReference", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBlenderGeneratorChildInternalState", 0)
	HK_PATCH_MEMBER_ADDED("isActive", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("syncNextFrame", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEvaluateExpressionModifierInternalExpressionData", 0)
	HK_PATCH_MEMBER_ADDED("raisedEvent", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("wasTrueInPreviousFrame", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbGeneratorSyncInfoSyncPoint", 0)
	HK_PATCH_MEMBER_ADDED("id", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("time", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbGeneratorSyncInfo", 0)
	HK_PATCH_MEMBER_ADDED("syncPoints", TYPE_TUPLE_STRUCT, "hkbGeneratorSyncInfoSyncPoint", 8)
	HK_PATCH_MEMBER_ADDED("baseFrequency", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("localTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("playbackSpeed", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numSyncPoints", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isCyclic", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isMirrored", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isAdditive", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbGeneratorSyncInfoSyncPoint", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventsFromRangeModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("wasActiveInPreviousFrame", TYPE_ARRAY_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbManualSelectorGeneratorInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("currentGeneratorIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbPositionRelativeSelectorGeneratorInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("entryPosition", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("entryForward", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("lastTargetPos", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("lastTargetRot", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("targetLinearDisp", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("targetAngularDisp", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("clipTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("currentGeneratorIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("usingBlendToFixPositionGenerator", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("doLeadInFixup", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbGeneratorTransitionEffectInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("timeInTransition", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("duration", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("effectiveBlendInDuration", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("effectiveBlendOutDuration", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("toGeneratorState", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("echoTransitionGenerator", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("echoToGenerator", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("justActivated", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("updateActiveNodes", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("stage", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCombineTransformsModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("translationOut", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("rotationOut", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbDelayedModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("secondsElapsed", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isActive", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbDampingModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("dampedVector", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vecErrorSum", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vecPreviousError", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("dampedValue", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("errorSum", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("previousError", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbStateMachineInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("activeTransitions", TYPE_ARRAY_STRUCT, "hkbStateMachineActiveTransitionInfo", 0)
	HK_PATCH_MEMBER_ADDED("transitionFlags", TYPE_ARRAY_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("wildcardTransitionFlags", TYPE_ARRAY_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("delayedTransitions", TYPE_ARRAY_STRUCT, "hkbStateMachineDelayedTransitionInfo", 0)
	HK_PATCH_MEMBER_ADDED("timeInState", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("lastLocalTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("currentStateId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("previousStateId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("nextStartStateIndexOverride", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("stateOrTransitionChanged", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("echoNextUpdate", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbStateMachineDelayedTransitionInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbStateMachineActiveTransitionInfo", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbTransformVectorModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("vectorOut", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbComputeRotationToTargetModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("rotationOut", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbClipGeneratorInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("extractedMotion", TYPE_VEC_12, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("echos", TYPE_ARRAY_STRUCT, "hkbClipGeneratorEcho", 0)
	HK_PATCH_MEMBER_ADDED("localTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("time", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("previousUserControlledTimeFraction", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("bufferSize", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("echoBufferSize", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("atEnd", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("ignoreStartTime", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pingPongBackward", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbClipGeneratorEcho", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbJigglerModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("currentVelocitiesWS", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("currentPositions", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("timeStep", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("initNextModify", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSplinePathGeneratorInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("entryPosition", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("entryForward", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("exitPosition", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("exitForward", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("averageSpeed", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pathTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("curTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pathParam", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("currentGeneratorIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("doLeadInFixup", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("eventTriggered", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbMoveCharacterModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("timeSinceLastModify", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbLookAtModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("lookAtLastTargetWS", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("lookAtWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isTargetInsideLimitCone", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbTimerModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("secondsElapsed", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbRotateCharacterModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("angle", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbComputeRotationFromAxisAngleModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("rotationOut", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbPoseMatchingGeneratorInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("currentMatch", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("bestMatch", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("timeSinceBetterMatch", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("error", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("resetCurrentMatchLocalTime", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBlendingTransitionEffectInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterPoseAtBeginningOfTransition", TYPE_ARRAY_VEC_12, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("timeRemaining", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("timeInTransition", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("applySelfTransition", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("initializeCharacterPose", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbGetUpModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("timeSinceBegin", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("timeStep", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("initNextModify", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventDrivenModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("isActive", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbComputeDirectionModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("pointOut", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("groundAngleOut", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("upAngleOut", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("computedOutput", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEvaluateExpressionModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("internalExpressionsData", TYPE_ARRAY_STRUCT, "hkbEvaluateExpressionModifierInternalExpressionData", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbEvaluateExpressionModifierInternalExpressionData", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBlenderGeneratorInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("childrenInternalStates", TYPE_ARRAY_STRUCT, "hkbBlenderGeneratorChildInternalState", 0)
	HK_PATCH_MEMBER_ADDED("sortedChildren", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("endIntervalWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numActiveChildren", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("beginIntervalIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("endIntervalIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("initSync", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("doSubtractiveBlend", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbBlenderGeneratorChildInternalState", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSequenceInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("nextSampleEvents", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("nextSampleReals", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("nextSampleBools", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("nextSampleInts", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("time", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbDetectCloseToGroundModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("isCloseToGround", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbGetWorldFromModelModifierInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("translationOut", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("rotationOut", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbExtrapolatingTransitionEffectInternalState", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("fromGeneratorSyncInfo", TYPE_STRUCT, "hkbGeneratorSyncInfo", 0)
	HK_PATCH_MEMBER_ADDED("worldFromModel", TYPE_VEC_12, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("motion", TYPE_VEC_12, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pose", TYPE_ARRAY_VEC_12, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("additivePose", TYPE_ARRAY_VEC_12, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("toGeneratorDuration", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("isFromGeneratorActive", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("gotPose", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("gotAdditivePose", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbGeneratorSyncInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterSkinInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("skinIds", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("instanceName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("templateName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("fullPathToProject", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("event", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBehaviorInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_OBJECT, "hkbBehaviorGraphData", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbBehaviorGraphData", 2)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventRaisedInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("eventName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("raisedBySdk", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbRaiseEventCommand", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("global", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("externalId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSetWordVariableCommand", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("quadValue", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("variableId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("value", TYPE_STRUCT, "hkbVariableValue", 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("global", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbVariableValue", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterControlCommand", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("command", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbContext", 0, "hkbContext", 1)
	HK_PATCH_MEMBER_REMOVED("projectData", TYPE_OBJECT, "hkbProjectData", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbProjectData", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachine", 2, "hkbStateMachine", 3)
	HK_PATCH_FUNCTION(hkbStateMachine_2_to_3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterSetup", 1, "hkbCharacterSetup", 2)
	HK_PATCH_MEMBER_REMOVED("ragdollSkeleton", TYPE_OBJECT, "hkaSkeleton", 0)
	HK_PATCH_DEPENDS("hkaSkeleton", 2)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbLinkedSymbolInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("eventNames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("variableNames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbFootIkControlsModifierLeg", 0)
    HK_PATCH_MEMBER_ADDED("groundPosition", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("ungroundedEvent", TYPE_STRUCT, "hkbEventProperty" , 0)
    HK_PATCH_MEMBER_ADDED_REAL("verticalError", 0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("hitSomething", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("isPlantedMS", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFootIkControlsModifier", 0, "hkbFootIkControlsModifier", 1)
    HK_PATCH_MEMBER_ADDED("legs", TYPE_ARRAY_STRUCT, "hkbFootIkControlsModifierLeg", 0)
    HK_PATCH_DEPENDS("hkbFootIkControlsModifierLeg", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRagdollController", 3, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("ragdollBlendOutTime", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("character", TYPE_OBJECT, "hkbCharacter", 0)
	HK_PATCH_MEMBER_REMOVED("ragdollInstance", TYPE_OBJECT, "hkaRagdollInstance", 0)
	HK_PATCH_MEMBER_REMOVED("ragdollPoseWS", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("firstGenerateAfterRagdollIsAddedToWorld", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("firstGenerateAfterRigidBodyControllerActive", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("autoAddRemoveRagdollToWorld", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("isEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("isPoweredControllerEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("isRigidBodyControllerEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("worldFromModelModeData", TYPE_STRUCT, "hkbWorldFromModelModeData", 0)
	HK_PATCH_MEMBER_REMOVED("useAsynchronousStepping", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbWorldFromModelModeData", 0)
	HK_PATCH_DEPENDS("hkbCharacter", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaRagdollInstance", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterData", 5, "hkbCharacterData", 6)
    HK_PATCH_MEMBER_ADDED("footIkDriverInfo", TYPE_OBJECT, "hkbFootIkDriverInfo", 0)
    HK_PATCH_DEPENDS("hkbFootIkDriverInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbFootIkDriverInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("legs", TYPE_ARRAY_STRUCT, "hkbFootIkDriverInfoLeg", 0)
    HK_PATCH_MEMBER_ADDED_REAL("raycastDistanceUp", 0.500000f)
    HK_PATCH_MEMBER_ADDED_REAL("raycastDistanceDown", 0.800000f)
    HK_PATCH_MEMBER_ADDED_REAL("originalGroundHeightMS", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("verticalOffset", 0.000000f)
    HK_PATCH_MEMBER_ADDED_INT("collisionFilterInfo", 3)
    HK_PATCH_MEMBER_ADDED_REAL("forwardAlignFraction", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("sidewaysAlignFraction", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("sidewaysSampleWidth", 0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("lockFeetWhenPlanted", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("useCharacterUpVector", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("isQuadrupedNarrow", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbFootIkDriverInfoLeg", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbFootIkDriverInfoLeg", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("kneeAxisLS", 0.000000f,0.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("footEndLS", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("footPlantedAnkleHeightMS", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("footRaisedAnkleHeightMS", 0.500000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxAnkleHeightMS", 0.700000f)
    HK_PATCH_MEMBER_ADDED_REAL("minAnkleHeightMS", -0.100000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxKneeAngleDegrees", 180.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("minKneeAngleDegrees", 0.000000f)
    HK_PATCH_MEMBER_ADDED_INT("hipIndex", -1)
    HK_PATCH_MEMBER_ADDED_INT("kneeIndex", -1)
    HK_PATCH_MEMBER_ADDED_INT("ankleIndex", -1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSimpleCharacter", 3, "hkbSimpleCharacter", 4)
	HK_PATCH_MEMBER_REMOVED("ragdollController", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbRagdollController", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbActiveNodesInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("activeNodes", TYPE_ARRAY_STRUCT, "hkbActiveNodesInfoActiveNode", 0)
	HK_PATCH_MEMBER_ADDED("activeEventIds", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("activeVariableIds", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbActiveNodesInfoActiveNode", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbActiveNodesInfoActiveNode", 0)
	HK_PATCH_MEMBER_ADDED("nodeName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userData0", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userData1", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("id", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("depth", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBehaviorEventsInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("externalEventIds", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacter", 0, "hkbCharacter", 1)
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbParticleSystemEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEventPayload")
	HK_PATCH_MEMBER_ADDED_BYTE("type", 1)
	HK_PATCH_MEMBER_ADDED_INT("emitBoneIndex", -1)
	HK_PATCH_MEMBER_ADDED_VEC_4("offset", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_VEC_4("direction", 0.000000f,0.000000f,1.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("speed", 1.000000f)
	HK_PATCH_MEMBER_ADDED_INT("numParticles", 100)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollControlData", 0, "hkbPoweredRagdollControlData", 1)
	HK_PATCH_MEMBER_ADDED("easeConstraintLimitsDuration", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCameraShakeEventPayload", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEventPayload")
	HK_PATCH_MEMBER_ADDED_REAL("amplitude", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("halfLife", 1.000000f)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSceneModifierList", 0, "hkbSceneModifierList", 1)
	HK_PATCH_FUNCTION(hkbSceneModifierList_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSetNodePropertyCommand", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("nodeName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("propertyName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("propertyValue", TYPE_STRUCT, "hkbVariableValue", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbVariableValue", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbProjectData", 0, "hkbProjectData", 1)
	HK_PATCH_MEMBER_ADDED_INT("defaultEventMode", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbTwistModifier", 0, "hkbTwistModifier", 1)
	HK_PATCH_MEMBER_ADDED_INT("rotationAxisCoordinates", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBehaviorGraph", 0, "hkbBehaviorGraph", 1)
	HK_PATCH_FUNCTION(hkbBehaviorGraph_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSimpleCharacter", 4, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbCharacter", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("nearbyCharacters", TYPE_ARRAY_OBJECT, "hkbCharacter", 0)
	HK_PATCH_MEMBER_REMOVED("setup", TYPE_OBJECT, "hkbCharacterSetup", 0)
	HK_PATCH_MEMBER_REMOVED("worldFromModel", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("poseLocal", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("deleteWorldFromModel", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("deletePoseLocal", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("ragdollWorldFromModel", TYPE_VEC_12, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("behaviorGraph", TYPE_OBJECT, "hkbBehaviorGraph", 0)
	HK_PATCH_MEMBER_REMOVED("projectData", TYPE_OBJECT, "hkbProjectData", 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkbProjectData", 1)
	HK_PATCH_DEPENDS("hkbCharacter", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbCharacterSetup", 2)
	HK_PATCH_DEPENDS("hkbGenerator", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbBehaviorGraph", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacter", 1, "hkbCharacter", 2)
	HK_PATCH_MEMBER_ADDED("nearbyCharacters", TYPE_ARRAY_OBJECT, "hkbCharacter", 0)
	HK_PATCH_MEMBER_ADDED("setup", TYPE_OBJECT, "hkbCharacterSetup", 0)
	HK_PATCH_MEMBER_ADDED("behaviorGraph", TYPE_OBJECT, "hkbBehaviorGraph", 0)
	HK_PATCH_MEMBER_ADDED("projectData", TYPE_OBJECT, "hkbProjectData", 0)
	HK_PATCH_MEMBER_ADDED("currentLod", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkbCharacterSetup", 2)
	HK_PATCH_DEPENDS("hkbGenerator", 0)
	HK_PATCH_DEPENDS("hkbProjectData", 1)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkbBehaviorGraph", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbProjectStringData", 0, "hkbProjectStringData", 1)
	HK_PATCH_MEMBER_ADDED("fullPathToSource", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbWorldEnums", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSimulationControlCommand", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("command", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSimulationStateInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("simulationState", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbStateChooser", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachine", 3, "hkbStateMachine", 4)
	HK_PATCH_MEMBER_ADDED("startStateChooser", TYPE_OBJECT, "hkbStateChooser", 0)
	HK_PATCH_DEPENDS("hkbStateChooser", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBallModifier", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("velocity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("applyForceEventId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("applyForce", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbNode", 1)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbBindable", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSetLocalTimeOfClipGeneratorCommand", 0)
   HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
   HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
   HK_PATCH_MEMBER_ADDED("localTime", TYPE_REAL, HK_NULL, 0)
   HK_PATCH_MEMBER_ADDED("nodeId", TYPE_INT, HK_NULL, 0)
   HK_PATCH_DEPENDS("hkBaseObject", 0)
   HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollControlData", 1, "hkbPoweredRagdollControlData", 2)
	HK_PATCH_MEMBER_REMOVED("easeConstraintLimitsDuration", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterControllerModifierInternalState", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("gravity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("timestep", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isInitialVelocityAdded", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isTouchingGround", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterControllerModifier", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
    HK_PATCH_MEMBER_ADDED("controlData", TYPE_STRUCT, "hkbCharacterControllerControlData", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("initialVelocity", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED("initialVelocityCoordinates", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_INT("motionMode", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("forceDownwardMomentum", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("applyGravity", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("setInitialVelocity", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("isTouchingGround", 1)
    HK_PATCH_DEPENDS("hkbNode", 1)
    HK_PATCH_DEPENDS("hkbCharacterControllerControlData", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbBindable", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterControllerControlData", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("desiredVelocity", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("verticalGain", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("horizontalCatchUpGain", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxVerticalSeparation", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxHorizontalSeparation", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbTestStateChooser", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbStateChooser")
	HK_PATCH_MEMBER_ADDED("int", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("real", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("string", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbStateChooser", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbHandIkDriverInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("hands", TYPE_ARRAY_STRUCT, "hkbHandIkDriverInfoHand", 0)
    HK_PATCH_MEMBER_ADDED_INT("fadeInOutCurve", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbHandIkDriverInfoHand", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbHandIkDriverInfoHand", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("elbowAxisLS", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("backHandNormalLS", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("handOffsetLS", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("handOrienationOffsetLS", 0.000000f,0.000000f,0.000000f,1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxElbowAngleDegrees", 180.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("minElbowAngleDegrees", 0.000000f)
    HK_PATCH_MEMBER_ADDED_INT("shoulderIndex", -1)
    HK_PATCH_MEMBER_ADDED_INT("shoulderSiblingIndex", -1)
    HK_PATCH_MEMBER_ADDED_INT("elbowIndex", -1)
    HK_PATCH_MEMBER_ADDED_INT("elbowSiblingIndex", -1)
    HK_PATCH_MEMBER_ADDED_INT("wristIndex", -1)
    HK_PATCH_MEMBER_ADDED_BYTE("enforceEndPosition", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("enforceEndRotation", 0)
    HK_PATCH_MEMBER_ADDED_CSTRING("localFrameName", HK_NULL)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbHandIkControlData", 1, "hkbHandIkControlData", 2)
    HK_PATCH_MEMBER_ADDED_POINTER("targetHandle", "hkbHandle", 0)
	HK_PATCH_MEMBER_RENAMED("positionOnFraction", "transformOnFraction")
    HK_PATCH_MEMBER_ADDED_REAL("extrapolationTimeStep", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("handleChangeSpeed", 1.000000f)
    HK_PATCH_MEMBER_ADDED_INT("handleChangeMode", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("fixUp", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbHandle", 1)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterData", 6, "hkbCharacterData", 7)
    HK_PATCH_MEMBER_ADDED("handIkDriverInfo", TYPE_OBJECT, "hkbHandIkDriverInfo", 0)
    HK_PATCH_DEPENDS("hkbHandIkDriverInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSceneModifierListSceneModifierEntry", 0, "hkbSceneModifierListSceneModifierEntry", 1)
	HK_PATCH_MEMBER_REMOVED("postSceneModifier", TYPE_OBJECT, "hkbModifier",0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbLookAtModifier", 1, "hkbLookAtModifier", 2)
	HK_PATCH_MEMBER_ADDED_VEC_4("eyePositionHS", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_ADDED("isTargetInsideLimitCone", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbJigglerModifier", 0, "hkbJigglerModifier", 1)
	HK_PATCH_MEMBER_ADDED_INT("jiggleCoordinates", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbEventBase", 0)
	HK_PATCH_MEMBER_ADDED_INT("id", -1)
	HK_PATCH_MEMBER_ADDED("payload", TYPE_OBJECT, "hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkbEventPayload", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbEventProperty", 0, "hkbEventProperty", 1)
	HK_PATCH_PARENT_SET("hkbEvent", "hkbEventBase")
HK_PATCH_END()

HK_PATCH_BEGIN("hkbEvent", 0, "hkbEvent", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkbEventBase")
	HK_PATCH_MEMBER_REMOVED("id", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("payload", TYPE_OBJECT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbStateMachineEventPropertyArray", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("events", TYPE_ARRAY_STRUCT, "hkbEventProperty", 0 )
	HK_PATCH_DEPENDS("hkbEventProperty", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbEventBase", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineStateInfo", 3, "hkbStateMachineStateInfo", 4)
	HK_PATCH_MEMBER_ADDED("enterNotifyEvents", TYPE_OBJECT, "hkbStateMachineEventPropertyArray", 0)
	HK_PATCH_MEMBER_ADDED("exitNotifyEvents", TYPE_OBJECT, "hkbStateMachineEventPropertyArray", 0)
	HK_PATCH_FUNCTION(hkbStateMachineStateInfo_3_to_4)
	HK_PATCH_MEMBER_REMOVED("enterNotifyEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_MEMBER_REMOVED("exitNotifyEvent", TYPE_STRUCT, "hkbEventProperty", 0)
	HK_PATCH_DEPENDS("hkbEventProperty", 1)
	HK_PATCH_DEPENDS("hkbEventBase", 0)
	HK_PATCH_DEPENDS("hkbStateMachineEventPropertyArray", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineTransitionInfoReference", 0, "hkbStateMachineTransitionInfoReference", 1)
	HK_PATCH_MEMBER_ADDED_INT("stateMachineId", -1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoseMatchingGenerator", 1, "hkbPoseMatchingGenerator", 2)
	HK_PATCH_MEMBER_ADDED_INT("startMatchingEventId", -1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbStateMachineDelayedTransitionInfo", 0, "hkbStateMachineDelayedTransitionInfo", 1)
	HK_PATCH_MEMBER_ADDED("timeDelayed", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterSteppedInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("deltaTime", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbEventRaisedInfo", 0, "hkbEventRaisedInfo", 1)
	HK_PATCH_MEMBER_ADDED("senderId", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbLookAtModifier", 2, "hkbLookAtModifier", 3)
	HK_PATCH_MEMBER_RENAMED("headForwardHS", "headForwardLS")
	HK_PATCH_MEMBER_RENAMED("headRightHS", "neckRightLS")
    HK_PATCH_MEMBER_ADDED_VEC_4("neckForwardLS", 0.000000f,1.000000f,0.000000f,0.000000f)
	HK_PATCH_FUNCTION(hkbLookAtModifier_2_to_3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBehaviorInfoIdToNamePair", 0)
	HK_PATCH_MEMBER_ADDED("behaviorName", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("nodeName", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("toolType", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("id", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBehaviorInfo", 0, "hkbBehaviorInfo", 1)
	HK_PATCH_MEMBER_ADDED("idToNamePairs", TYPE_ARRAY_STRUCT, "hkbBehaviorInfoIdToNamePair", 0)
	HK_PATCH_DEPENDS("hkbBehaviorInfoIdToNamePair", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfigCharacterInfo", 2, "hkbDemoConfigCharacterInfo", 3)
	HK_PATCH_MEMBER_RENAMED("characterDataFilename", "overrideCharacterDataFilename")
	HK_PATCH_MEMBER_RENAMED("behaviorFilename", "overrideBehaviorFilename")
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRigidBodyRagdollControlData", 0, "hkbRigidBodyRagdollControlData", 1)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("durationToBlend", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbActiveNodesInfo", 0, "hkbActiveNodesInfo", 1)
	HK_PATCH_MEMBER_REMOVED("activeNodes", TYPE_ARRAY_STRUCT, "hkbActiveNodesInfoActiveNode", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbActiveNodesInfo", 1, HK_NULL, HK_CLASS_REMOVED)
   HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
   HK_PATCH_MEMBER_REMOVED("characterId", TYPE_INT, HK_NULL, 0)
   HK_PATCH_MEMBER_REMOVED("activeEventIds", TYPE_ARRAY_INT, HK_NULL, 0)
   HK_PATCH_MEMBER_REMOVED("activeVariableIds", TYPE_ARRAY_INT, HK_NULL, 0)
   HK_PATCH_DEPENDS("hkBaseObject", 0)
   HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbActiveNodesInfoActiveNode", 0, HK_NULL, HK_CLASS_REMOVED)
   HK_PATCH_MEMBER_REMOVED("nodeName", TYPE_CSTRING, HK_NULL, 0)
   HK_PATCH_MEMBER_REMOVED("userData0", TYPE_INT, HK_NULL, 0)
   HK_PATCH_MEMBER_REMOVED("userData1", TYPE_INT, HK_NULL, 0)
   HK_PATCH_MEMBER_REMOVED("id", TYPE_INT, HK_NULL, 0)
   HK_PATCH_MEMBER_REMOVED("type", TYPE_BYTE, HK_NULL, 0)
   HK_PATCH_MEMBER_REMOVED("depth", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBlendingTransitionEffect", 0, "hkbBlendingTransitionEffect", 1)
	HK_PATCH_MEMBER_DEFAULT_SET_INT("flags", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterAddedInfo", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("instanceName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("templateName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("fullPathToProject", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("skeleton", TYPE_OBJECT, "hkaSkeleton", 0)
	HK_PATCH_MEMBER_ADDED("worldFromModel", TYPE_VEC_12, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("poseModelSpace", TYPE_ARRAY_VEC_12, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaSkeleton", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterSteppedInfo", 0, "hkbCharacterSteppedInfo", 1)
	HK_PATCH_MEMBER_ADDED("worldFromModel", TYPE_VEC_12, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("poseModelSpace", TYPE_ARRAY_VEC_12, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterInfo", 0, "hkbCharacterInfo", 1)
	HK_PATCH_MEMBER_REMOVED("instanceName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("templateName", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("fullPathToProject", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterSkinInfo", 0, "hkbCharacterSkinInfo", 1)
	HK_PATCH_MEMBER_ADDED("hasRagdoll", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbExpressionCondition", 0, "hkbExpressionCondition", 1)
	HK_PATCH_MEMBER_REMOVED("compiledExpressionSet", TYPE_OBJECT, "hkbCompiledExpressionSet", 0)
	HK_PATCH_DEPENDS("hkbCompiledExpressionSet", 1)
HK_PATCH_END()
HK_PATCH_BEGIN("hkbEvaluateExpressionModifier", 0, "hkbEvaluateExpressionModifier", 1)
	HK_PATCH_MEMBER_REMOVED("compiledExpressionSet", TYPE_OBJECT, "hkbCompiledExpressionSet", 0)
	HK_PATCH_DEPENDS("hkbCompiledExpressionSet", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbHandIkDriverInfoHand", 0, "hkbHandIkDriverInfoHand", 1)
	HK_PATCH_MEMBER_DEFAULT_SET_VEC_4("elbowAxisLS", 0.000000f,1.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_VEC_4("backHandNormalLS", 0.000000f,1.000000f,0.000000f,0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbHandIkModifierHand", 2, "hkbHandIkModifierHand", 3)
	HK_PATCH_MEMBER_DEFAULT_SET_VEC_4("elbowAxisLS", 0.000000f,1.000000f,0.000000f,0.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_VEC_4("backHandNormalLS", 0.000000f,1.000000f,0.000000f,0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterStringData", 4, "hkbCharacterStringData", 5)
	HK_PATCH_MEMBER_ADDED("mirroredSyncPointSubstringsA", TYPE_ARRAY_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("mirroredSyncPointSubstringsB", TYPE_ARRAY_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbPoweredRagdollControlData", 2, "hkbPoweredRagdollControlData", 3)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("maxForce", 50.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSceneModifierList", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("sceneModifierEntries", TYPE_ARRAY_STRUCT, "hkbSceneModifierListSceneModifierEntry", 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkbSceneModifierListSceneModifierEntry", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbModifier", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSceneModifierListSceneModifierEntry", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("sceneModifier", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbProjectData", 1, "hkbProjectData", 2)
	HK_PATCH_MEMBER_REMOVED("attachmentSetups", TYPE_ARRAY_OBJECT, "hkbAttachmentSetup", 0)
	HK_PATCH_DEPENDS("hkbAttachmentSetup", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterSkinInfo", 1, "hkbCharacterSkinInfo", 2)
    HK_PATCH_MEMBER_REMOVED("skinIds", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("hasRagdoll", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("deformableSkins", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rigidSkins", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterSteppedInfo", 1, "hkbCharacterSteppedInfo", 2)
    HK_PATCH_MEMBER_ADDED("rigidAttachmentTransforms", TYPE_ARRAY_VEC_12, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbSetBehaviorCommand", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("behavior", TYPE_OBJECT, "hkbBehaviorGraph", 0)
	HK_PATCH_MEMBER_ADDED("rootGenerator", TYPE_OBJECT, "hkbGenerator", 0)
	HK_PATCH_MEMBER_ADDED("referencedBehaviors", TYPE_ARRAY_OBJECT, "hkbBehaviorGraph", 0)
	HK_PATCH_MEMBER_ADDED("startStateIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("randomizeSimulation", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkbNode", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkbGenerator", 0)
	HK_PATCH_DEPENDS("hkbBindable", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkbBehaviorGraph", 1)
HK_PATCH_END()


HK_PATCH_BEGIN("hkbSetNodePropertyCommand", 0, "hkbSetNodePropertyCommand", 1)
	HK_PATCH_MEMBER_ADDED_INT("padding", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterInfo", 1, "hkbCharacterInfo", 2)
	HK_PATCH_MEMBER_ADDED_INT("padding", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBehaviorEventsInfo", 0, "hkbBehaviorEventsInfo", 1)
	HK_PATCH_MEMBER_ADDED_INT("padding", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbSetBehaviorCommand", 0, "hkbSetBehaviorCommand", 1)
	HK_PATCH_MEMBER_ADDED_INT("padding", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbEventRaisedInfo", 1, "hkbEventRaisedInfo", 2)
	HK_PATCH_MEMBER_ADDED_INT("padding", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterControlCommand", 0, "hkbCharacterControlCommand", 1)
	HK_PATCH_MEMBER_ADDED_INT("padding", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbBehaviorGraphInternalStateInfo", 1)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("internalState", TYPE_OBJECT, "hkbBehaviorGraphInternalState", 0)
        HK_PATCH_MEMBER_ADDED("auxiliaryNodeInfo", TYPE_ARRAY_OBJECT, "hkbAuxiliaryNodeInfo", 0)
        HK_PATCH_MEMBER_ADDED("activeEventIds", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("activeVariableIds", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkbBehaviorGraphInternalState", 0)
        HK_PATCH_DEPENDS("hkbAuxiliaryNodeInfo", 1)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbClientCharacterState", 1)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("deformableSkinIds", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("rigidSkinIds", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("externalEventIds", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("auxiliaryInfo", TYPE_ARRAY_OBJECT, "hkbAuxiliaryNodeInfo", 0)
        HK_PATCH_MEMBER_ADDED("activeEventIds", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("activeVariableIds", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("instanceName", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("templateName", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("fullPathToProject", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("behaviorData", TYPE_OBJECT, "hkbBehaviorGraphData", 0)
        HK_PATCH_MEMBER_ADDED("behaviorInternalState", TYPE_OBJECT, "hkbBehaviorGraphInternalState", 0)
        HK_PATCH_MEMBER_ADDED("visible", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("elapsedSimulationTime", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("skeleton", TYPE_OBJECT, "hkaSkeleton", 0)
        HK_PATCH_MEMBER_ADDED("worldFromModel", TYPE_VEC_12, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("poseModelSpace", TYPE_ARRAY_VEC_12, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("rigidAttachmentTransforms", TYPE_ARRAY_VEC_12, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkbAuxiliaryNodeInfo", 1)
        HK_PATCH_DEPENDS("hkbBehaviorGraphData", 2)
        HK_PATCH_DEPENDS("hkbBehaviorGraphInternalState", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hkaSkeleton", 3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAuxiliaryNodeInfo", 1)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("depth", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("referenceBehaviorName", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("selfTransitionNames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
