/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

// AI specific product patches.
// This file is #included by hkaiPatches.cpp

//=======
// 650b1
//=======

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiTriangleMesh", 0)
	HK_PATCH_MEMBER_ADDED("triangles", TYPE_ARRAY_STRUCT, "hkaiTriangleMeshTriangle", 0)
	HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkaiTriangleMeshTriangle", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiDefaultNavMeshCostModifier", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("edgeMaskLookupTable", TYPE_TUPLE_INT, HK_NULL, 32)
	HK_PATCH_MEMBER_ADDED_REAL("maxCostPenalty", 1.000000f)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshCutter", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("originalNumFaces", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("originalNumEdges", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("originalNumVertices", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("magic", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("mesh", TYPE_OBJECT, "hkaiNavMesh", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMesh", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiWorld", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("up", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("navMesh", TYPE_OBJECT, "hkaiNavMesh", 0)
	HK_PATCH_MEMBER_ADDED("characters", TYPE_ARRAY_OBJECT, "hkaiCharacter", 0)
	HK_PATCH_MEMBER_ADDED("bounds", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_MEMBER_ADDED("dynamicNavMesh", TYPE_STRUCT, "hkaiNavMesh", 0)
	HK_PATCH_MEMBER_ADDED("cutter", TYPE_STRUCT, "hkaiNavMeshCutter", 0)
	HK_PATCH_MEMBER_ADDED("cutOptions", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("silhouetteQuantizationBits", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("silhouetteRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	HK_PATCH_DEPENDS("hkaiNavMesh", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutter", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiCharacter", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCutNavMeshQueryMediator", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkaiNavMeshQueryMediator")
	HK_PATCH_MEMBER_ADDED("cutter", TYPE_OBJECT, "hkaiNavMeshCutter", 0)
	HK_PATCH_MEMBER_ADDED("orig", TYPE_OBJECT, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutter", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshCostModifier", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPathFollowingProperties", 0)
	HK_PATCH_MEMBER_ADDED_REAL("searchPathLimit", 5.000000f)
	HK_PATCH_MEMBER_ADDED("changeSegmentDist", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("desiredSpeedAtEnd", 0.0f)
	HK_PATCH_MEMBER_ADDED_REAL("slowdownToEndDist", -1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("goalDistTolerance", 0.250000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshUserEdge", 0)
	HK_PATCH_MEMBER_ADDED("startPoint", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("endPoint", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("oppositeFace", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("cost", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshEdge", 0)
	HK_PATCH_MEMBER_ADDED("a", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("b", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("oppositeEdge", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("oppositeFace", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vertexClearance", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiTriangleMeshTriangle", 0)
	HK_PATCH_MEMBER_ADDED("userData", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshFace", 0)
	HK_PATCH_MEMBER_ADDED("startEdgeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("startUserEdgeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numEdges", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numUserEdges", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("regionId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMesh", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("faces", TYPE_ARRAY_STRUCT, "hkaiNavMeshFace", 0)
	HK_PATCH_MEMBER_ADDED("edges", TYPE_ARRAY_STRUCT, "hkaiNavMeshEdge", 0)
	HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userEdges", TYPE_ARRAY_STRUCT, "hkaiNavMeshUserEdge", 0)
	HK_PATCH_MEMBER_ADDED("numRegions", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("queryMediator", TYPE_OBJECT, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshFace", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshEdge", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshUserEdge", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCharacter", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("forward", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("goalPosition", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("velocity", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("desiredSpeed", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("angularVelocity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("id", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pathFollowingProperties", TYPE_STRUCT, "hkaiPathFollowingProperties", 0)
	HK_PATCH_MEMBER_ADDED("state", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("currentPathSegment", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("startNode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("goalNode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("debugDisplayEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiPathFollowingProperties", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

// *****    DONE    *****

//=======
// 650r1
//=======

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPath", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("positions", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("navMeshEdges", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("startNode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("goalNode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiAvoidanceSolverMovementProperties", 0)
	HK_PATCH_MEMBER_ADDED("minVelocity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxVelocity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxAcceleration", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxDeceleration", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxAngularVelocity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxAngularAcceleration", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiAvoidanceSolverAvoidanceProperties", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("movementProperties", TYPE_STRUCT, "hkaiAvoidanceSolverMovementProperties", 0)
	HK_PATCH_MEMBER_ADDED("radius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("weight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("cosViewAngle", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("agentLimitTime", 1.000000f)
	HK_PATCH_MEMBER_ADDED("agentPenaltyWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("obstacleLimitTime", 1.000000f)
	HK_PATCH_MEMBER_ADDED("obstaclePenaltyWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("boundaryLimitTime", 0.250000f)
	HK_PATCH_MEMBER_ADDED("boundaryPenaltyWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiAvoidanceSolverMovementProperties", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 0, "hkaiCharacter", 1)
	HK_PATCH_MEMBER_ADDED("path", TYPE_OBJECT, "hkaiPath", 0)
	HK_PATCH_MEMBER_ADDED("avoidanceProperties", TYPE_OBJECT, "hkaiAvoidanceSolverAvoidanceProperties", 0)
	HK_PATCH_DEPENDS("hkaiPath", 0)
HK_PATCH_END()

//=======
// 660b1
//=======

HK_PATCH_BEGIN("hkaiWorld", 0, "hkaiWorld", 1)
	HK_PATCH_MEMBER_ADDED("characterRadiusMultiplier", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("repathingThreshold", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 1, "hkaiWorld", 2)
	HK_PATCH_MEMBER_ADDED("maxObjectSize", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCutNavMeshQueryMediator", 0, "hkaiCutNavMeshQueryMediator", 1)
	HK_PATCH_MEMBER_ADDED_REAL("cutAabbTolerance", 0.050000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPath", 0, "hkaiPath", 1)
	HK_PATCH_MEMBER_ADDED("navMesh", TYPE_OBJECT, "hkaiNavMesh", 0)
	HK_PATCH_DEPENDS("hkaiNavMesh", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiAvoidanceSolverMovementProperties", 0, "hkaiAvoidanceSolverMovementProperties", 1)
	HK_PATCH_MEMBER_ADDED("maxTurnVelocity", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshCutterDebugSnapshot", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("cutter", TYPE_OBJECT, "hkaiNavMeshCutter", 0)
	HK_PATCH_MEMBER_ADDED("sils", TYPE_ARRAY_OBJECT, "hkaiCompoundSilhouette", 0)
	HK_PATCH_MEMBER_ADDED("faces", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutter", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiCompoundSilhouette", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCompoundSilhouette", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("points", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("new", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("dirty", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutter", 0, "hkaiNavMeshCutter", 1)
	HK_PATCH_MEMBER_ADDED("stepHeight", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 1, "hkaiCharacter", 2)
	HK_PATCH_MEMBER_ADDED_INT("agentFilterInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCarver", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiCharacter", 2, "hkaiCharacter", 3)
	HK_PATCH_MEMBER_ADDED("potentialGoalPositions", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("goalPositionSet", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiWorld", 2, "hkaiWorld", 3)
	HK_PATCH_MEMBER_ADDED("maxCharRepathPerFrame", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("cutCounter", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("projectionMode", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 3, "hkaiCharacter", 4)
	HK_PATCH_MEMBER_ADDED("userData", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("repathDelay", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPath", 1, "hkaiPath", 2)

HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPath", 2, "hkaiPath", 3)
	HK_PATCH_MEMBER_ADDED("hasUserEdges", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiAvoidanceSolverAvoidanceProperties", 0, "hkaiAvoidanceSolverAvoidanceProperties", 1)
	HK_PATCH_MEMBER_ADDED_REAL("limitObstacleDistance", 1.5f)
	HK_PATCH_MEMBER_ADDED_REAL("limitObstacleVelocity", 1.5f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiEdgeGeometryEdge", 0)
	HK_PATCH_MEMBER_ADDED("a", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("b", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("face", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiEdgeGeometryFace", 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiEdgeGeometry", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("edges", TYPE_ARRAY_STRUCT, "hkaiEdgeGeometryEdge", 0)
	HK_PATCH_MEMBER_ADDED("faces", TYPE_ARRAY_STRUCT, "hkaiEdgeGeometryFace", 0)
	HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("zeroFace", TYPE_STRUCT, "hkaiEdgeGeometryFace", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiEdgeGeometryEdge", 0)
	HK_PATCH_DEPENDS("hkaiEdgeGeometryFace", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiAvoidanceSolverAvoidanceProperties", 1, "hkaiAvoidanceSolverAvoidanceProperties", 2)
	HK_PATCH_MEMBER_ADDED_REAL("limitBoundaryDistance", 1.500000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshEdge", 0, "hkaiNavMeshEdge", 1)
	HK_PATCH_MEMBER_REMOVED("faceIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("oppositeSectionUid", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("oppositeRuntimeId", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMesh", 0, "hkaiNavMesh", 1)
	HK_PATCH_MEMBER_ADDED("sectionDependencies", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("sectionUid", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("runtimeId", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiWorldPendingGoal", 0)
	HK_PATCH_MEMBER_ADDED("numPositions", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("character", TYPE_OBJECT, "hkaiCharacter", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiCharacter", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiDefaultLocalSteering", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkaiLocalSteering")
	HK_PATCH_MEMBER_ADDED("pathFollowingProperties", TYPE_STRUCT, "hkaiDefaultLocalSteeringPathFollowingProperties", 0)
	HK_PATCH_MEMBER_ADDED("avoidanceProperties", TYPE_OBJECT, "hkaiAvoidanceSolverAvoidanceProperties", 0)
	HK_PATCH_DEPENDS("hkaiLocalSteering", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiDefaultLocalSteeringPathFollowingProperties", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiAvoidanceSolverAvoidanceProperties", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPathFollowingProperties", 0, "hkaiDefaultLocalSteeringPathFollowingProperties", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiLocalSteering", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 3, "hkaiWorld", 4)
	HK_PATCH_MEMBER_REMOVED("characterRadiusMultiplier", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pendingGoals", TYPE_ARRAY_STRUCT, "hkaiWorldPendingGoal", 0)
	HK_PATCH_MEMBER_ADDED("pendingGoalPositions", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkaiWorldPendingGoal", 0)
	//HK_PATCH_FUNCTION(hkaiWorld_3_to_4)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 4, "hkaiCharacter", 5)
	HK_PATCH_MEMBER_REMOVED("goalPosition", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("angularVelocity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("startNode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("goalNode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("debugDisplayEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("potentialGoalPositions", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("goalPositionSet", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("repathDelay", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("desiredVelocity", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("radius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("localSteering", TYPE_OBJECT, "hkaiLocalSteering", 0)
	HK_PATCH_FUNCTION(hkaiCharacter_4_to_5) // func
	HK_PATCH_MEMBER_REMOVED("pathFollowingProperties", TYPE_STRUCT, "hkaiDefaultLocalSteeringPathFollowingProperties", 0)
	HK_PATCH_MEMBER_REMOVED("avoidanceProperties", TYPE_OBJECT, "hkaiAvoidanceSolverAvoidanceProperties", 0)
	HK_PATCH_DEPENDS("hkaiDefaultLocalSteeringPathFollowingProperties", 0)
	HK_PATCH_DEPENDS("hkaiAvoidanceSolverAvoidanceProperties", 2)
	HK_PATCH_DEPENDS("hkaiLocalSteering", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshFace", 0, "hkaiNavMeshFace", 1)
	HK_PATCH_MEMBER_ADDED("clusterIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMesh", 1, "hkaiNavMesh", 2)
	HK_PATCH_MEMBER_ADDED("aabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	HK_PATCH_FUNCTION(hkaiNavMesh_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiTriangleMesh", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("triangles", TYPE_ARRAY_STRUCT, "hkaiTriangleMeshTriangle", 0)
	HK_PATCH_MEMBER_REMOVED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkaiTriangleMeshTriangle", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiTriangleMeshTriangle", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("userData", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiStreamingDirectedGraphExternalEdgeInfo", 0)
	HK_PATCH_MEMBER_ADDED("nodeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("edgeKey", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("targetUid", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiDirectedGraphExplicitCostEdge", 0)
	HK_PATCH_MEMBER_ADDED("cost", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("target", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiStreamingDirectedGraph", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkaiDirectedGraphExplicitCost")
	HK_PATCH_MEMBER_ADDED("sectionUid", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("externalEdges", TYPE_ARRAY_STRUCT, "hkaiStreamingDirectedGraphExternalEdgeInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiStreamingDirectedGraphExternalEdgeInfo", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiDirectedGraphExplicitCost", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiDirectedGraphExplicitCost", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("positions", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("nodes", TYPE_ARRAY_STRUCT, "hkaiDirectedGraphExplicitCostNode", 0)
	HK_PATCH_MEMBER_ADDED("edges", TYPE_ARRAY_STRUCT, "hkaiDirectedGraphExplicitCostEdge", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiDirectedGraphExplicitCostEdge", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiDirectedGraphExplicitCostNode", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiDirectedGraphExplicitCostNode", 0)
	HK_PATCH_MEMBER_ADDED("edgeStartIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numEdges", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshEdge", 1, "hkaiNavMeshEdge", 2)
	HK_PATCH_MEMBER_REMOVED("oppositeRuntimeId", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorldPendingGoal", 0, "hkaiWorldPendingGoal", 1)
	HK_PATCH_MEMBER_ADDED("positionIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshUserEdge", 0, "hkaiNavMeshUserEdge", 1)
	HK_PATCH_MEMBER_REMOVED("cost", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("oppositeSectionUid", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 5, "hkaiCharacter", 6)
	HK_PATCH_MEMBER_REMOVED("desiredVelocity", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("avoidanceState", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_INT("agentPriority", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiAvoidanceSolverAvoidanceProperties", 2, "hkaiAvoidanceSolverAvoidanceProperties", 3)
	HK_PATCH_MEMBER_REMOVED("agentPenaltyWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("boundaryPenaltyWeight", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiAvoidancePairPropertiesPairData", 1)
	HK_PATCH_MEMBER_ADDED_INT("key", 0)
	HK_PATCH_MEMBER_ADDED_REAL("weight", 0.500000f)
	HK_PATCH_MEMBER_ADDED_REAL("cosViewAngle", -0.421600f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiAvoidancePairProperties", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("avoidancePairDataMap", TYPE_ARRAY_OBJECT, "hkaiAvoidancePairPropertiesPairData", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiAvoidancePairPropertiesPairData", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 4, "hkaiWorld", 5)
	HK_PATCH_MEMBER_ADDED("avoidancePairProps", TYPE_OBJECT, "hkaiAvoidancePairProperties", 0)
	HK_PATCH_DEPENDS("hkaiAvoidancePairProperties", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 6, "hkaiCharacter", 7)
	HK_PATCH_MEMBER_ADDED_INT("family", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 7, "hkaiCharacter", 8)
	HK_PATCH_MEMBER_ADDED_BYTE("avoidanceEnabled", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiAvoidanceSolverAvoidanceProperties", 3, "hkaiAvoidanceSolverAvoidanceProperties", 4)
	HK_PATCH_MEMBER_REMOVED("weight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("cosViewAngle", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 8, "hkaiCharacter", 9)
	HK_PATCH_MEMBER_REMOVED("family", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_INT("avoidanceType", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCompoundSilhouette", 0, "hkaiCompoundSilhouette", 1)
	HK_PATCH_MEMBER_REMOVED("new", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("dirty", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMesh", 2, "hkaiNavMesh", 3)
	HK_PATCH_MEMBER_REMOVED("queryMediator", TYPE_OBJECT, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	//HK_PATCH_FUNCTION(hkaiNavMesh_2_to_3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPath", 3, "hkaiPath", 4)
	HK_PATCH_MEMBER_ADDED("mediator", TYPE_OBJECT, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	//HK_PATCH_FUNCTION(hkaiPath_3_to_4)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshManager", 0)
	HK_PATCH_MEMBER_ADDED("sections", TYPE_ARRAY_STRUCT, "hkaiNavMeshManagerSectionInfo", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshManagerSectionInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshCutterOriginalEdgeInfo", 0)
	HK_PATCH_MEMBER_ADDED("edgeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("oppositeEdge", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("oppositeFace", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshManagerSectionInfo", 0)
	HK_PATCH_MEMBER_ADDED("uid", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("sectionPtr", TYPE_OBJECT, "hkaiNavMesh", 0)
	HK_PATCH_MEMBER_ADDED("clusterGraph", TYPE_OBJECT, "hkaiStreamingDirectedGraph", 0)
	HK_PATCH_MEMBER_ADDED("mediator", TYPE_OBJECT, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMesh", 3)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiDirectedGraphExplicitCost", 0)
	HK_PATCH_DEPENDS("hkaiStreamingDirectedGraph", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiWorldDynamicNavMeshInfo", 0)
	HK_PATCH_MEMBER_ADDED("cutter", TYPE_OBJECT, "hkaiNavMeshCutter", 0)
	HK_PATCH_MEMBER_ADDED("dynamicMediator", TYPE_OBJECT, "hkaiCutNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkaiCutNavMeshQueryMediator", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutter", 1)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutterDebugSnapshot", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("cutter", TYPE_OBJECT, "hkaiNavMeshCutter", 0)
	HK_PATCH_MEMBER_REMOVED("sils", TYPE_ARRAY_OBJECT, "hkaiCompoundSilhouette", 0)
	HK_PATCH_MEMBER_REMOVED("faces", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutter", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiCompoundSilhouette", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutter", 1, "hkaiNavMeshCutter", 2)
	HK_PATCH_MEMBER_REMOVED("mesh", TYPE_OBJECT, "hkaiNavMesh", 0)
	HK_PATCH_MEMBER_ADDED("connectivityInfo", TYPE_ARRAY_STRUCT, "hkaiNavMeshCutterOriginalEdgeInfo", 0)
	HK_PATCH_DEPENDS("hkaiNavMesh", 3)
	HK_PATCH_DEPENDS("hkaiNavMeshCutterOriginalEdgeInfo", 0)
	//HK_PATCH_FUNCTION(hkaiNavMeshCutter_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 5, "hkaiWorld", 6)
	HK_PATCH_MEMBER_REMOVED("navMesh", TYPE_OBJECT, "hkaiNavMesh", 0)
	HK_PATCH_MEMBER_REMOVED("dynamicNavMesh", TYPE_STRUCT, "hkaiNavMesh", 0)
	HK_PATCH_MEMBER_REMOVED("cutter", TYPE_STRUCT, "hkaiNavMeshCutter", 0)
	HK_PATCH_MEMBER_REMOVED("repathingThreshold", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("maxCharRepathPerFrame", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("cutCounter", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("streamingManager", TYPE_STRUCT, "hkaiNavMeshManager", 0)
	HK_PATCH_MEMBER_ADDED("dynamicInfo", TYPE_ARRAY_STRUCT, "hkaiWorldDynamicNavMeshInfo", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutter", 1)
	HK_PATCH_DEPENDS("hkaiNavMesh", 3)
	HK_PATCH_DEPENDS("hkaiWorldDynamicNavMeshInfo", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshManager", 0)
	//HK_PATCH_FUNCTION(hkaiWorld_5_to_6)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshCutterCutOptions", 0)
	HK_PATCH_MEMBER_ADDED("cutFaceType", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 6, "hkaiWorld", 7)
	HK_PATCH_MEMBER_REMOVED("cutOptions", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("cutOptions", TYPE_STRUCT, "hkaiNavMeshCutterCutOptions", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutterCutOptions", 0)
	//HK_PATCH_FUNCTION(hkaiWorld_6_to_7)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiStreamingMediator", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkaiNavMeshQueryMediator")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshCutterMeshInfo", 0)
	HK_PATCH_MEMBER_ADDED("originalNumFaces", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("originalNumEdges", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("originalNumVertices", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("magic", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutter", 2, "hkaiNavMeshCutter", 3)
	HK_PATCH_MEMBER_REMOVED("originalNumFaces", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("originalNumEdges", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("originalNumVertices", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("magic", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("meshInfos", TYPE_ARRAY_OBJECT, "hkaiNavMeshCutterMeshInfo", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutterMeshInfo", 0)
	//HK_PATCH_FUNCTION(hkaiNavMeshCutter_2_to_3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 7, "hkaiWorld", 8)
	HK_PATCH_MEMBER_ADDED("cutter", TYPE_STRUCT, "hkaiNavMeshCutter", 0)
	HK_PATCH_MEMBER_ADDED("dynamicMediator", TYPE_OBJECT, "hkaiCutNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkaiCutNavMeshQueryMediator", 1)
	HK_PATCH_DEPENDS("hkaiNavMeshCutter", 2)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	//HK_PATCH_FUNCTION(hkaiWorld_7_to_8)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutterOriginalEdgeInfo", 0, "hkaiNavMeshCutterOriginalEdgeInfo", 1)
	HK_PATCH_MEMBER_REMOVED("edgeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("faceIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("edgeKey", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceKey", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorldDynamicNavMeshInfo", 0, "hkaiWorldDynamicNavMeshInfo", 1)
	HK_PATCH_MEMBER_REMOVED("cutter", TYPE_OBJECT, "hkaiNavMeshCutter", 0)
	HK_PATCH_MEMBER_REMOVED("dynamicMediator", TYPE_OBJECT, "hkaiCutNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkaiCutNavMeshQueryMediator", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutter", 2)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	//HK_PATCH_FUNCTION(hkaiWorldDynamicNavMeshInfo_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCharacterRepathInformation", 0)
	HK_PATCH_MEMBER_ADDED("pathAge", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pathFailCount", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("meshWasCut", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 9, "hkaiCharacter", 10)
	HK_PATCH_MEMBER_ADDED("repathInformation", TYPE_STRUCT, "hkaiCharacterRepathInformation", 0)
	HK_PATCH_DEPENDS("hkaiCharacterRepathInformation", 0)
	//HK_PATCH_FUNCTION(hkaiCharacter_9_to_10)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiStreamingMediator", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkaiNavMeshQueryMediator", HK_NULL)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshManager", 0, "hkaiNavMeshManager", 1)
	HK_PATCH_MEMBER_ADDED("aabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	//HK_PATCH_FUNCTION(hkaiNavMeshManager_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCutNavMeshQueryMediator", 1, "hkaiCutNavMeshQueryMediator", 2)
	HK_PATCH_MEMBER_REMOVED("orig", TYPE_OBJECT, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_MEMBER_ADDED("manager", TYPE_OBJECT, "hkaiNavMeshManager", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshManager", 0)
	//HK_PATCH_FUNCTION(hkaiCutNavMeshQueryMediator_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCutNavMeshQueryMediator", 2, "hkaiDynamicNavMeshQueryMediator", 2)
 	HK_PATCH_DEPENDS("hkBaseObject", 0)
 	HK_PATCH_DEPENDS("hkaiNavMeshCutter", 3)
 	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
 	HK_PATCH_DEPENDS("hkaiNavMeshManager", 1)
 	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiDynamicNavMeshQueryMediator", 2, "hkaiDynamicNavMeshQueryMediator", 3)
	HK_PATCH_MEMBER_REMOVED("manager", TYPE_OBJECT, "hkaiNavMeshManager", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshManager", 1)
	//HK_PATCH_FUNCTION(hkaiDynamicNavMeshQueryMediator_2_to_3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiAvoidancePairProperties", 1, "hkaiAvoidancePairProperties", 2)
	HK_PATCH_MEMBER_REMOVED("avoidancePairDataMap", TYPE_ARRAY_OBJECT, "hkaiAvoidancePairPropertiesPairData", 0)
	HK_PATCH_MEMBER_ADDED("avoidancePairDataMap", TYPE_ARRAY_STRUCT, "hkaiAvoidancePairPropertiesPairData", 0)
	HK_PATCH_DEPENDS("hkaiAvoidancePairPropertiesPairData", 1)
	//HK_PATCH_FUNCTION(hkaiAvoidancePairProperties_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 0)
	HK_PATCH_MEMBER_ADDED("maxStepHeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxSeparation", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("cosAlignmentAngle", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("minEdgeOverlap", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutter", 3, "hkaiNavMeshCutter", 4)
	HK_PATCH_MEMBER_REMOVED("stepHeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("up", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("edgeMatchParams", TYPE_STRUCT, "hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 0)
	HK_PATCH_MEMBER_ADDED_REAL("cutEdgeTolerance", 0.000100f)
	HK_PATCH_DEPENDS("hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 0)
	//HK_PATCH_FUNCTION(hkaiNavMeshCutter_3_to_4)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiDirectedGraphExplicitCostExternalEdgeInfo", 0)
	HK_PATCH_MEMBER_ADDED("nodeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("edgeKey", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("targetUid", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiDirectedGraphExplicitCost", 0, "hkaiDirectedGraphExplicitCost", 1)
	HK_PATCH_MEMBER_ADDED("sectionUid", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("externalEdges", TYPE_ARRAY_STRUCT, "hkaiDirectedGraphExplicitCostExternalEdgeInfo", 0)
	HK_PATCH_DEPENDS("hkaiDirectedGraphExplicitCostExternalEdgeInfo", 0)
	//HK_PATCH_FUNCTION(hkaiDirectedGraphExplicitCost_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshManagerSectionInfo", 0, "hkaiNavMeshManagerSectionInfo", 1)
	HK_PATCH_MEMBER_REMOVED("clusterGraph", TYPE_OBJECT, "hkaiStreamingDirectedGraph", 0)
	HK_PATCH_MEMBER_ADDED("clusterGraph", TYPE_OBJECT, "hkaiDirectedGraphExplicitCost", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiDirectedGraphExplicitCost", 1)
	HK_PATCH_DEPENDS("hkaiStreamingDirectedGraph", 0)
	//HK_PATCH_FUNCTION(hkaiNavMeshManagerSectionInfo_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiStreamingDirectedGraph", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkaiDirectedGraphExplicitCost", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("sectionUid", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("externalEdges", TYPE_ARRAY_STRUCT, "hkaiStreamingDirectedGraphExternalEdgeInfo", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiStreamingDirectedGraphExternalEdgeInfo", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiDirectedGraphExplicitCost", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiStreamingDirectedGraphExternalEdgeInfo", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("nodeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("edgeKey", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("targetUid", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshManager", 1, "hkaiNavMeshManager", 2)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	//HK_PATCH_FUNCTION(hkaiNavMeshManager_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPath", 4, "hkaiPath", 5)
	HK_PATCH_MEMBER_REMOVED("navMesh", TYPE_OBJECT, "hkaiNavMesh", 0)
	HK_PATCH_MEMBER_ADDED("navMeshManager", TYPE_OBJECT, "hkaiNavMeshManager", 0)
	HK_PATCH_DEPENDS("hkaiNavMesh", 3)
	HK_PATCH_DEPENDS("hkaiNavMeshManager", 2)
	//HK_PATCH_FUNCTION(hkaiPath_4_to_5)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshCutterSavedConnectivity", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutter", 4, "hkaiNavMeshCutter", 5)
	HK_PATCH_MEMBER_REMOVED("connectivityInfo", TYPE_ARRAY_STRUCT, "hkaiNavMeshCutterOriginalEdgeInfo", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutterOriginalEdgeInfo", 1)
	//HK_PATCH_FUNCTION(hkaiNavMeshCutter_4_to_5)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutter", 5, "hkaiNavMeshCutter", 6)
	HK_PATCH_MEMBER_ADDED_REAL("minEdgeMatchingLength", 0.010000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 8, "hkaiWorld", 9)
	HK_PATCH_MEMBER_REMOVED("dynamicInfo", TYPE_ARRAY_STRUCT, "hkaiWorldDynamicNavMeshInfo", 0)
	HK_PATCH_DEPENDS("hkaiWorldDynamicNavMeshInfo", 1)
	//HK_PATCH_FUNCTION(hkaiWorld_8_to_9)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorldDynamicNavMeshInfo", 1, HK_NULL, HK_CLASS_REMOVED)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshManager", 2, "hkaiNavMeshManager", 3)
	HK_PATCH_MEMBER_ADDED("isTemporary", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCompoundSilhouette", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("points", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshSimplificationUtilsSettings", 0)
	HK_PATCH_MEMBER_ADDED_REAL("maxArea", 1.500000f)
	HK_PATCH_MEMBER_ADDED_REAL("concaveMaxArea", 0.150000f)
	HK_PATCH_MEMBER_ADDED_REAL("minCorridorWidth", 0.400000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxCorridorWidth", 0.600000f)
	HK_PATCH_MEMBER_ADDED_REAL("holeReplacementArea", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxLoopShrinkFraction", 0.750000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxHeightError", 1.500000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshGenerationUtilsSettings", 0)
	HK_PATCH_MEMBER_ADDED("characterHeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("up", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxWalkableSlope", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("degenerateAreaThreshold", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("convexThreshold", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("edgeMatchingParams", TYPE_STRUCT, "hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 0)
	HK_PATCH_MEMBER_ADDED("minRegionArea", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("carvers", TYPE_ARRAY_OBJECT, "hkaiCarver", 0)
	HK_PATCH_MEMBER_ADDED("materialMap", TYPE_ARRAY_STRUCT, "hkaiNavMeshGenerationUtilsMaterialConstructionPair", 0)
	HK_PATCH_MEMBER_ADDED("weldInputVertices", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("weldThreshold", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("enableSimplification", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("simplificationSettings", TYPE_STRUCT, "hkaiNavMeshSimplificationUtilsSettings", 0)
	HK_PATCH_MEMBER_ADDED("loopFinderSettings", TYPE_STRUCT, "hkaiLoopFinderSettings", 0)
	HK_PATCH_MEMBER_ADDED("pruneColinearHoleVertices", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("mergeColinearEdges", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("saveInputSnapshot", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("snapshotFilename", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshSimplificationUtilsSettings", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshGenerationUtilsMaterialConstructionPair", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 0)
	HK_PATCH_DEPENDS("hkaiLoopFinderSettings", 0)
	HK_PATCH_DEPENDS("hkaiCarver", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiLoopFinderSettings", 0)
	HK_PATCH_MEMBER_ADDED("colinearAngle", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("colinearDistance", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("degenerateLength", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshGenerationUtilsMaterialConstructionPair", 0)
	HK_PATCH_MEMBER_ADDED("materialIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshGenerationSnapshot", 0)
	HK_PATCH_MEMBER_ADDED("geometry", TYPE_STRUCT, "hkGeometry", 0)
	HK_PATCH_MEMBER_ADDED("settings", TYPE_STRUCT, "hkaiNavMeshGenerationUtilsSettings", 0)
	HK_PATCH_DEPENDS("hkGeometry", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshGenerationUtilsSettings", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 0, "hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 1)
	HK_PATCH_MEMBER_ADDED("maxOverhang", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiDirectedGraphExplicitCostEdge", 0, "hkaiDirectedGraphExplicitCostEdge", 1)
	HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationUtilsSettings", 0, "hkaiNavMeshGenerationUtilsSettings", 1)
	HK_PATCH_MEMBER_ADDED("minDistanceToSpawnPoints", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("regionSpawnPoints", TYPE_ARRAY_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationUtilsSettings", 1, "hkaiNavMeshGenerationUtilsSettings", 2)
	HK_PATCH_MEMBER_ADDED("minCharacterWidth", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshEdge", 2, "hkaiNavMeshEdge", 3)
	HK_PATCH_MEMBER_RENAMED("flags", "old_flags")
	HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("cutInfo", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkaiNavMeshEdge_2_to_3)
	HK_PATCH_MEMBER_REMOVED("old_flags", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPathSegment", 0)
	HK_PATCH_MEMBER_ADDED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userEdgeData", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userEdgeType", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPath", 5, "hkaiPath", 6)
	HK_PATCH_MEMBER_REMOVED("positions", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("navMeshEdges", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("startNode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("goalNode", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("hasUserEdges", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("mediator", TYPE_OBJECT, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_MEMBER_REMOVED("navMeshManager", TYPE_OBJECT, "hkaiNavMeshManager", 0)
	HK_PATCH_MEMBER_ADDED("segments", TYPE_ARRAY_STRUCT, "hkaiPathSegment", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshManager", 3)
	HK_PATCH_DEPENDS("hkaiPathSegment", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationUtilsSettings", 2, "hkaiNavMeshGenerationUtilsSettings", 3)
	HK_PATCH_MEMBER_ADDED("maxHorizontalRange", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxVerticalRange", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshGenerationSettings", 0)
    HK_PATCH_MEMBER_ADDED_REAL("maxHorizontalRange", 10000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxVerticalRange", 1000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("characterHeight", 1.750000f)
    HK_PATCH_MEMBER_ADDED("up", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("maxWalkableSlope", 1.047198f)
    HK_PATCH_MEMBER_ADDED("degenerateAreaThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("convexThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("edgeMatchingParams", TYPE_STRUCT, "hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 0)
    HK_PATCH_MEMBER_ADDED_REAL("minRegionArea", 5.000000f)
    HK_PATCH_MEMBER_ADDED("minDistanceToSpawnPoints", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("regionSpawnPoints", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("carvers", TYPE_ARRAY_OBJECT, "hkaiCarver", 0)
    HK_PATCH_MEMBER_ADDED("materialMap", TYPE_ARRAY_STRUCT, "hkaiNavMeshGenerationSettingsMaterialConstructionPair", 0)
    HK_PATCH_MEMBER_ADDED("weldInputVertices", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("weldThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("minCharacterWidth", 0.000000f)
    HK_PATCH_MEMBER_ADDED("enableSimplification", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("simplificationSettings", TYPE_STRUCT, "hkaiNavMeshSimplificationUtilsSettings", 0)
    HK_PATCH_MEMBER_ADDED("loopFinderSettings", TYPE_STRUCT, "hkaiLoopFinderSettings", 0)
    HK_PATCH_MEMBER_ADDED("pruneColinearHoleVertices", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("mergeColinearEdges", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("saveInputSnapshot", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("snapshotFilename", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("localSettings", TYPE_ARRAY_STRUCT, "hkaiNavMeshGenerationSettingsLocalSettings", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationSettingsMaterialConstructionPair", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshSimplificationUtilsSettings", 0)
    HK_PATCH_DEPENDS("hkaiLoopFinderSettings", 0)
    HK_PATCH_DEPENDS("hkaiCarver", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationSettingsLocalSettings", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 0)
    HK_PATCH_MEMBER_ADDED_REAL("maxStepHeight", 0.500000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxSeparation", 0.100000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxOverhang", 0.010000f)
    HK_PATCH_MEMBER_ADDED_REAL("cosAlignmentAngle", 0.996195f)
    HK_PATCH_MEMBER_ADDED_REAL("minEdgeOverlap", 0.020000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshGenerationSettingsLocalSettings", 0)
    HK_PATCH_MEMBER_ADDED("aabb", TYPE_STRUCT, "hkAabb", 0)
    HK_PATCH_MEMBER_ADDED("maxWalkableSlope", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("edgeMatchingParams", TYPE_STRUCT, "hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 0)
    HK_PATCH_MEMBER_ADDED("simplificationSettings", TYPE_STRUCT, "hkaiNavMeshSimplificationUtilsSettings", 0)
    HK_PATCH_DEPENDS("hkAabb", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshSimplificationUtilsSettings", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshGenerationSettingsMaterialConstructionPair", 0)
    HK_PATCH_MEMBER_ADDED("materialIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutter", 6, "hkaiNavMeshCutter", 7)
    HK_PATCH_MEMBER_REMOVED("edgeMatchParams", TYPE_STRUCT, "hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 0)
    HK_PATCH_MEMBER_ADDED("edgeMatchParams", TYPE_STRUCT, "hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 1)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 0)
    //HK_PATCH_FUNCTION(hkaiNavMeshCutter_6_to_7)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSnapshot", 0, "hkaiNavMeshGenerationSnapshot", 1)
    HK_PATCH_MEMBER_REMOVED("settings", TYPE_STRUCT, "hkaiNavMeshGenerationUtilsSettings", 0)
    HK_PATCH_MEMBER_ADDED("settings", TYPE_STRUCT, "hkaiNavMeshGenerationSettings", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationUtilsSettings", 3)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationSettings", 0)
    //HK_PATCH_FUNCTION(hkaiNavMeshGenerationSnapshot_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 1, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("maxStepHeight", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxSeparation", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("cosAlignmentAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("minEdgeOverlap", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxOverhang", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationUtilsSettings", 3, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("characterHeight", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("up", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxWalkableSlope", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("degenerateAreaThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("convexThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("edgeMatchingParams", TYPE_STRUCT, "hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 0)
    HK_PATCH_MEMBER_REMOVED("minRegionArea", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("carvers", TYPE_ARRAY_OBJECT, "hkaiCarver", 0)
    HK_PATCH_MEMBER_REMOVED("materialMap", TYPE_ARRAY_STRUCT, "hkaiNavMeshGenerationUtilsMaterialConstructionPair", 0)
    HK_PATCH_MEMBER_REMOVED("weldInputVertices", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("weldThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("enableSimplification", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("simplificationSettings", TYPE_STRUCT, "hkaiNavMeshSimplificationUtilsSettings", 0)
    HK_PATCH_MEMBER_REMOVED("loopFinderSettings", TYPE_STRUCT, "hkaiLoopFinderSettings", 0)
    HK_PATCH_MEMBER_REMOVED("pruneColinearHoleVertices", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("mergeColinearEdges", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("saveInputSnapshot", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("snapshotFilename", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("minDistanceToSpawnPoints", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("regionSpawnPoints", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("minCharacterWidth", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxHorizontalRange", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxVerticalRange", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshSimplificationUtilsSettings", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationUtilsMaterialConstructionPair", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationUtilsEdgeMatchingParameters", 1)
    HK_PATCH_DEPENDS("hkaiLoopFinderSettings", 0)
    HK_PATCH_DEPENDS("hkaiCarver", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationUtilsMaterialConstructionPair", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("materialIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("flags", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshGenerationSettingsMaterialSimplificationSettingsPair", 0)
    HK_PATCH_MEMBER_ADDED("materialIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("simplificationSettings", TYPE_STRUCT, "hkaiNavMeshSimplificationUtilsSettings", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshSimplificationUtilsSettings", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 0, "hkaiNavMeshGenerationSettings", 1)
    HK_PATCH_MEMBER_ADDED("materialSettingsMap", TYPE_ARRAY_STRUCT, "hkaiNavMeshGenerationSettingsMaterialSimplificationSettingsPair", 0)
    HK_PATCH_DEPENDS("hkaiNavMeshGenerationSettingsMaterialSimplificationSettingsPair", 0)
    //HK_PATCH_FUNCTION(hkaiNavMeshGenerationSettings_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 1, "hkaiNavMeshGenerationSettings", 2)
	HK_PATCH_MEMBER_ADDED("quantizationGridSize", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 2, "hkaiNavMeshGenerationSettings", 3)
	HK_PATCH_MEMBER_ADDED("degenerateWidthThreshold", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 0, "hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 1)
	HK_PATCH_MEMBER_RENAMED("cosAlignmentAngle", "cosPlanarAlignmentAngle")
	HK_PATCH_MEMBER_ADDED_REAL("cosVerticalAlignmentAngle", 0.5f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMesh", 3, "hkaiNavMesh", 4)
	HK_PATCH_MEMBER_REMOVED("userEdges", TYPE_ARRAY_STRUCT, "hkaiNavMeshUserEdge", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshUserEdge", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshUserEdge", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("startPoint", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("endPoint", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("faceIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("oppositeFace", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("data", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("oppositeSectionUid", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiDefaultLocalSteeringPathFollowingProperties", 0, "hkaiDefaultLocalSteeringPathFollowingProperties", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 3, "hkaiNavMeshGenerationSettings", 4)
	HK_PATCH_MEMBER_REMOVED("carvers", TYPE_ARRAY_OBJECT, "hkaiCarver", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiCarver", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiVolume", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCarver", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 4, "hkaiNavMeshGenerationSettings", 5)
	HK_PATCH_MEMBER_ADDED("carvers", TYPE_ARRAY_OBJECT, "hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettingsLocalSettings", 0, "hkaiNavMeshGenerationSettingsLocalSettings", 1)
	HK_PATCH_MEMBER_REMOVED("aabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_MEMBER_ADDED("volume", TYPE_OBJECT, "hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 9, "hkaiWorld", 10)
	HK_PATCH_MEMBER_REMOVED("cutOptions", TYPE_STRUCT, "hkaiNavMeshCutterCutOptions", 0)
	HK_PATCH_MEMBER_REMOVED("silhouetteQuantizationBits", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("silhouetteRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("maxObjectSize", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("silhouetteExtrusion", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkaiNavMeshCutterCutOptions", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCutterCutOptions", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("cutFaceType", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiNavMeshSimplificationUtilsSettings", 0, "hkaiNavMeshSimplificationUtilsSettings", 1)
   HK_PATCH_MEMBER_ADDED("useHeightPartitioning", TYPE_BYTE, HK_NULL, 0)
   HK_PATCH_MEMBER_ADDED("maxPartitioningHeight", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 5, "hkaiNavMeshGenerationSettings", 6)
	HK_PATCH_MEMBER_ADDED_INT("edgeMatchingMetric", 2)
	HK_PATCH_MEMBER_ADDED_INT("edgeConnectionIterations", 2)
	HK_PATCH_FUNCTION(hkaiNavMeshGenerationSettings_5_to_6)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiAvoidanceSolverAvoidanceProperties", 4, "hkaiAvoidanceSolverAvoidanceProperties", 5)
	HK_PATCH_MEMBER_REMOVED("radius", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 10, "hkaiCharacter", 11)
	HK_PATCH_MEMBER_ADDED("desiredVelocity", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkaiCharacter_10_to_11)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 6, "hkaiNavMeshGenerationSettings", 7)
	HK_PATCH_MEMBER_ADDED("carvedMaterial", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("carvedCuttingMaterial", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkaiNavMeshGenerationSettings_6_to_7)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 10, "hkaiWorld", 11)
	HK_PATCH_MEMBER_REMOVED("pendingGoals", TYPE_ARRAY_STRUCT, "hkaiWorldPendingGoal", 0)
	HK_PATCH_MEMBER_REMOVED("pendingGoalPositions", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkaiWorldPendingGoal", 1)
	//HK_PATCH_FUNCTION(hkaiWorld_10_to_11)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorldPendingGoal", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("numPositions", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("character", TYPE_OBJECT, "hkaiCharacter", 0)
	HK_PATCH_MEMBER_REMOVED("positionIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiCharacter", 11)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 11, "hkaiWorld", 12)
	HK_PATCH_MEMBER_REMOVED("characters", TYPE_ARRAY_OBJECT, "hkaiCharacter", 0)
	HK_PATCH_MEMBER_REMOVED("projectionMode", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkaiCharacter", 11)
	//HK_PATCH_FUNCTION(hkaiWorld_11_to_12)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 7, "hkaiNavMeshGenerationSettings", 8)
	HK_PATCH_MEMBER_ADDED_BYTE("validateInputGeometry", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 11, "hkaiCharacter", 12)
	HK_PATCH_MEMBER_ADDED("localSensorAabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_MEMBER_REMOVED("path", TYPE_OBJECT, "hkaiPath", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	HK_PATCH_DEPENDS("hkaiPath", 6)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshEdge", 3, "hkaiNavMeshEdge", 4)
	HK_PATCH_MEMBER_ADDED("padding", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 12, "hkaiCharacter", 13)
	HK_PATCH_MEMBER_ADDED("currentNavMeshFace", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkaiCharacter_12_to_13)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacterRepathInformation", 0, "hkaiCharacterRepathInformation", 1)
	HK_PATCH_MEMBER_REMOVED("pathAge", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("meshWasCut", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 12, "hkaiWorld", 13)
	HK_PATCH_MEMBER_ADDED("maxRequestsPerStep", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("priorityThreshold", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiDefaultLocalSteeringPathFollowingProperties", 1, "hkaiDefaultLocalSteeringPathFollowingProperties", 2)
	HK_PATCH_MEMBER_REMOVED("changeSegmentDist", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshSimplificationUtilsSettings", 1, "hkaiNavMeshSimplificationUtilsSettings", 2)
	HK_PATCH_MEMBER_ADDED_REAL("cosConvexThreshold", 0.99f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 13, "hkaiWorld", 14)
	HK_PATCH_MEMBER_ADDED("numPathRequestsPerJob", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numBehaviorUpdatesPerJob", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numCharactersPerAvoidanceJob", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkaiWorld_13_to_14)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 13, "hkaiCharacter", 14)
	HK_PATCH_MEMBER_ADDED("avoidanceProperties", TYPE_OBJECT, "hkaiAvoidanceSolverAvoidanceProperties", 0)
	HK_PATCH_DEPENDS("hkaiAvoidanceSolverAvoidanceProperties", 5)
	//HK_PATCH_FUNCTION(hkaiCharacter_13_to_14)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 14, "hkaiCharacter", 15)
	HK_PATCH_MEMBER_REMOVED("id", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiAvoidanceSolverAvoidanceProperties", 5, "hkaiAvoidanceSolverAvoidanceProperties", 6)
	HK_PATCH_MEMBER_REMOVED("obstaclePenaltyWeight", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshFace", 1, "hkaiNavMeshFace", 2)
	HK_PATCH_MEMBER_ADDED("padding", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkaiNavMeshFace_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 14, "hkaiWorld", 15)
	HK_PATCH_MEMBER_ADDED("maxPathSearchEdgesOut", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxPathSearchSegmentsOut", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkaiWorld_14_to_15)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiDefaultNavMeshCostModifier", 0, "hkaiDefaultNavMeshCostModifier", 1)
	HK_PATCH_PARENT_SET("hkReferencedObject", "hkaiNavMeshCostModifier")
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCostModifier", 0, "hkaiNavMeshCostModifier", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkaiNavMeshCostModifier_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshTraversalInfo", 0)
	HK_PATCH_MEMBER_ADDED("diameter", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("filterInfo", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPathfindingUtil", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPathfindingUtilFindPathInput", 0)
	HK_PATCH_MEMBER_ADDED("startPoint", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("endPoint", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("up", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("startFaceIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("endFaceIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxNumberOfIterations", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("characterInfo", TYPE_STRUCT, "hkaiNavMeshTraversalInfo", 0)
	HK_PATCH_MEMBER_ADDED("smoothingMode", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("searchSphereRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("searchCapsuleRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("checkForDirectPath", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("useHierarchyInfo", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("heuristicWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_INT("maxOpenSetSizeBytes", 131072)
	HK_PATCH_MEMBER_ADDED_INT("maxSearchStateSizeBytes", 590336)
	HK_PATCH_MEMBER_ADDED_INT("maxHierarchyOpenSetSizeBytes", 32768)
	HK_PATCH_MEMBER_ADDED_INT("maxHierarchySearchStateSizeBytes", 147968)
	HK_PATCH_DEPENDS("hkaiNavMeshTraversalInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 15, "hkaiWorld", 16)
	HK_PATCH_MEMBER_ADDED("defaultPathfindingInput", TYPE_STRUCT, "hkaiPathfindingUtilFindPathInput", 0)
	HK_PATCH_DEPENDS("hkaiPathfindingUtilFindPathInput", 0)
	HK_PATCH_FUNCTION(hkaiWorld_15_to_16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPlaneVolume", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkaiVolume")
	HK_PATCH_MEMBER_ADDED("planes", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("geometry", TYPE_STRUCT, "hkGeometry", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkGeometry", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiInvertedAabbVolume", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkaiVolume")
	HK_PATCH_MEMBER_ADDED("aabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_MEMBER_ADDED("geometry", TYPE_STRUCT, "hkGeometry", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	HK_PATCH_DEPENDS("hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkGeometry", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshCostModifier", 1, "hkaiNavMeshCostModifier", 2)
	HK_PATCH_MEMBER_REMOVED("type", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

#if defined(HK_FEATURE_PRODUCT_AI) && defined(HK_FEATURE_PRODUCT_PHYSICS)
HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPhysicsShapeVolume", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkaiVolume")
	HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hkpShape", 0)
	HK_PATCH_MEMBER_ADDED("shapeTransform", TYPE_VEC_16, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkpShape", 0)
	HK_PATCH_DEPENDS("hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()
#endif //AI+PHYSICS

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiUserEdgeUtilsObb", 0)
	HK_PATCH_MEMBER_ADDED("transform", TYPE_VEC_16, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("halfExtents", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiUserEdgeUtils", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiUserEdgeUtilsUserEdgePair", 0)
	HK_PATCH_MEMBER_ADDED("x", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("y", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("z", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("meshUidA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("meshUidB", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceB", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userDataA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userDataB", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("costAtoB", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("costBtoA", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("direction", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiUserEdgeUtilsUserEdgeSetup", 0)
	HK_PATCH_MEMBER_ADDED("obbA", TYPE_STRUCT, "hkaiUserEdgeUtilsObb", 0)
	HK_PATCH_MEMBER_ADDED("obbB", TYPE_STRUCT, "hkaiUserEdgeUtilsObb", 0)
	HK_PATCH_MEMBER_ADDED("userDataA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userDataB", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("costAtoB", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("costBtoA", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("direction", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkaiUserEdgeUtilsObb", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 15, "hkaiCharacter", 16)
	HK_PATCH_MEMBER_REMOVED("currentPathSegment", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("repathInformation", TYPE_STRUCT, "hkaiCharacterRepathInformation", 0)
	HK_PATCH_DEPENDS("hkaiCharacterRepathInformation", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacterRepathInformation", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("pathFailCount", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 8, "hkaiNavMeshGenerationSettings", 9)
	HK_PATCH_MEMBER_RENAMED("minDistanceToSpawnPoints", "minDistanceToSeedPoints")
	HK_PATCH_MEMBER_RENAMED("regionSpawnPoints", "regionSeedPoints")
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshSimplificationUtilsSettings", 2, "hkaiNavMeshSimplificationUtilsSettings", 3)
	HK_PATCH_MEMBER_RENAMED("maxArea", "maxBorderSimplifyArea")
	HK_PATCH_MEMBER_RENAMED("concaveMaxArea", "maxConcaveBorderSimplifyArea")
	HK_PATCH_MEMBER_RENAMED("maxHeightError", "maxBorderHeightError")
	HK_PATCH_MEMBER_RENAMED("maxPartitioningHeight", "maxPartitionHeightError")
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshSimplificationUtilsSettings", 3, "hkaiNavMeshSimplificationUtilsSettings", 4)
	HK_PATCH_MEMBER_ADDED_REAL("boundaryEdgeFilterThreshold", 0.010000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPathfindingUtilFindPathInput", 0, "hkaiPathfindingUtilFindPathInput", 1)
	HK_PATCH_MEMBER_RENAMED("characterInfo", "agentInfo")
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 9, "hkaiNavMeshGenerationSettings", 10)
	HK_PATCH_MEMBER_ADDED_REAL("loopReplacementArea", 0.000000f)
	HK_PATCH_FUNCTION(hkaiNavMeshGenerationSettings_9_to_10)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiMaterialPainter", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("material", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("volume", TYPE_OBJECT, "hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 10, "hkaiNavMeshGenerationSettings", 11)
	HK_PATCH_MEMBER_ADDED("painters", TYPE_ARRAY_OBJECT, "hkaiMaterialPainter", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiMaterialPainter", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiNavMeshFace", 2, "hkaiNavMeshFace", 3)
	HK_PATCH_MEMBER_ADDED("clearancesIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMesh", 4, "hkaiNavMesh", 5)
	HK_PATCH_MEMBER_ADDED("clearanceCache", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("globalClearanceCache", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("uncutClearanceCacheSize", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxGlobalClearance", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshEdge", 4, "hkaiNavMeshEdge", 5)
	HK_PATCH_MEMBER_RENAMED("vertexClearance", "userEdgeCost")
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavVolume", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("cells", TYPE_ARRAY_STRUCT, "hkaiNavVolumeCell", 0)
	HK_PATCH_MEMBER_ADDED("edges", TYPE_ARRAY_STRUCT, "hkaiNavVolumeEdge", 0)
	HK_PATCH_MEMBER_ADDED("cellIndices", TYPE_ARRAY_STRUCT, "hkaiNavVolumeFI", 0)
	HK_PATCH_MEMBER_ADDED("cellRegions", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("aabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_MEMBER_ADDED("res", TYPE_TUPLE_INT, HK_NULL, 3)
	HK_PATCH_MEMBER_ADDED("inputFilename", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavVolumeCell", 0)
	HK_PATCH_DEPENDS("hkaiNavVolumeFI", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiNavVolumeEdge", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavVolumeFI", 0)
	HK_PATCH_MEMBER_ADDED("a", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("b", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavVolumeCell", 0)
	HK_PATCH_MEMBER_ADDED("min", TYPE_TUPLE_INT, HK_NULL, 3)
	HK_PATCH_MEMBER_ADDED("max", TYPE_TUPLE_INT, HK_NULL, 3)
	HK_PATCH_MEMBER_ADDED("numEdges", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("startEdgeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavVolumeEdge", 0)
	HK_PATCH_MEMBER_ADDED("oppositeCell", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavVolumeGenerationSettings", 0)
	HK_PATCH_MEMBER_ADDED_REAL("maxHorizontalRange", 10000.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxVerticalRange", 1000.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("validateInputGeometry", 0)
	HK_PATCH_MEMBER_ADDED("up", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("cellDensity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("minRegionVolume", 5.000000f)
	HK_PATCH_MEMBER_ADDED("minDistanceToSeedPoints", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("regionSeedPoints", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("carvers", TYPE_ARRAY_OBJECT, "hkaiVolume", 0)
	HK_PATCH_MEMBER_ADDED("painters", TYPE_ARRAY_OBJECT, "hkaiMaterialPainter", 0)
	HK_PATCH_MEMBER_ADDED("saveInputSnapshot", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("snapshotFilename", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiVolume", 0)
	HK_PATCH_DEPENDS("hkaiMaterialPainter", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiNavVolumeGenerationSettings", 0, "hkaiNavVolumeGenerationSettings", 1)
	HK_PATCH_MEMBER_ADDED_REAL("characterHeight", 1.750000f)
	HK_PATCH_MEMBER_ADDED_REAL("characterDepth", 0.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("characterWidth", 1.750000f)
	HK_PATCH_MEMBER_ADDED("iterationsStabilizationThreshold", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxMergingIterations", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavMeshInstance", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("originalMesh", TYPE_OBJECT, "hkaiNavMesh", 0)
	HK_PATCH_MEMBER_ADDED("edgeMap", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceMap", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("instancedFaces", TYPE_ARRAY_STRUCT, "hkaiNavMeshFace", 0)
	HK_PATCH_MEMBER_ADDED("instancedEdges", TYPE_ARRAY_STRUCT, "hkaiNavMeshEdge", 0)
	HK_PATCH_MEMBER_ADDED("ownedFaces", TYPE_ARRAY_STRUCT, "hkaiNavMeshFace", 0)
	HK_PATCH_MEMBER_ADDED("ownedEdges", TYPE_ARRAY_STRUCT, "hkaiNavMeshEdge", 0)
	HK_PATCH_MEMBER_ADDED("ownedVertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceFlags", TYPE_ARRAY_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("clearanceCache", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("globalClearanceCache", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("faceClearanceIndices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxGlobalClearance", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transform", TYPE_VEC_16, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkaiNavMeshFace", 4)
	HK_PATCH_DEPENDS("hkaiNavMeshEdge", 5)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMesh", 4)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshManager", 3, "hkaiStreamingManager", 4)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshManagerSectionInfo", 1, "hkaiStreamingManagerSectionInfo", 2)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiStreamingCollectionInstanceInfo", 0)
	HK_PATCH_MEMBER_ADDED("instancePtr", TYPE_OBJECT, "hkaiNavMeshInstance",0)
	HK_PATCH_MEMBER_ADDED("clusterGraph", TYPE_OBJECT, "hkaiDirectedGraphExplicitCost", 0)
	HK_PATCH_MEMBER_ADDED("mediator", TYPE_OBJECT, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshInstance", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkaiDirectedGraphExplicitCost", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiStreamingCollection", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("instances", TYPE_ARRAY_STRUCT, "hkaiStreamingCollectionInstanceInfo", 0)
	HK_PATCH_MEMBER_ADDED("aabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiStreamingCollectionInstanceInfo", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 16, "hkaiWorld", 17)
	HK_PATCH_MEMBER_REMOVED("streamingManager", TYPE_STRUCT, "hkaiStreamingManager", 0)
	HK_PATCH_MEMBER_ADDED("streamingCollection", TYPE_STRUCT, "hkaiStreamingCollection", 0)
	HK_PATCH_MEMBER_ADDED("meshInstance", TYPE_STRUCT, "hkaiNavMeshInstance", 0)
	HK_PATCH_DEPENDS("hkaiStreamingManager", 4)
	HK_PATCH_DEPENDS("hkaiStreamingCollection", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshInstance", 0)
	//HK_PATCH_FUNCTION(hkaiWorld_16_to_17)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiStreamingManager", 4, "hkaiStreamingManager", 5)
	HK_PATCH_MEMBER_REMOVED("aabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	//HK_PATCH_FUNCTION(hkaiStreamingManager_4_to_5)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiNavMeshCutterOriginalEdgeInfo", 1, HK_NULL, HK_CLASS_REMOVED )
	HK_PATCH_MEMBER_REMOVED("oppositeEdge", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("oppositeFace", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("edgeKey", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("faceKey", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiNavMeshFace", 3, "hkaiNavMeshFace", 4)
	HK_PATCH_MEMBER_REMOVED("clearancesIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMesh", 5, "hkaiNavMesh", 6)
	HK_PATCH_MEMBER_REMOVED("clearanceCache", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("globalClearanceCache", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("uncutClearanceCacheSize", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("maxGlobalClearance", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiStreamingManagerSectionInfo", 2, "hkaiStreamingManagerSectionInfo", 3)
	HK_PATCH_MEMBER_REMOVED("mediator", TYPE_OBJECT, "hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavMeshQueryMediator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	//HK_PATCH_FUNCTION(hkaiStreamingManagerSectionInfo_2_to_3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavVolumeExternalEdgeInfo", 0)
	HK_PATCH_MEMBER_ADDED("edgeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("cellIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("oppositeUid", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiStreamingCollectionInstanceInfo", 0, "hkaiStreamingCollectionInstanceInfo", 1)
	HK_PATCH_MEMBER_ADDED("volumePtr", TYPE_OBJECT, "hkaiNavVolume", 0)
	HK_PATCH_DEPENDS("hkaiNavVolume", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	//HK_PATCH_FUNCTION(hkaiStreamingCollectionInstanceInfo_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavVolume", 0, "hkaiNavVolume", 1)
	HK_PATCH_MEMBER_ADDED("externalEdges", TYPE_ARRAY_STRUCT, "hkaiNavVolumeExternalEdgeInfo", 0)
	HK_PATCH_MEMBER_ADDED("streamingDependencies", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("uid", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("runtimeId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkaiNavVolumeExternalEdgeInfo", 0)
	//HK_PATCH_FUNCTION(hkaiNavVolume_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavVolumeEdge", 0, "hkaiNavVolumeEdge", 1)
	HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiStreamingManager", 5, "hkaiStreamingManager", 6)
	HK_PATCH_MEMBER_REMOVED("isTemporary", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiStreamingManagerSectionInfo", 3, "hkaiStreamingManagerSectionInfo", 4)
	HK_PATCH_MEMBER_ADDED("volumePtr", TYPE_OBJECT, "hkaiNavVolume", 0)
	HK_PATCH_DEPENDS("hkaiNavVolume", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	//HK_PATCH_FUNCTION(hkaiStreamingManagerSectionInfo_3_to_4)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiVolumePathfindingUtilFindPathInput", 1)
	HK_PATCH_MEMBER_ADDED("startPoint", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("endPoint", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("up", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("startCellIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("endCellIndex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxNumberOfIterations", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("agentInfo", TYPE_STRUCT, "hkaiNavMeshTraversalInfo", 0)
	HK_PATCH_MEMBER_ADDED("heuristicWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_INT("maxOpenSetSizeBytes", 131072)
	HK_PATCH_MEMBER_ADDED_INT("maxSearchStateSizeBytes", 590336)
	HK_PATCH_DEPENDS("hkaiNavMeshTraversalInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiVolumePathfindingUtil", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavVolumeGenerationSettings", 1, "hkaiNavVolumeGenerationSettings", 2)
	HK_PATCH_MEMBER_ADDED("volumeAabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavVolumeCostModifier", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiDefaultNavVolumeCostModifier", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkaiNavVolumeCostModifier")
	HK_PATCH_MEMBER_ADDED("cellMaskLookupTable", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("costMultiplierLookupTable", TYPE_TUPLE_REAL, HK_NULL, 32)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkaiNavVolumeCostModifier", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavVolumeGenerationSettingsMergingSettings", 0)
	HK_PATCH_MEMBER_ADDED("nodeWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("edgeWeight", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("multiplier", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("iterationsStabilizationThreshold", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxMergingIterations", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavVolumeGenerationSettings", 2, "hkaiNavVolumeGenerationSettings", 3)
	HK_PATCH_MEMBER_REMOVED("iterationsStabilizationThreshold", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("maxMergingIterations", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("mergingSettings", TYPE_STRUCT, "hkaiNavVolumeGenerationSettingsMergingSettings", 0)
	HK_PATCH_DEPENDS("hkaiNavVolumeGenerationSettingsMergingSettings", 0)
	//HK_PATCH_FUNCTION(hkaiNavVolumeGenerationSettings_2_to_3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavVolumeGenerationSettings", 3, "hkaiNavVolumeGenerationSettings", 4)
	HK_PATCH_MEMBER_DEFAULT_SET_VEC_4("up", 0.000000f,0.000000f,1.000000f,0.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("minDistanceToSeedPoints", 1.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_BYTE("saveInputSnapshot", 0)
	HK_PATCH_MEMBER_REMOVED("cellDensity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("cellWidth", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("border", 0.010000f)
	HK_PATCH_MEMBER_ADDED_BYTE("useBorderCells", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavVolume", 1, "hkaiNavVolume", 2)
	HK_PATCH_MEMBER_REMOVED("cellIndices", TYPE_ARRAY_STRUCT, "hkaiNavVolumeFI", 0)
	HK_PATCH_MEMBER_ADDED("quantizationScale", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("quantizationOffset", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavVolumeFI", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("a", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("b", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiNavVolumeGenerationSettingsMergingSettings", 0, "hkaiNavVolumeGenerationSettingsMergingSettings", 1)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("nodeWeight", 10.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("edgeWeight", 1.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("multiplier", 1.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_INT("iterationsStabilizationThreshold", 10)
	HK_PATCH_MEMBER_DEFAULT_SET_INT("maxMergingIterations", 1000000)
	HK_PATCH_MEMBER_ADDED_BYTE("estimateNewEdges", 1)
	HK_PATCH_MEMBER_ADDED_REAL("slopeThreshold", 1.000000f)
	HK_PATCH_MEMBER_ADDED_BYTE("autoSplit", 1)
	HK_PATCH_MEMBER_ADDED_INT("chunkDivsX", 1)
	HK_PATCH_MEMBER_ADDED_INT("chunkDivsY", 1)
	HK_PATCH_MEMBER_ADDED_INT("chunkDivsZ", 1)
	HK_PATCH_MEMBER_ADDED_INT("randomSeed", 123)
	HK_PATCH_MEMBER_ADDED_REAL("splitMergeProb", 0.700000f)
	HK_PATCH_MEMBER_ADDED_BYTE("useSimpleFirstMergePass", 1)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiNavMeshFace", 4, "hkaiNavMeshFace", 5)
	HK_PATCH_MEMBER_REMOVED("regionId", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("flags", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMesh", 6, "hkaiNavMesh", 7)
	HK_PATCH_MEMBER_REMOVED("numRegions", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkaiNavVolume", 2, "hkaiNavVolume", 3)
	HK_PATCH_MEMBER_REMOVED("cellRegions", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavVolume", 3, "hkaiNavVolume", 4)
	HK_PATCH_MEMBER_REMOVED("inputFilename", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 11, "hkaiNavMeshGenerationSettings", 12)
	HK_PATCH_MEMBER_ADDED_BYTE("characterWidthUsage", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 17, "hkaiWorld", 18)
	HK_PATCH_MEMBER_ADDED("erosionRadius", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMesh", 7, "hkaiNavMesh", 8)
	HK_PATCH_MEMBER_ADDED("erosionRadius", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 12, "hkaiNavMeshGenerationSettings", 13)
	HK_PATCH_MEMBER_REMOVED("mergeColinearEdges", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 1, "hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 2)
	HK_PATCH_MEMBER_ADDED_REAL("edgeTraversibilityHorizontalEpsilon", 0.010000f)
	HK_PATCH_MEMBER_ADDED_REAL("edgeTraversibilityVerticalEpsilon", 0.010000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPathfindingUtilFindPathInput", 1, "hkaiPathfindingUtilFindPathInput", 2)
	HK_PATCH_MEMBER_DEFAULT_SET_INT("maxNumberOfIterations", 100000)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("searchSphereRadius", -1.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("searchCapsuleRadius", -1.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_BYTE("useHierarchyInfo", 0)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("heuristicWeight", 1.000000f)
	HK_PATCH_MEMBER_REMOVED("smoothingMode", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_BYTE("smoothOutputPath", 1)
	HK_PATCH_MEMBER_ADDED_REAL("simpleRadiusThreshold", 0.010000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshSimplificationUtilsSettings", 4, "hkaiNavMeshSimplificationUtilsSettings", 5)
	HK_PATCH_MEMBER_ADDED_INT("maxPartitionSize", 40000)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiNavVolumeGenerationSnapshot", 1)
	HK_PATCH_MEMBER_ADDED("geometry", TYPE_STRUCT, "hkGeometry", 0)
	HK_PATCH_MEMBER_ADDED("settings", TYPE_STRUCT, "hkaiNavVolumeGenerationSettings", 0)
	HK_PATCH_DEPENDS("hkGeometry", 0)
	HK_PATCH_DEPENDS("hkaiNavVolumeGenerationSettings", 5)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettings", 13, "hkaiNavMeshGenerationSettings", 14)
	HK_PATCH_MEMBER_ADDED_INT("defaultConstructionProperties", 3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPathfindingUtilPathPoint", 0)
	HK_PATCH_MEMBER_ADDED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userEdgeData", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userEdgeType", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPath", 6, "hkaiPath", 7)
	HK_PATCH_MEMBER_REMOVED("segments", TYPE_ARRAY_STRUCT, "hkaiPathSegment", 0)
	HK_PATCH_MEMBER_ADDED("segments", TYPE_ARRAY_STRUCT, "hkaiPathfindingUtilPathPoint", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPathSegment", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("userEdgeData", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("userEdgeType", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPathPathPoint", 0)
	HK_PATCH_MEMBER_ADDED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("userEdgeData", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPath", 7, "hkaiPath", 8)
	HK_PATCH_MEMBER_REMOVED("segments", TYPE_ARRAY_STRUCT, "hkaiPathfindingUtilPathPoint", 0)
	HK_PATCH_MEMBER_ADDED("segments", TYPE_ARRAY_STRUCT, "hkaiPathPathPoint", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPathfindingUtilPathPoint", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("userEdgeData", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("userEdgeType", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 18, "hkaiWorld", 19)
	HK_PATCH_MEMBER_RENAMED("maxPathSearchSegmentsOut", "maxPathSearchPointsOut")
	HK_PATCH_MEMBER_RENAMED("dynamicMediator", "dynamicNavMeshMediator")
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiPathfindingUtilFindPathInput", 2, "hkaiPathfindingUtilFindPathInput", 3)
	HK_PATCH_MEMBER_REMOVED("smoothOutputPath", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_BYTE("outputPathType", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiWorld", 19, "hkaiWorld", 20)
	HK_PATCH_MEMBER_ADDED("defaultVolumePathfindingInput", TYPE_STRUCT, "hkaiVolumePathfindingUtilFindPathInput", 0)
	HK_PATCH_DEPENDS("hkaiVolumePathfindingUtilFindPathInput", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiCharacter", 16, "hkaiCharacter", 17)
	HK_PATCH_MEMBER_ADDED("movementState", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshTraversalInfo", 0, "hkaiAgentTraversalInfo", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 2, "hkaiNavMeshGenerationSettingsEdgeMatchingParameters", 3)
	HK_PATCH_MEMBER_ADDED_REAL("cosClimbingFaceNormalAlignmentAngle", -0.500000f)
	HK_PATCH_MEMBER_ADDED_REAL("cosClimbingEdgeAlignmentAngle", 0.996195f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaiNavMeshSimplificationUtilsSettings", 5, "hkaiNavMeshSimplificationUtilsSettings", 6)
	HK_PATCH_MEMBER_ADDED_REAL("maxSharedVertexHorizontalError", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxSharedVertexVerticalError", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxBoundaryVertexHorizontalError", 1.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("maxBoundaryVertexVerticalError", 1.000000f)
HK_PATCH_END()

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
