/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

// Patches common to all products.
// This file is #included by hkPatches.cpp

//=======
// 650b1
//=======

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkLocalFrameGroup", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkSemanticsAttribute", 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkRangeInt32Attribute", 0)
	HK_PATCH_MEMBER_ADDED("absmin", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("absmax", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("softmin", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("softmax", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMeshVertexBuffer", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkArrayTypeAttribute", 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkDemoReplayUtilityFrame", 0)
	HK_PATCH_MEMBER_ADDED("keysDown", TYPE_STRUCT, "hkBitField", 0)
	HK_PATCH_MEMBER_ADDED("camera", TYPE_STRUCT, "hkDemoReplayUtilityCamera", 0)
	HK_PATCH_MEMBER_ADDED("mouseX", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("mouseY", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("padButtons", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("mouseButtons", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("sticks", TYPE_TUPLE_REAL, HK_NULL, 4)
	HK_PATCH_DEPENDS("hkBitField", 0)
	HK_PATCH_DEPENDS("hkDemoReplayUtilityCamera", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkRangeRealAttribute", 0)
	HK_PATCH_MEMBER_ADDED("absmin", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("absmax", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("softmin", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("softmax", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkDataObjectTypeAttribute", 0)
	HK_PATCH_MEMBER_ADDED("typeName", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkDemoReplayUtilityMouseCallbacks", 0)
	HK_PATCH_MEMBER_ADDED("mouseMoveFunc", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("mouseWheelFunc", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("mouseButtonFunc", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkDemoReplayUtilityReplayData", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("framesWereAllocatedExternally", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("frames", TYPE_ARRAY_OBJECT, "hkDemoReplayUtilityFrame", 0)
	HK_PATCH_MEMBER_ADDED("initialMouseX", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("initialMouseY", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkDemoReplayUtilityFrame", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkLinkAttribute", 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkDemoReplayUtility", 0)
	HK_PATCH_MEMBER_ADDED("replayData", TYPE_OBJECT, "hkDemoReplayUtilityReplayData", 0)
	HK_PATCH_MEMBER_ADDED("currentFrame", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkDemoReplayUtilityReplayData", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkDescriptionAttribute", 0)
	HK_PATCH_MEMBER_ADDED("string", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMeshShape", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkGizmoAttribute", 0)
	HK_PATCH_MEMBER_ADDED("visible", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("label", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMeshSectionCinfo", 0)
	HK_PATCH_MEMBER_ADDED("vertexBuffer", TYPE_OBJECT, "hkMeshVertexBuffer", 0)
	HK_PATCH_MEMBER_ADDED("material", TYPE_OBJECT, "hkMeshMaterial", 0)
	HK_PATCH_MEMBER_ADDED("primitiveType", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numPrimitives", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("indexType", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("indices", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vertexStartIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transformIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkMeshVertexBuffer", 0)
	HK_PATCH_DEPENDS("hkMeshMaterial", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkUiAttribute", 0)
	HK_PATCH_MEMBER_ADDED("visible", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("hideInModeler", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("label", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("group", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("endGroup", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("advanced", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkDocumentationAttribute", 0)
	HK_PATCH_MEMBER_ADDED("docsSectionTag", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMemoryMeshShape", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkMeshShape")
	HK_PATCH_MEMBER_ADDED("sections", TYPE_ARRAY_STRUCT, "hkMeshSectionCinfo", 0)
	HK_PATCH_MEMBER_ADDED("indices16", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("indices32", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkMeshShape", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hkMeshSectionCinfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMeshMaterial", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMeshSection", 0)
	HK_PATCH_MEMBER_ADDED("primitiveType", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numPrimitives", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numIndices", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vertexStartIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transformIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("indexType", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("indices", TYPE_OBJECT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vertexBuffer", TYPE_OBJECT, "hkMeshVertexBuffer", 0)
	HK_PATCH_MEMBER_ADDED("material", TYPE_OBJECT, "hkMeshMaterial", 0)
	HK_PATCH_MEMBER_ADDED("sectionIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkMeshVertexBuffer", 0)
	HK_PATCH_DEPENDS("hkMeshMaterial", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkModelerNodeTypeAttribute", 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkHalf", 0)
	HK_PATCH_MEMBER_ADDED("value", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkDemoReplayUtilityCamera", 0)
	HK_PATCH_MEMBER_ADDED("from", TYPE_TUPLE_REAL, HK_NULL, 3)
	HK_PATCH_MEMBER_ADDED("to", TYPE_TUPLE_REAL, HK_NULL, 3)
	HK_PATCH_MEMBER_ADDED("up", TYPE_TUPLE_REAL, HK_NULL, 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkSimpleLocalFrame", 0, "hkSimpleLocalFrame", 1)
	HK_PATCH_MEMBER_ADDED("group", TYPE_OBJECT, "hkLocalFrameGroup", 0)
	HK_PATCH_DEPENDS("hkLocalFrameGroup", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkAlignSceneToNodeOptions", 0)
	HK_PATCH_MEMBER_ADDED("invert", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transformPositionX", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transformPositionY", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transformPositionZ", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transformRotation", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transformScale", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("transformSkew", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("keyframe", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("nodeName", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4C1T10", 0, "hkxVertexP4N4C1T10", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4W4I4C1T12", 0, "hkxVertexP4N4T4B4W4I4C1T12", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4C1T2", 0, "hkxVertexP4N4C1T2", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4C1T6", 0, "hkxVertexP4N4C1T6", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4C1T2", 0, "hkxVertexP4N4T4B4C1T2", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4C1T6", 0, "hkxVertexP4N4T4B4C1T6", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4C1T10", 0, "hkxVertexP4N4T4B4C1T10", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4W4I4C1T4", 0, "hkxVertexP4N4T4B4W4I4C1T4", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4W4I4C1T8", 0, "hkxVertexP4N4T4B4W4I4C1T8", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkxVertexP4N4W4I4C1T4", 0, "hkxVertexP4N4W4I4C1T4", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4W4I4C1T8", 0, "hkxVertexP4N4W4I4C1T8", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4W4I4C1T12", 0, "hkxVertexP4N4W4I4C1T12", 1)
	HK_PATCH_MEMBER_RENAMED("diffuse", "diffuseA")
	HK_PATCH_MEMBER_REMOVED("padding", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkUiAttribute", 0, "hkUiAttribute", 1)
	HK_PATCH_MEMBER_ADDED("endGroup2", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkHalf", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("value", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkUiAttribute", 1, "hkUiAttribute", 2)
	HK_PATCH_MEMBER_ADDED("hideBaseClassMembers", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkGeometry", 0)
	HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("triangles", TYPE_ARRAY_STRUCT, "hkGeometryTriangle", 0)
	HK_PATCH_DEPENDS("hkGeometryTriangle", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkGeometryTriangle", 0)
	HK_PATCH_MEMBER_ADDED("a", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("b", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("c", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("material", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()


// 7.0
HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxVertexBufferVertexData", 0)
	HK_PATCH_MEMBER_ADDED("vectorData", TYPE_ARRAY_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("floatData", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("uint32Data", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("uint16Data", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("uint8Data", TYPE_ARRAY_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numVerts", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vectorStride", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("floatStride", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("uint32Stride", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("uint16Stride", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("uint8Stride", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexDescriptionElementDecl", 0, "hkxVertexDescriptionElementDecl", 1)
	HK_PATCH_MEMBER_ADDED("byteStride", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexBuffer", 0, "hkxVertexBuffer", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("data", TYPE_STRUCT, "hkxVertexBufferVertexData", 0)
	HK_PATCH_MEMBER_ADDED("desc", TYPE_STRUCT, "hkxVertexDescription", 0)
	HK_PATCH_FUNCTION(hkxVertexBuffer_0_to_1)
	HK_PATCH_MEMBER_REMOVED("vertexData", TYPE_ARRAY_STRUCT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("vertexDesc", TYPE_OBJECT, "hkxVertexDescription", 0)
	HK_PATCH_DEPENDS("hkxVertexBufferVertexData", 0)
	HK_PATCH_DEPENDS("hkxVertexDescriptionElementDecl", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexDescription", 0, "hkxVertexDescription", 1)
	HK_PATCH_MEMBER_REMOVED("stride", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxEnum", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("items", TYPE_ARRAY_STRUCT, "hkxEnumItem", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkxEnumItem", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxEnumItem", 0)
	HK_PATCH_MEMBER_ADDED("value", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4C1T10", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u4", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v4", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4W4I4C1T12", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u4", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v4", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u5", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v5", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4C1T2", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4C1T6", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4C1T2", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4C1T6", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4W4I4Q4", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("weights", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("indices", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("qu0", TYPE_TUPLE_INT, HK_NULL, 2)
	HK_PATCH_MEMBER_REMOVED("qu1", TYPE_TUPLE_INT, HK_NULL, 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4W4I4T6", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4C1T10", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u4", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v4", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4W4I4C1Q2", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("weights", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("indices", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuse", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("qu", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("qv", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4W4I4C1T4", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4W4I4C1T8", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4W4I4C1Q2", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("weights", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("indices", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuse", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("qu", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("qv", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4W4I4C1T4", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4W4I4C1T8", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4T4B4T4", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("tangent", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("binormal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4W4I4C1T12", 1, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v3", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u4", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v4", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u5", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v5", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("diffuseB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxSparselyAnimatedString", 0, "hkxSparselyAnimatedString", 1)
	HK_PATCH_MEMBER_RENAMED("strings", "old_strings")
	HK_PATCH_MEMBER_ADDED("strings", TYPE_ARRAY_CSTRING, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkxSparselyAnimatedString_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_strings", TYPE_ARRAY_STRUCT, "hkxSparselyAnimatedStringStringType", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxSparselyAnimatedStringStringType", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("string", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4W4I4T2", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexP4N4W4I4T6", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("position", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("normal", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("w3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i0", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i1", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i2", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("i3", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v0", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v1", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("u2", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("v2", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxTextureInplace", 0, "hkxTextureInplace", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxIndexBuffer", 0, "hkxIndexBuffer", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexIntDataChannel", 0, "hkxVertexIntDataChannel", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxMaterialEffect", 0, "hkxMaterialEffect", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxMeshSection", 0, "hkxMeshSection", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxEdgeSelectionChannel", 0, "hkxEdgeSelectionChannel", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxScene", 0, "hkxScene", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxSparselyAnimatedString", 1, "hkxSparselyAnimatedString", 2)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxSparselyAnimatedBool", 0, "hkxSparselyAnimatedBool", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxSparselyAnimatedInt", 0, "hkxSparselyAnimatedInt", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxMesh", 0, "hkxMesh", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxAnimatedFloat", 0, "hkxAnimatedFloat", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxTriangleSelectionChannel", 0, "hkxTriangleSelectionChannel", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxSparselyAnimatedEnum", 0, "hkxSparselyAnimatedEnum", 1)
	HK_PATCH_MEMBER_REMOVED("type", TYPE_OBJECT, "hkClassEnum", 0)
	HK_PATCH_MEMBER_ADDED("enum", TYPE_OBJECT, "hkxEnum", 0)
	HK_PATCH_DEPENDS("hkClassEnum", 0)
	HK_PATCH_DEPENDS("hkxEnum", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxMaterialShaderSet", 0, "hkxMaterialShaderSet", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexSelectionChannel", 0, "hkxVertexSelectionChannel", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxAnimatedQuaternion", 0, "hkxAnimatedQuaternion", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexFloatDataChannel", 0, "hkxVertexFloatDataChannel", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxTextureFile", 0, "hkxTextureFile", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxLight", 0, "hkxLight", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxAnimatedMatrix", 0, "hkxAnimatedMatrix", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxAttributeHolder", 0, "hkxAttributeHolder", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkAlignSceneToNodeOptions", 0, "hkAlignSceneToNodeOptions", 1)
	HK_PATCH_MEMBER_REMOVED("nodeName", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("nodeName", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxMaterialShader", 0, "hkxMaterialShader", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxSkinBinding", 0, "hkxSkinBinding", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxCamera", 0, "hkxCamera", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexVectorDataChannel", 0, "hkxVertexVectorDataChannel", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxAnimatedVector", 0, "hkxAnimatedVector", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkMemoryResourceHandleExternalLink", 0, "hkMemoryResourceHandleExternalLink", 1)
	HK_PATCH_MEMBER_REMOVED("externalIdIsAllocated", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("memberNameIsAllocated", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkMemoryResourceHandle", 0, "hkMemoryResourceHandle", 1)
	HK_PATCH_MEMBER_REMOVED("nameIsAllocated", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkMemoryResourceContainer", 0, "hkMemoryResourceContainer", 1)
	HK_PATCH_MEMBER_REMOVED("nameIsAllocated", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkMeshSectionCinfo", 0, "hkMeshSectionCinfo", 1)
	HK_PATCH_MEMBER_REMOVED("indices", TYPE_OBJECT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkMeshSection", 0, "hkMeshSection", 1)
	HK_PATCH_MEMBER_REMOVED("indices", TYPE_OBJECT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxEnvironment", 0, "hkxEnvironment", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkMemoryResourceHandle", 1, "hkMemoryResourceHandle", 2)
	HK_PATCH_MEMBER_REMOVED("objectIsRerencedObject", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkAlignSceneToNodeOptions", 1, "hkAlignSceneToNodeOptions", 2)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hkxNode", 0, "hkxNode", 1)
	// nothing
HK_PATCH_END()

HK_PATCH_BEGIN("hkxSkinBinding", 1, "hkxSkinBinding", 2)
	HK_PATCH_MEMBER_ADDED("nodeNames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkxSkinBinding_1_to_2)
	HK_PATCH_MEMBER_REMOVED("mapping", TYPE_ARRAY_OBJECT, "hkxNode", 0)
	HK_PATCH_DEPENDS("hkxNode", 1)
HK_PATCH_END()


// 7.5

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMemoryMeshMaterial", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkMeshMaterial")
        HK_PATCH_MEMBER_ADDED("materialName", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("textures", TYPE_ARRAY_OBJECT, "hkMeshTexture", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkMeshMaterial", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hkMeshTexture", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMemoryMeshVertexBuffer", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkMeshVertexBuffer")
        HK_PATCH_MEMBER_ADDED("format", TYPE_STRUCT, "hkVertexFormat", 0)
        HK_PATCH_MEMBER_ADDED("elementOffsets", TYPE_TUPLE_INT, HK_NULL, 32)
        HK_PATCH_MEMBER_ADDED("memory", TYPE_ARRAY_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("vertexStride", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("locked", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("numVertices", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("isSharable", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkMeshVertexBuffer", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hkVertexFormat", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkVertexFormatElement", 0)
        HK_PATCH_MEMBER_ADDED("dataType", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("numValues", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("usage", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("subUsage", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("pad", TYPE_TUPLE_BYTE, HK_NULL, 3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMultipleVertexBufferElementInfo", 0)
        HK_PATCH_MEMBER_ADDED("vertexBufferIndex", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("elementIndex", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMultipleVertexBuffer", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkMeshVertexBuffer")
        HK_PATCH_MEMBER_ADDED("vertexFormat", TYPE_STRUCT, "hkVertexFormat", 0)
        HK_PATCH_MEMBER_ADDED("lockedElements", TYPE_ARRAY_STRUCT, "hkMultipleVertexBufferLockedElement", 0)
        HK_PATCH_MEMBER_ADDED("lockedBuffer", TYPE_OBJECT, "hkMemoryMeshVertexBuffer", 0)
        HK_PATCH_MEMBER_ADDED("elementInfos", TYPE_ARRAY_STRUCT, "hkMultipleVertexBufferElementInfo", 0)
        HK_PATCH_MEMBER_ADDED("vertexBufferInfos", TYPE_ARRAY_STRUCT, "hkMultipleVertexBufferVertexBufferInfo", 0)
        HK_PATCH_MEMBER_ADDED("numVertices", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("isLocked", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("updateCount", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("writeLock", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("isSharable", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("constructionComplete", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkMeshVertexBuffer", 0)
        HK_PATCH_DEPENDS("hkMemoryMeshVertexBuffer", 0)
        HK_PATCH_DEPENDS("hkMultipleVertexBufferElementInfo", 0)
        HK_PATCH_DEPENDS("hkMultipleVertexBufferVertexBufferInfo", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hkMultipleVertexBufferLockedElement", 0)
        HK_PATCH_DEPENDS("hkVertexFormat", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkIndexedTransformSet", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("matrices", TYPE_ARRAY_VEC_16, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("inverseMatrices", TYPE_ARRAY_VEC_16, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("matricesOrder", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("matricesNames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("allMatricesAreAffine", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMeshBody", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMemoryMeshTexture", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkMeshTexture")
        HK_PATCH_MEMBER_ADDED("data", TYPE_ARRAY_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("format", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("hasMipMaps", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("filterMode", TYPE_INT, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkMeshTexture", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMemoryMeshBody", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkMeshBody")
        HK_PATCH_MEMBER_ADDED("transform", TYPE_VEC_16, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("transformSet", TYPE_OBJECT, "hkIndexedTransformSet", 0)
        HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hkMeshShape", 0)
        HK_PATCH_MEMBER_ADDED("vertexBuffers", TYPE_ARRAY_OBJECT, "hkMeshVertexBuffer", 0)
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkMeshShape", 0)
        HK_PATCH_DEPENDS("hkMeshBody", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkIndexedTransformSet", 0)
        HK_PATCH_DEPENDS("hkMeshVertexBuffer", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMeshTexture", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMultipleVertexBufferVertexBufferInfo", 0)
        HK_PATCH_MEMBER_ADDED("vertexBuffer", TYPE_OBJECT, "hkMeshVertexBuffer", 0)
        HK_PATCH_MEMBER_ADDED("isLocked", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkMeshVertexBuffer", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMultipleVertexBufferLockedElement", 0)
        HK_PATCH_MEMBER_ADDED("vertexBufferIndex", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("elementIndex", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("lockedBufferIndex", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("vertexFormatIndex", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("lockFlags", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("outputBufferIndex", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("emulatedIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkVertexFormat", 0)
        HK_PATCH_MEMBER_ADDED("elements", TYPE_TUPLE_STRUCT, "hkVertexFormatElement", 32)
        HK_PATCH_MEMBER_ADDED("numElements", TYPE_INT, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkVertexFormatElement", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMeshBoneIndexMapping", 0)
		HK_PATCH_MEMBER_ADDED("mapping", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkIndexedTransformSet", 0, "hkIndexedTransformSet", 1)
		HK_PATCH_MEMBER_ADDED("indexMappings", TYPE_ARRAY_OBJECT, "hkMeshBoneIndexMapping", 0)
HK_PATCH_DEPENDS("hkMeshBoneIndexMapping", 0)

HK_PATCH_END()

HK_PATCH_BEGIN("hkMemoryMeshTexture", 0, "hkMemoryMeshTexture", 1)
		HK_PATCH_MEMBER_ADDED("usageHint", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkPackfileHeader", 0, "hkPackfileHeader", 1)
		HK_PATCH_MEMBER_REMOVED("pad", TYPE_TUPLE_INT, HK_NULL, 2)
		HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("pad", TYPE_TUPLE_INT, HK_NULL, 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkMemoryMeshTexture", 1, "hkMemoryMeshTexture", 2)
        HK_PATCH_MEMBER_ADDED("filename", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("textureCoordChannel", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxMaterialProperty", 0)
	HK_PATCH_MEMBER_ADDED("key", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("value", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxMaterial", 0, "hkxMaterial", 1)
	HK_PATCH_MEMBER_ADDED("properties", TYPE_ARRAY_STRUCT, "hkxMaterialProperty", 0)
	HK_PATCH_DEPENDS("hkxMaterialProperty", 0)
	//HK_PATCH_FUNCTION(hkxMaterial_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflectedFileAttribute", 0)
	HK_PATCH_MEMBER_ADDED("value", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkHalf8", 0)
	HK_PATCH_MEMBER_ADDED("vec", TYPE_TUPLE_REAL, HK_NULL, 8)
HK_PATCH_END()

HK_PATCH_BEGIN("hkMemoryMeshVertexBuffer", 0, "hkMemoryMeshVertexBuffer", 1)
        HK_PATCH_MEMBER_ADDED("isBigEndian", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkSerializableScanSnapshotAllocation", 0)
	HK_PATCH_MEMBER_ADDED("start", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("size", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("traceId", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkSerializableScanSnapshotBlock", 0)
	HK_PATCH_MEMBER_ADDED("typeIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("start", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("size", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("arraySize", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("startReferenceIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numReferences", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkSerializableScanSnapshot", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("allocations", TYPE_ARRAY_STRUCT, "hkSerializableScanSnapshotAllocation", 0)
	HK_PATCH_MEMBER_ADDED("blocks", TYPE_ARRAY_STRUCT, "hkSerializableScanSnapshotBlock", 0)
	HK_PATCH_MEMBER_ADDED("refs", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("typeNames", TYPE_ARRAY_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("traceText", TYPE_ARRAY_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("traceAddrs", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("traceParents", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkSerializableScanSnapshotAllocation", 0)
	HK_PATCH_DEPENDS("hkSerializableScanSnapshotBlock", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMemoryTrackerAttribute", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkSerializableScanSnapshotBlock", 0, "hkTrackerSerializableScanSnapshotBlock", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkSerializableScanSnapshotAllocation", 0, "hkTrackerSerializableScanSnapshotAllocation", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkSerializableScanSnapshot", 0, "hkTrackerSerializableScanSnapshot", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkMotionState", 0, "hkMotionState", 1)
	HK_PATCH_MEMBER_ADDED("timeFactor", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkMotionState_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkHalf8", 0, "hkHalf8", 1)
	HK_PATCH_MEMBER_RENAMED("vec", "quad")
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkAabbHalf", 0)
	HK_PATCH_MEMBER_ADDED("data", TYPE_TUPLE_INT, HK_NULL, 6)
	HK_PATCH_MEMBER_ADDED("extras", TYPE_TUPLE_INT, HK_NULL, 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkxVertexDescriptionElementDecl", 1, "hkxVertexDescriptionElementDecl", 2)
	HK_PATCH_MEMBER_ADDED("numElements", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_FUNCTION(hkxVertexDescriptionElementDecl_1_to_2)
HK_PATCH_END()

// Required by some cloth operators
HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkPackedVector3", 0)
	HK_PATCH_MEMBER_ADDED("values", TYPE_TUPLE_INT, HK_NULL, 4)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkQTransform", 0)
	HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY("rotation")
	HK_PATCH_MEMBER_ADDED_VEC_4("translation", 0,0,0,0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkPostFinishAttribute", 0)
HK_PATCH_END()

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
