/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

// Cloth specific product patches.
// This file is #included by hclPatches.cpp

//=======
// 650b1
//=======

HK_PATCH_BEGIN("hclTransitionConstraintSetPerParticle", 0, "hclTransitionConstraintSetPerParticle", 1)
	HK_PATCH_MEMBER_ADDED("toAnimDelay", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("toSimDelay", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED_REAL("toSimMaxDistance", 1.0f)
	HK_PATCH_FUNCTION(hclTransitionConstraintSetPerParticle_0_to_1)
	HK_PATCH_MEMBER_REMOVED("particleDelay", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSkinOperator", 0, "hclSkinOperator", 1)
	HK_PATCH_MEMBER_ADDED_INT("startVertex", 0)
	HK_PATCH_MEMBER_ADDED("endVertex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclSkinOperator_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hclTransitionConstraintSet", 0, "hclTransitionConstraintSet", 1)
	HK_PATCH_MEMBER_ADDED("toAnimPeriod", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("toAnimPlusDelayPeriod", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("toSimPeriod", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("toSimPlusDelayPeriod", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclTransitionConstraintSet_0_to_1)
	HK_PATCH_MEMBER_REMOVED("transitionPeriod", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("transitionPlusDelayPeriod", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()


//=======
// 650rc1
//=======

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclScratchBufferDefinition", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclBufferDefinition")
	HK_PATCH_MEMBER_ADDED_BYTE("storeNormals", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("storeTangentsAndBiTangents", 0)
	HK_PATCH_MEMBER_ADDED("triangleIndices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclBufferDefinition", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclMeshMeshDeformOperator", 0, "hclMeshMeshDeformOperator", 1)
	HK_PATCH_MEMBER_ADDED_INT("startVertex", 0)
	HK_PATCH_MEMBER_ADDED("endVertex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclMeshMeshDeformOperator_0_to_1)
HK_PATCH_END()


//=======
// 660beta1
//=======


HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimClothSetupObjectPerInstanceCollidable", 0)
        HK_PATCH_MEMBER_ADDED("collidable", TYPE_OBJECT, "hclCollidable", 0)
        HK_PATCH_MEMBER_ADDED("collidingParticles", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclCollidable", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimulationSetupMeshMapOptions", 0)
        HK_PATCH_MEMBER_ADDED("collapseVertices", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("collapseThreshold", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSetupMeshSectionTriangle", 0)
        HK_PATCH_MEMBER_ADDED("indices", TYPE_TUPLE_INT, HK_NULL, 3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimulateSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simClothSetupObject", TYPE_OBJECT, "hclSimClothSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("numberOfSubsteps", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("numberOfSolveIterations", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("explicitConstraintOrder", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("constraintSetExecutionOrder", TYPE_ARRAY_OBJECT,"hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
        HK_PATCH_DEPENDS("hclSimClothSetupObject", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

#if defined(HK_FEATURE_PRODUCT_CLOTH) && defined(HK_FEATURE_PRODUCT_ANIMATION)

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSkeletonTransformSetSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclTransformSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("skeleton", TYPE_OBJECT, "hkaSkeleton", 0)
        HK_PATCH_MEMBER_ADDED("worldFromModel", TYPE_VEC_16, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclTransformSetSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hkaSkeleton", 0)
HK_PATCH_END()

#endif // HK_FEATURE_PRODUCT_CLOTH && HK_FEATURE_PRODUCT_ANIMATION

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclVertexCopySetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("inputBufferSetupObject", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("outputBufferSetupObject", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("copyNormals", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclNamedTransformSetSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclTransformSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("skelName", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclTransformSetSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBonePlanesSetupObjectGlobalPlane", 0)
        HK_PATCH_MEMBER_ADDED("transformName", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particles", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("planeEquationBoneSpace", TYPE_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("allowedPenetration", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("stiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimulationSetupMesh", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclSetupMesh")
        HK_PATCH_MEMBER_ADDED("originalMesh", TYPE_OBJECT, "hclSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("mergeOptions", TYPE_STRUCT, "hclSimulationSetupMeshMapOptions", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMeshMapOptions", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStandardLinkSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("stiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBonePlanesSetupObjectPerParticleAngle", 0)
        HK_PATCH_MEMBER_ADDED("transformName", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particlesMaxAngle", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("particlesMinAngle", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("originBoneSpace", TYPE_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("axisBoneSpace", TYPE_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("minAngle", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("maxAngle", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("stiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBonePlanesSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("transformSetSetup", TYPE_OBJECT, "hclTransformSetSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("perParticlePlanes", TYPE_ARRAY_STRUCT, "hclBonePlanesSetupObjectPerParticlePlane", 0)
        HK_PATCH_MEMBER_ADDED("globalPlanes", TYPE_ARRAY_STRUCT, "hclBonePlanesSetupObjectGlobalPlane", 0)
        HK_PATCH_MEMBER_ADDED("perParticleAngle", TYPE_ARRAY_STRUCT, "hclBonePlanesSetupObjectPerParticleAngle", 0)
        HK_PATCH_DEPENDS("hclBonePlanesSetupObjectPerParticleAngle", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclBonePlanesSetupObjectPerParticlePlane", 0)
        HK_PATCH_DEPENDS("hclBonePlanesSetupObjectGlobalPlane", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclTransformSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclConstraintSetSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMeshBone", 0)
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("boneFromSkin", TYPE_VEC_16, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimClothSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("gravity", TYPE_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("globalDampingPerSecond", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("enableMidPhase", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("doNormals", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("specifyDensity", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("vertexDensity", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("rescaleMass", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("totalMass", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleMass", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("particleRadius", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("particleFriction", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("fixedParticles", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("constraintSetSetups", TYPE_ARRAY_OBJECT, "hclConstraintSetSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("perInstanceCollidables", TYPE_ARRAY_STRUCT, "hclSimClothSetupObjectPerInstanceCollidable", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclSimClothSetupObjectPerInstanceCollidable", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMeshSectionSectionVertexFloatChannel", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclStorageSetupMeshSectionSectionVertexChannel")
        HK_PATCH_MEMBER_ADDED("vertexFloats", TYPE_ARRAY_REAL, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclStorageSetupMeshSectionSectionVertexChannel", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSceneDataSetupMeshSection", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("setupMesh", TYPE_OBJECT, "hclSceneDataSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("meshSection", TYPE_OBJECT, "hkxMeshSection", 0)
        HK_PATCH_MEMBER_ADDED("skinnedSection", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkxMeshSection", 0)
        HK_PATCH_DEPENDS("hclSceneDataSetupMesh", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStretchLinkSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("movableParticlesSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("fixedParticlesSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("rigidFactor", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("stiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("stretchDirection", TYPE_VEC_4, HK_NULL, 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclOperatorSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclClothSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("bufferSetupObjects", TYPE_ARRAY_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("transformSetSetupObjects", TYPE_ARRAY_OBJECT, "hclTransformSetSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("simClothSetupObjects", TYPE_ARRAY_OBJECT, "hclSimClothSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("operatorSetupObjects", TYPE_ARRAY_OBJECT, "hclOperatorSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("clothStateSetupObjects", TYPE_ARRAY_OBJECT, "hclClothStateSetupObject", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclClothStateSetupObject", 0)
        HK_PATCH_DEPENDS("hclTransformSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
        HK_PATCH_DEPENDS("hclSimClothSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclRecalculateNormalsSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("buffer", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendLinkSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("createStandardLinks", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("bendStiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("stretchStiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("flatnessFactor", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMesh", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclSetupMesh")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("worldFromMesh", TYPE_VEC_16, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("sections", TYPE_ARRAY_OBJECT, "hclStorageSetupMeshSection", 0)
        HK_PATCH_MEMBER_ADDED("vertexChannels", TYPE_ARRAY_STRUCT, "hclStorageSetupMeshVertexChannel", 0)
        HK_PATCH_MEMBER_ADDED("triangleChannels", TYPE_ARRAY_STRUCT, "hclStorageSetupMeshTriangleChannel", 0)
        HK_PATCH_MEMBER_ADDED("bones", TYPE_ARRAY_STRUCT, "hclStorageSetupMeshBone", 0)
        HK_PATCH_MEMBER_ADDED("isSkinned", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("mode", TYPE_INT, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclStorageSetupMeshBone", 0)
        HK_PATCH_DEPENDS("hclStorageSetupMeshSection", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclStorageSetupMeshTriangleChannel", 0)
        HK_PATCH_DEPENDS("hclStorageSetupMeshVertexChannel", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBonePlanesSetupObjectPerParticlePlane", 0)
        HK_PATCH_MEMBER_ADDED("transformName", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particles", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("directionBoneSpace", TYPE_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("allowedDistance", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("stiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStaticDisplayBufferSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclBufferSetupObject")
        HK_PATCH_MEMBER_ADDED("setupMesh", TYPE_OBJECT, "hclSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMeshSectionSectionVertexSelectionChannel", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclStorageSetupMeshSectionSectionVertexChannel")
        HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclStorageSetupMeshSectionSectionVertexChannel", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclHingeSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("hingeStiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("relaxFactor", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclDisplayBufferSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclBufferSetupObject")
        HK_PATCH_MEMBER_ADDED("setupMesh", TYPE_OBJECT, "hclSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMeshSectionSectionTriangleSelectionChannel", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("triangleIndices", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSkinSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("transformSetSetup", TYPE_OBJECT, "hclTransformSetSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("referenceBufferSetup", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("outputBufferSetup", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("skinNormals", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("skinTangents", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("skinBiTangents", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclTransformSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMeshSectionSectionVertexChannel", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclVertexGatherSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("direction", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationBuffer", TYPE_OBJECT, "hclSimClothBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("simulationParticleSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("displayBuffer", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("displayVertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("gatherAllThreshold", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("gatherNormals", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
        HK_PATCH_DEPENDS("hclSimClothBufferSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclNamedSetupMesh", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclSetupMesh")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("meshName", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMeshSection", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("parentSetupMesh", TYPE_OBJECT, "hclSetupMesh", 0)

        HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("normals", TYPE_ARRAY_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("tangents", TYPE_ARRAY_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("bitangents", TYPE_ARRAY_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("triangles", TYPE_ARRAY_STRUCT, "hclSetupMeshSectionTriangle", 0)
        HK_PATCH_MEMBER_ADDED("sectionVertexChannels", TYPE_ARRAY_OBJECT, "hclStorageSetupMeshSectionSectionVertexChannel", 0)
        HK_PATCH_MEMBER_ADDED("sectionTriangleChannels", TYPE_ARRAY_OBJECT, "hclStorageSetupMeshSectionSectionTriangleSelectionChannel", 0)
        HK_PATCH_MEMBER_ADDED("boneInfluences", TYPE_ARRAY_OBJECT, "hclStorageSetupMeshSectionBoneInfluences", 0)
        HK_PATCH_DEPENDS("hclStorageSetupMeshSectionSectionTriangleSelectionChannel", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclSetupMeshSectionTriangle", 0)
        HK_PATCH_DEPENDS("hclStorageSetupMeshSectionBoneInfluences", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclStorageSetupMeshSectionSectionVertexChannel", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclMoveFixedParticlesSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simClothSetupObject", TYPE_OBJECT, "hclSimClothSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("displayBufferSetup", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
        HK_PATCH_DEPENDS("hclSimClothSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimClothBufferSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclBufferSetupObject")
        HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simClothSetupObject", TYPE_OBJECT, "hclSimClothSetupObject", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclSimClothSetupObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclClothSetupContainer", 0)
        HK_PATCH_MEMBER_ADDED("clothSetupDatas", TYPE_ARRAY_OBJECT, "hclClothSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("namedSetupMeshWrappers", TYPE_ARRAY_OBJECT, "hclNamedSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("namedTransformSetWrappers", TYPE_ARRAY_OBJECT, "hclNamedTransformSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclNamedSetupMesh", 0)
        HK_PATCH_DEPENDS("hclClothSetupObject", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclTransformSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclNamedTransformSetSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBufferSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSceneDataSetupMesh", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclSetupMesh")
        HK_PATCH_MEMBER_ADDED("node", TYPE_OBJECT, "hkxNode", 0)
        HK_PATCH_MEMBER_ADDED("worldFromMesh", TYPE_VEC_16, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("mesh", TYPE_OBJECT, "hkxMesh", 0)
        HK_PATCH_MEMBER_ADDED("skinBinding", TYPE_OBJECT, "hkxSkinBinding", 0)
        HK_PATCH_MEMBER_ADDED("vertexChannels", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("triangleChannels", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("meshBufferInterfaces", TYPE_ARRAY_OBJECT, "hclSetupMeshSection", 0)
        HK_PATCH_DEPENDS("hkxMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkxAttributeHolder", 0)
        HK_PATCH_DEPENDS("hkxSkinBinding", 0)
        HK_PATCH_DEPENDS("hkxNode", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclSetupMeshSection", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclTransitionSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("toAnimDelay", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("toSimDelay", TYPE_STRUCT, "hclVertexFloatInput",0)
        HK_PATCH_MEMBER_ADDED("toSimMaxDistance", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("toAnimPeriod", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("toSimPeriod", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("referenceBufferSetup", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMeshSectionBoneInfluences", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("weights", TYPE_ARRAY_REAL, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclVolumeConstraintSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("applyToParticles", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("stiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("influenceParticles", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("particleWeights", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclLocalRangeSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("maximumDistance", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("minNormalDistance", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("maxNormalDistance", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_MEMBER_ADDED("referenceBufferSetup", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclMeshMeshDeformSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("inputBufferSetupObject", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("inputTriangleSelection", TYPE_STRUCT, "hclTriangleSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("outputBufferSetupObject", TYPE_OBJECT, "hclBufferSetupObject", 0)
        HK_PATCH_MEMBER_ADDED("outputVertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("scaleNormalBehaviour", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("influenceRadius", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("maxTrianglesPerVertex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("minimumTriangleWeight", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("inputTrianglesSubsetThreshold", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("deformNormals", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
        HK_PATCH_DEPENDS("hclTriangleSelectionInput", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSetupMesh", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSetupMeshSection", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclClothStateSetupObject", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("operatorSetupObjects", TYPE_ARRAY_OBJECT, "hclOperatorSetupObject", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclTransformSetSetupObject", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMeshTriangleChannel", 0)
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclScratchBufferSetupObject", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclBufferSetupObject")
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("setupMesh", TYPE_OBJECT, "hclSetupMesh", 0)
	HK_PATCH_MEMBER_ADDED("storeNormals", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("storeTangentsAndBiTangents", TYPE_BYTE, HK_NULL,0)
	HK_PATCH_MEMBER_ADDED("storeTriangles", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclSetupMesh", 0)
	HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStorageSetupMeshVertexChannel", 0)
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBlendSetupObject", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("A", TYPE_OBJECT, "hclBufferSetupObject", 0)
	HK_PATCH_MEMBER_ADDED("B", TYPE_OBJECT, "hclBufferSetupObject", 0)
	HK_PATCH_MEMBER_ADDED("C", TYPE_OBJECT, "hclBufferSetupObject", 0)
	HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
	HK_PATCH_MEMBER_ADDED("blendWeights", TYPE_STRUCT, "hclVertexFloatInput", 0)
	HK_PATCH_MEMBER_ADDED("mapToScurve", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
	HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
	HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

// 7.0 Beta
HK_PATCH_BEGIN("hclClothStateBufferAccess", 0, "hclClothStateBufferAccess", 1)
	HK_PATCH_MEMBER_ADDED("shadowBufferIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclClothStateBufferAccess_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclRuntimeConversionInfoSlotConversion", 0)
    HK_PATCH_MEMBER_ADDED("elements", TYPE_TUPLE_BYTE, HK_NULL, 4)
    HK_PATCH_MEMBER_ADDED("numElements", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("index", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("partialWrite", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStaticShadowBufferDefinition", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hclBufferDefinition")
    HK_PATCH_MEMBER_ADDED("staticPositions", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("staticNormals", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("staticTangents", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("staticBiTangents", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("triangleIndices", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hclBufferDefinition", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclOutputConvertOperator", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hclOperator")
    HK_PATCH_MEMBER_ADDED("userBufferIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shadowBufferIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("conversionInfo", TYPE_STRUCT, "hclRuntimeConversionInfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hclOperator", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hclRuntimeConversionInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclRuntimeConversionInfoElementConversion", 0)
    HK_PATCH_MEMBER_ADDED("index", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("offset", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("conversion", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclRuntimeConversionInfo", 0)
    HK_PATCH_MEMBER_ADDED("slotConversions", TYPE_TUPLE_STRUCT, "hclRuntimeConversionInfoSlotConversion", 4)
    HK_PATCH_MEMBER_ADDED("elementConversions", TYPE_TUPLE_STRUCT, "hclRuntimeConversionInfoElementConversion", 4)
    HK_PATCH_MEMBER_ADDED("numSlotsConverted", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numElementsConverted", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hclRuntimeConversionInfoElementConversion", 0)
    HK_PATCH_DEPENDS("hclRuntimeConversionInfoSlotConversion", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclInputConvertOperator", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hclOperator")
    HK_PATCH_MEMBER_ADDED("userBufferIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shadowBufferIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("conversionInfo", TYPE_STRUCT, "hclRuntimeConversionInfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hclOperator", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hclRuntimeConversionInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclShadowBufferDefinition", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hclBufferDefinition")
    HK_PATCH_MEMBER_ADDED("shadowPositions", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shadowNormals", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shadowTangents", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shadowBiTangents", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("triangleIndices", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hclBufferDefinition", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclClothContainer", 0, "hclClothContainer", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hclClothSetupContainer", 0, "hclClothSetupContainer", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_END()

HK_PATCH_BEGIN("hclConvexHeightFieldShape", 0, "hclConvexHeightFieldShape", 1)
	HK_PATCH_MEMBER_REMOVED("allocatedHeights", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSceneDataSetupMesh", 0, "hclSceneDataSetupMesh", 1)
	HK_PATCH_MEMBER_RENAMED("meshBufferInterfaces", "old_meshBufferInterfaces")
	HK_PATCH_MEMBER_ADDED("meshBufferInterfaces", TYPE_ARRAY_OBJECT, "hclSceneDataSetupMeshSection", 0)
	HK_PATCH_FUNCTION(hclSceneDataSetupMesh_0_to_1)
	HK_PATCH_MEMBER_REMOVED("old_meshBufferInterfaces", TYPE_ARRAY_OBJECT, "hclSetupMeshSection", 0)
    HK_PATCH_DEPENDS("hclSetupMeshSection", 0)
    HK_PATCH_DEPENDS("hclSceneDataSetupMeshSection", 0)
HK_PATCH_END()

//7.0 Release

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBufferUsage", 0)
	HK_PATCH_MEMBER_ADDED("perComponentFlags", TYPE_TUPLE_BYTE, HK_NULL, 4)
	HK_PATCH_MEMBER_ADDED("trianglesRead", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclClothStateBufferAccess", 1, "hclClothStateBufferAccess", 2)
        HK_PATCH_MEMBER_ADDED("bufferUsage", TYPE_STRUCT, "hclBufferUsage", 0)
		HK_PATCH_FUNCTION(hclClothStateBufferAccess_1_to_2)
		HK_PATCH_MEMBER_REMOVED("accessFlags", TYPE_INT, HK_NULL, 0)
		HK_PATCH_DEPENDS("hclBufferUsage", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSkinOperator", 1, "hclSkinOperator", 2)
	HK_PATCH_MEMBER_ADDED("partialSkinning", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclSkinOperator_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hclGatherAllVerticesOperator", 0, "hclGatherAllVerticesOperator", 1)
	HK_PATCH_MEMBER_ADDED("partialGather", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclGatherAllVerticesOperator_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hclMeshMeshDeformOperator", 1, "hclMeshMeshDeformOperator", 2)
	HK_PATCH_MEMBER_ADDED("partialDeform", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclMeshMeshDeformOperator_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclUpdateSomeVertexFramesOperatorTriangle", 0)
	HK_PATCH_MEMBER_ADDED("indices", TYPE_TUPLE_INT, HK_NULL, 3)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclUpdateVertexFramesSetupObject", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
	HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("buffer", TYPE_OBJECT, "hclBufferSetupObject", 0)
	HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
	HK_PATCH_MEMBER_ADDED("updateNormals", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("updateTangents", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("updateBiTangents", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("flipNormals", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxSpuDataSize", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
	HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclUpdateAllVertexFramesOperator", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclOperator")
	HK_PATCH_MEMBER_ADDED("bufferIdx", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("updateNormals", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("updateTangents", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("updateBiTangents", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("flipNormals", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vertToNormalID", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numUniqueNormalIDs", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("referenceVertices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("tangentEdgeCosAngle", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("tangentEdgeSinAngle", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("biTangentFlip", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("spuSupported", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclOperator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclUpdateSomeVertexFramesOperator", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclOperator")
	HK_PATCH_MEMBER_ADDED("bufferIdx", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("updateNormals", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("updateTangents", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("updateBiTangents", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("flipNormals", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("involvedTriangles", TYPE_ARRAY_STRUCT, "hclUpdateSomeVertexFramesOperatorTriangle", 0)
	HK_PATCH_MEMBER_ADDED("involvedVertices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("selectionVertexToInvolvedVertex", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("involvedVertexToNormalID", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("numUniqueNormalIDs", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("referenceVertices", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("tangentEdgeCosAngle", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("tangentEdgeSinAngle", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("biTangentFlip", TYPE_ARRAY_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("spuSupported", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclUpdateSomeVertexFramesOperatorTriangle", 0)
	HK_PATCH_DEPENDS("hclOperator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclStorageSetupMeshSection", 0, "hclStorageSetupMeshSection", 1)
	HK_PATCH_MEMBER_ADDED("normalIDs", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclUpdateAllVertexFramesOperator", 0, "hclUpdateAllVertexFramesOperator", 1)
	HK_PATCH_MEMBER_REMOVED("spuSupported", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclUpdateSomeVertexFramesOperator", 0, "hclUpdateSomeVertexFramesOperator", 1)
	HK_PATCH_MEMBER_REMOVED("spuSupported", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclUpdateVertexFramesSetupObject", 0, "hclUpdateVertexFramesSetupObject", 1)
	HK_PATCH_MEMBER_REMOVED("maxSpuDataSize", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothDataSimulationInfo", 0, "hclSimClothDataSimulationInfo", 1)
	HK_PATCH_MEMBER_ADDED("flipNormals", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclUpdateVertexFramesSetupObject", 1, "hclUpdateVertexFramesSetupObject", 2)
	HK_PATCH_MEMBER_REMOVED("flipNormals", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()


// 2010.1.0

HK_PATCH_BEGIN("hclSimClothData", 0, "hclSimClothData", 1)
	HK_PATCH_MEMBER_ADDED("staticCollisionMasks", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxCollisionPairs", TYPE_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclSimClothData_0_to_1)
	HK_PATCH_DEPENDS("hclSimClothDataCollisionPair", 0)
	HK_PATCH_MEMBER_REMOVED("enableMidPhase", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("staticCollisionPairs", TYPE_ARRAY_STRUCT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclCapsuleShape", 0, "hclCapsuleShape", 1)
	HK_PATCH_MEMBER_ADDED("capLenSqrdInv", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclCapsuleShape_0_to_1)
	HK_PATCH_MEMBER_REMOVED("capLenSqrd", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclTaperedCapsuleShape", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclShape")
	HK_PATCH_MEMBER_ADDED("small", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("big", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("smallRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("bigRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("coneApex", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("coneAxis", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("l", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("d", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("dVec", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("cosTheta", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("sinTheta", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("tanTheta", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("tanThetaSqr", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("tanThetaVecNeg", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_DEPENDS("hclShape", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothDataCollisionPair", 0, HK_NULL, HK_CLASS_REMOVED)
        HK_PATCH_MEMBER_REMOVED("particleIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_REMOVED("collidableIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclCollidable", 0, "hclCollidable", 1)
        HK_PATCH_MEMBER_REMOVED("stepMovement", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_REMOVED("radius", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothSetupObject", 0, "hclSimClothSetupObject", 1)
        HK_PATCH_MEMBER_REMOVED("enableMidPhase", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimulateSetupObject", 0, "hclSimulateSetupObject", 1)
	HK_PATCH_MEMBER_ADDED("collideAndSolve", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimulateOperator", 0, "hclSimulateOperator", 1)
	HK_PATCH_MEMBER_ADDED("collideAndSolve", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimClothDataCollidableTransformMap", 0)
    HK_PATCH_MEMBER_ADDED_INT("transformSetIndex", -1)
    HK_PATCH_MEMBER_ADDED("transformIndices", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("offsets", TYPE_ARRAY_VEC_16, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothSetupObject", 1, "hclSimClothSetupObject", 2)
    HK_PATCH_MEMBER_ADDED("collidableTransformSet", TYPE_OBJECT, "hclTransformSetSetupObject", 0)
    HK_PATCH_DEPENDS("hclTransformSetSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothData", 1, "hclSimClothData", 2)
    HK_PATCH_MEMBER_ADDED("collidableTransformMap", TYPE_STRUCT, "hclSimClothDataCollidableTransformMap", 0)
    HK_PATCH_DEPENDS("hclSimClothDataCollidableTransformMap", 0)
    HK_PATCH_FUNCTION(hclSimClothData_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("hclTaperedCapsuleShape", 0, "hclTaperedCapsuleShape", 1)
	HK_PATCH_MEMBER_ADDED("lVec", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("vPerm", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothSetupObjectPerInstanceCollidable", 0, "hclSimClothSetupObjectPerInstanceCollidable", 1)
   HK_PATCH_MEMBER_ADDED("drivingBoneName", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendStiffnessConstraintSet", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSet")
        HK_PATCH_MEMBER_ADDED("links", TYPE_ARRAY_STRUCT, "hclBendStiffnessConstraintSetLink", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclConstraintSet", 0)
        HK_PATCH_DEPENDS("hclBendStiffnessConstraintSetLink", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendStiffnessSetupObject", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSetSetupObject")
        HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("simulationMesh", TYPE_OBJECT, "hclSimulationSetupMesh", 0)
        HK_PATCH_MEMBER_ADDED("vertexSelection", TYPE_STRUCT, "hclVertexSelectionInput", 0)
        HK_PATCH_MEMBER_ADDED("bendStiffness", TYPE_STRUCT, "hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclSimulationSetupMesh", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
        HK_PATCH_DEPENDS("hclVertexFloatInput", 0)
        HK_PATCH_DEPENDS("hclConstraintSetSetupObject", 0)
        HK_PATCH_DEPENDS("hclSetupMesh", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendStiffnessConstraintSetLink", 0)
        HK_PATCH_MEMBER_ADDED("particleA", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleB", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleC", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleD", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("weightA", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("weightB", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("weightC", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("weightD", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("bendStiffness", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclBendStiffnessConstraintSet", 0, "hclBendStiffnessConstraintSet", 1)
		HK_PATCH_MEMBER_ADDED("useRestPoseConfig", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclBendStiffnessSetupObject", 0, "hclBendStiffnessSetupObject", 1)
		HK_PATCH_MEMBER_ADDED("useRestPoseConfig", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclBendStiffnessConstraintSetLink", 0, "hclBendStiffnessConstraintSetLink", 1)
		HK_PATCH_MEMBER_ADDED("restCurvature", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclUpdateAllVertexFramesOperator", 1, "hclUpdateAllVertexFramesOperator", 2)
	HK_PATCH_MEMBER_ADDED("triangleFlips", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclUpdateAllVertexFramesOperator_1_to_2)
	HK_PATCH_MEMBER_REMOVED("flipNormals", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclUpdateSomeVertexFramesOperator", 1, "hclUpdateSomeVertexFramesOperator", 2)
	HK_PATCH_MEMBER_ADDED("triangleFlips", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclUpdateSomeVertexFramesOperator_1_to_2)
	HK_PATCH_MEMBER_REMOVED("flipNormals", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothData", 2, "hclSimClothData", 3)
	HK_PATCH_MEMBER_ADDED("triangleFlips", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclSimClothData_2_to_3)
	HK_PATCH_DEPENDS("hclSimClothDataSimulationInfo", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothDataSimulationInfo", 1, "hclSimClothDataSimulationInfo", 2)
	HK_PATCH_MEMBER_REMOVED("flipNormals", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStandardLinkConstraintSetMx", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSet")
        HK_PATCH_MEMBER_ADDED("batches", TYPE_ARRAY_STRUCT, "hclStandardLinkConstraintSetMxBatch", 0)
        HK_PATCH_MEMBER_ADDED("singles", TYPE_ARRAY_STRUCT, "hclStandardLinkConstraintSetMxSingle", 0)
        HK_PATCH_DEPENDS("hclStandardLinkConstraintSetMxBatch", 0)
        HK_PATCH_DEPENDS("hclStandardLinkConstraintSetMxSingle", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclConstraintSet", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStandardLinkConstraintSetMxBatch", 0)
        HK_PATCH_MEMBER_ADDED("restLengths", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("stiffnessesA", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("stiffnessesB", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("particlesA", TYPE_TUPLE_INT, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("particlesB", TYPE_TUPLE_INT, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStandardLinkConstraintSetMxSingle", 0)
        HK_PATCH_MEMBER_ADDED("restLength", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("stiffnessA", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("stiffnessB", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleA", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStretchLinkConstraintSetMxBatch", 0)
        HK_PATCH_MEMBER_ADDED("restLengths", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("stiffnesses", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("particlesA", TYPE_TUPLE_INT, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("particlesB", TYPE_TUPLE_INT, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStretchLinkConstraintSetMxSingle", 0)
        HK_PATCH_MEMBER_ADDED("restLength", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("stiffness", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleA", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclStretchLinkConstraintSetMx", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSet")
        HK_PATCH_MEMBER_ADDED("batches", TYPE_ARRAY_STRUCT, "hclStretchLinkConstraintSetMxBatch", 0)
        HK_PATCH_MEMBER_ADDED("singles", TYPE_ARRAY_STRUCT, "hclStretchLinkConstraintSetMxSingle", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclConstraintSet", 0)
        HK_PATCH_DEPENDS("hclStretchLinkConstraintSetMxBatch", 0)
        HK_PATCH_DEPENDS("hclStretchLinkConstraintSetMxSingle", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendLinkConstraintSetMx", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSet")
        HK_PATCH_MEMBER_ADDED("batches", TYPE_ARRAY_STRUCT, "hclBendLinkConstraintSetMxBatch", 0)
        HK_PATCH_MEMBER_ADDED("singles", TYPE_ARRAY_STRUCT, "hclBendLinkConstraintSetMxSingle", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclConstraintSet", 0)
        HK_PATCH_DEPENDS("hclBendLinkConstraintSetMxSingle", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBendLinkConstraintSetMxBatch", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendLinkConstraintSetMxBatch", 0)
        HK_PATCH_MEMBER_ADDED("bendMinLengths", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("stretchMaxLengths", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("stretchStiffnesses", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("bendStiffnesses", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("invMassesA", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("invMassesB", TYPE_TUPLE_REAL, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("particlesA", TYPE_TUPLE_INT, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("particlesB", TYPE_TUPLE_INT, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendLinkConstraintSetMxSingle", 0)
        HK_PATCH_MEMBER_ADDED("bendMinLength", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("stretchMaxLength", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("stretchStiffness", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("bendStiffness", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("invMassA", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("invMassB", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleA", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("particleB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclVolumeConstraintSetupObject", 0, "hclVolumeConstraintSetupObject", 1)
	HK_PATCH_MEMBER_ADDED("useDeprecatedMethod", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclVolumeConstraintSetupObject_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hclVolumeConstraint", 0, "hclVolumeConstraint", 1)
	HK_PATCH_MEMBER_ADDED("useDeprecatedMethod", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclVolumeConstraint_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hclTaperedCapsuleShape", 1, "hclTaperedCapsuleShape", 2)
	HK_PATCH_MEMBER_REMOVED("vPerm", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothData", 3, "hclSimClothData", 4)
	HK_PATCH_MEMBER_ADDED("maxParticleRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclSimClothData_3_to_4)
HK_PATCH_END()

HK_PATCH_BEGIN("hclClothData", 0, "hclClothData", 1)
	HK_PATCH_MEMBER_ADDED("targetPlatform", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclLocalRangeConstraintSet", 0, "hclLocalRangeConstraintSet", 1)
	HK_PATCH_MEMBER_ADDED("applyNormalComponent", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclLocalRangeConstraintSet_0_to_1)
HK_PATCH_END()

// 2010.2.0

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendStiffnessConstraintSetMxBatch",0)
		HK_PATCH_MEMBER_ADDED("weightsA", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("weightsB", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("weightsC", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("weightsD", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("bendStiffnesses", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("restCurvatures", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("invMassesA", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("invMassesB", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("invMassesC", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("invMassesD", TYPE_TUPLE_REAL, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("particlesA", TYPE_TUPLE_INT, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("particlesB", TYPE_TUPLE_INT, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("particlesC", TYPE_TUPLE_INT, HK_NULL, 16)
		HK_PATCH_MEMBER_ADDED("particlesD", TYPE_TUPLE_INT, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendStiffnessConstraintSetMx", 0)
		HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSet")
		HK_PATCH_MEMBER_ADDED("batches", TYPE_ARRAY_STRUCT, "hclBendStiffnessConstraintSetMxBatch", 0)
		HK_PATCH_MEMBER_ADDED("singles", TYPE_ARRAY_STRUCT, "hclBendStiffnessConstraintSetMxSingle", 0)
		HK_PATCH_MEMBER_ADDED("useRestPoseConfig", TYPE_BYTE, HK_NULL, 0)
		HK_PATCH_DEPENDS("hkBaseObject", 0)
		HK_PATCH_DEPENDS("hclConstraintSet", 0)
		HK_PATCH_DEPENDS("hclBendStiffnessConstraintSetMxSingle", 0)
		HK_PATCH_DEPENDS("hkReferencedObject", 0)
		HK_PATCH_DEPENDS("hclBendStiffnessConstraintSetMxBatch", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBendStiffnessConstraintSetMxSingle",0)
		HK_PATCH_MEMBER_ADDED("weightA", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("weightB", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("weightC", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("weightD", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("bendStiffness", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("restCurvature", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("invMassA", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("invMassB", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("invMassC", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("invMassD", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("particleA", TYPE_INT, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("particleB", TYPE_INT, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("particleC", TYPE_INT, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("particleD", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclVolumeConstraintMxApplySingleData",0)
	   HK_PATCH_MEMBER_ADDED("frameVector", TYPE_VEC_4, HK_NULL, 0)
	   HK_PATCH_MEMBER_ADDED("particleIndex", TYPE_INT, HK_NULL, 0)
	   HK_PATCH_MEMBER_ADDED("stiffness", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclVolumeConstraintMx", 0)
	   HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSet")
	   HK_PATCH_MEMBER_ADDED("frameBatchDatas", TYPE_ARRAY_STRUCT, "hclVolumeConstraintMxFrameBatchData", 0)
	   HK_PATCH_MEMBER_ADDED("frameSingleDatas", TYPE_ARRAY_STRUCT, "hclVolumeConstraintMxFrameSingleData", 0)
	   HK_PATCH_MEMBER_ADDED("applyBatchDatas", TYPE_ARRAY_STRUCT, "hclVolumeConstraintMxApplyBatchData", 0)
	   HK_PATCH_MEMBER_ADDED("applySingleDatas", TYPE_ARRAY_STRUCT, "hclVolumeConstraintMxApplySingleData", 0)
	   HK_PATCH_DEPENDS("hkBaseObject", 0)
	   HK_PATCH_DEPENDS("hclConstraintSet", 0)
	   HK_PATCH_DEPENDS("hclVolumeConstraintMxApplyBatchData", 0)
	   HK_PATCH_DEPENDS("hclVolumeConstraintMxFrameBatchData", 0)
	   HK_PATCH_DEPENDS("hkReferencedObject", 0)
	   HK_PATCH_DEPENDS("hclVolumeConstraintMxFrameSingleData", 0)
	   HK_PATCH_DEPENDS("hclVolumeConstraintMxApplySingleData", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclVolumeConstraintMxApplyBatchData", 0)
	   HK_PATCH_MEMBER_ADDED("frameVector", TYPE_TUPLE_VEC_4, HK_NULL, 16)
	   HK_PATCH_MEMBER_ADDED("particleIndex", TYPE_TUPLE_INT, HK_NULL, 16)
	   HK_PATCH_MEMBER_ADDED("stiffness", TYPE_TUPLE_REAL, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclVolumeConstraintMxFrameBatchData", 0)
	   HK_PATCH_MEMBER_ADDED("frameVector", TYPE_TUPLE_VEC_4, HK_NULL, 16)
	   HK_PATCH_MEMBER_ADDED("particleIndex", TYPE_TUPLE_INT, HK_NULL, 16)
	   HK_PATCH_MEMBER_ADDED("weight", TYPE_TUPLE_REAL, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclVolumeConstraintMxFrameSingleData",0)
	   HK_PATCH_MEMBER_ADDED("frameVector", TYPE_VEC_4, HK_NULL, 0)
	   HK_PATCH_MEMBER_ADDED("particleIndex", TYPE_INT, HK_NULL, 0)
	   HK_PATCH_MEMBER_ADDED("weight", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclMeshBoneDeformOperatorTriangleBonePair", 0)
		HK_PATCH_MEMBER_ADDED("localBoneTransform", TYPE_VEC_16, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("triangleIndex", TYPE_INT, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("weight", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclMeshBoneDeformSetupObject", 0)
		HK_PATCH_PARENT_SET(HK_NULL, "hclOperatorSetupObject")
		HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("inputBufferSetupObject", TYPE_OBJECT, "hclBufferSetupObject", 0)
		HK_PATCH_MEMBER_ADDED("inputTriangleSelection", TYPE_STRUCT, "hclTriangleSelectionInput", 0)
		HK_PATCH_MEMBER_ADDED("outputTransformSetSetupObject", TYPE_OBJECT, "hclTransformSetSetupObject", 0)
		HK_PATCH_MEMBER_ADDED("deformedBones", TYPE_ARRAY_CSTRING, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("maxTrianglesPerBone", TYPE_INT, HK_NULL, 0)
		HK_PATCH_MEMBER_ADDED("minimumTriangleWeight", TYPE_REAL, HK_NULL, 0)
		HK_PATCH_DEPENDS("hkBaseObject", 0)
		HK_PATCH_DEPENDS("hclTransformSetSetupObject", 0)
		HK_PATCH_DEPENDS("hclOperatorSetupObject", 0)
		HK_PATCH_DEPENDS("hclTriangleSelectionInput", 0)
		HK_PATCH_DEPENDS("hkReferencedObject", 0)
		HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclMeshBoneDeformOperator", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclOperator")
	HK_PATCH_MEMBER_ADDED("inputBufferIdx", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("outputTransformSetIdx", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("triangleBonePairs", TYPE_ARRAY_STRUCT, "hclMeshBoneDeformOperatorTriangleBonePair", 0)
	HK_PATCH_MEMBER_ADDED("triangleBoneStartForBone", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hclMeshBoneDeformOperatorTriangleBonePair", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclOperator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimpleMeshBoneDeformOperator", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclOperator")
	HK_PATCH_MEMBER_ADDED("inputBufferIdx", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("outputTransformSetIdx", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("triangleBonePairs", TYPE_ARRAY_STRUCT, "hclSimpleMeshBoneDeformOperatorTriangleBonePair", 0)
	HK_PATCH_MEMBER_ADDED("localBoneTransforms", TYPE_ARRAY_VEC_16, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclSimpleMeshBoneDeformOperatorTriangleBonePair", 0)
	HK_PATCH_DEPENDS("hclOperator", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimpleMeshBoneDeformOperatorTriangleBonePair", 0)
	HK_PATCH_MEMBER_ADDED("boneOffset", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("triangleOffset", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclAntiPinchConstraintSetPerParticle", 1)
	HK_PATCH_MEMBER_ADDED("particleIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("referenceVertex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclAntiPinchConstraintSet", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hclConstraintSet")
	HK_PATCH_MEMBER_ADDED("perParticleData", TYPE_ARRAY_STRUCT, "hclAntiPinchConstraintSetPerParticle", 0)
	HK_PATCH_MEMBER_ADDED("toAnimPeriod", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("toSimPeriod", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("toSimMaxDistance", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("referenceMeshBufferIdx", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hclConstraintSet", 0)
	HK_PATCH_DEPENDS("hclAntiPinchConstraintSetPerParticle", 1)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclSimClothDataCollidablePinchingData", 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionPriority", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionRadius", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothSetupObjectPerInstanceCollidable", 1, "hclSimClothSetupObjectPerInstanceCollidable", 2)
	HK_PATCH_MEMBER_ADDED("pinchDetectionEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionPriority", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionRadius", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclCollidable", 1, "hclCollidable", 2)
	HK_PATCH_MEMBER_ADDED("pinchDetectionEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionPriority", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionRadius", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothSetupObject", 2, "hclSimClothSetupObject", 3)
	HK_PATCH_MEMBER_ADDED("enablePinchDetection", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionEnabledParticles", TYPE_STRUCT, "hclVertexSelectionInput", 0)
	HK_PATCH_MEMBER_ADDED("toAnimPeriod", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("toSimPeriod", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("drivePinchedParticlesToReferenceMesh", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchReferenceBufferSetup", TYPE_OBJECT, "hclBufferSetupObject", 0)
	HK_PATCH_DEPENDS("hclVertexSelectionInput", 0)
	HK_PATCH_DEPENDS("hclBufferSetupObject", 0)
	HK_PATCH_FUNCTION(hclSimClothSetupObject_2_to_3)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothDataParticleData", 0, "hclSimClothDataParticleData", 1)
	HK_PATCH_MEMBER_ADDED("pinchDetectionEnabled", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothData", 4, "hclSimClothData", 5)
	HK_PATCH_MEMBER_ADDED("antiPinchConstraintSets", TYPE_ARRAY_OBJECT, "hclConstraintSet", 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionEnabled", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("collidablePinchingDatas", TYPE_ARRAY_STRUCT, "hclSimClothDataCollidablePinchingData", 0)
	HK_PATCH_DEPENDS("hclSimClothDataCollidablePinchingData", 0)
	HK_PATCH_DEPENDS("hclConstraintSet", 0)
	HK_PATCH_FUNCTION(hclSimClothData_4_to_5)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothData", 5, "hclSimClothData", 6)
	HK_PATCH_MEMBER_ADDED("minPinchedParticleIndex", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxPinchedParticleIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothSetupObjectPerInstanceCollidable", 2, "hclSimClothSetupObjectPerInstanceCollidable", 3)
	HK_PATCH_MEMBER_REMOVED("pinchDetectionPriority", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionPriority", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclCollidable", 2, "hclCollidable", 3)
	HK_PATCH_MEMBER_REMOVED("pinchDetectionPriority", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionPriority", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothDataCollidablePinchingData", 0, "hclSimClothDataCollidablePinchingData", 1)
	HK_PATCH_MEMBER_REMOVED("pinchDetectionPriority", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("pinchDetectionPriority", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothDataParticleData", 1, "hclSimClothDataParticleData", 2)
	HK_PATCH_MEMBER_REMOVED("pinchDetectionEnabled", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSimClothData", 6, "hclSimClothData", 7)
	HK_PATCH_MEMBER_ADDED("perParticlePinchDetectionEnabledFlags", TYPE_ARRAY_BYTE, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclSimClothData_6_to_7)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSkinOperator", 2, "hclSkinOperator", 3)
	HK_PATCH_MEMBER_ADDED("usedBoneGroupIds", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("boneGroupSize", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSkinOperatorBoneInfluence", 0, "hclSkinOperatorBoneInfluence", 1)
   HK_PATCH_MEMBER_RENAMED("boneIndex", "old_boneIndex")
   HK_PATCH_MEMBER_ADDED("boneIndex", TYPE_INT, HK_NULL, 0)
   HK_PATCH_FUNCTION(hclSkinOperatorBoneInfluence_0_to_1)
   HK_PATCH_MEMBER_REMOVED("old_boneIndex", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBufferLayout", 0)
    HK_PATCH_MEMBER_ADDED("elementsLayout", TYPE_TUPLE_STRUCT, "hclBufferLayoutBufferElement", 4)
    HK_PATCH_MEMBER_ADDED("numSlots", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("slots", TYPE_TUPLE_STRUCT, "hclBufferLayoutSlot", 4)
    HK_PATCH_MEMBER_ADDED("triangleFormat", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hclBufferLayoutBufferElement", 0)
    HK_PATCH_DEPENDS("hclBufferLayoutSlot", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBufferLayoutBufferElement", 0)
    HK_PATCH_MEMBER_ADDED("vectorConversion", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("vectorSize", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("slotId", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("slotStart", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBufferLayoutSlot", 0)
    HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("stride", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclBufferDefinition", 0, "hclBufferDefinition", 1)
    HK_PATCH_MEMBER_ADDED("bufferLayout", TYPE_STRUCT, "hclBufferLayout", 0)

    HK_PATCH_DEPENDS("hclBufferLayout", 0)
    HK_PATCH_FUNCTION(hclBufferDefinition_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hclStorageSetupMesh", 0, "hclStorageSetupMesh", 1)
	HK_PATCH_MEMBER_REMOVED("mode", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclLocalRangeSetupObject", 0, "hclLocalRangeSetupObject", 1)
	HK_PATCH_MEMBER_ADDED("useMinNormalDistance", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("useMaxNormalDistance", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("stiffness", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_FUNCTION(hclLocalRangeSetupObject_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("hclLocalRangeConstraintSet", 1, "hclLocalRangeConstraintSet", 2)
	HK_PATCH_MEMBER_ADDED("stiffness", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceDeformerTwoBlendEntryBlock", 0)
    HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 16)
    HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_TUPLE_INT, HK_NULL, 32)
    HK_PATCH_MEMBER_ADDED("boneWeights", TYPE_TUPLE_BYTE, HK_NULL, 32)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceSkinOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclOperator")
        HK_PATCH_MEMBER_ADDED("outputBufferIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("transformSetIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("boneSpaceDeformer", TYPE_STRUCT, "hclBoneSpaceDeformer", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceDeformer", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceSkinPNOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclObjectSpaceSkinOperator")
        HK_PATCH_MEMBER_ADDED("localPNs", TYPE_ARRAY_STRUCT, "hclObjectSpaceDeformerLocalBlockPN", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceSkinOperator", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceDeformerLocalBlockPN", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceDeformerThreeBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 5)
        HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_TUPLE_INT, HK_NULL, 15)
        HK_PATCH_MEMBER_ADDED("padding", TYPE_TUPLE_BYTE, HK_NULL, 8)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceDeformerFourBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 4)
        HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_TUPLE_INT, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("padding", TYPE_TUPLE_BYTE, HK_NULL, 8)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceDeformerLocalBlockP", 0)
        HK_PATCH_MEMBER_ADDED("localPosition", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_DEPENDS("hkPackedVector3", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceDeformer", 0)
        HK_PATCH_MEMBER_ADDED("fourBlendEntries", TYPE_ARRAY_STRUCT, "hclObjectSpaceDeformerFourBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("threeBlendEntries", TYPE_ARRAY_STRUCT, "hclObjectSpaceDeformerThreeBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("twoBlendEntries", TYPE_ARRAY_STRUCT, "hclObjectSpaceDeformerTwoBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("oneBlendEntries", TYPE_ARRAY_STRUCT, "hclObjectSpaceDeformerOneBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("controlBytes", TYPE_ARRAY_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("startVertexIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("endVertexIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("batchSizeSpu", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("partialWrite", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hclObjectSpaceDeformerThreeBlendEntryBlock", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceDeformerTwoBlendEntryBlock", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceDeformerFourBlendEntryBlock", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceDeformerOneBlendEntryBlock", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceDeformerLocalBlockPNT", 0)
        HK_PATCH_MEMBER_ADDED("localPosition", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_MEMBER_ADDED("localNormal", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_MEMBER_ADDED("localTangent", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_DEPENDS("hkPackedVector3", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceDeformerLocalBlockP", 0)
        HK_PATCH_MEMBER_ADDED("localPosition", TYPE_TUPLE_VEC_4, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceDeformerOneBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_TUPLE_INT, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceDeformerThreeBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_TUPLE_INT, HK_NULL, 48)
        HK_PATCH_MEMBER_ADDED("boneWeights", TYPE_TUPLE_BYTE, HK_NULL, 48)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceDeformerLocalBlockPN", 0)
        HK_PATCH_MEMBER_ADDED("localPosition", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_MEMBER_ADDED("localNormal", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_DEPENDS("hkPackedVector3", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceSkinPOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclBoneSpaceSkinOperator")
        HK_PATCH_MEMBER_ADDED("localPs", TYPE_ARRAY_STRUCT, "hclBoneSpaceDeformerLocalBlockP", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceSkinOperator", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceDeformerLocalBlockP", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceDeformerFourBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_TUPLE_INT, HK_NULL, 64)
        HK_PATCH_MEMBER_ADDED("boneWeights", TYPE_TUPLE_BYTE, HK_NULL, 64)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceDeformerLocalBlockPNT", 0)
        HK_PATCH_MEMBER_ADDED("localPosition", TYPE_TUPLE_VEC_4, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("localNormal", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_MEMBER_ADDED("localTangent", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_DEPENDS("hkPackedVector3", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceDeformerTwoBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 8)
        HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_TUPLE_INT, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceSkinPNOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclBoneSpaceSkinOperator")
        HK_PATCH_MEMBER_ADDED("localPNs", TYPE_ARRAY_STRUCT, "hclBoneSpaceDeformerLocalBlockPN", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceSkinOperator", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceDeformerLocalBlockPN", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceSkinPNTOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclBoneSpaceSkinOperator")
        HK_PATCH_MEMBER_ADDED("localPNTs", TYPE_ARRAY_STRUCT, "hclBoneSpaceDeformerLocalBlockPNT", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceDeformerLocalBlockPNT", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceSkinOperator", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceSkinPNTBOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclBoneSpaceSkinOperator")
        HK_PATCH_MEMBER_ADDED("localPNTBs", TYPE_ARRAY_STRUCT, "hclBoneSpaceDeformerLocalBlockPNTB", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceDeformerLocalBlockPNTB", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceSkinOperator", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceDeformerLocalBlockPNTB", 0)
        HK_PATCH_MEMBER_ADDED("localPosition", TYPE_TUPLE_VEC_4, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("localNormal", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_MEMBER_ADDED("localTangent", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_MEMBER_ADDED("localBiTangent", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_DEPENDS("hkPackedVector3", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceDeformer", 0)
        HK_PATCH_MEMBER_ADDED("fourBlendEntries", TYPE_ARRAY_STRUCT, "hclBoneSpaceDeformerFourBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("threeBlendEntries", TYPE_ARRAY_STRUCT, "hclBoneSpaceDeformerThreeBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("twoBlendEntries", TYPE_ARRAY_STRUCT, "hclBoneSpaceDeformerTwoBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("oneBlendEntries", TYPE_ARRAY_STRUCT, "hclBoneSpaceDeformerOneBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("controlBytes", TYPE_ARRAY_BYTE, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("startVertexIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("endVertexIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("batchSizeSpu", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("partialWrite", TYPE_BYTE, HK_NULL, 0)
        HK_PATCH_DEPENDS("hclBoneSpaceDeformerThreeBlendEntryBlock", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceDeformerFourBlendEntryBlock", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceDeformerTwoBlendEntryBlock", 0)
        HK_PATCH_DEPENDS("hclBoneSpaceDeformerOneBlendEntryBlock", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceDeformerOneBlendEntryBlock", 0)
        HK_PATCH_MEMBER_ADDED("vertexIndices", TYPE_TUPLE_INT, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_TUPLE_INT, HK_NULL, 16)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclBoneSpaceDeformerLocalBlockPN", 0)
        HK_PATCH_MEMBER_ADDED("localPosition", TYPE_TUPLE_VEC_4, HK_NULL, 16)
        HK_PATCH_MEMBER_ADDED("localNormal", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_DEPENDS("hkPackedVector3", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceSkinPNTBOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclObjectSpaceSkinOperator")
        HK_PATCH_MEMBER_ADDED("localPNTBs", TYPE_ARRAY_STRUCT, "hclObjectSpaceDeformerLocalBlockPNTB", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceDeformerLocalBlockPNTB", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceSkinOperator", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceDeformerLocalBlockPNTB", 0)
        HK_PATCH_MEMBER_ADDED("localPosition", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_MEMBER_ADDED("localNormal", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_MEMBER_ADDED("localTangent", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_MEMBER_ADDED("localBiTangent", TYPE_TUPLE_STRUCT, "hkPackedVector3", 16)
        HK_PATCH_DEPENDS("hkPackedVector3", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceSkinOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclOperator")
        HK_PATCH_MEMBER_ADDED("outputBufferIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("transformSetIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("boneFromSkinMeshTransforms", TYPE_ARRAY_VEC_16, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("objectSpaceDeformer", TYPE_STRUCT, "hclObjectSpaceDeformer", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceDeformer", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceSkinPOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclObjectSpaceSkinOperator")
        HK_PATCH_MEMBER_ADDED("localPs", TYPE_ARRAY_STRUCT, "hclObjectSpaceDeformerLocalBlockP", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceDeformerLocalBlockP", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceSkinOperator", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclObjectSpaceSkinPNTOperator", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hclObjectSpaceSkinOperator")
        HK_PATCH_MEMBER_ADDED("localPNTs", TYPE_ARRAY_STRUCT, "hclObjectSpaceDeformerLocalBlockPNT", 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hclOperator", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceSkinOperator", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hclObjectSpaceDeformerLocalBlockPNT", 0)
HK_PATCH_END()


HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclClothStateTransformSetAccess", 0)
        HK_PATCH_MEMBER_ADDED("transformSetIndex", TYPE_INT, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("transformSetUsage", TYPE_STRUCT, "hclTransformSetUsage", 0)
        HK_PATCH_DEPENDS("hclTransformSetUsage", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclTransformSetUsage", 0)
        HK_PATCH_MEMBER_ADDED("perComponentFlags", TYPE_TUPLE_BYTE, HK_NULL, 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hclClothState", 0, "hclClothState", 1)
		HK_PATCH_MEMBER_RENAMED("usedTransformSets", "old_usedTransformSets")
		HK_PATCH_MEMBER_ADDED("usedTransformSets", TYPE_ARRAY_STRUCT, "hclClothStateTransformSetAccess", 0)
		HK_PATCH_FUNCTION(hclClothState_0_to_1)
        HK_PATCH_MEMBER_REMOVED("old_usedTransformSets", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_DEPENDS("hclClothStateTransformSetAccess", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSkinOperator", 3, "hclSkinOperator", 4)
		HK_PATCH_MEMBER_ADDED("dualQuaternionSkinning", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hclConvexGeometryShape", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hclShape")
	HK_PATCH_MEMBER_ADDED("tetrahedraGrid", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("gridCells", TYPE_ARRAY_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("tetrahedraEquations", TYPE_ARRAY_VEC_16, HK_NULL,0)
	HK_PATCH_MEMBER_ADDED("objAabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_MEMBER_ADDED("localFromWorld", TYPE_VEC_16, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("worldFromLocal", TYPE_VEC_16, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("geomCentroid", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("invCellSize", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("gridRes", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hclShape", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSkinSetupObject", 0, "hclSkinSetupObject", 1)
		HK_PATCH_MEMBER_ADDED("useDualQuaternionMethod", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hclSkinOperatorBoneInfluence", 1, "hclSkinOperatorBoneInfluence", 2)
		HK_PATCH_MEMBER_RENAMED("boneIndex", "old_boneIndex")
		HK_PATCH_MEMBER_ADDED("boneIndex", TYPE_BYTE, HK_NULL, 0)
		HK_PATCH_FUNCTION(hclSkinOperatorBoneInfluence_1_to_2)
		HK_PATCH_MEMBER_REMOVED("old_boneIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
