/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_SOUND_SOURCE_INC_H
#define HK_SOUND_SOURCE_INC_H

class hksSource : public hkReferencedObject
{
public:

	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	hksSource(bool global);

	virtual bool attachBuffer( class hksBuffer* buf, bool isLoop=true, float startOffsetInSeconds = 0.f, float loopStartOffsetInSeconds = 0.f  ) = 0;
	virtual bool detachBuffers() = 0;	

	virtual void getAttachedBuffers( hkArray<hksBuffer*>& b ) = 0;

	enum PlayState
	{
		HKS_ERROR,
		HKS_ERROR_NOBUFFER,
		HKS_STOPPED,
		HKS_PLAYING,
		HKS_PAUSED
	};

	enum PlayMode
	{
		HKS_PLAY_ONCE,
		HKS_PLAY_LOOP
	};

	// The world space position of the sound
	virtual void setPosition( const hkVector4& p ) = 0;
	virtual const hkVector4& getPosition() const;
	
	// The velocity of the sound source
	virtual void setVelocity( const hkVector4& v ) = 0;
	virtual const hkVector4& getVelocity() const;
	
	// The pitch of the sound source (0=stopped, 1=normal speed, ...)
	virtual void setPitch( hkReal pitch) = 0;
	virtual hkReal getPitch() const;
	
	// The volume of the sound source
	virtual void setVolume( hkReal volume) = 0;
	virtual hkReal getVolume() const;
	
	// The the inner radius of the sound source
	virtual void setInnerRadius( hkReal radius) = 0;
	virtual hkReal getInnerRadius() const;
	
	// The distance curve scale
	virtual void setDistanceScale(hkReal scale) = 0;
	virtual hkReal getDistanceScale() const;
	
	// The velocity curve scale (affect doppler)
	virtual void setVelocityScale(hkReal scale)=0;
	virtual hkReal getVelocityScale() const;
	
	// Returns true if the voice is not localized in space
	virtual hkBool isGlobal();

	virtual void start(PlayMode mode = HKS_PLAY_LOOP) = 0;
	virtual void pause() = 0;
	virtual void endLoop() = 0; // will stop playback at end of current loop
	virtual void stop() = 0; // will stop playback now
	virtual int  loopCount() const=0;

	virtual PlayState getState() const = 0;

protected:

	hkVector4 m_position;
	hkVector4 m_velocity;
	hkReal m_volume;
	hkReal m_pitch;
	hkReal m_innerRadius;
	hkReal m_distanceScale;
	hkReal m_velocityScale;
	hkBool m_global;
	hkBool m_once;
	
};


#endif // HK_SOUND_BUFFER_INC_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
