/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_OGLES2_PRECOMPILE_H
#define HK_GRAPHICS_OGLES2_PRECOMPILE_H

#include <Graphics/Common/hkGraphics.h> // the source header for the hkg precompiles

#if defined(WIN32)
#	ifndef _WINDOWS_
#	define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#	undef _WIN32_WINNT 
#	define _WIN32_WINNT 0x0500	  // xp/2000
#	undef _WIN32_WINDOWS  
#	define _WIN32_WINDOWS 0x0500 // xp/2000
#	if (_MSC_VER >= 1400)
#		define _CRT_SECURE_NO_DEPRECATE 1
#		define _CRT_NONSTDC_NO_DEPRECATE 1
#	endif
#	include <windows.h>
#	endif
#	include <GL/gl.h>
#	include <GL/glext.h>
#elif defined(HK_PLATFORM_X64)
#	define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
//#	define _WIN32_WINNT 0x0500	  // xp/2000
#	define _WIN32_WINDOWS 0x0500 // xp/2000
#	include <windows.h>
#	include <GL/gl.h>
#	include <GL/glext.h>
#elif defined(HK_PLATFORM_MAC386) || defined(HK_PLATFORM_MACPPC) 
#	include <OpenGL/gl.h>
#	include <OpenGL/glext.h>
#elif defined(HK_PLATFORM_MACARM)
//#   include <OpenGLES/EAGL.h>
#	include <OpenGLES/ES2/gl.h>
#	include <OpenGLES/ES2/glext.h>
#else
#	include <GL/gl.h>
#	include <GL/glext.h>
#endif

#ifdef GL_RGB8
#define HKG_DEFAULT_TEXTURE_RGB GL_RGB8
#else //if defined(GL_RGB) // iphones etc
#define HKG_DEFAULT_TEXTURE_RGB GL_RGB
#endif

#ifdef GL_RGBA8
#define HKG_DEFAULT_TEXTURE_RGBA GL_RGBA8
#else //if defined(GL_RGBA4) //could use GL_RGBA8_OES 
#define HKG_DEFAULT_TEXTURE_RGBA GL_RGBA
#endif

#include <Graphics/OglES2/Shared/hkgFunctionPtrsOGLES2.h>

#endif //HK_GRAPHICS_OGLES2_PRECOMPILE_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
