/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_CUBEMAP_TEXTURE_OGLES2__H
#define HK_GRAPHICS_CUBEMAP_TEXTURE_OGLES2__H

#include <Graphics/Common/Texture/hkgCubemapTexture.h>
#include <Graphics/OglES2/Shared/DisplayContext/hkgDisplayContextOGLES2.h>

class hkgCubemapTextureOGLES2: public hkgCubemapTexture
{
public:

	static hkgCubemapTexture* createCubemapTextureOGLES2(hkgDisplayContext* context)
	{
		return new hkgCubemapTextureOGLES2(context);
	}	

		// assumes filename will inlcude a %s to replace with
		// posx, negx, etc
	virtual bool loadFromFile(const char* filename, void * hinstance = HK_NULL); 
	virtual bool realize(bool dynamic = false, HKG_TEXTURE_USAGE_HINT useHint = HKG_TEXTURE_USAGE_UNKOWN );	
	virtual void free();		

	virtual HKG_TEXTURE_PIXEL_FORMAT getPixelFormat() const;

	virtual unsigned char* lock(int mipLevel = 0, bool willWriteAllPixels = false); 
	virtual void unlock(int mipLevel = 0); 

protected:
	
	virtual void bind(int stage, HKG_TEXTURE_MODE mode) const;		
	virtual void unbind(int stage) const;		

	GLuint mp_glID;

	unsigned char* m_faceData[6];

	inline hkgCubemapTextureOGLES2(hkgDisplayContext* context);
	virtual ~hkgCubemapTextureOGLES2();
};

#include <Graphics/OglES2/Shared/Texture/hkgCubemapTextureOGLES2.inl>

#endif // HK_GRAPHICS_CUBEMAP_TEXTURE_OGLES2__H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
