/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#ifndef HK_GRAPHICS_SHADER_OGLES2__H
#define HK_GRAPHICS_SHADER_OGLES2__H

#include <Graphics/Common/Shader/hkgShader.h>

class hkgShaderOGLES2 : public hkgShader
{
public:

	virtual const char* getDefaultFileNameExtension() { return ".glsl"; }

	GLuint getShaderID() const { return m_shader; }

protected:

	hkgShaderOGLES2(HKG_SHADER_TYPE t);
	virtual ~hkgShaderOGLES2();

	bool compile(hkIstream& s, const char* filename, const char* entryPoint, const char* includes, int numDefines, const ShaderDefine* defines);

	virtual bool bind() { return false; /* effect takes care off it since no concept of individual stage binds */ }	
	virtual bool unbind() { return false; }	
	virtual void free();	
	virtual void setWKNFloatInputIndex( int i, const float* v, int numV ) {}
	virtual void setFloatInputByName( const char* n, const float* v, int numV ) {}

	void loadIncludedFiles( const char* pFile, const char* pFileName, const char* includePath, extArray< extStringPtr >& storage );
	
	GLuint m_shader;
};

#endif //HK_GRAPHICS_SHADER_OGLES2__H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
