/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HKG_INSTANCED_DISPLAY_OBJECT_OGL__H
#define HKG_INSTANCED_DISPLAY_OBJECT_OGL__H

#include <Graphics/Common/DisplayObject/hkgInstancedDisplayObject.h>

#define HKG_INSTANCED_DISPLAY_OGL_TRANSFORM_ATTRIB 9  // attribute for transform data (9 = texcoord1)

class hkgInstancedDisplayObjectOGL : public hkgInstancedDisplayObject
{
	public:

		HKG_DECLARE_CLASS_ALLOCATOR();

		static hkgInstancedDisplayObject* HK_CALL createInstancedDisplayObjectOGL( hkgDisplayContext* ctx );

		hkgInstancedDisplayObjectOGL( );

		virtual ~hkgInstancedDisplayObjectOGL();

			/// special render call to make use of hardware instancing support if any
		virtual void render( hkgDisplayContext* context ) const;

			/// special picking support
		virtual int intersect( const hkgRay& ray, bool ignoreBackfaces, hkgDisplayObjectPickData& data) const;

			/// set the total number of instanced objects, must be called BEFORE cloning or rendering ( finalises the VBO )
			/// No need to call if you are going to use replace buffers anyway
		virtual void setMaxNumObjects( int numObjects, bool allocateBuffers = true );

			/// adds a shallow copy (shares hkgGeometry down) with the same transform and same flags to m_displayObjects
		virtual hkgDisplayObject* clone( float* transform = HK_NULL );

		virtual void setRenderMode(HKG_INSTANCED_DISPLAY_MODE mode);

    	void enableInstancedArrays(bool on);
		bool getEnableInstancedArrays() const;

		virtual void setTransform( const float* transform, int objectIdx );

		virtual const float* getTransform( int objectIdx ) const;

			// For Readback rendering:
		void setTransformRowPointer(int r, float* tp) { m_transformRowPtr[r] = tp; }
		float* getTransformRowPointer(int r) const { return m_transformRowPtr[r]; }
	
		void setElementTypeAndSize( unsigned int type, unsigned int elementSize); 
		inline void setTransformBuffer(int r, unsigned int vb, unsigned int offset) { m_gpuVB[r] = vb; m_gpuVBOffset[r] = offset; }

protected:


		bool m_enableInstancedArrays;
		float* m_transformRowPtr[3];
		extArray<float> m_cpuTransforms;

		unsigned int m_elementType;
		unsigned int m_elementSize;

		unsigned int m_gpuVB[3];
        unsigned int m_gpuVBOffset[3];
};

#endif // HKG_INSTANCED_DISPLAY_OBJECT_OGL__H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
