/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_VERTEX_SET_DX9_H
#define HK_GRAPHICS_VERTEX_SET_DX9_H

#include <Graphics/Common/Geometry/VertexSet/hkgVertexSet.h>

class hkgVertexSetDX9 : public hkgVertexSet
{
public:

	static hkgVertexSet* createVertexSetDX9( hkgDisplayContext* context)
	{
		return new hkgVertexSetDX9( context);
	}	

	virtual ~hkgVertexSetDX9();

	virtual void setNumVerts(int nv, HKG_VERTEX_FORMAT format, HKG_VERTEX_BUFFER_ACCESS accessFlags = HKG_VERTEX_BUFFER_ACCESS_DEFAULT);

	virtual unsigned char* lock(HKG_LOCK_FLAG f);  
	virtual void unlock();

		/// Set the client pointers / stream pointers to this data. Passed the current 
		/// enabled streams so that it can match what it needs.
	virtual void setStreams(); 
	virtual void clearStreams(); 

	inline bool isBufferInHardware() const;

	LPDIRECT3DVERTEXBUFFER9 getVertexBuffer() const { return m_pVB; }

	void invalidateVB();
	void restoreVB();

protected:

	hkgVertexSetDX9(hkgDisplayContext* context);

	LPDIRECT3DVERTEXBUFFER9			m_pVB;		// interleaved vertex buffer

	LPDIRECT3DVERTEXDECLARATION9	m_pVertexDeclaration;      // Vertex declaration for shaders
	LPDIRECT3DVERTEXDECLARATION9	m_pInstancedVertexDeclaration;      // Vertex declaration for shaders

	int m_maxHardwareBlendMatrices;
	bool m_hardwareVB;

	unsigned char* m_localBuffer;
};

#include <Graphics/Dx9/Shared/Geometry/VertexSet/hkgVertexSetDX9.inl>

#endif //HK_GRAPHICS_VERTEX_SET_DX9_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
