/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_VERTEX_SET_DX10_H
#define HK_GRAPHICS_VERTEX_SET_DX10_H

#include <Graphics/Common/Geometry/VertexSet/hkgVertexSet.h>

class hkgVertexSetDX10 : public hkgVertexSet
{
public:

	static hkgVertexSet* createVertexSetDX10(hkgDisplayContext* context)
	{
		return new hkgVertexSetDX10(context);
	}	

	virtual ~hkgVertexSetDX10();

	virtual void advanceToFrame(int frameId);

	virtual void setDesiredVertexComponentFormat( HKG_VERTEX_COMPONENT component, HKG_VERTEX_STORAGE s);
	virtual void setNumVerts(int nv, HKG_VERTEX_FORMAT format, HKG_VERTEX_BUFFER_ACCESS accessFlags = HKG_VERTEX_BUFFER_ACCESS_DEFAULT);

	virtual unsigned char* lock(HKG_LOCK_FLAG f);  
	virtual unsigned char* partialLock(HKG_LOCK_FLAG f, HKG_VERTEX_FORMAT vertexFormatPartsToLock);
	virtual void unlock();

	virtual int getVertexComponentStream( HKG_VERTEX_COMPONENT component ) const;
	virtual int getVertexComponentStreamOffset( HKG_VERTEX_COMPONENT component ) const;

		/// Set the client pointers / stream pointers to this data. Passed the current 
		/// enabled streams so that it can match what it needs.
	virtual void setStreams(); 

protected:

	hkgVertexSetDX10(hkgDisplayContext* context);

	void computeLocalOffsets();

	ID3D10Buffer*						m_pnVertexBuffer[2];		// interleaved vertex buffer
	ID3D10Buffer*						m_tbVertexBuffer;		// interleaved vertex buffer
	ID3D10Buffer*						m_cuvVertexBuffer;		// interleaved vertex buffer
	int m_pnStride;
	int m_tbStride;
	int m_cuvStride;
	bool m_lockedPN;
	int m_lockedPNIndex;
	bool m_lockedTB;
	bool m_lockedCUV;

	bool m_mappedPN;
	bool m_mappedTB;
	bool m_mappedCUV;

	extArray<D3D10_INPUT_ELEMENT_DESC>	m_vertexDescArray;		// Vertex declaration for shaders
	extArray<D3D10_INPUT_ELEMENT_DESC>	m_vertexInstancedDescArray; 
	extArray<D3D10_INPUT_ELEMENT_DESC>	m_vertexVelocityDescArray; 
	class hkgDisplayContextDX10*		m_context;
	
	HKG_VERTEX_STORAGE					m_desiredStorageFormats[HKG_VERTEX_COMPONENT_NUM]; // the format of each vert component

	extArray<unsigned char>				m_localPN;
	extArray<unsigned char>				m_localTB;
	extArray<unsigned char>				m_localCUV;

	int m_currentFrameId;
	int m_currentPosVbIndex;
	int m_maxHardwareBlendMatrices;
};

#include <Graphics/Dx10/Shared/Geometry/VertexSet/hkgVertexSetDX10.inl>

#endif //HK_GRAPHICS_VERTEX_SET_DX10_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
