/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_BLEND_MATRIX_SET_DX10
#define HK_GRAPHICS_BLEND_MATRIX_SET_DX10

#include <Graphics/Common/Geometry/BlendMatrixSet/hkgBlendMatrixSet.h>

/// A class to represent a group of matrices used for blending
class hkgBlendMatrixSetDX10 : public hkgBlendMatrixSet
{
public:
	
	static hkgBlendMatrixSet* createBlendMatrixSetDX10(hkgDisplayContext* context)
	{
		return new hkgBlendMatrixSetDX10(context);
	}	

	virtual void advanceToFrame(int frameId);

	virtual int getNumMatrices() const { return getCurrentMatrices().getSize(); }

	virtual void addMatrix(const float* m, int referenceID);

	virtual void setMatrix(int i, const float* m);
	virtual void setMatrixAligned( int i, const hkTransform& mat);

	virtual const float* getMatrix(int i) const { return (const float*)&(getCurrentMatrices()[i]); }

	virtual bool bind();	

	virtual void clear() { m_matricesA.setSize(0); m_matricesB.setSize(0); m_referenceIDs.setSize(0); }

	
	struct BlendMatrix
	{
		HK_ALIGN16(float m[16]);
	};


	inline const extArray<BlendMatrix>& getCurrentMatrices() const { return m_currentMatrixStack? m_matricesB : m_matricesA; }
	inline extArray<BlendMatrix>& getCurrentMatrices() { return m_currentMatrixStack? m_matricesB : m_matricesA; }
	inline extArray<BlendMatrix>& getPrevMatrices() { return m_currentMatrixStack? m_matricesA : m_matricesB; }
	
protected:

	hkgBlendMatrixSetDX10(hkgDisplayContext* context);

	hkgDisplayContext* m_context;
	extArray<BlendMatrix> m_matricesA;
	extArray<BlendMatrix> m_matricesB;

	int m_currentMatrixStack;
	int m_currentFrameId;

	int m_maxPlatformMatrices;

};

#endif // HK_GRAPHICS_BLEND_MATRIX_SET_DX10

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
