/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_SHADER_LIB_H
#define HK_GRAPHICS_SHADER_LIB_H

class hkgDisplayContext;
class hkgShader;
class hkgShaderEffectCollection;

#include <Graphics/Common/Texture/hkgTexture.h>
#include <Graphics/Common/Shader/hkgShaderLibDefines.h>

// The shader files used by this lib have comments near the top in the form:   
 ///:STYLE <vertexentryname> <pixelentryname> L<type><maxnum> T<numtcoords> {SHADOWMAP,DIFFUSEn,REFLECTION,BUMPn,NORMALn,DISPLACEMENTn,SPECULARn,SPECULARANDGLOSSn,OPACITYn,EMISSIVEn,REFRACTION,GLOSSn} {INSTANCED,SKINNED}
// where the texture type is ordered as per enum in hkxMaterial so agreeded final stage slot between hkx and hkg
// and where 'n' is the tcoord channel that will be used for that tex type so we can match exactly
// and where light type is D for Directional, O for Omni, S for Spot, and maxnum is the max num lights used (assumes used numLights constant to render with less).
// When you have a hkxMaterial (self describing) or demo material you would like a shader for
// on the current platform, then you can request one from this lib
// It will cache shaders and resuse etc as requested.
class hkgShaderLib : public hkgReferencedObject
{
	public: 
		hkgShaderLib( hkgDisplayContext* ctx );

		virtual ~hkgShaderLib( );

			// Add a search path to find the shaders (.hlsl and .cg files)
			// eg  ./resources/shaders
		void addSearchPath( const char* path );
		void clearSearchPaths();

		// force next search to not use precompiled shaders
		void clearCache();

		// usually we auyto load normal and instanced shaders
		// use this method to toggle
		void setAutoLoadShaderTypes( bool instanced, bool skinned );
		void getAutoLoadShaderTypes( bool& instanced, bool& skinned );

		// Set to -1 to just use current platform default (say 64)
		// It will not allow it to exceed platform max (64 in SM2/SM3, 1024 in SM4 etc)
		void setMaxBlendMatrices(int m);
		int getMaxBlendMatrices() const;
		
		struct TextureStage
		{
			HKG_TEXTURE_TYPE_HINT m_type; // Diffuse, Normal, etc
			int m_textureCoord; // Texcoord channel used
		};

			/// Get a shader collection for the given material
			/// Will normal give back at least 3 sets (2 for shadow map passes, and 1 for no shadows) 
			/// Will return NULL if none found that match
			/// Pass 0 for numLights for unlit shaders
		hkgShaderEffectCollection* findShader( const extArray<TextureStage>& sourceMaterialStages, HKG_SHADERLIB_OBJECT_FLAGS objectFlags = HKG_SHADERLIB_OBJECT_NO_FLAGS, 
			HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints = HKG_SHADERLIB_EXTRA_TEXTURE_HINT_NONE, int numLights = 1, const char* debugName = HK_NULL /*for error reporting only*/, int numTCoordsHint = -1);

		hkgShaderEffectCollection* findShader( HKG_SHADERLIB_WELLKNOWN_TYPE t, HKG_SHADERLIB_OBJECT_FLAGS objectFlags = HKG_SHADERLIB_OBJECT_NO_FLAGS, 
			HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints = HKG_SHADERLIB_EXTRA_TEXTURE_HINT_NONE, int numLights = 1);

	public:

		class ShaderMatcher
		{
		public:
			virtual ~ShaderMatcher() {}

			virtual bool styleMatch( const char* shaderFileStyle, HKG_SHADERLIB_OBJECT_FLAGS objectFlags, HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints, int numLights, int numTCoordsHint ) const = 0;
		};

	protected:

		hkgShaderEffectCollection* findShaderMatch( const ShaderMatcher& matchFunc, HKG_SHADERLIB_OBJECT_FLAGS objectFlags, HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints, int numLights, int numTCoordsHint );

		void createDepthShaders();
		void createVelocityShaders();

		hkgDisplayContext* m_context;

		extArray< extStringPtr > m_searchPaths;
		extArray< struct ShaderCacheInfo* > m_shaderCache; // shader pairs already created

		bool m_autoLoadInstanced;
		bool m_autoLoadSkinned;
		int m_maxBlendMatrices;

		bool	   m_lookedForDepthShaders;
		hkgShader* m_toDepthVShader;
		hkgShader* m_toDepthVShaderInstanced;
		hkgShader* m_toDepthVShaderSkinned;
		hkgShader* m_toDepthPShader;
		hkgShader* m_toDepthPShaderAlphaDiscard;

		bool	   m_lookedForVelShaders;
		hkgShader* m_toVelocityVShader;
		hkgShader* m_toVelocityVShaderDynamicVB;
		hkgShader* m_toVelocityVShaderInstanced;
		hkgShader* m_toVelocityVShaderSkinned;
		hkgShader* m_toVelocityPShader;
};

#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
