/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

hkgShaderEffectCollection::hkgShaderEffectCollection() 
{

}

inline hkgShaderEffectCollection* hkgShaderEffectCollection::defaultCreateInternal()
{
	return new hkgShaderEffectCollection();
}


inline void hkgShaderEffectCollection::addShaderEffect( hkgShader* vshader, hkgShader* pshader, hkgShader* gshader, const char* name )
{
	hkgShaderEffect* ss = hkgShaderEffect::create();
	ss->setShaders( vshader, gshader, pshader );
	ss->setName(name);
	addShaderEffect( ss );
	ss->removeReference();
}

inline void hkgShaderEffectCollection::addShaderEffect( hkgShader* vshader, hkgShader* pshader, hkgShader* gshader, hkgShader* hshader, hkgShader* dshader, const char* name )
{
	hkgShaderEffect* ss = hkgShaderEffect::create();
	ss->setShaders( vshader, hshader, dshader, gshader, pshader );
	ss->setName(name);
	addShaderEffect( ss );
	ss->removeReference();
}

inline void hkgShaderEffectCollection::addShaderEffect( hkgShaderEffect* e )
{
	m_shaders.pushBack(e);
	e->addReference();
}


inline void hkgShaderEffectCollection::removeShaderEffect( int i )
{
	m_shaders[i]->removeReference();
	m_shaders.removeAtAndCopy(i);
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
