/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_SHADER_COLLECTION
#define HK_GRAPHICS_SHADER_COLLECTION

#include <Graphics/Common/Shader/hkgShader.h>
#include <Graphics/Common/Shader/hkgShaderEffect.h>



// A collection of shader effects, so sets with / without lighting, with/without shadows, etc as appropriate
class hkgShaderEffectCollection : public hkgReferencedObject
{
public:

	static hkgShaderEffectCollection* (HK_CALL* create)();

	/// Default create function, use ::create instead.
	inline static hkgShaderEffectCollection* defaultCreateInternal();

	inline void addShaderEffect( hkgShaderEffect* e );
	inline void addShaderEffect( hkgShader* vshader, hkgShader* pshader, hkgShader* gshader = HK_NULL, const char* name = HK_NULL);
	inline void addShaderEffect( hkgShader* vshader, hkgShader* pshader, hkgShader* gshader, hkgShader* hshader, hkgShader* dshader, const char* name = HK_NULL);

		/// Given a context and the current held set of shaders, return the best fit.
	hkgShaderEffect* matchStyle( hkgDisplayContext* context, HKG_MATERIAL_VERTEX_HINT hints );
	hkgShaderEffect* findEffectByStyle( HKG_SHADER_RENDER_STYLE s );
	
	void merge( const hkgShaderEffectCollection* other );
	bool supportsMaterialHint( HKG_MATERIAL_VERTEX_HINT hints ) const;

	int getNumShaderEffects() const;
	hkgShaderEffect* getShaderEffect(int i);
	const hkgShaderEffect* getShaderEffect(int i) const;
	inline void removeShaderEffect( int i );

protected:

	inline hkgShaderEffectCollection();
	virtual ~hkgShaderEffectCollection();

	extArray< hkgShaderEffect* > m_shaders;
	extArray< hkgMaterial* > m_warnedShaders;
};

#include <Graphics/Common/Shader/hkgShaderEffectCollection.inl>

#endif //HK_GRAPHICS_SHADER_COLLECTION

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
