/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_SHADER_DEFINES__H
#define HK_GRAPHICS_SHADER_DEFINES__H

// two types of shaders, pixel and vertex, although the input data
// in terms of the graphics engine constants is the same for both
typedef unsigned short HKG_SHADER_TYPE;
#define HKG_NULL_SHADER 0
#define HKG_VERTEX_SHADER 1
#define HKG_PIXEL_SHADER  2
#define HKG_GEOMETRY_SHADER 3	 //DX10 
#define HKG_HULL_SHADER     4	 //DX11 (Vert->[Hull->[Tess FF]->Domain]->Geom->Pixel)
#define HKG_DOMAIN_SHADER   5	 //DX11
#define HKG_NUM_SHADER_TYPES (HKG_DOMAIN_SHADER+1)

typedef unsigned short HKG_SHADER_PARAM_TYPE;
#define HKG_SINGLE_SHADER  1 // A hkgShader
#define HKG_EFFECT_SHADER  2 // A hkgShaderEffect

typedef unsigned int HKG_SHADER_TYPE_BITS;
#define HKG_NULL_SHADER_BIT	1
#define HKG_VERTEX_SHADER_BIT	2
#define HKG_PIXEL_SHADER_BIT	4
#define HKG_GEOMETRY_SHADER_BIT	8	 
#define HKG_HULL_SHADER_BIT		16	 
#define HKG_DOMAIN_SHADER_BIT	32
#define HKG_COMPUTE_SHADER_BIT	64	

// semantics for inputs (imply sizes)
typedef unsigned int HKG_SHADER_MAT_INPUT_CONSTANT;
#define HKG_SHADER_MAT_INPUT_NONE					0
#define HKG_SHADER_MAT_INPUT_VIEW					(1<<0)
#define HKG_SHADER_MAT_INPUT_VIEW_INV				(1<<1)
#define HKG_SHADER_MAT_INPUT_VIEW_INV_TRANSPOSE		(1<<2)

#define HKG_SHADER_MAT_INPUT_PROJ					(1<<3)
#define HKG_SHADER_MAT_INPUT_PROJ_INV				(1<<4)
#define HKG_SHADER_MAT_INPUT_PROJ_INV_TRANSPOSE		(1<<5)

#define HKG_SHADER_MAT_INPUT_WV						(1<<6) // WORLD * VIEW
#define HKG_SHADER_MAT_INPUT_WV_INV					(1<<7)
#define HKG_SHADER_MAT_INPUT_WV_INV_TRANSPOSE		(1<<8)

#define HKG_SHADER_MAT_INPUT_VP						(1<<9) // VIEW * PROJ (hkgCamera 'camera' matrix)
#define HKG_SHADER_MAT_INPUT_PREV_VP				(1<<10) 
#define HKG_SHADER_MAT_INPUT_VP_INV					(1<<11)
#define HKG_SHADER_MAT_INPUT_VP_INV_TRANSPOSE		(1<<12)

#define HKG_SHADER_MAT_INPUT_WVP					(1<<13) // WORLD * VIEW * PROJ 
#define HKG_SHADER_MAT_INPUT_WVP_INV				(1<<14) 
#define HKG_SHADER_MAT_INPUT_WVP_INV_TRANSPOSE		(1<<15) 

#define HKG_SHADER_MAT_INPUT_WORLD					(1<<16)
#define HKG_SHADER_MAT_INPUT_PREV_WORLD				(1<<17)
#define HKG_SHADER_MAT_INPUT_WORLD_INV				(1<<18) 
#define HKG_SHADER_MAT_INPUT_WORLD_INV_TRANSPOSE	(1<<19)

#define HKG_SHADER_MAT_INPUT_VIEW_TO_LIGHTPROJ		(1<<20) // for shadow map projection (includes texture coord offsets)
#define HKG_SHADER_MAT_INPUT_VIEW_TO_LIGHTPROJ1		(1<<21) // for shadow map projection (includes texture coord offsets)
#define HKG_SHADER_MAT_INPUT_VIEW_TO_LIGHTPROJ2		(1<<22) // for shadow map projection (includes texture coord offsets)
#define HKG_SHADER_MAT_INPUT_VIEW_TO_LIGHTPROJ3		(1<<23) // for shadow map projection (includes texture coord offsets)
#define HKG_SHADER_MAT_INPUT_4x4					(1<<24) // generic 4x4 matrix. Use setWKNFloatInputIndex with known index to set.
#define HKG_SHADER_MAT_INPUT_3x4					(1<<25) // generic 3x4 matrix. Use setWKNFloatInputIndex with known index to set.


typedef unsigned int HKG_SHADER_INPUT_CONSTANT;

#define HKG_SHADER_INPUT_NONE					0
#define HKG_SHADER_INPUT_VECTOR					(1<<0) // generic vector. Use setWKNFloatInputIndex with known index to set.

#define HKG_SHADER_INPUT_AMBIENT_COLOR			(1<<1) // ambient (material + scene) color
#define HKG_SHADER_INPUT_DIFFUSE_COLOR			(1<<2) // diffuse material color
#define HKG_SHADER_INPUT_SPECULAR_COLOR			(1<<3) // specular material color
#define HKG_SHADER_INPUT_SPECULAR_POWER			(1<<4) // specular power exponent for material 

#define HKG_SHADER_INPUT_SHADOWMAP_SIZE			(1<<5) // dimensions of the current shadow map (for no hw based shadow bilerp)
#define HKG_SHADER_INPUT_SHADOWMAP_DISTANCE     (1<<6) // dimensions of the current shadow map (for no hw based shadow bilerp)
#define HKG_SHADER_INPUT_SHADOWMAP_VSM_BIAS     (1<<7)
#define HKG_SHADER_INPUT_SHADOWMAP_VSM_EPSILON  (1<<8)
#define HKG_SHADER_INPUT_SHADOWMAP_PSVSM_SPLIT_DISTANCES (1<<9)

#define HKG_SHADER_INPUT_LIGHT_POS				(1<<10) // assumes that light pos or dir, if seen indicates a new light.
#define HKG_SHADER_INPUT_LIGHT_DIR				(1<<11) 
#define HKG_SHADER_INPUT_LIGHT_DIR_VIEWSPACE    (1<<12) 
#define HKG_SHADER_INPUT_LIGHT_COLOR			(1<<13) // assumes spec == diffuse color
#define HKG_SHADER_INPUT_LIGHT_RIMCOLOR			(1<<14)
#define HKG_SHADER_INPUT_LIGHT_SPOT_PARAMS	 	(1<<15) // spotlight params ( outer angle (>0 if is a spot light, 0 for not spot), inner angle, ( want falloff exponent? )
#define HKG_SHADER_INPUT_LIGHT_SHADOW_START_WORLD (1<<16)
#define HKG_SHADER_INPUT_LIGHT_SHADOW_START_VIEW  (1<<17)
#define HKG_SHADER_INPUT_LIGHT_POS_VIEWSPACE	 (1<<18)

#define HKG_SHADER_INPUT_NUM_LIGHTS				(1<<19) // the current active num lights

#define HKG_SHADER_INPUT_FOG_COLOR				(1<<20) 
#define HKG_SHADER_INPUT_FOG_PARAMS             (1<<21) //.x == 0 == none, 1 = linear, 2 == exp, 3 == exp2  : .y = near : .z = far : .w = density
#define HKG_SHADER_INPUT_DEPTH_PARAMS           (1<<22) //.x == linear depth scale (0 or 1 normally)

#define HKG_SHADER_INPUT_VERT_PARAMS            (1<<23) //.x == normalIntStorageSize (8 == 8bit, so DX will need a rescale, 16 == shorts, so OGL will need a rescale)

#define HKG_SHADER_CAMERA_MASK					(0x0000FFFF) // first 16 bits
#define HKG_SHADER_WVP_MASK					    (0x000FFFFF) // first 20 bits
#define HKG_SHADER_MATRIX_MASK					(0x000FFFFF | HKG_SHADER_INPUT_MAT_4x4 | HKG_SHADER_INPUT_MAT_3x4)  // first 20 bits or generic matrix

#define HKG_SHADER_INPUT_MATERIAL_MASK			(HKG_SHADER_INPUT_AMBIENT_COLOR | HKG_SHADER_INPUT_DIFFUSE_COLOR | HKG_SHADER_INPUT_SPECULAR_COLOR | HKG_SHADER_INPUT_SPECULAR_POWER) 

typedef unsigned int HKG_SHADER_RENDER_STYLE;
#define HKG_SHADER_RENDER_NOSTYLE 0
#define HKG_SHADER_RENDER_1LIGHTS 1
#define HKG_SHADER_RENDER_2LIGHTS 2
#define HKG_SHADER_RENDER_3LIGHTS 3
#define HKG_SHADER_RENDER_4LIGHTS 4
#define HKG_SHADER_RENDER_5LIGHTS 5
#define HKG_SHADER_RENDER_6LIGHTS 6
#define HKG_SHADER_RENDER_7LIGHTS 7
#define HKG_SHADER_RENDER_LIGHT_MASK (0x07)

#define HKG_SHADER_RENDER_MODULATE_TEXTURE0  (1<<4)
#define HKG_SHADER_RENDER_MODULATE_TEXTURE1  (1<<5)
#define HKG_SHADER_RENDER_MODULATE_TEXTURE2  (1<<6)
#define HKG_SHADER_RENDER_MODULATE_TEXTURE3  (1<<7)
#define HKG_SHADER_RENDER_DECAL_TEXTURE0	 (1<<8)
#define HKG_SHADER_RENDER_DECAL_TEXTURE1	 (1<<9)
#define HKG_SHADER_RENDER_DECAL_TEXTURE2	 (1<<10)
#define HKG_SHADER_RENDER_DECAL_TEXTURE3	 (1<<11)
#define HKG_SHADER_RENDER_TEXTURE_MASK		 (0x0FF<<4)

#define HKG_SHADER_RENDER_VERTEX_COLOR      (1<<12) // per vertex color source supported
#define HKG_SHADER_RENDER_BLENDING          (1<<13) // per vertex weights and indices supported
#define HKG_SHADER_RENDER_TANGENTS          (1<<14) // per vertex tangent and binormal supported
#define HKG_SHADER_RENDER_INSTANCING_USING_TCOORDS (1<<15) // per vertex world transform (instancing) supported
#define HKG_SHADER_RENDER_DYNAMICVB          (1<<16) // knows the vb is dynamic 
#define HKG_SHADER_RENDER_MATERIAL_HINT_MASK (0x01f << 12) // all the above 5 flags
#define HKG_SHADER_RENDER_MATERIAL_HINT_MASK_IGNORE_DVB (0x00f << 12) // all the above 4 main shader flags (as dynamics vb not always an issue)

#define HKG_SHADER_RENDER_TO_DEPTHMAP			(1<<17) // can do first pass of shadow map render
#define HKG_SHADER_RENDER_TO_DEPTHMAP_VSM		(1<<18) // can do first pass of shadow map render, stores variance aswell as a normalized depth
#define HKG_SHADER_RENDER_BASED_ON_DEPTHMAP		(1<<19) // assumes it has to do PCF (precentage closer filtering) itself and r/q
#define HKG_SHADER_RENDER_BASED_ON_DEPTHMAP_HW	(1<<20) // assumes it h/w will do r/q etc for it and the p.c.f.
#define HKG_SHADER_RENDER_BASED_ON_DEPTHMAP_VSM	(1<<21) // assumes it has a two component texture, meant for Variance Shadow Maps
#define HKG_SHADER_RENDER_TO_VELOCITYMAP		(1<<22) // can do velocity render pass 
#define HKG_SHADER_RENDER_SKYBOX				(1<<23) // assumes this shader will be used on skyboxes: one tex, no light, no shadow

#endif // HK_GRAPHICS_SHADER_DEFINES__H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
