/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_VERTEX_SET_DEFINES__H
#define HK_GRAPHICS_VERTEX_SET_DEFINES__H

typedef hkUint16 HKG_VERTEX_COMPONENT;
#define HKG_VERTEX_COMPONENT_POS					 0
#define HKG_VERTEX_COMPONENT_NORMAL					 1
#define HKG_VERTEX_COMPONENT_TANGENT				 2
#define HKG_VERTEX_COMPONENT_BITANGENT				 3 
#define HKG_VERTEX_COMPONENT_TEX0					 4
#define HKG_VERTEX_COMPONENT_TEX1					 5
#define HKG_VERTEX_COMPONENT_TEX2					 6
#define HKG_VERTEX_COMPONENT_TEX3					 7
#define HKG_VERTEX_COMPONENT_TEX4					 8
#define HKG_VERTEX_COMPONENT_TEX5					 9
#define HKG_VERTEX_COMPONENT_COLOR					10
#define HKG_VERTEX_COMPONENT_BLENDWEIGHTS			11
#define HKG_VERTEX_COMPONENT_BLENDINDICES			12
#define HKG_VERTEX_COMPONENT_INSTANCED_USER_DATA	13
#define HKG_VERTEX_COMPONENT_NUM					14

#define HKG_VERTEX_COMPONENT_MAX_TCOORDS			6

typedef hkUint16 HKG_VERTEX_FORMAT;
#define HKG_VERTEX_FORMAT_NONE	   	      0    // Error state really
#define HKG_VERTEX_FORMAT_POS		      (1<<HKG_VERTEX_COMPONENT_POS)						// has pos
#define HKG_VERTEX_FORMAT_NORMAL	      (1<<HKG_VERTEX_COMPONENT_NORMAL)					// has normal
#define HKG_VERTEX_FORMAT_TANGENT		  (1<<HKG_VERTEX_COMPONENT_TANGENT)					// has tangent
#define HKG_VERTEX_FORMAT_BITANGENT		  (1<<HKG_VERTEX_COMPONENT_BITANGENT)				// has bitangent (aka binormal)
#define HKG_VERTEX_FORMAT_TEX0            (1<<HKG_VERTEX_COMPONENT_TEX0)					// has tex coords for stage 0
#define HKG_VERTEX_FORMAT_TEX1            (1<<HKG_VERTEX_COMPONENT_TEX1)					// has tex coords for stage 1
#define HKG_VERTEX_FORMAT_TEX2            (1<<HKG_VERTEX_COMPONENT_TEX2)					// has tex coords for stage 2
#define HKG_VERTEX_FORMAT_TEX3            (1<<HKG_VERTEX_COMPONENT_TEX3)					// has tex coords for stage 3
#define HKG_VERTEX_FORMAT_TEX4            (1<<HKG_VERTEX_COMPONENT_TEX4)					// has tex coords for stage 4
#define HKG_VERTEX_FORMAT_TEX5            (1<<HKG_VERTEX_COMPONENT_TEX5)					// has tex coords for stage 5
#define HKG_VERTEX_FORMAT_COLOR           (1<<HKG_VERTEX_COMPONENT_COLOR)					// has color
#define HKG_VERTEX_FORMAT_BLENDWEIGHTS    (1<<HKG_VERTEX_COMPONENT_BLENDWEIGHTS)			// has bone/blend weights
#define HKG_VERTEX_FORMAT_BLENDINDICES    (1<<HKG_VERTEX_COMPONENT_BLENDINDICES)			// has blend indices (to world blend matrices)

#define HKG_VERTEX_FORMAT_INSTANCED_USER_DATA (1<<HKG_VERTEX_COMPONENT_INSTANCED_USER_DATA)	// additional per-instance data

typedef hkUint8 HKG_LOCK_FLAG;
#define HKG_LOCK_NONE  0  
#define HKG_LOCK_READWRITE  1
#define HKG_LOCK_DEFAULT    1
#define HKG_LOCK_READONLY     2 // will only read elements
#define HKG_LOCK_WRITEONLY    4 // will only write (some) elements
#define HKG_LOCK_WRITEDISCARD 8 // will write to all elements, so no need for previous vert state to be fetched etc

#define HKG_LOCK_READMASK (HKG_LOCK_READWRITE | HKG_LOCK_READONLY)
#define HKG_LOCK_WRITEMASK (HKG_LOCK_WRITEDISCARD | HKG_LOCK_WRITEONLY | HKG_LOCK_READWRITE)

typedef hkUint8 HKG_VERTEX_BUFFER_ACCESS; 
#define HKG_VERTEX_BUFFER_ACCESS_UNKNOWN  0
#define HKG_VERTEX_BUFFER_ACCESS_DYNAMIC  1
#define HKG_VERTEX_BUFFER_ACCESS_WRITE	  2
#define HKG_VERTEX_BUFFER_ACCESS_READ	  4
#define HKG_VERTEX_BUFFER_ACCESS_SUPPORT_VELOCITYMAP 8

#define HKG_VERTEX_BUFFER_ACCESS_DEFAULT ( HKG_VERTEX_BUFFER_ACCESS_WRITE | HKG_VERTEX_BUFFER_ACCESS_READ )
#define HKG_VERTEX_BUFFER_ACCESS_DYNAMIC_WRITEONLY ( HKG_VERTEX_BUFFER_ACCESS_WRITE | HKG_VERTEX_BUFFER_ACCESS_DYNAMIC )
#define HKG_VERTEX_BUFFER_ACCESS_DYNAMIC_READWRITE ( HKG_VERTEX_BUFFER_ACCESS_READ | HKG_VERTEX_BUFFER_ACCESS_WRITE | HKG_VERTEX_BUFFER_ACCESS_DYNAMIC )

typedef hkUint8 HKG_VERTEX_STORAGE;
// Common formats
#define HKG_VERTEX_STORAGE_NONE    0  
#define HKG_VERTEX_STORAGE_4UBC    1  // 4 unsigned bytes, unpacked to (0..1), unpacked as per d3d color ((ARGB) expanded to (R, G, B, A))
#define HKG_VERTEX_STORAGE_4UBN    2  // 4 unsigned bytes, normalized, unpacked to (0..1), but not swizzled
#define HKG_VERTEX_STORAGE_4BN     3  // 4 unsigned bytes, normalized, unpacked to (0..1), but assumed to be in range (-1,1) in shader code (so shaders must (*2 - 1) on it)
#define HKG_VERTEX_STORAGE_4UB     4  // 4 unsigned bytes, no normalization
#define HKG_VERTEX_STORAGE_1F      5  // 1 float  
#define HKG_VERTEX_STORAGE_2F      6  // 2 floats (common for UV coords, for Tex0-3)
#define HKG_VERTEX_STORAGE_3F      7  // 3 floats (Normals or Pos), and weights
#define HKG_VERTEX_STORAGE_4F      8  // Color in float form
#define HKG_VERTEX_STORAGE_8UB     9  // 8 unsigned bytes for blending weights on PSP
// More advanced, 2 bytes per component
#define HKG_VERTEX_STORAGE_2S     10  // 2 signed shorts, usually expanded in shaders to (v[0],v[1],0,1)
#define HKG_VERTEX_STORAGE_4S     11  // 4 signed shorts
// Normalized 2 bytes
#define HKG_VERTEX_STORAGE_2SN    12  // 2 signed shorts, normalized, so usually expanded in shaders to (v[0]/32767.0,v[1]/32767.0,0,1)
#define HKG_VERTEX_STORAGE_4SN    13  // 4 signed shorts, normalized, so usually expanded in shaders to (v[0]/32767.0,v[1]/32767.0,v[2]/32767.0,v[3]/32767.0)
#define HKG_VERTEX_STORAGE_2USN   14  // 2 unsigned shorts, normalized, so usually expanded in shaders to (v[0]/65535.0,v[1]/65535.0,0,1)
#define HKG_VERTEX_STORAGE_4USN   15  // 4 unsigned shorts, normalized, so usually expanded in shaders to (v[0]/65535.0,v[1]/65535.0,v[2]/65535.0,v[3]/65535.0)
#define HKG_VERTEX_STORAGE_2F16   16  // Two 16-bit floating point values, expanded to (v[0], v[1], 0, 1)
#define HKG_VERTEX_STORAGE_4F16   17  // Four float 16 values
#define HKG_VERTEX_STORAGE_NUM   (HKG_VERTEX_STORAGE_4F16 + 1)

#define HK_VERTEX_DEFAULT_INSTANCING_TCOORD_OFFSET 5 //5,6,7 
#define HK_VERTEX_DEFAULT_TANGENTS_TCOORD_OFFSET   3 //3,4
#define HK_VERTEX_DEFAULT_TEXTURE_TCOORD_OFFSET   0 //0,1,2 (TEX3 will start to interfere with tangents (push them up on tcoord) etc.)
#define HK_VERTEX_DEFAULT_WEIGHTS_TCOORD_OFFSET   5 //5,6 for weights and indices (can share with instances as don't instance skins (at the mo anyway, and prob doesn't make sense unless they are all in the same pose anyway)

typedef hkUint8 HKG_VERTEX_STORAGE_LAYOUT;
#define HKG_VERTEX_STORAGE_LAYOUT_UNKNOWN 0 
#define HKG_VERTEX_STORAGE_LAYOUT_INTERLEAVED 1  /* a struct with all info, so position for a vert is followed by the other info for the vert (Array of Structs) */
#define HKG_VERTEX_STORAGE_LAYOUT_PARTIAL_INTERLEAVED 2 /* a set of structs, with commonly accessed information grouped together into buffers. For instance Pos and Normal in one buffer as skinned together normally, with Color and Texture coords in a second buffer. */
#define HKG_VERTEX_STORAGE_LAYOUT_DEINTERLEAVED 3 /* a separate buffer for each component. This can be faster to access on some platforms such as PS3, but can be bad for cache performance per vert on some platforms */
#define HKG_VERTEX_STORAGE_LAYOUT_DEFAULT (HKG_VERTEX_STORAGE_LAYOUT_PARTIAL_INTERLEAVED) 


#endif //HK_GRAPHICS_VERTEX_SET_DEFINES__H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
