/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

inline hkgFaceSetPrimitive::hkgFaceSetPrimitive( HKG_FACE_RENDER_TYPE t )
: m_type(t), m_indexSize(HKG_INDICES_NONE), m_ownIndices(true), m_indices(HK_NULL), m_vertBufStartIndex(0), m_len(0), m_blendMatrices(HK_NULL)
{
}



inline hkgFaceSetPrimitive::~hkgFaceSetPrimitive()
{
	setLength(0, false, HKG_INDICES_NONE);

	if (m_blendMatrices)
		m_blendMatrices->release();
}

inline int hkgFaceSetPrimitive::getLength() const
{
	return m_len;
}

inline HKG_FACE_RENDER_TYPE hkgFaceSetPrimitive::getType() const
{
	return m_type;
}

inline HKG_FACE_INDEX_SIZE hkgFaceSetPrimitive::getIndexSize() const
{
	return m_indexSize;
}

inline void hkgFaceSetPrimitive::setVertexBufferStartIndex( int n )
{
	m_vertBufStartIndex = n;
}

inline int hkgFaceSetPrimitive::getVertexBufferStartIndex() const
{
	return m_vertBufStartIndex;
}

inline const hkUint16* hkgFaceSetPrimitive::getIndices16() const 
{ 
	if (m_indexSize != HKG_INDICES_UINT32)
		return (const hkUint16*)m_indices; 
	else 
		return HK_NULL;
}

inline hkUint16*	hkgFaceSetPrimitive::getIndices16() 
{
	if (m_indexSize != HKG_INDICES_UINT32)
		return (hkUint16*)m_indices; 
	else 
		return HK_NULL;
}


inline const hkUint32* hkgFaceSetPrimitive::getIndices32() const 
{ 
	if (m_indexSize != HKG_INDICES_UINT16)
		return (const hkUint32*)m_indices; 
	else
		return HK_NULL;
}

inline hkUint32*	hkgFaceSetPrimitive::getIndices32() 
{
	if (m_indexSize != HKG_INDICES_UINT16)
		return (hkUint32*)m_indices; 
	else 
		return HK_NULL;
}

inline bool hkgFaceSetPrimitive::hasIndices() const
{
	return m_indices != HK_NULL;
}

inline void hkgFaceSetPrimitive::setIndices16(hkUint16* conn, int len, bool takeOwnerShip)
{
	if (m_indices)
		setLength(0, false, HKG_INDICES_NONE);

	m_ownIndices = takeOwnerShip;
	m_indexSize = conn? HKG_INDICES_UINT16 : HKG_INDICES_NONE;
	m_len = len;
	m_indices = conn;
}


inline void hkgFaceSetPrimitive::setIndices32(hkUint32* conn, int len, bool takeOwnerShip)
{
	if (m_indices)
		setLength(0, false, HKG_INDICES_NONE);

	m_ownIndices = takeOwnerShip;
	m_indexSize = conn? HKG_INDICES_UINT32 : HKG_INDICES_NONE;
	m_len = len;
	m_indices = conn;
}

inline bool hkgFaceSetPrimitive::hasData() const
{
	return (m_len > 0);
}

inline hkgBlendMatrixSet* hkgFaceSetPrimitive::getBlendMatrices() const
{	
	return m_blendMatrices;
}

inline void hkgFaceSetPrimitive::setBlendMatrices(hkgBlendMatrixSet* bm)
{
	if (bm)
		bm->reference();
	if (m_blendMatrices)
		m_blendMatrices->release();
	m_blendMatrices = bm;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
