/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Graphics/Common/hkGraphics.h> // precompiled


/***************************************************************************/
/*                                                                         */
/*  ftspic.c                                                               */
/*                                                                         */
/*    The FreeType position independent code services for smooth module.   */
/*                                                                         */
/*  Copyright 2009 by                                                      */
/*  Oran Agra and Mickey Gabel.                                            */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/


#include <Graphics/Common/Font/FreeType/ft2build.h>
#include FT_FREETYPE_H
#include FT_INTERNAL_OBJECTS_H
#include "ftspic.h"

#ifdef FT_CONFIG_OPTION_PIC

  /* forward declaration of PIC init functions from ftgrays.c */
  void FT_Init_Class_ft_grays_raster(FT_Raster_Funcs*);

  void
  ft_smooth_renderer_class_pic_free(  FT_Library library )
  {
    FT_PIC_Container* pic_container = &library->pic_container;
    FT_Memory memory = library->memory;
    if ( pic_container->smooth )
    {
      SmoothPIC* container = (SmoothPIC*)pic_container->smooth;
      if(--container->ref_count)
        return;
      FT_FREE( container );
      pic_container->smooth = NULL;
    }
  }


  FT_Error
  ft_smooth_renderer_class_pic_init(  FT_Library library )
  {
    FT_PIC_Container* pic_container = &library->pic_container;
    FT_Error        error = FT_Err_Ok;
    SmoothPIC* container;
    FT_Memory memory = library->memory;

    /* since this function also serve smooth_lcd and smooth_lcdv renderers, 
       it implements reference counting */
    if(pic_container->smooth)
    {
      ((SmoothPIC*)pic_container->smooth)->ref_count++;
      return error;
    }

    /* allocate pointer, clear and set global container pointer */
    if ( FT_ALLOC ( container, sizeof ( *container ) ) )
      return error;
    FT_MEM_SET( container, 0, sizeof(*container) );
    pic_container->smooth = container;
    container->ref_count = 1;

    /* initialize pointer table - this is how the module usually expects this data */
    FT_Init_Class_ft_grays_raster(&container->ft_grays_raster);
/*Exit:*/
    if(error)
      ft_smooth_renderer_class_pic_free(library);
    return error;
  }

  /* re-route these init and free functions to the above functions */
  FT_Error ft_smooth_lcd_renderer_class_pic_init(FT_Library library)
  {
    return ft_smooth_renderer_class_pic_init(library);
  }
  void ft_smooth_lcd_renderer_class_pic_free(FT_Library library)
  {
    ft_smooth_renderer_class_pic_free(library);
  }
  FT_Error ft_smooth_lcdv_renderer_class_pic_init(FT_Library library)
  {
    return ft_smooth_renderer_class_pic_init(library);
  }
  void ft_smooth_lcdv_renderer_class_pic_free(FT_Library library)
  {
    ft_smooth_renderer_class_pic_free(library);
  }

#endif /* FT_CONFIG_OPTION_PIC */


/* END */

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
