/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

inline void hkgDisplayObject::setStatusFlags( HKG_DISPLAY_OBJECT_STATUS f)
{
	m_status = f;
}

inline HKG_DISPLAY_OBJECT_STATUS hkgDisplayObject::getStatusFlags() const
{
	return m_status;
}

inline void hkgDisplayObject::setTransform( const float* t )
{
	HK_ASSERT(0x4367ceee,  t != HK_NULL );
	hkgMat4Copy( m_trans, t );
}

inline void hkgDisplayObject::setTransformAligned( const hkTransform& t )
{
	hkgMat4CleanBottomRow( (float*)(&t) );
	hkString::memCpy16<64>(m_trans, &t);
}

inline const float*	hkgDisplayObject::getTransform() const
{
	return m_trans;
}

inline void hkgDisplayObject::setPrevTransformExplicit( const float* t )
{
	HK_ASSERT(0x4367ceee,  t != HK_NULL );
	hkgMat4Copy( m_prevTrans, t );
}

inline const float*	hkgDisplayObject::getPrevTransform() const
{
	return m_prevTrans;
}

inline void hkgDisplayObject::addGeometry(hkgGeometry* g)
{
	g->reference();

	HKG_GEOMETRY_TRANSPARENCY t = g->getTransparencyType();
	m_geomTransp |= t;

	switch (t)
	{
		case HKG_GEOMETRY_TRANS_OPAQUE:
			m_solidGeoms.pushBack(g);
			break;
		case HKG_GEOMETRY_TRANS_TRANSPARENT:
			m_alphaGeoms.pushBack(g);
			break;
		default : // mixed or unknown
			m_mixedGeoms.pushBack(g);
			break;
	}

	onGeometryChange();
}

inline int hkgDisplayObject::getNumGeometry() const
{
	return ( m_solidGeoms.getSize() + m_alphaGeoms.getSize() + m_mixedGeoms.getSize() );
}

inline hkgGeometry* hkgDisplayObject::getGeometry(int i)
{
	HK_ASSERT(0x1b9d35f7,  i >= 0 && i < getNumGeometry());
	int ss = m_solidGeoms.getSize();
	if (i < ss)
		return m_solidGeoms[i];
	else if ( i < (ss + m_alphaGeoms.getSize()) )
		return m_alphaGeoms[i-ss];
	else if ( i < (ss + m_alphaGeoms.getSize() + m_mixedGeoms.getSize()) )
		return m_mixedGeoms[i-(ss+m_alphaGeoms.getSize())];
	else
		return HK_NULL;
}

inline const hkgGeometry* hkgDisplayObject::getGeometry(int i) const
{
	return const_cast<hkgDisplayObject*>(this)->getGeometry(i);
}

inline extArray<hkgGeometry*>* hkgDisplayObject::remapIndex( int& index ) const
{
	HK_ASSERT(0x1290b865,  index < getNumGeometry() );

	int ss = m_solidGeoms.getSize();
	extArray<hkgGeometry*>* ga = HK_NULL;

	if (index < ss)
	{
		ga = const_cast<extArray<hkgGeometry*>*>( &m_solidGeoms );
	}
	else if ( index < (ss + m_alphaGeoms.getSize()) )
	{
		index -= ss;
		ga = const_cast<extArray<hkgGeometry*>*>( &m_alphaGeoms );
	}
	else
	{
		index -= (ss - m_alphaGeoms.getSize());
		ga = const_cast<extArray<hkgGeometry*>*>( &m_mixedGeoms );
	}

	return ga;
}

inline hkgGeometry* hkgDisplayObject::removeGeometry(int i, bool preserveOrder)
{
	int index = i;
	extArray<hkgGeometry*>* ga = remapIndex( index );

	hkgGeometry* g = (*ga)[index];
	if (preserveOrder)
		ga->removeAtAndCopy(index);
	else
		ga->removeAt(index);

	if (ga->getSize() == 0)
		computeTransparency();

	onGeometryChange();

	return g;
}

inline void hkgDisplayObject::setGeometry(int i, hkgGeometry* g)
{
	g->reference();
	
	int index = i;
	extArray<hkgGeometry*>* ga = remapIndex( index );

	hkgGeometry* oldGeom = (*ga)[index];
	oldGeom->release();

	if (g != oldGeom)
	{
		onGeometryChange();
	}

	(*ga)[index] = g;
}

inline hkgGeometry* hkgDisplayObject::searchAndRemoveByName( extArray<hkgGeometry*>* geomArray, const char* name, bool preserveOrder)
{
	int s = geomArray->getSize();
	int i = 0;

	while(i < s)
	{
		if ( hkString::strCmp(name, (*geomArray)[i]->getName()) == 0 )
		{
			hkgGeometry* g = (*geomArray)[i];

			if (preserveOrder)
				geomArray->removeAtAndCopy(i);
			else
				geomArray->removeAt(i);

			if (geomArray->getSize() == 0)
				computeTransparency();

			onGeometryChange();

			return g;
		}
	}
	return HK_NULL;
}

inline hkgGeometry* hkgDisplayObject::removeGeometry(const char* name, bool preserveOrder)
{
	hkgGeometry* g = searchAndRemoveByName( &m_solidGeoms, name, preserveOrder );
	if (g)
		return g;

	g = searchAndRemoveByName( &m_alphaGeoms, name, preserveOrder );
	if (g)
		return g;

	g = searchAndRemoveByName( &m_mixedGeoms, name, preserveOrder );
	return g;
}


inline void hkgDisplayObject::setName( const char* s)
{
	m_name = s; // copy
}

inline const char* hkgDisplayObject::getName() const
{
	return m_name.cString();
}

inline HKG_GEOMETRY_TRANSPARENCY hkgDisplayObject::getTransparencyType() const
{
	return m_geomTransp;
}

inline bool hkgDisplayObject::hasAABB() const
{
	return m_computedRadius > 0;
}

inline bool hkgDisplayObject::boundsVisibleInFrustum( const hkgCamera* camera )
{
	float wc[3];
	hkgVec3Transform( wc, m_aabbCent, m_trans);
	return (m_computedRadius < 0.001f) || ( camera->sphereVisible( wc, m_computedRadius ));
}

const float* hkgDisplayObject::getAABBCentPtr() const
{
	return m_aabbCent;
}

const float* hkgDisplayObject::getAABBExtPtr() const
{
	return m_aabbExtent;
}

inline void hkgDisplayObject::setDrawLocalFrame( bool on )
{
	m_drawLocalFrame = on;
}

inline bool hkgDisplayObject::getDrawLocalFrame() const
{
	return m_drawLocalFrame;
}


inline hkgDisplayObject::hkgDisplayObject()
: m_forceNoZRead(false),
  m_forceNoZWrite(false),
  m_forceWireframe(false),
  m_forceDrawBothSides(false),
  m_geomTransp( HKG_GEOMETRY_TRANS_UNKNOWN ), 
  m_computedRadius(-1),
  m_status( HKG_DISPLAY_OBJECT_DYNAMIC ),
  m_userPtrType(USER_POINTER_UNKNOWN),
  m_userPtr(HK_NULL),
  m_currentFrameId(-1),
  m_renderCallback(HK_NULL)
{
	m_drawLocalFrame = false;
	m_drawAABB = false;

	hkgVec3Set( m_aabbCent, 0,0,0);
	hkgVec3Set( m_aabbExtent, 1,1,1);

	hkgMat4Identity( m_trans );
	hkgMat4Identity( m_prevTrans );
}

inline hkgDisplayObject* hkgDisplayObject::defaultCreateInternal()
{
	return new hkgDisplayObject();
}

inline void hkgDisplayObject::setSpecialState( bool forceNoZRead, bool forceNoZWrite,	bool forceWireframe, bool forceBothSides)
{
	m_forceNoZRead = forceNoZRead;   
	m_forceNoZWrite = forceNoZWrite;  
	m_forceWireframe = forceWireframe; 
	m_forceDrawBothSides = forceBothSides;
}

inline void hkgDisplayObject::getSpecialState( bool& forceNoZRead, bool& forceNoZWrite, bool& forceWireframe, bool& forceBothSides) const
{
	forceNoZRead = m_forceNoZRead;   
	forceNoZWrite = m_forceNoZWrite;  
	forceWireframe = m_forceWireframe; 
	forceBothSides = m_forceDrawBothSides;
}

inline void hkgDisplayObject::setUserPointer(int type, void* d)
{
	m_userPtrType = type;
	m_userPtr = d;
}

inline void* hkgDisplayObject::getUserPointer() const
{
	return m_userPtr;
}

inline int hkgDisplayObject::getUserPointerType() const
{
	return m_userPtrType;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
