/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_GRAPHICS_BRIDGE_ASSET_CONV_H
#define HK_GRAPHICS_BRIDGE_ASSET_CONV_H

#include <Common/SceneData/Material/hkxMaterial.h>
#include <Graphics/Common/Geometry/VertexSet/hkgVertexSetDefines.h>

class hkgMaterial;
class hkgShaderLib;
class hkgVertexSet;

class hkgVertexCreateCallbackInterface
{
	//+hk.MemoryTracker(ignore=True)
public:

	// Can return null if doesn't care / leave to default create
	virtual hkgVertexSet* createNewVertexSet( HKG_VERTEX_FORMAT desiredFormat, int numVerts, bool dynamic, const char* nodeName ) const = 0;

	virtual ~hkgVertexCreateCallbackInterface() {}
};

/// A collection of asset conversion utilities
class hkgAssetConverter
{
	public:

		enum ConvertMask
		{
			CONVERT_ALL = 0,
			NO_MESHES = 1,
			NO_LIGHTS = 1<<1,
			NO_MATERIALS = 1<<2,
			NO_TEXTURES = 1<<3,
			NO_CAMERAS = 1<<4,
			NO_SHADOW_CAST = 1<<5,
			NO_VERTEX_COLORS = 1<<6,
			FORCE_VERTEX_COLORS = 1<<7,
			FORCE_DYNAMIC_VBS = 1<<8,
			FORCE_DIFFUSE_MAT_ONLY = 1<<9,
			FORCE_WHITE_DIFFUSE_COLOR = 1<<10,
			FORCE_BLACK_SPECULAR_COLOR = 1<<11,
			PACKED_NORMALS = 1<<12, // Store normals (N, T, B) as bytes rather than floats
			COMPUTED_BINORMAL = 1<<13, 
			SUPPORT_PERPIXEL_VELOCITY = 1<<14, // Make dynamic vbs support per pixel motion blur (they need to store two vbs for pos etc) 
			OPTIMIZE_FOR_VERTEX_CACHE = 1<<15, // Tipsify the indices so they reuse cached vertices better
			ALPHATEST_SHADOWS = 1<<16, // Make any created materials set the textures dutrint shadow gen so that they can be used to alpha clip shadows
			FORCE_ALL_SHADOWCASTERS = 1<<17, // Make any created materials set the textures dutrint shadow gen so that they can be used to alpha clip shadows
			DISABLE_TANGENT_CHECK = 1<<18, // Normally if a material has < 2 textures, buti has tangents, the tangents will be ignored so that the proper shader will be chosen 

			// For the shader lib, so it can pick the correct # lights
			// 1 and 2 lights are default / normal, so only 0 or > 2 are required normally as hints 
			HINT_0RENDERLIGHT = 1<<19,
			HINT_1RENDERLIGHT = 1<<20,
			HINT_2RENDERLIGHTS = 1<<21,
			HINT_3RENDERLIGHTS = 1<<22,
			HINT_4RENDERLIGHTS = 1<<23
		};

		struct Mapping
		{
			HKG_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( Mapping );

			Mapping() : m_origObject(HK_NULL), m_hkgObject(HK_NULL) { }
			const void* m_origObject; //The original object from the toolchain e.g. hkxCamera
			hkgReferencedObject* m_hkgObject; //The runtime graphics object we build e.g. hkgCamera
		};

		struct NodeMapping
		{
			HKG_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( Mapping);

			NodeMapping() : m_origNode(HK_NULL), m_hkgObject(HK_NULL) { }
			const class hkxNode* m_origNode; //The original node from the toolchain
			hkgReferencedObject* m_hkgObject; //The runtime graphics object we build e.g. hkgCamera
		};

		struct SkinPaletteMap
		{
			HKG_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( SkinPaletteMap);

			SkinPaletteMap() : m_skin(HK_NULL) { }
			class hkgDisplayObject* m_skin;
			extArray< class hkgBlendMatrixSet* > m_palettes;
		};

		struct IndexMapping
		{
			extArray<hkInt16> m_mapping;
		};

		struct MaterialCache
		{
			HKG_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( MaterialCache);

			MaterialCache() : m_supportsShaders(false), m_removeDriveLetterFromPath(true) { resetSearchOrder(); }
			~MaterialCache();
			bool m_supportsShaders;
			bool m_removeDriveLetterFromPath;
			extArray<Mapping> m_materials;	
			extArray<Mapping> m_textures;
			extArray<const char*> m_searchPaths;
			extArray<const char*> m_searchOrder;

			inline void clearSearchOrder()
			{
				m_searchOrder.setSize(0);
			}

			inline void resetSearchOrder()
			{
				m_searchOrder.pushBack(HK_NULL); // orig name, then look for others
				m_searchOrder.pushBack("DDS");
				m_searchOrder.pushBack("png"); 
				m_searchOrder.pushBack("PNG");
			}
		};

		enum MaterialVariants
		{
			MAT_NORMAL,
			MAT_SKIN,
			MAT_INSTANCE
		};

		struct MeshConvertInput
		{
			HKG_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( MeshConvertInput);

			MeshConvertInput() : m_enableLighting(true), m_allowMaterialSharing(true), m_allowTextureSharing(true), m_allowTextureMipmaps(true),
								   m_allowTextureCompression(false), m_allowTextureAnisotropicFilter(false), m_invertNormalMapGreenChannel(false), 
								   m_allowHardwareSkinning(true), m_collapseMaterial(false), m_allowPseudoInstancing(false), m_allowPseudoInstancingHardwareAccel(false), m_convMask(CONVERT_ALL), 
								   m_context(HK_NULL), m_world(HK_NULL), m_vertexCreationCallback(HK_NULL), m_materialCache(HK_NULL), m_meshCache(HK_NULL), m_nodeCache(HK_NULL), m_skinVertexBufferCache(HK_NULL), m_shaderLib(HK_NULL), m_name(HK_NULL)
			{
				m_worldTransform.setIdentity();
			}
			hkBool m_enableLighting;
			hkBool m_allowMaterialSharing; // share hkgMaterial ptrs
			hkBool m_allowTextureSharing;  // share hkgTexture ptrs
			hkBool m_allowTextureMipmaps;
			hkBool m_allowTextureCompression;
			hkBool m_allowTextureAnisotropicFilter;
			hkBool m_invertNormalMapGreenChannel;
			hkBool m_allowHardwareSkinning;
			hkBool m_forceVertexColors;
			hkBool m_collapseMaterial;
			hkBool m_allowPseudoInstancing; 
			hkBool m_allowPseudoInstancingHardwareAccel; 
			ConvertMask m_convMask;

			class hkgDisplayContext* m_context; 
			class hkgDisplayWorld* m_world; // for pseudo instances, we may need to replace already added objects 
			class hkgVertexCreateCallbackInterface* m_vertexCreationCallback; // may be null

			MaterialCache*			m_materialCache;			///< non optional material cache
			extArray<Mapping>*		m_meshCache;				///< optional mesh cache (not really that optional in effect, depending on the options u choose above)
			extArray<NodeMapping>*	m_nodeCache;				///< optional node cache, in case instancing replaces some object ptrs
			extArray<Mapping>*		m_skinVertexBufferCache;	///< optional skinVertexBufferCache

			hkMatrix4 m_worldTransform;

			hkgShaderLib* m_shaderLib; // may be null
			const char* m_name;
		};

		struct MeshConvertOutput
		{
			MeshConvertOutput(){ m_materialIndicesToClean = HK_NULL; }
			hkBool m_wasSkin;
			extArray<hkgMaterial*>* m_materialIndicesToClean;
		};

		/// materialIndicesToClean - an array of material pointers that need to be cleaned up.
		/// The caller of this function is responsible for cleaning the materials up, if necessary
		static class hkgDisplayObject* HK_CALL convertMesh( const class hkxMesh* mesh, const MeshConvertInput& input, MeshConvertOutput& output );

		static int HK_CALL convertMaterial( const class hkxMaterial* material, hkgDisplayContext* context, MaterialCache& materialCache,
											hkBool allowMatSharing, hkBool allowTexSharing, hkBool doMipmaps, hkBool doCompression, hkBool doAniso, 
											hkBool invertNormalMaps, hkBool diffuseOnly, hkBool forceWhiteDiffuse, hkBool forceBlackSpecular,
											hkgShaderLib* shaderLib, int forNumLights, MaterialVariants matVariant, ConvertMask convMask, hkBool collapseMaterial );

		static int HK_CALL convertTexture(  const class hkxTextureInplace* texture, hkgDisplayContext* context, hkxMaterial::TextureType tHint, 
											MaterialCache& materialCache, hkBool allowTexSharing, hkBool doMipmaps, hkBool doCompression, hkBool doAniso, hkBool invertNormalMaps   );

		static int HK_CALL convertTexture(  const class hkxTextureFile* texture, hkgDisplayContext* context, hkxMaterial::TextureType tHint,
											MaterialCache& materialCache, hkBool allowTexSharing, hkBool doMipmaps, hkBool doCompression, hkBool doAniso, hkBool invertNormalMaps   );

		static class hkgLight* HK_CALL convertLight( const class hkxLight* l, class hkgLightManager* manager );

		static class hkgCamera* HK_CALL convertCamera( const class hkxCamera* camera, const char* name );

		static SkinPaletteMap* HK_CALL setupHardwareSkin( hkgDisplayContext* context, hkgDisplayObject* dispObj, 
								IndexMapping* mappings, hkInt32 numMappings, 
								hkInt16 fullPaletteSize, hkBool allowCulling);

		static void HK_CALL updateSkin( hkgDisplayObject* dispObj, 
			const hkArrayBase< hkTransform >& matrixPalletes, const hkArrayBase< hkgBlendMatrixSet* >& graphicsPalettes, 
			const hkTransform& skinTransform, const class hkAabb* pLocalAabb = HK_NULL);

		
		// Search for the index of an object to retreive the display object.
		static int HK_CALL findFirstMapping( const extArray<Mapping>& inList, const void* original);
		static int HK_CALL findFirstMapping( const extArray<SkinPaletteMap*>& inList, const void* original);

		static void HK_CALL findAllMappings( const extArray<Mapping>& inList, const void* original, extArray<int>& mappedEntries);
		static void HK_CALL findAllMappings( const extArray<SkinPaletteMap*>& inList, const void* original, extArray<int>& mappedEntries);

			// A dscription of the vertex format for our graphics library
		static class hkxVertexDescription* HK_CALL constructVertexDesc(class hkgVertexSet* v);
};

#endif // HK_GRAPHICS_BRIDGE_ASSET_CONV_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
