/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#ifndef HKG_MESH_TEXTURE_H
#define HKG_MESH_TEXTURE_H

#include <Common/GeometryUtilities/Mesh/hkMeshTexture.h>

	/// Havoks texture wrapper around hkg Graphics
class hkgMeshTexture: public hkMeshTexture
{
	public:
			/// Constructor that creates a new hkgTexture using context.  Textures created with this 
			/// constructor are write only.
		hkgMeshTexture(hkgDisplayContext* context);
			/// Constructor that wraps an existing hkgTexture.  Textures created with this constructor
			/// are read only.
		hkgMeshTexture(const hkgTexture* texture);

			/// Destructor.  Releases the hkgTexture if it was loaded.
		~hkgMeshTexture();

			/// Not implemented, returns HK_NULL, 0 and unknown respectively
		virtual void getData(unsigned char*& data, int& size, Format& format);
			/// Sets the data of the internal hkgTexture
		virtual void setData(unsigned char* data, int size, Format format);
		
			// hkMeshTexture implementation
		virtual const char* getFilename() const;
			// hkMeshTexture implementation
		virtual void setFilename( const char* filename );

			// hkMeshTexture implementation
		virtual bool getHasMipMaps() const;
			// hkMeshTexture implementation
		virtual void setHasMipMaps(bool hasMipMaps);
			
			// hkMeshTexture implementation
		virtual FilterMode getFilterMode() const;
			// hkMeshTexture implementation
		virtual void setFilterMode(FilterMode filterMode);
			
			// hkMeshTexture implementation
		virtual TextureUsageType getUsageHint() const;
			// hkMeshTexture implementation
		virtual void setUsageHint( TextureUsageType hint );

			// hkMeshTexture implementation
		virtual hkInt32 getTextureCoordChannel() const;
			// hkMeshTexture implementation
		virtual void setTextureCoordChannel( hkInt32 channelIndex );

			// Is the texture a read only wrapper around a hkgTexture instance.
		bool isReadOnly() const;

			// Gets the wrapped hkgTexture.
		hkgTexture* getTexture() const;

	protected:
			/// Internal hkgTexture
		hkgTexture* m_texture;
			/// Filename of the texture, if specified
		hkStringPtr m_filename;
			/// Flag if the texture can be written to
		hkBool m_isReadOnly;
			/// Usage hint
		hkEnum<hkMeshTexture::TextureUsageType, hkInt8> m_usageHint;
			/// Channel in the vertex buffer
		hkInt32 m_textureCoordChannel;
};
#endif	//HKG_MESH_TEXTURE_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
