/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HKG_MESH_MATERIAL_H
#define HKG_MESH_MATERIAL_H

#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>
#include <Graphics/Common/Shader/hkgShaderLib.h>

extern const hkClass hkgMeshMaterialClass;

class hkgMeshSystem;
class hkgMeshTexture;

	/// Havoks mesh material wrapper around hkg Graphics
class hkgMeshMaterial: public hkMeshMaterial
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);
			/// Ctor
        hkgMeshMaterial(hkgDisplayContext* context, hkgMeshSystem* system, const hkgMaterial* material = HK_NULL);

            /// Dtor
        virtual ~hkgMeshMaterial();

	        // hkMeshMaterial implementation
        virtual hkResult createCompatibleVertexFormat(const hkVertexFormat& format, hkVertexFormat& compatibleFormat);

	        // hkMeshMaterial implementation
        virtual hkMeshVertexBuffer* createCompatibleVertexBuffer(hkMeshVertexBuffer* buffer);

	        // hkMeshMaterial implementation
        virtual bool isCompatible(const hkMeshVertexBuffer* buffer);

			// hkMeshMaterial implementation
		virtual void setName(const char* name);
			// hkMeshMaterial implementation
		virtual const char* getName() const;

            // hkMeshMaterial implementation
		virtual int getNumTextures() const;
			// hkMeshMaterial implementation
		virtual hkMeshTexture* getTexture(int index) const;
			// hkMeshMaterial implementation
		virtual void addTexture(hkMeshTexture* texture);

            // hkReferencedObject Implementation
        virtual const hkClass* getClassType() const { return &hkgMeshMaterialClass; }
            // hkReferencedObject Implementation
        virtual void calcContentStatistics( hkStatisticsCollector* collector,const hkClass* cls ) const;

            /// Set a material
        void setMaterial(hkgMaterial* material);

			/// Get the texture stages used, as expected by the shader lib
		void getTextureStages( extArray<hkgShaderLib::TextureStage>& textureStages ) const;
		
	public:
		    //
		    //	Members
		    //
        const hkgMaterial*			m_material;             ///< the hkgMaterial
        hkgDisplayContext*			m_context;				///< The graphics context - needed as has thread lock when releasing
		extArray<hkgMeshTexture*>	m_textures;				///< textures in the material.  these mirror the textures in m_material.
		hkgMeshSystem*				m_system;				///< System that owns the material - used to load textures.
};

#endif // HKG_MESH_MATERIAL_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
