/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
#include <Demos/demos.h>

#	define HK_MAIN_CALL _cdecl

// Function to set up the platform
// The function is called twice:
// once before options have been parsed with null argument
// once after parsing with the parsed options structure.
extern void HK_CALL DemoPlatformInit(hkDemoFrameworkOptions* options);

extern int HK_CALL hkFrameworkMain(hkDemoFrameworkOptions& options, char* startUpGame);

#if defined( HK_ATOM )
extern "C" int __cdecl ADP_Close( void );
#endif


//
// The entry point for our demos
// 
int HK_MAIN_CALL main(int argc, char* argvIn[])
{
	DemoPlatformInit(HK_NULL);

	const char** argv = (const char**)argvIn;

	hkDemoFrameworkOptions options;
	options.parse(argc, argv);
	DemoPlatformInit(&options);

	// Start the demo framework
	int res = frameworkMain(options, "Menu");

#if defined( HK_ATOM )
	ADP_Close();
#endif
	return res;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
