/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertOneLightBumpT1 PixT1Bump LD* T1 NORMAL0 SPECULAR0
//:STYLE VertOneLightBumpShadowProjT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP NORMAL0 SPECULAR0

#pragma include("CommonHeader.glslh")

// Matrices
uniform HIGHP mat4 g_mWorldInv;
uniform HIGHP mat4 g_mWorldView;
uniform HIGHP mat4 g_mProj;	
uniform HIGHP mat4 g_mViewInv;	
 
// Textures, set assignment so that the behaviour is the same no mater what shader is using it 
uniform sampler2D g_sSamplerOne;  
uniform sampler2D g_sSamplerTwo;  
uniform sampler2D g_sSamplerThree;
uniform sampler2D g_sSamplerFour; 

#ifdef ENTRYPOINT_VertOneLightBumpT1
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec3 InNormal;
attribute HIGHP vec3 InTangent;
attribute HIGHP vec3 InBinormal;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
void main()
{
	// copy texture coordinates
    VOutTexCoord0 = InTexCoord0;
	
	// transform position to clip space
	gl_Position = g_mWorldViewProj * InPosition;

	// compute the 3x3 tranform from object space to tangent space
	mat3 objToTangentSpace;
	float bumpHeight = 1.0;
	objToTangentSpace[0] = InTangent.xyz * bumpHeight;
	objToTangentSpace[1] = InBinormal.xyz * bumpHeight;
	objToTangentSpace[2] = InNormal;
	
    vec4 vertexPos = g_mWorld * InPosition; // world space position

	// light vector
	vec3 lightVec =  mat3(g_mWorldInv) * g_vLightDir;  // transform back to object space
	VOutTexCoord2.xyz =  lightVec * objToTangentSpace; // transform from object to tangent space
	
	// eye vector
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 eyeVec = worldEyePos - vertexPos.xyz; // world space eye vector
	eyeVec = mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	eyeVec = normalize(eyeVec);
	
	// half-angle vector
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord3.xyz = H * objToTangentSpace;	// transform to tangent space
}
#endif

// Vertex based lighting (with specular), also projects the position into the shadow map space
#ifdef ENTRYPOINT_VertOneLightBumpShadowProjT1
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec3 InNormal;
attribute HIGHP vec3 InTangent;
attribute HIGHP vec3 InBinormal;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;
void main()
{
    vec4 viewPos =  g_mWorldView * vec4(InPosition.xyz, 1.0);
    gl_Position =  g_mProj * viewPos;
    VOutTexCoord0 = InTexCoord0;
		 
		// project pos into light space
    VOutTexCoord4 =  g_mViewToLightProj * viewPos;
    
    #ifdef HKG_SHADOWS_VSM
            VOutTexCoord5 =  g_mWorld * vec4(InPosition.xyz, 1.0);
    #endif
    
	// compute the 3x3 tranform from object space to tangent space
	mat3 objToTangentSpace;
	float bumpHeight = 1.0;
	objToTangentSpace[0] = InTangent.xyz * bumpHeight;
	objToTangentSpace[1] = InBinormal.xyz * bumpHeight;
	objToTangentSpace[2] = InNormal;
	
    vec4 vertexPos = g_mWorld * InPosition; // world space position

	// light vector
	vec3 lightVec =  mat3(g_mWorldInv) * g_vLightDir;  // transform back to object space
	VOutTexCoord2.xyz =  lightVec * objToTangentSpace; // transform from object to tangent space
	
	// eye vector
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 eyeVec = worldEyePos - vertexPos.xyz; // world space eye vector
	eyeVec = mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	eyeVec = normalize(eyeVec);
	
	// half-angle vector
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord3.xyz = H * objToTangentSpace;	// transform to tangent space
}
#endif


// Pixel Shaders
#ifdef ENTRYPOINT_PixT1Bump
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
void main()
{
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0,0,1); 
	
#if ENABLE_NORMAL_MAP
	N = texture2D(g_sSamplerZero, VOutTexCoord0.xy).xyz*2.0 - 1.0;
	N = normalize(N);
#endif

#if ENABLE_SPEC_MAP
	SpecMap *= texture2D(g_sSamplerOne, VOutTexCoord0.xy).rgb;
#endif

	vec3 L = normalize(VOutTexCoord2.xyz);
	vec3 H = normalize(VOutTexCoord3.xyz);
	float NdotL = dot(N, L);
	float NdotH = dot(N, H);
#if ENABLE_LIGHTING
    float specPower = g_cSpecularPower;
    vec4 light = Phong( NdotL, NdotH, specPower ) * vec4(g_cLightColor.rgb, 1);
#else
	vec4 light = vec4(1,1,1,1);
#endif

	gl_FragColor.rgb = (1-light.rgb)*g_cAmbientColor.rgb*g_cDiffuseColor.rgb + light.rgb*g_cDiffuseColor.rgb + light.www*SpecMap;
	gl_FragColor.a = g_cDiffuseColor.a; // modulate alpha as is, light doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1Bump
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;
void main()
{
    #ifdef HKG_SHADOWS_VSM
		float lightAmount = getLightAmountVSM( VOutTexCoord4, VOutTexCoord5 );
  	#else
		float lightAmount = getLightAmountSM( VOutTexCoord4 ); 
	#endif
		
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0,0,1); 
		
#if ENABLE_NORMAL_MAP
	N = texture2D(g_sSamplerOne, VOutTexCoord0.xy).xyz*2.0 - 1.0;
	N = normalize(N);
#endif

#if ENABLE_SPEC_MAP
	SpecMap *= texture2D(g_sSamplerTwo, VOutTexCoord0.xy).rgb;
#endif

	// interp will not preserve length
	vec3 L = normalize(VOutTexCoord2.xyz);
	vec3 H = normalize(VOutTexCoord3.xyz);
	float NdotL = dot(N, L);
	float NdotH = dot(N, H);
	
#if ENABLE_LIGHTING
	float specPower = g_cSpecularPower;
	vec4 light = lightAmount * Phong(NdotL, NdotH, specPower) * vec4(g_cLightColor.rgb, 1);
#else
	vec4 light = vec4(1,1,1,1);
#endif
	
	gl_FragColor.rgb = (1-light.rgb)*g_cAmbientColor.rgb*g_cDiffuseColor.rgb + light.rgb*g_cDiffuseColor.rgb + light.www*SpecMap;
	gl_FragColor.a = g_cDiffuseColor.a; // modulate alpha as is, shadow doesn't affect it.
}	

#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
