/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
// Used directly by light shaft renders, not a generic shaderlib style

#include "CommonHeader.hlslh"

struct vertexInputShafts
{
	float3 pos : POSITION;
};

struct vertexOutputShafts
{
	float4 pos : POSITION;
	float3 posView	: TEXCOORD0;
	float3 posLight	: TEXCOORD1;
	float4 texNoise0: TEXCOORD2;
	float4 texNoise1: TEXCOORD3;
//	float4 texCookie: TEXCOORD4;
	
};

#ifdef HKG_DX10
cbuffer perLightShaft{
#endif

	float4x4 g_mProj;
	float4x4 g_mWorldView;
	float4x4 g_mViewInv;
	float4x4 g_mWorldLightProjScroll0;
	float4x4 g_mWorldLightProjScroll1;
//	float4x4 g_mWorldLightProjBias;	
	float4x4 g_mShaftWorldToLightProj;
	float4x4 g_mShaftWorldToLight;
	
	float3 g_vLightShaftMinBounds; //camera view space
	float3 g_vLightShaftMaxBounds; //camera view space

	float g_iNumShaftSampleRatio;
	float g_iShaftStrength; // 0.02
	float g_iShaftFalloff; // 5
		
#ifdef HKG_DX10
};
#endif

vertexOutputShafts mainVS( vertexInputShafts In )
{
    vertexOutputShafts Out;
    
    float4 viewPos = float4( (g_vLightShaftMinBounds * In.pos.xyz) + ( g_vLightShaftMaxBounds * (1.0f - In.pos.xyz) ), 1 );
    float4 worldPos = mul( viewPos, g_mViewInv );
	float4 lightSpaceProjPos = mul( worldPos, g_mShaftWorldToLightProj );
	float4 lightSpacePos = mul( worldPos, g_mShaftWorldToLight );
	
	Out.texNoise0 = mul( lightSpaceProjPos, g_mWorldLightProjScroll0 );
	Out.texNoise1 = mul( lightSpaceProjPos, g_mWorldLightProjScroll1 );
   // Out.texCookie = mul( lightSpaceProjPos, g_mWorldLightProjBias );
  
	Out.pos = mul( viewPos, g_mProj);
	Out.posView = viewPos.xyz;
	Out.posLight = lightSpacePos.xyz;
		
	return Out;
}

pixelOutput mainPS( vertexOutputShafts In )
{
	pixelOutput Output;
	
	float3 DV = normalize(g_vLightPosView.xyz - In.posView);
	float cosAngle = dot(DV,g_vLightDirView.xyz);
	float cosOuter = g_cLightSpotParams.z;
	clip( cosAngle - cosOuter ); // early out if cos(angle) < cos(outer)
	
	float shadow = getLightAmountShadow(In.posView);
		
	float cosInner = g_cLightSpotParams.y;
	float cosInnerMinusOuter = cosInner - cosOuter;
	float spot = saturate( (cosAngle - cosOuter) / cosInnerMinusOuter );
		
	float3 n0 = _sample4(In.texNoise0.xy/In.texNoise0.w).rgb;
	float3 n1 = _sample5(In.texNoise1.xy/In.texNoise1.w).rgb;
	 
	Output.color.rgb = 1; //n0 * n1 * shadow * spot;
	float atten = 0.25f + g_iShaftFalloff / dot( In.posLight, In.posLight );
    Output.color.a = ( n1.r * n0.r * g_iShaftStrength * g_iNumShaftSampleRatio) * shadow * spot * atten;
	clip(Output.color.a - 0.001f);
	
    //	if ( g_iFogParams.x > 0)
    //  {
    //	    Output.color = computeFog( In.posView.z, Output.color );
    //  }

	Output.pzDepth.rgba = 0;
    
    return Output; 
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
