/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertOneLightBumpT5 PixT5Bump LD* T5 DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1
//:STYLE VertOneLightBumpT5 PixT5Bump LD* T5 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 DEFINE:SHADOW_LOOKUP

//:STYLE VertOneLightBumpT5 PixT5Bump LD* T5 DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT5 PixT5Bump LD* T5 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 SKINNED DEFINE:HKG_SKINNING DEFINE:SHADOW_LOOKUP

//:STYLE VertOneLightBumpT5 PixT5Bump LD* T5 DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT5 PixT5Bump LD* T5 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:SHADOW_LOOKUP

#pragma include("CommonHeader.glslh")

#define ALPHA_DISCARD_TOLERANCE 1.0/255

// extra textures
uniform sampler2D g_sSamplerOne;  
uniform sampler2D g_sSamplerTwo;  
uniform sampler2D g_sSamplerThree;
uniform sampler2D g_sSamplerFour;

// Matrices
uniform HIGHP mat4 g_mWorldInv;
uniform HIGHP mat4 g_mWorldView;
uniform HIGHP mat4 g_mProj;	
uniform HIGHP mat4 g_mViewInv;	
	
// Vertex Shaders
#ifdef ENTRTPOINT_VertOneLightBumpT5
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec2 InTexCoord1;
attribute HIGHP vec2 InTexCoord2;
attribute HIGHP vec3 InNormal;
attribute HIGHP vec3 InTangent;
attribute HIGHP vec3 InBinormal;
varying HIGHP vec4 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec3 VOutTexCoord5;
void main()
{
	vec3 position = InPosition.xyz;
    vec3 normal = InNormal;

	vec3 worldVertPos =  (g_mWorld * vec4(position.xyz, 1.0) ).xyz;
	vec4 viewPos =  g_mWorldView * vec4(position.xyz, 1.0);
	vec3 toLight0 = g_vLightDir.xyz;
//	if (lightZeroIsOmniOrSpot())
//	{
//		toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
//	}
	vec3 lightVec =  mat3(g_mWorldInv) * toLight0 ; 
//	vec3 lightVec1 =  mat3(g_mWorldInv) * g_vLight1Dir;  
	vec3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = eyeVec * mat3(g_mWorldInv);  // transform back to object space	
	
	// copy texture coordinates	    
    VOutTexCoord0.xy = InTexCoord0;
	VOutTexCoord1.xy = InTexCoord1;
	VOutTexCoord1.zw = InTexCoord2;
	VOutTexCoord2.xy = InTangent.xy;
	VOutTexCoord2.zw = InBinormal.xy;
	
	// transform position to clip space
	gl_Position = g_mProj * viewPos;
   
	// compute the 3x3 tranform from object space to tangent space
	mat3 objToTangentSpace;
	float bumpHeight = 1.0;
	objToTangentSpace[0] = InTangent.xyz * bumpHeight;
	objToTangentSpace[1] = InBinormal.xyz * bumpHeight;
	objToTangentSpace[2] = normal;
	
    // light vector
	VOutTexCoord3 = lightVec * objToTangentSpace; // transform from object to tangent space
//	VOutTexCoord4 = 0;
//	if (g_iNumLights > 1)
//	{
//		VOutTexCoord4 =  lightVec * objToTangentSpace1; // transform from object to tangent space
//	}

	// eye vector
	VOutTexCoord5 = eyeVec * objToTangentSpace;
 //   VOutTexCoord6 = viewPos.xyz;

}
#endif

// Does both shadow and non shadow compile
#ifdef ENTRYPOINT_PixT5Bump
varying HIGHP vec4 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec3 VOutTexCoord5;
void main()
{
#ifdef SHADOW_LOOKUP
	float lightAmount = 1; //XX
	vec4 mask = texture2D(g_sSamplerOne, VOutTexCoord0.xy);
#else	
    float lightAmount = 1;
	vec4 mask = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
#endif
				
	// This ia a little swizzled due to the first assets we have that use it
	// where rgba does not map to ch(1,2,3,4) but to ch(2,3,1,4)..
	vec2 uv0 = VOutTexCoord1.zw; //channel1 (r in mask)
	vec2 uv1 = VOutTexCoord1.xy; //channel2 (g in mask)
	vec2 uv2 = VOutTexCoord2.xy; //channel3 (b in mask)
	vec2 uv3 = VOutTexCoord2.zw; //channel4 (a in mask)
	
	// x0.5 as our actuyal uvs will be half space
	vec2 gradUV0x = dFdx( uv0 * 0.5);
	vec2 gradUV0y = dFdy( uv0 * 0.5);
	vec2 gradUV1x = dFdx( uv1 * 0.5);
	vec2 gradUV1y = dFdy( uv1 * 0.5);
	vec2 gradUV2x = dFdx( uv2 * 0.5);
	vec2 gradUV2y = dFdy( uv2 * 0.5);
	vec2 gradUV3x = dFdx( uv3 * 0.5);
	vec2 gradUV3y = dFdy( uv3 * 0.5);	
	    
	float fullTexSize = 1024.0; 
	float fullTexSizeSqrd = fullTexSize * fullTexSize;
	float mipLevelT0 = 0.5 * log2( max(dot(gradUV0x, gradUV0x), dot(gradUV0y, gradUV0y)) * fullTexSizeSqrd );
	float mipLevelT1 = 0.5 * log2( max(dot(gradUV1x, gradUV1x), dot(gradUV1y, gradUV1y)) * fullTexSizeSqrd );
	float mipLevelT2 = 0.5 * log2( max(dot(gradUV2x, gradUV2x), dot(gradUV2y, gradUV2y)) * fullTexSizeSqrd );
	float mipLevelT3 = 0.5 * log2( max(dot(gradUV3x, gradUV3x), dot(gradUV3y, gradUV3y)) * fullTexSizeSqrd );
	    
	float texSize = fullTexSize;
	float uv0texSize = texSize / pow(2, mipLevelT0);
	float uv1texSize = texSize / pow(2, mipLevelT1);
	float uv2texSize = texSize / pow(2, mipLevelT2);
	float uv3texSize = texSize / pow(2, mipLevelT3);
	
	vec2 one = vec2(1,1);
	vec2 minUV0 = one / uv0texSize;
	vec2 maxUV0 = ( uv0texSize - one) / uv0texSize;
	vec2 minUV1 = one / uv1texSize;
	vec2 maxUV1 = ( uv1texSize - one) / uv1texSize;
	vec2 minUV2 = one / uv2texSize;
	vec2 maxUV2 = ( uv2texSize - one) / uv2texSize;
	vec2 minUV3 = one / uv3texSize;
	vec2 maxUV3 = ( uv3texSize - one) / uv3texSize;
	
	vec2 atlasUV0 = vec2( clamp( fract( uv0 ), minUV0, maxUV0 ) * 0.5);
	vec2 atlasUV1 = vec2( clamp( fract( uv1 ), minUV1, maxUV1 ) * 0.5);
	vec2 atlasUV2 = vec2( clamp( fract( uv2 ), minUV2, maxUV2 ) * 0.5);
	vec2 atlasUV3 = vec2( clamp( fract( uv3 ), minUV3, maxUV3 ) * 0.5);

	atlasUV0 += vec2(0.5,0.5);
	atlasUV1 += vec2(0.5,0  );
	atlasUV2 += vec2(0  ,0.5);
		
	float mr = mask.r;
	float mg = mask.g;
	float mb = mask.b;
	float ma = mask.a;
	
#ifdef SHADOW_LOOKUP
	vec4 ColorMap 	= mr*texture2DLod(g_sSamplerTwo, atlasUV0, mipLevelT0)     + mg*texture2DLod(g_sSamplerTwo,atlasUV1, mipLevelT1)      + mb*texture2DLod(g_sSamplerTwo,atlasUV2, mipLevelT2)     + ma*texture2DLod(g_sSamplerTwo,atlasUV3, mipLevelT3);
	vec3 N 			= mr*texture2DLod(g_sSamplerThree, atlasUV0, mipLevelT0).xyz	+ mg*texture2DLod(g_sSamplerThree,atlasUV1, mipLevelT1).xyz	 + mb*texture2DLod(g_sSamplerThree,atlasUV2, mipLevelT2).xyz + ma*texture2DLod(g_sSamplerThree,atlasUV3, mipLevelT3).xyz;
	vec3 SpecMap		= mr*texture2DLod(g_sSamplerFour, atlasUV0, mipLevelT0).xyz	+ mg*texture2DLod(g_sSamplerFour, atlasUV1, mipLevelT1).xyz	 + mb*texture2DLod(g_sSamplerFour, atlasUV2, mipLevelT2).xyz + ma*texture2DLod(g_sSamplerFour, atlasUV3, mipLevelT3).xyz;
#else
	vec4 ColorMap 	= mr*texture2DLod(g_sSamplerOne, atlasUV0, mipLevelT0)     + mg*texture2DLod(g_sSamplerOne,atlasUV1, mipLevelT1)      + mb*texture2DLod(g_sSamplerOne,atlasUV2, mipLevelT2)     + ma*texture2DLod(g_sSamplerOne,atlasUV3, mipLevelT3);
	vec3 N 			= mr*texture2DLod(g_sSamplerTwo, atlasUV0, mipLevelT0).xyz	+ mg*texture2DLod(g_sSamplerTwo,atlasUV1, mipLevelT1).xyz	 + mb*texture2DLod(g_sSamplerTwo,atlasUV2, mipLevelT2).xyz + ma*texture2DLod(g_sSamplerTwo,atlasUV3, mipLevelT3).xyz;
	vec3 SpecMap		= mr*texture2DLod(g_sSamplerThree, atlasUV0, mipLevelT0).xyz	+ mg*texture2DLod(g_sSamplerThree, atlasUV1, mipLevelT1).xyz	 + mb*texture2DLod(g_sSamplerThree, atlasUV2, mipLevelT2).xyz + ma*texture2DLod(g_sSamplerThree, atlasUV3, mipLevelT3).xyz;
#endif

	
	ColorMap *= g_cDiffuseColor;
	ColorMap /= (mr+mg+mb+ma);
	
	if (ColorMap.a < ALPHA_DISCARD_TOLERANCE )
		discard;

	SpecMap *= g_cSpecularColor.rgb; 
	SpecMap /= (mr+mg+mb+ma);
	
	N = N*2.0 - vec3(1.0,1.0,1.0);
	N = normalize(N);
		
	vec3 L0 = normalize(VOutTexCoord3.xyz);
	vec3 E = normalize(VOutTexCoord5.xyz);
	float NdotL = dot(N, L0); 
	vec3 HA = E + L0;
	vec3 H = normalize(HA);
	float NdotH = dot(N, H);
	vec4 light0 = Phong(NdotL, NdotH, g_cSpecularPower) * vec4(g_cLightColor.rgb,1.0);
	vec4 light1 = vec4(0.0,0.0,0.0,0.0); //XX 
	vec3 totalLight = light0.rgb + g_cAmbientColor.rgb;
	
	clamp(totalLight,0,1);
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
//    if ( g_iFogParams.x > 0)
//    {
//		gl_FragColor = computeFog( VOutTexCoord6.z, gl_FragColor );
//    }
    
//    gl_FragSecondaryColor.rgb = VOutTexCoord6.z * g_iDepthParams.x ;
//    gl_FragSecondaryColor.a = gl_FragColor.a;

}
#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
