/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//
// One diffuse map, with and without shadows. Unlit.
//:STYLE VertT1 PixT1 LD0 T1 DIFFUSE0
//:STYLE VertT1 PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0

//:STYLE VertT1 PixT1 LD0 T1 DIFFUSE0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertT1 PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertT1 PixT1 LD0 T1 DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertT1 PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING

#include "CommonHeader.hlslh"

// extra matrices
float4x4 g_mWorldView		: WorldView;
float4x4 g_mProj			: Proj;
 

vertexOutputUnlitT1 VertT1(vertexInputUnlitT1 In) 
{
	vertexOutputUnlitT1 Output;
    
#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2;
   	//world[3] = In.transformRow3;
   	float3 worldVertPos = mul(world , float4(In.position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
#else
		
	float3 position = In.position.xyz;
    
#ifdef HKG_SKINNING   
    float blendWeightsArray[4] = (float[4])In.blendWeights;    
	#if defined(HKG_DX10)
		int   indexArray[4] = (int[4])In.blendIndices;    
	#else
		int4  indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
		int   indexArray[4] = (int[4])indexVector;    
	#endif
    skinPosition( In.position, blendWeightsArray, indexArray, position );     
#endif 

	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);	
#endif

    Output.position = mul( viewPos, g_mProj);
	Output.posView = viewPos;
    Output.texCoord0 = In.texCoord0;
	return Output;
}


pixelOutput PixShadowSceneT1( vertexOutputUnlitT1 In )
{
    pixelOutput Output;

    float lightAmount = getLightAmountShadow( In.posView );
	
    float4 texel = _sample4(In.texCoord0 );
    Output.color.rgb = texel.rgb * lightAmount.rrr; // modulate rgb wrt shadow.
    Output.color.a = texel.a; // set alpha as is, shadow doesn't affect it.
	clip( texel.a - ALPHA_DISCARD_TOLERANCE );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
	
	return Output;
}


pixelOutput PixT1( vertexOutputUnlitT1 In ) 
{ 
    pixelOutput Output;
    Output.color = _sample0(In.texCoord0); 
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
