/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//
// One diffuse map, with and without shadows. Unlit.
//:STYLE VertT1 PixT1 LD0 T1 DIFFUSE0
//:STYLE VertShadowProjT1 PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0

#pragma include("CommonHeader.glslh")

// extra matrices
uniform HIGHP mat4 g_mWorldView;		
uniform HIGHP mat4 g_mProj;			
 
// extra textures
uniform sampler2D g_sSamplerOne; 
uniform sampler2D g_sSamplerTwo; 

#ifdef ENTRYPOINT_VertT1
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
varying HIGHP vec2 VOutTexCoord0;
void main()
{
    gl_Position = g_mWorldViewProj * vec4(InPosition.xyz , 1.0);
    VOutTexCoord0 = InTexCoord0;
}
#endif

#ifdef ENTRYPOINT_VertShadowProjT1
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;
void main()
{
    vec4 viewPos = g_mWorldView * vec4(InPosition.xyz, 1.0);
    
    gl_Position =  g_mProj * viewPos;
    VOutTexCoord0 = InTexCoord0;
    
	// project pos into light space
    VOutTexCoord4 =  g_mViewToLightProj * viewPos;
    
    #ifdef HKG_SHADOWS_VSM
          VOutTexCoord5 = g_mWorld * vec4(InPosition.xyz, 1.0);
	#endif
  
	return Out;
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;
void main()
{
    #ifdef HKG_SHADOWS_VSM 
		float lightAmount = getLightAmountVSM( VOutTexCoord4, VOutTexCoord5  );
 	#else
		float lightAmount = getLightAmountSM( VOutTexCoord4 ); 
	#endif
	
    vec4 texel = texture2D( g_sSamplerOne, InTexCoord0.xy );
    gl_FragColor.rgb = texel.rgb * lightAmount; // modulate rgb wrt shadow.
    gl_FragColor.a = texel.a; // set alpha as is, shadow doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixT1
varying HIGHP vec2 VOutTexCoord0;
void main()
{ 
    gl_FragColor = texture2D(g_sSamplerZero, InTexCoord0.xy); 
}
#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
