/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertOneLightReflectT1 PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0
//:STYLE VertOneLightReflectShadowProjT1 PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0
//:STYLE VertOneLightReflectT1 PixT1ReflectMask LD* T1 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0
//:STYLE VertOneLightReflectShadowProjT1 PixShadowSceneT1ReflectMask LD* T1 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0
//:STYLE VertOneLightReflectT2 PixT2ReflectMask LD* T2 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0
//:STYLE VertOneLightReflectShadowProjT2 PixShadowSceneT2ReflectMask LD* T2 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0

#pragma include("CommonHeader.glslh")

// Matrices
uniform HIGHP mat4 g_mWorldInv;
uniform HIGHP mat4 g_mWorldView;
uniform HIGHP mat4 g_mProj;	
uniform HIGHP mat4 g_mViewInv;	
 
// Textures, set assignment so that the behaviour is the same no mater what shader is using it 
uniform samplerCube g_sSamplerOneCube;
uniform sampler2D g_sSamplerOne;  

uniform samplerCube g_sSamplerTwoCube;  
uniform sampler2D g_sSamplerTwo;  

uniform samplerCube g_sSamplerThreeCube;  
uniform sampler2D g_sSamplerThree;

uniform sampler2D g_sSamplerFour;
uniform sampler2D g_sSamplerFive; 



void computeTangentSpace( in vec3 tangent, in vec3 binormal, in vec3 normal, out mat3 objToTangentSpace, out vec3 tangentToWorldSpaceRow0, out vec3 tangentToWorldSpaceRow1, out vec3 tangentToWorldSpaceRow2 )
{
	float bumpHeight = 1.0;
	
	objToTangentSpace[0] = tangent * bumpHeight;
	objToTangentSpace[1] = binormal * bumpHeight;
	objToTangentSpace[2] = normal;
 
 	mat3 TangentToObjSpace;
	
	TangentToObjSpace[0] = vec3(objToTangentSpace[0].x, objToTangentSpace[1].x, objToTangentSpace[2].x);
	TangentToObjSpace[1] = vec3(objToTangentSpace[0].y, objToTangentSpace[1].y, objToTangentSpace[2].y);
	TangentToObjSpace[2] = vec3(objToTangentSpace[0].z, objToTangentSpace[1].z, objToTangentSpace[2].z);

	vec3 wr0 = g_mWorld[0].xyz;
	vec3 wr1 = g_mWorld[1].xyz;
	vec3 wr2 = g_mWorld[2].xyz;
	
	tangentToWorldSpaceRow0.x = dot( wr0, TangentToObjSpace[0]);
	tangentToWorldSpaceRow0.y = dot( wr1, TangentToObjSpace[0]);
	tangentToWorldSpaceRow0.z = dot( wr2, TangentToObjSpace[0]);
	tangentToWorldSpaceRow1.x = dot( wr0, TangentToObjSpace[1]);
	tangentToWorldSpaceRow1.y = dot( wr1, TangentToObjSpace[1]);
	tangentToWorldSpaceRow1.z = dot( wr2, TangentToObjSpace[1]);
	tangentToWorldSpaceRow2.x = dot( wr0, TangentToObjSpace[2]);
	tangentToWorldSpaceRow2.y = dot( wr1, TangentToObjSpace[2]);
	tangentToWorldSpaceRow2.z = dot( wr2, TangentToObjSpace[2]);  
	
}

#ifdef ENTRYPOINT_VertOneLightReflectT1
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec3 InNormal;
attribute HIGHP vec3 InTangent;
attribute HIGHP vec3 InBinormal;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;
void main()
{
	gl_Position = g_mWorldViewProj * InPosition;
	VOutTexCoord0 = InTexCoord0;
	
	vec4 vertexPos = g_mWorld * InPosition; // world space position

	mat3 objToTangentSpace;
	computeTangentSpace( InTangent.xyz, InBinormal.xyz, InNormal.xyz, objToTangentSpace, VOutTexCoord4.xyz, VOutTexCoord5.xyz, VOutTexCoord6.xyz);

	// light vector
	vec3 lightVec =  mat3(g_mWorldInv) * g_vLightDir;  // transform back to object space
	VOutTexCoord2.xyz = objToTangentSpace * lightVec; // transform from object to tangent space
	
	// eye vector
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 eyeVec = worldEyePos - vertexPos.xyz; // world space eye vector
	eyeVec = normalize(eyeVec);
	VOutTexCoord4.w = eyeVec.x;
	VOutTexCoord5.w = eyeVec.y;
	VOutTexCoord6.w = eyeVec.z;
	
	eyeVec = mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord3.xyz = H * objToTangentSpace;	// transform to tangent space
}
#endif

#ifdef ENTRYPOINT_VertOneLightReflectShadowProjT1
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec3 InNormal;
attribute HIGHP vec3 InTangent;
attribute HIGHP vec3 InBinormal;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord1;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;
varying HIGHP vec4 VOutTexCoord7;
void main()
{
    vec4 viewPos =  g_mWorldView * vec4(InPosition.xyz, 1.0);
    
    gl_Position =  g_mProj * viewPos;
    VOutTexCoord0 = InTexCoord0;
		 
		// project pos into light space
    VOutTexCoord1 = g_mViewToLightProj * viewPos;
    
    #ifdef HKG_SHADOWS_VSM
            VOutTexCoord7 =  g_mWorld * vec4(InPosition.xyz, 1.0);
    #endif
    
	// compute the 3x3 tranform from object space to tangent space
	mat3 objToTangentSpace;
	computeTangentSpace( InTangent.xyz, InBinormal.xyz, InNormal, objToTangentSpace, VOutTexCoord4.xyz, VOutTexCoord5.xyz, VOutTexCoord6.xyz);
	
	vec4 vertexPos = g_mWorld * InPosition; // world space position

	// light vector
	vec3 lightVec =  mat3(g_mWorldInv) * g_vLightDir;  // transform back to object space
	VOutTexCoord2.xyz = lightVec * objToTangentSpace; // transform from object to tangent space
	
	// eye vector
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 eyeVec = worldEyePos - vertexPos.xyz; // world space eye vector
	eyeVec = normalize(eyeVec);
	VOutTexCoord4.w = eyeVec.x;
	VOutTexCoord5.w = eyeVec.y;
	VOutTexCoord6.w = eyeVec.z;
	
	eyeVec = mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord3.xyz = H * objToTangentSpace;	// transform to tangent space
}
#endif

#ifdef ENTRYPOINT_VertOneLightReflectT2
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec2 InTexCoord1;
attribute HIGHP vec3 InNormal;
attribute HIGHP vec3 InTangent;
attribute HIGHP vec3 InBinormal;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;
void main()
{
	VOutTexCoord0 = InTexCoord0;
	VOutTexCoord1 = InTexCoord1;
	gl_Position = g_mWorldViewProj * InPosition;

	mat3 objToTangentSpace;
	computeTangentSpace( InTangent.xyz, InBinormal.xyz, InNormal, objToTangentSpace, VOutTexCoord4.xyz, VOutTexCoord5.xyz, VOutTexCoord6.xyz);
	
	vec4 vertexPos = g_mWorld * InPosition; // world space position

	// light vector
	vec3 lightVec =  mat3(g_mWorldInv) * g_vLightDir;  // transform back to object space
	VOutTexCoord2.xyz = lightVec * objToTangentSpace; // transform from object to tangent space
	
	// eye vector
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 eyeVec = worldEyePos - vertexPos.xyz; // world space eye vector
	eyeVec = normalize(eyeVec);
	VOutTexCoord4.w = eyeVec.x;
	VOutTexCoord5.w = eyeVec.y;
	VOutTexCoord6.w = eyeVec.z;
	
	eyeVec = mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord3.xyz = H * objToTangentSpace;	// transform to tangent space

}
#endif

#ifdef ENTRYPOINT_VertOneLightReflectShadowProjT2
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec2 InTexCoord1;
attribute HIGHP vec3 InNormal;
attribute HIGHP vec3 InTangent;
attribute HIGHP vec3 InBinormal;
varying HIGHP vec4 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord1;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;
varying HIGHP vec4 VOutTexCoord7;
void main()
{
    vec4 viewPos = g_mWorldView * vec4(InPosition.xyz, 1.0);
    
    gl_Position = g_mProj * viewPos;
    
    VOutTexCoord0 = vec4( InTexCoord0.xy, InTexCoord1.xy);
	 
		// project pos into light space
    VOutTexCoord1 = g_mViewToLightProj * viewPos);
    
    #ifdef HKG_SHADOWS_VSM
            VOutTexCoord7 =   g_mWorld, vec4(InPosition.xyz, 1.0) ).xyz;
   #endif
    
	// compute the 3x3 tranform from object space to tangent space
	mat3 objToTangentSpace;
	computeTangentSpace( InTangent.xyz, InBinormal.xyz, InNormal.xyz, objToTangentSpace, VOutTexCoord4.xyz, VOutTexCoord5.xyz, VOutTexCoord6.xyz);
	
    vec4 vertexPos = g_mWorld * InPosition; // world space position

	// light vector
	vec3 lightVec =  mat3(g_mWorldInv) * g_vLightDir;  // transform back to object space
	VOutTexCoord2.xyz = lightVec * objToTangentSpace; // transform from object to tangent space
	
	// eye vector
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 eyeVec = worldEyePos - vertexPos.xyz; // world space eye vector
	eyeVec = normalize(eyeVec);
	VOutTexCoord4.w = eyeVec.x;
	VOutTexCoord5.w = eyeVec.y;
	VOutTexCoord6.w = eyeVec.z;
	
	eyeVec =  mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord3.xyz = H * objToTangentSpace;	// transform to tangent space

}
#endif

// Pixel Shaders

#ifdef ENTRYPOINT_PixT1Reflect
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;

void main()
{
	vec4 ColorMap = vec4(1,1,1,1);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
#endif
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = texture2D(g_sSamplerTwo, VOutTexCoord0.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = texture2D(g_sSamplerTwo, VOutTexCoord0.xy);
	#endif
#endif

	vec3 worldEyeVec = vec3( -VOutTexCoord4.w, -VOutTexCoord5.w, -VOutTexCoord6.w ); 
	vec3 worldNormal = vec3( dot(VOutTexCoord4.xyz, N), dot(VOutTexCoord5.xyz, N), dot(VOutTexCoord6.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	vec4 ReflectionMap = textureCube(g_sSamplerOneCube, reflVect); 
	ColorMap.rgb = ColorMap.rgb * ReflectionMap.rgb;  


#if ENABLE_SPEC_MAP
	SpecMap *= texture2D(g_sSamplerThree, VOutTexCoord0.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;

	
	vec3 L = normalize(VOutTexCoord2.xyz);
	vec3 H = normalize(VOutTexCoord3.xyz);
	float NdotL = dot(N, L);
	float NdotH = dot(N, H);
#if ENABLE_LIGHTING
    float specPower = g_cSpecularPower;
    vec4 light = Phong( NdotL, NdotH, specPower ) * vec4(g_cLightColor.rgb, 1);
#else
	vec4 light = vec4(1,1,1,1);
#endif
	
	gl_FragColor.rgb = (1-light.rgb)*g_cAmbientColor.rgb*ColorMap.rgb + light.rgb*ColorMap.rgb + light.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixT1ReflectMask
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;
void main()
{
	vec4 ColorMap = vec4(1,1,1,1);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = texture2D(g_sSamplerThree, VOutTexCoord0.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = texture2D(g_sSamplerThree, VOutTexCoord0.xy);
	#endif
#endif

	vec3 worldEyeVec = vec3( -VOutTexCoord4.w, -VOutTexCoord5.w, -VOutTexCoord6.w ); 
	vec3 worldNormal = vec3( dot(VOutTexCoord4.xyz, N), dot(VOutTexCoord5.xyz, N), dot(VOutTexCoord6.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	vec4 ReflectionMap = textureCube(g_sSamplerTwoCube, reflVect); 
	vec4 ReflectionMask = texture2D(g_sSamplerOne, VOutTexCoord0.xy); 
	ColorMap.rgb = (1-ReflectionMask.rgb)*ColorMap.rgb + ReflectionMask.rgb*ReflectionMap.rgb*ColorMap.rgb;  
		


#if ENABLE_SPEC_MAP
	SpecMap *= texture2D(g_sSamplerFour, VOutTexCoord0.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	
	
	vec3 L = normalize(VOutTexCoord2.xyz);
	vec3 H = normalize(VOutTexCoord3.xyz);
	float NdotL = dot(N, L);
	float NdotH = dot(N, H);
	
#if ENABLE_LIGHTING
    float specPower = g_cSpecularPower;
    vec4 light = Phong( NdotL, NdotH, specPower ) * vec4(g_cLightColor.rgb, 1);
#else
	vec4 light = vec4(1,1,1,1);
#endif
	
	gl_FragColor.rgb = (1-light.rgb)*g_cAmbientColor.rgb*ColorMap.rgb + light.rgb*ColorMap.rgb + light.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixT2ReflectMask
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;
void main()
{
	vec4 ColorMap = vec4(1,1,1,1);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
#endif
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = (texture2D(g_sSamplerThree, VOutTexCoord0.xy)*2.0 - 1.0).xyz;
		N = normalize(N);
	#else
		ColorMap = texture2D(g_sSamplerThree, VOutTexCoord0.xy);
	#endif
#endif

	
	vec3 worldEyeVec = vec3( -VOutTexCoord4.w, -VOutTexCoord5.w, -VOutTexCoord6.w ); 
	vec3 worldNormal = vec3( dot(VOutTexCoord4.xyz, N), dot(VOutTexCoord5.xyz, N), dot(VOutTexCoord6.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	vec4 ReflectionMap = textureCube(g_sSamplerTwoCube, reflVect); 
	vec4 ReflectionMask = texture2D(g_sSamplerOne, VOutTexCoord1.xy); 
	ColorMap.rgb = (1-ReflectionMask.rgb)*ColorMap.rgb + ReflectionMask.rgb*ReflectionMap.rgb*ColorMap.rgb;  


#if ENABLE_SPEC_MAP
	SpecMap *= texture2D(g_sSamplerFour, VOutTexCoord0.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;

	
	vec3 L = normalize(VOutTexCoord2.xyz);
	vec3 H = normalize(VOutTexCoord3.xyz);
	float NdotL = dot(N, L);
	float NdotH = dot(N, H);
#if ENABLE_LIGHTING
    float specPower = g_cSpecularPower;
    vec4 light = Phong( NdotL, NdotH, specPower ) * vec4(g_cLightColor.rgb, 1);
#else
	vec4 light = vec4(1,1,1,1);
#endif
	
	gl_FragColor.rgb = (1-light.rgb)*g_cAmbientColor.rgb*ColorMap.rgb + light.rgb*ColorMap.rgb + light.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1Reflect
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord1;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;
varying HIGHP vec4 VOutTexCoord7;
void main()
{
    #ifdef HKG_SHADOWS_VSM
		float lightAmount = getLightAmountVSM( VOutTexCoord1, VOutTexCoord7 );
  	#else
		float lightAmount = getLightAmountSM( VOutTexCoord1 ); 
	#endif
		
	vec4 ColorMap = vec4(1,1,1,1);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = texture2D(g_sSamplerOne, VOutTexCoord0.xy);
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = texture2D(g_sSamplerThree, VOutTexCoord0.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = texture2D(g_sSamplerThree, VOutTexCoord0.xy);
	#endif
#endif

	vec3 worldEyeVec = vec3( -VOutTexCoord4.w, -VOutTexCoord5.w, -VOutTexCoord6.w ); 
	vec3 worldNormal = vec3( dot(VOutTexCoord4.xyz, N), dot(VOutTexCoord5.xyz, N), dot(VOutTexCoord6.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	vec4 ReflectionMap = textureCube(g_sSamplerTwoCube, reflVect); 
	ColorMap.rgb = ColorMap.rgb * ReflectionMap.rgb;  


#if ENABLE_SPEC_MAP
	SpecMap *= texture2D(g_sSamplerFour, VOutTexCoord0.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;

	// interp will not preserve length
	
	vec3 L = normalize(VOutTexCoord2.xyz);
	vec3 H = normalize(VOutTexCoord3.xyz);
	float NdotL = dot(N, L);
	float NdotH = dot(N, H);
	
#if ENABLE_LIGHTING
	float specPower = g_cSpecularPower;
	vec4 light = lightAmount * Phong(NdotL, NdotH, specPower) * vec4(g_cLightColor.rgb, 1);
#else
	vec4 light = vec4(1,1,1,1);
#endif
	
	gl_FragColor.rgb = (1-light.rgb)*g_cAmbientColor.rgb*ColorMap.rgb + light.rgb*ColorMap.rgb + light.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1ReflectMask
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord1;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;
varying HIGHP vec4 VOutTexCoord7;
void main()
{
  
    #ifdef HKG_SHADOWS_VSM
		float lightAmount = getLightAmountVSM( VOutTexCoord1, VOutTexCoord7 );
  	#else
		float lightAmount = getLightAmountSM( VOutTexCoord1 ); 
	#endif
		
	vec4 ColorMap = vec4(1,1,1,1);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = texture2D(g_sSamplerOne, VOutTexCoord0.xy);
#endif
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = texture2D(g_sSamplerFour, VOutTexCoord0.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = texture2D(g_sSamplerFour, VOutTexCoord0.xy);
	#endif
#endif	
		
	vec3 worldEyeVec = vec3( -VOutTexCoord4.w, -VOutTexCoord5.w, -VOutTexCoord6.w ); 
	vec3 worldNormal = vec3( dot(VOutTexCoord4.xyz, N), dot(VOutTexCoord5.xyz, N), dot(VOutTexCoord6.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	vec4 ReflectionMap = textureCube(g_sSamplerThreeCube, reflVect); 
	vec4 ReflectionMask = texture2D(g_sSamplerTwo, VOutTexCoord0.xy);
	ColorMap.rgb = ( (vec3(1,1,1)-ReflectionMask.rgb) + ReflectionMask.rgb*ReflectionMap.rgb )*ColorMap.rgb;  

#if ENABLE_SPEC_MAP
	SpecMap *= texture2D(g_sSamplerFive, VOutTexCoord0.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;

	// interp will not preserve length
	
	vec3 L = normalize(VOutTexCoord2.xyz);
	vec3 H = normalize(VOutTexCoord3.xyz);
	float NdotL = dot(N, L);
	float NdotH = dot(N, H);
	
#if ENABLE_LIGHTING
	float specPower = g_cSpecularPower;
	vec4 light = lightAmount * Phong(NdotL, NdotH, specPower) * vec4(g_cLightColor.rgb, 1);
#else
	vec4 light = vec4(1,1,1,1);
#endif
	
	gl_FragColor.rgb = (1-light.rgb)*g_cAmbientColor.rgb*ColorMap.rgb + light.rgb*ColorMap.rgb + light.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.

}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT2ReflectMask
varying HIGHP vec4 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord1;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;
varying HIGHP vec4 VOutTexCoord6;
varying HIGHP vec4 VOutTexCoord7;
void main()
{
     #ifdef HKG_SHADOWS_VSM
		float lightAmount = getLightAmountVSM( VOutTexCoord1, VOutTexCoord7 );
  	#else
		float lightAmount = getLightAmountSM( VOutTexCoord1 ); 
	#endif
		
	vec4 ColorMap = vec4(1,1,1,1);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0,0,1); 
	
	vec2 tc0 = VOutTexCoord0.xy;
	vec2 tc1 = VOutTexCoord0.zw;
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = texture2D(g_sSamplerOne, tc0);
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = texture2D(g_sSamplerFour, tc0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = texture2D(g_sSamplerFour, tc0);
	#endif
#endif

	vec3 worldEyeVec = vec3( -VOutTexCoord4.w, -VOutTexCoord5.w, -VOutTexCoord6.w ); 
	vec3 worldNormal = vec3( dot(VOutTexCoord4.xyz, N), dot(VOutTexCoord5.xyz, N), dot(VOutTexCoord6.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	vec4 ReflectionMap = textureCube(g_sSamplerThreeCube, reflVect); 
	vec4 ReflectionMask = texture2D(g_sSamplerTwo, tc1);
	ColorMap.rgb = (1-ReflectionMask.rgb)*ColorMap.rgb + ReflectionMask.rgb*ReflectionMap.rgb*ColorMap.rgb;  
	

#if ENABLE_SPEC_MAP
	SpecMap *= texture2D(g_sSamplerFive, tc0).rgb;
#endif

	ColorMap *= g_cDiffuseColor;

	
	vec3 L = normalize(VOutTexCoord2.xyz);
	vec3 H = normalize(VOutTexCoord3.xyz);
	float NdotL = dot(N, L);
	float NdotH = dot(N, H);
	
#if ENABLE_LIGHTING
	float specPower = g_cSpecularPower;
	vec4 light = lightAmount * Phong(NdotL, NdotH, specPower) * vec4(g_cLightColor.rgb, 1);
#else
	vec4 light = vec4(1,1,1,1);
#endif
	
	gl_FragColor.rgb = (1-light.rgb)*g_cAmbientColor.rgb*ColorMap.rgb + light.rgb*ColorMap.rgb + light.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	}
#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
