/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//
// [None, one or two] diffuse maps, no normal map, with and without shadows. Vertex lit with one or two lights

//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0 OPACITY0
//:STYLE VertOneLightT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0
//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING

//:STYLE VertOneLightT2 PixDecalT2 LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1
//:STYLE VertOneLightT2 PixShadowDecalT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1
//:STYLE VertOneLightT2 PixDecorT2 LD* T2 DIFFUSE0 OPACITY1
//:STYLE VertOneLightT2 PixShadowDecorT2 LD* T2 SHADOWMAP DIFFUSE0 OPACITY1

//:STYLE VertOneLightT0 PixT0 LD* T0  
//:STYLE VertOneLightT0 PixShadowSceneT0 LD* T0 SHADOWMAP
//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0
//:STYLE VertOneLightT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0
//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC 
//:STYLE VertOneLightT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC 
//:STYLE VertOneLightT2 PixT2 LD* T2 DIFFUSE0 DIFFUSE1
//:STYLE VertOneLightT2 PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1

//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertOneLightT0 PixT0 LD* T0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightT0 PixShadowSceneT0 LD* T0 SHADOWMAP SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightT2 PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightT2 PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertOneLightT0 PixT0 LD* T0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightT0 PixShadowSceneT0 LD* T0 SHADOWMAP INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightT2 PixT2 LD* T2 DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightT2 PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING




#include "CommonHeader.hlslh"

// extra matrices
float4x4 g_mWorldInv;
float4x4 g_mWorldView		: WorldView;
float4x4 g_mProj			: Proj;
float4x4 g_mViewInv			: ViewInverse;

// Vertex based lighting (with specular)
vertexOutputT0 VertOneLightT0(vertexInputT0 In) 
{
    vertexOutputT0 Output;
       
#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2;
   	//world[3] = In.transformRow3;
   	float3 worldVertPos = mul(world , float4(In.position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
	float3 N = mul( (float3x3)world, In.normal.xyz ).xyz; //assumes no scale etc
#else
	
	float3 position = In.position.xyz;
    float3 normal = In.normal;

#ifdef HKG_SKINNING   
    float blendWeightsArray[4] = (float[4])In.blendWeights;    
	#if defined(HKG_DX10)
		int   indexArray[4] = (int[4])In.blendIndices;    
	#else
		int4  indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
		int   indexArray[4] = (int[4])indexVector;    
	#endif
    skinPositionNormal( In.position, In.normal, blendWeightsArray, indexArray, position, normal );     
#endif 

	float3 worldVertPos = mul(float4(position, 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);
	float3 N = mul( normal, (float3x3)g_mWorldInvTranspose ); //normal vector
#endif

	Output.position = mul( viewPos, g_mProj);
    Output.posView = viewPos.xyz;
  
	//calculate our vectors N, E, L, and H
	
	float3 worldEyePos = g_mViewInv[3].xyz;
	float4 light0;
	float4 light1;
	LightVertex(worldVertPos, N, worldEyePos, light0, light1);
	float4 vertColor = 1;
	MaterialContribution(vertColor, light0, light1, Output.diffColor0, Output.diffColor1, Output.specCol0);


	return Output; 
}

// Vertex based lighting (with specular)
vertexOutputT1 VertOneLightT1(vertexInputT1 In) 
{
    vertexOutputT1 Output;

#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2; 
   	//world[3] = In.transformRow3;
   	float3 worldVertPos = mul(world , float4(In.position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
	float3 N = mul( (float3x3)world, In.normal.xyz ); //assumes no scale etc
#else    

    float3 position = In.position.xyz;
    float3 normal = In.normal;    

#ifdef HKG_SKINNING   
    float blendWeightsArray[4] = (float[4])In.blendWeights;    
	#if defined(HKG_DX10)
		int   indexArray[4] = (int[4])In.blendIndices;    
	#else
		int4  indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
		int   indexArray[4] = (int[4])indexVector;    
	#endif
    skinPositionNormal( In.position, In.normal, blendWeightsArray, indexArray, position, normal );     
#endif 

	float3 worldVertPos = mul(float4( position, 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);
	float3 N = mul( normal, (float3x3)g_mWorldInvTranspose ); //normal vector
    
#endif
	
	Output.position = mul( viewPos, g_mProj);
	Output.posView = viewPos.xyz;
    Output.texCoord0 = In.texCoord0;
	
	//calculate our vectors N, E, L, and H
	float3 worldEyePos = g_mViewInv[3].xyz;
    float4 light0;
	float4 light1;
	LightVertex(worldVertPos, N, worldEyePos, light0, light1);
	float4 vertColor = 1;
	MaterialContribution(vertColor, light0, light1, Output.diffColor0, Output.diffColor1, Output.specCol0);
			
	return Output;
}


// Vertex based lighting (with specular)
vertexOutputT2 VertOneLightT2(vertexInputT2 In) 
{
    vertexOutputT2 Output;

#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2;
   	//world[3] = IN.transformRow3;
   	float3 worldVertPos = mul(world , float4(In.position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
	float3 N = mul( (float3x3)world, In.normal.xyz ); //assumes no scale etc
#else
	 
	float3 position = In.position.xyz;
    float3 normal = In.normal;    

	#ifdef HKG_SKINNING   
		float blendWeightsArray[4] = (float[4])In.blendWeights;    
		#if defined(HKG_DX10)
			int   indexArray[4] = (int[4])In.blendIndices;    
		#else
			int4  indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
			int   indexArray[4] = (int[4])indexVector;    
		#endif
		skinPositionNormal( In.position, In.normal, blendWeightsArray, indexArray, position, normal );     
	#endif 

	float3 worldVertPos = mul(float4(position , 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);
	float3 N = mul( normal, (float3x3)g_mWorldInvTranspose ); //normal vector
#endif
	
	Output.position = mul( viewPos, g_mProj);
	Output.posView = viewPos.xyz;
    Output.texCoord01.xy = In.texCoord0;
	Output.texCoord01.zw = In.texCoord1;
	
	//calculate our vectors N, E, L, and H
	float3 worldEyePos = g_mViewInv[3].xyz;
	float4 light0;
	float4 light1;
	LightVertex(worldVertPos, N, worldEyePos, light0, light1);
	float4 vertColor = float4(1,1,1,1);
	MaterialContribution(vertColor, light0, light1, Output.diffColor0, Output.diffColor1, Output.specCol0);
	return Output;
}

pixelOutput PixShadowSceneT0( vertexOutputT0 In )
{
    pixelOutput Output;

	clip( In.diffColor0.a - ALPHA_DISCARD_TOLERANCE );
	
    float lightAmount = getLightAmountShadow( In.posView );
	
	float3 amb = g_cDiffuseColor.rgb * g_cAmbientColor.rgb;
	Output.color.rgb = (1-lightAmount)*( amb + In.diffColor1.rgb ) + lightAmount*( In.diffColor0.rgb + In.diffColor1.rgb ) + lightAmount*In.specCol0.rgb;
	Output.color.a = In.diffColor0.a; // modulate alpha as is, shadow doesn't affect it.
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	Output.pzDepth.rgba = In.posView.z * g_iDepthParams.x ;
    
    return Output;
}

pixelOutput PixShadowSceneT1( vertexOutputT1 In )
{
    pixelOutput Output;

    float lightAmount = getLightAmountShadow( In.posView );
	
	float4 texel = _sample4(In.texCoord0 );

    float4 SpecMap = 1;
#ifdef USE_SPEC 
    SpecMap = _sample5(In.texCoord0);
#endif

	float3 amb = g_cDiffuseColor.rgb * g_cAmbientColor.rgb;
	float3 matLight = (1-lightAmount)*( amb + In.diffColor1.rgb) + lightAmount*( In.diffColor0.rgb + In.diffColor1.rgb ) + lightAmount*In.specCol0.rgb*SpecMap.rgb;
	
	Output.color.rgb = texel.rgb*matLight;
	Output.color.a = texel.a * In.diffColor0.a; // modulate alpha as is, shadow doesn't affect it.
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );

    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    

    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixShadowSceneT2( vertexOutputT2 In )
{
    pixelOutput Output;

    float lightAmount = getLightAmountShadow( In.posView );
	
	float4 texel0 = _sample4(In.texCoord01.xy );
    float4 texel1 = _sample5(In.texCoord01.zw );
    float3 texelTotal = (texel0.rgb + (texel1.rgb * 0.6));
     
	float3 amb = g_cDiffuseColor.rgb * g_cAmbientColor.rgb;
	float3 matLight = (1-lightAmount)*( amb + In.diffColor1.rgb) + lightAmount*( In.diffColor0.rgb + In.diffColor1.rgb ) + lightAmount*In.specCol0.rgb;
	Output.color.rgb = texelTotal.rgb*matLight;
	Output.color.a = texel0.a * texel1.a * In.diffColor0.a; // modulate alpha as is, shadow doesn't affect it.
   	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );
	 if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}


pixelOutput PixT0( vertexOutputT0 In ) 
{ 
    pixelOutput Output;
    Output.color.rgb = In.diffColor0.rgb + In.diffColor1.rgb + In.specCol0.rgb;
    Output.color.a = In.diffColor0.a;
   	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );
	 if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixT1( vertexOutputT1 In ) 
{ 
    pixelOutput Output;
    float4 texel = _sample0(In.texCoord0); 

    float4 SpecMap = 1;
#ifdef USE_SPEC 
    SpecMap = _sample1(In.texCoord0);
#endif

    Output.color.rgb = texel.rgb * (In.diffColor0.rgb + In.diffColor1.rgb) + (In.specCol0.rgb*SpecMap.rgb);
    Output.color.a = texel.a * In.diffColor0.a;

    clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
		
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a; 
	return Output;
}

pixelOutput PixT2( vertexOutputT2 In ) 
{ 
    pixelOutput Output;
    float4 texel0 = _sample0(In.texCoord01.xy );
    float4 texel1 = _sample1(In.texCoord01.zw );
    float3 texelTotal = texel0.rgb + (texel1.rgb * 0.6);
    
	Output.color.rgb = texelTotal.rgb * (In.diffColor0.rgb + In.diffColor1.rgb) + In.specCol0.rgb;
    Output.color.a = texel0.a * texel1.a * In.diffColor0.a;
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
    
    return Output;
}

pixelOutput PixDecalT2( vertexOutputT2 In ) 
{ 
    pixelOutput Output;
	
	// Sample textures: original, fractured, and decal map
	float4 	clrOrig 	= _sample0(In.texCoord01.xy);
	float4	clrBroken 	= _sample1(In.texCoord01.xy);
	float	clrD		= _sample2(In.texCoord01.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
	
	// Modulate	
    float4 texelTotal = lerp(clrBroken, clrOrig, 0.5f + clrD);
    
	Output.color.rgb = texelTotal.rgb * (In.diffColor0.rgb + In.diffColor1.rgb) + In.specCol0.rgb;
    Output.color.a = texelTotal.a * In.diffColor0.a;
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
    
    return Output;
}

pixelOutput PixShadowDecalT2( vertexOutputT2 In )
{
    pixelOutput Output;

	float lightAmount = getLightAmountShadow( In.posView );
	
	// Sample textures: original, fractured, and decal map
	float4 	clrOrig 	= _sample4(In.texCoord01.xy);
	float4	clrBroken 	= _sample5(In.texCoord01.xy);
	float	clrD		= _sample6(In.texCoord01.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
	
	// Modulate	
    float4 texelTotal = lerp(clrBroken, clrOrig, 0.5f + clrD);
     
	float3 amb = g_cDiffuseColor.rgb * g_cAmbientColor.rgb;
	float3 matLight = (1-lightAmount)*( amb + In.diffColor1.rgb) + lightAmount*( In.diffColor0.rgb + In.diffColor1.rgb ) + lightAmount*In.specCol0.rgb;
	Output.color.rgb = texelTotal.rgb * matLight;
	Output.color.a = texelTotal.a * In.diffColor0.a; // modulate alpha as is, shadow doesn't affect it.
   	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );
	 if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixDecorT2( vertexOutputT2 In ) 
{ 
    pixelOutput Output;
	
	// Sample textures: original and decor map
	float4 	clrDecor 	= _sample0(In.texCoord01.xy);
	float	clrD		= _sample1(In.texCoord01.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
		
	// Apply a threshold
	clrD = (clrD > 0.0f) ? 1.0f : 0.0f;
	float 	alpha 	= clrDecor.a * (1.0f - clrD);
    float4 texelTotal = float4(clrDecor.rgb, alpha);
    
	Output.color.rgb = texelTotal.rgb * (In.diffColor0.rgb + In.diffColor1.rgb) + In.specCol0.rgb;
    Output.color.a = texelTotal.a * In.diffColor0.a;
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
    
    return Output;
}

pixelOutput PixShadowDecorT2( vertexOutputT2 In )
{
    pixelOutput Output;

	float lightAmount = getLightAmountShadow( In.posView );
	
	// Sample textures: original and decor map
	float4 	clrDecor 	= _sample4(In.texCoord01.xy);
	float	clrD		= _sample5(In.texCoord01.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
	
	// Apply a threshold
	clrD = (clrD > 0.0f) ? 1.0f : 0.0f;
	float 	alpha 	= clrDecor.a * (1.0f - clrD);
    float4 texelTotal = float4(clrDecor.rgb, alpha);
     
	float3 amb = g_cDiffuseColor.rgb * g_cAmbientColor.rgb;
	float3 matLight = (1-lightAmount)*( amb + In.diffColor1.rgb) + lightAmount*( In.diffColor0.rgb + In.diffColor1.rgb ) + lightAmount*In.specCol0.rgb;
	Output.color.rgb = texelTotal.rgb * matLight;
	Output.color.a = texelTotal.a * In.diffColor0.a; // modulate alpha as is, shadow doesn't affect it.
   	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );
	 if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
