/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//:STYLE VertOneLightT2 PixDecalT2 LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1
//:STYLE VertOneLightShadowProjT2 PixShadowDecalT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1
//:STYLE VertOneLightT2 PixDecorT2 LD* T2 DIFFUSE0 OPACITY1
//:STYLE VertOneLightShadowProjT2 PixShadowDecorT2 LD* T2 SHADOWMAP DIFFUSE0 OPACITY1

//
// [None, one or two] diffuse maps, no normal map, with and without shadows. Vertex lit
//:STYLE VertOneLightT0 PixT0 LD* T0
//:STYLE VertOneLightShadowProjT0 PixShadowSceneT0 LD* T0 SHADOWMAP
//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0
//:STYLE VertOneLightShadowProjT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0
//:STYLE VertOneLightT1 PixT1 LD* T1 DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC 
//:STYLE VertOneLightShadowProjT1 PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC 
//:STYLE VertOneLightT2 PixT2 LD* T2 DIFFUSE0 DIFFUSE1 1L
//:STYLE VertOneLightShadowProjT2 PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1

#pragma include("CommonHeader.glslh")

// extra matrices
uniform mat4 g_mWorldInv;
uniform mat4 g_mWorldView; 
uniform mat4 g_mProj;	
uniform mat4 g_mViewInv; 
 
// extra textures
uniform sampler2D g_sSamplerOne;  
uniform sampler2D g_sSamplerTwo;  
uniform sampler2D g_sSamplerThree;


// Vertex based lighting (with specular)
// Pixel shaders
#ifdef ENTRYPOINT_VertOneLightT0
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec3 InNormal;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main()
{
    gl_Position = g_mWorldViewProj * vec4(InPosition.xyz , 1.0);
  	
	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 worldVertPos =  ( g_mWorld * vec4(InPosition.xyz,1) ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	vec4 vertColor = vec4(1,1,1,1);
	MaterialContribution(vertColor, light, VOutColor0,  VOutColor1);
}
#endif

// Vertex based lighting (with specular), also projects the position into the shadow map space
#ifdef ENTRYPOINT_VertOneLightShadowProjT0
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec3 InNormal;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;
void main()
{
    vec4 viewPos = g_mWorldView * vec4(InPosition.xyz, 1.0);
    gl_Position = g_mProj * viewPos;
    
	// project pos into light space
    VOutTexCoord4 = g_mViewToLightProj * viewPos;
    
    #ifdef HKG_SHADOWS_VSM
          VOutTexCoord5 =  g_mWorld * vec4(InPosition.xyz, 1.0);
	#endif
  
    // Lighting:
    
	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 worldVertPos = ( g_mWorld * vec4(InPosition.xyz,1) ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	vec4 vertColor = vec4(1,1,1,1);
	MaterialContribution(vertColor, light, VOutColor0, VOutColor1);
}
#endif

// Vertex based lighting (with specular)
#ifdef ENTRYPOINT_VertOneLightT1
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec3 InNormal;
attribute HIGHP vec2 InTexCoord0;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
void main()
{
    gl_Position =  g_mWorldViewProj * vec4(InPosition.xyz , 1.0);
    VOutTexCoord0 = InTexCoord0;
	
	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
    vec3 worldVertPos = ( g_mWorld * vec4(InPosition.xyz,1)  ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	vec4 vertColor = vec4(1,1,1,1);
	MaterialContribution(vertColor, light, VOutColor0, VOutColor1);
}
#endif

// Vertex based lighting (with specular), also projects the position into the shadow map space
#ifdef ENTRYPOINT_VertOneLightShadowProjT1
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec3 InNormal;
attribute HIGHP vec2 InTexCoord0;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord4;
varying HIGHP vec4 VOutTexCoord5;

void main()
{
    vec4 viewPos =  g_mWorldView * vec4(InPosition.xyz, 1.0);
    
    gl_Position = g_mProj * viewPos;
    VOutTexCoord0 = InTexCoord0;
    
	// project pos into light space
    VOutTexCoord4 = g_mViewToLightProj * viewPos;
    
    #ifdef HKG_SHADOWS_VSM
          VOutTexCoord5 =  g_mWorld * vec4(InPosition.xyz, 1.0);
	#endif
  
    // Lighting:
    
	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 worldVertPos = ( g_mWorld * vec4(InPosition.xyz,1) ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	vec4 vertColor = vec4(1,1,1,1);
	MaterialContribution(vertColor, light, VOutColor0, VOutColor1);
}
#endif


// Vertex based lighting (with specular)
#ifdef ENTRYPOINT_VertOneLightT2
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec3 InNormal;
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec2 InTexCoord1;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;

void main()
{
    gl_Position = g_mWorldViewProj * vec4(InPosition.xyz , 1.0);
    VOutTexCoord0 = InTexCoord0;
	VOutTexCoord1 = InTexCoord1;
	
	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 worldVertPos =  ( g_mWorld * vec4(InPosition.xyz,1)  ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	vec4 vertColor = vec4(1,1,1,1);
	MaterialContribution(vertColor, light, VOutColor0, VOutColor1);
}
#endif

// Vertex based lighting (with specular), also projects the position into the shadow map space
#ifdef ENTRYPOINT_VertOneLightShadowProjT2
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec3 InNormal;
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec2 InTexCoord1;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;

void main()
{
    vec4 viewPos = g_mWorldView * vec4(InPosition.xyz, 1.0);
    
    gl_Position = g_mProj * viewPos;
    VOutTexCoord0 = InTexCoord0;
    VOutTexCoord1 = InTexCoord1.0;
    
	// project pos into light space
    VOutTexCoord4 = g_mViewToLightProj * viewPos;
    
    #ifdef HKG_SHADOWS_VSM
          VOutTexCoord5 = g_mWorld * vec4(InPosition.xyz, 1.0);
	#endif
  
    // Lighting:
    
	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 worldVertPos = ( g_mWorld * vec4(InPosition.xyz,1) ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	vec4 vertColor = vec4(1,1,1,1);
	MaterialContribution(vertColor, light, VOutColor0, VOutColor1);
	
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT0
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;
void main()
{
    #ifdef HKG_SHADOWS_VSM 
		float lightAmount = getLightAmountVSM( VOutTexCoord4, VOutTexCoord5.xyz  );
 	#else
		float lightAmount = getLightAmountSM( VOutTexCoord4 ); 
	#endif
	
	gl_FragColor.rgb = (1.0-lightAmount)*VOutColor0.rgb*0.3 + lightAmount*VOutColor0.rgb + lightAmount*VOutColor1.rgb;
    gl_FragColor.a = VOutColor0.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;

void main()
{
    #ifdef HKG_SHADOWS_VSM 
		float lightAmount = getLightAmountVSM( VOutTexCoord4, VOutTexCoord5.xyz );
 	#else
		float lightAmount = getLightAmountSM( VOutTexCoord4 ); 
	#endif
	
	vec4 SpecMap = vec4(1.0,1.0,1.0,1.0);
#ifdef USE_SPEC 
    SpecMap = texture2D(g_sSamplerTwo,VOutTexCoord0.xy); 
#endif

    vec4 texel = texture2D( g_sSamplerOne, VOutTexCoord0.xy );
	texel.rgb *= VOutColor0.rgb;
    gl_FragColor.rgb = (1.0-lightAmount)*texel.rgb*0.3 + lightAmount*texel.rgb + lightAmount*VOutColor1.rgb*SpecMap.rgb;
    gl_FragColor.a = texel.a * VOutColor0.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT2
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;

void main()
{
    #ifdef HKG_SHADOWS_VSM 
		float lightAmount = getLightAmountVSM( VOutTexCoord4, VOutTexCoord5.xyz );
 	#else
		float lightAmount = getLightAmountSM( VOutTexCoord4 ); 
	#endif
	
    vec4 texel0 = texture2D( g_sSamplerOne, VOutTexCoord0 );
    vec4 texel1 = texture2D( g_sSamplerTwo, VOutTexCoord1 );
    vec3 texelTotal = (texel0.rgb + (texel1.rgb * 0.6));
    texelTotal.rgb *= VOutColor0.rgb;
	gl_FragColor.rgb = (1.0-lightAmount)*texelTotal.rgb*0.3 + lightAmount*texelTotal.rgb + lightAmount*VOutColor1.rgb;
    gl_FragColor.a = texel0.a * texel1.a * VOutColor0.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixT0
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main()
{ 
    gl_FragColor.rgb = VOutColor0.rgb + VOutColor1.rgb;
    gl_FragColor.a = VOutColor0.a;
}
#endif

#ifdef ENTRYPOINT_PixT1
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
void main()
{ 
	vec4 SpecMap = vec4(1.0,1.0,1.0,1.0);
#ifdef USE_SPEC 
    SpecMap = texture2D(g_sSamplerOne, VOutTexCoord0.xy); 
#endif

	vec4 texel = texture2D(g_sSamplerZero, VOutTexCoord0.xy); 
    gl_FragColor.rgb = texel.rgb * VOutColor0.rgb + VOutColor1.rgb*SpecMap.rgb;
    gl_FragColor.a = texel.a * VOutColor0.a;
}
#endif

#ifdef ENTRYPOINT_PixT2
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
void main()
{ 
    vec4 texel0 = texture2D( g_sSamplerZero, VOutTexCoord0 );
    vec4 texel1 = texture2D( g_sSamplerOne, VOutTexCoord1 );
    gl_FragColor.rgb = (texel0.rgb + (texel1.rgb * 0.6)) * VOutColor0.rgb + VOutColor1.rgb;
    gl_FragColor.a = texel0.a * texel1.a * VOutColor0.a;
}
#endif

#ifdef ENTRYPOINT_PixDecalT2
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
void main()
{ 
	// Sample textures: original, fractured, and decal map
	vec4 	clrOrig 	= texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	vec4	clrBroken 	= texture2D(g_sSamplerOne, VOutTexCoord0.xy);
	float	clrD		= texture2D(g_sSamplerTwo, VOutTexCoord1.xy).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
	
	// Modulate	
    vec4 texelTotal = mix(clrBroken, clrOrig, 0.5f + clrD);
	
    gl_FragColor.rgb = texelTotal.rgb * VOutColor0.rgb + VOutColor1.rgb;
    gl_FragColor.a = texelTotal.a * VOutColor0.a;
}
#endif

#ifdef ENTRYPOINT_PixShadowDecalT2
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;

void main()
{
    #ifdef HKG_SHADOWS_VSM 
		float lightAmount = getLightAmountVSM( VOutTexCoord4, VOutTexCoord5.xyz );
 	#else
		float lightAmount = getLightAmountSM( VOutTexCoord4 ); 
	#endif
	
	// Sample textures: original, fractured, and decal map
	vec4 	clrOrig 	= texture2D(g_sSamplerOne, VOutTexCoord0.xy);
	vec4	clrBroken 	= texture2D(g_sSamplerTwo, VOutTexCoord0.xy);
	float	clrD		= texture2D(g_sSamplerThree, VOutTexCoord1.xy).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
	
	// Modulate	
    vec4 texelTotal = mix(clrBroken, clrOrig, 0.5f + clrD);
	
    texelTotal.rgb *= VOutColor0.rgb;
	gl_FragColor.rgb = (1.0-lightAmount)*texelTotal.rgb*0.3 + lightAmount*texelTotal.rgb + lightAmount*VOutColor1.rgb;
    gl_FragColor.a = texelTotal.a * VOutColor0.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixDecorT2
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;

void main()
{ 
	// Sample textures: original and decor map
	vec4 	clrDecor 	= texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	float	clrD		= texture2D(g_sSamplerOne, VOutTexCoord1.xy).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
		
	// Apply a threshold
	clrD = (clrD > 0.0) ? 1.0 : 0.0;
	float 	alpha 	= clrDecor.a * (1.0 - clrD);
    vec4 texelTotal = vec4(clrDecor.rgb, alpha);
	
    gl_FragColor.rgb = texelTotal.rgb * VOutColor0.rgb + VOutColor1.rgb;
    gl_FragColor.a = texelTotal.a * VOutColor0.a;
}
#endif

#ifdef ENTRYPOINT_PixShadowDecorT2
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;

void main()
{
    #ifdef HKG_SHADOWS_VSM 
		float lightAmount = getLightAmountVSM( VOutTexCoord4, VOutTexCoord5.xyz );
 	#else
		float lightAmount = getLightAmountSM( VOutTexCoord4 ); 
	#endif
	
	// Sample textures: original and decor map
	vec4 	clrDecor 	= texture2D(g_sSamplerOne, VOutTexCoord0.xy);
	float	clrD		= texture2D(g_sSamplerTwo, VOutTexCoord1.xy).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
		
	// Apply a threshold
	clrD = (clrD > 0.0) ? 1.0 : 0.0;
	float 	alpha 	= clrDecor.a * (1.0 - clrD);
    vec4 texelTotal = vec4(clrDecor.rgb, alpha);
	
    texelTotal.rgb *= VOutColor0.rgb;
	gl_FragColor.rgb = (1.0-lightAmount)*texelTotal.rgb*0.3 + lightAmount*texelTotal.rgb + lightAmount*VOutColor1.rgb;
    gl_FragColor.a = texelTotal.a * VOutColor0.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
