/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//
// One diffuse map along with a normal map, with and without shadows. A common demo shader
// with 'proper' assets 
//
//:STYLE VertOneLightBump PixT1Bump LD* T1 DIFFUSE0 NORMAL0
//:STYLE VertOneLightBump PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0

//:STYLE VertOneLightBump PixT1BumpND LD* T1 NORMAL0
//:STYLE VertOneLightBump PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0

//:STYLE VertOneLightBump PixT1Bump LD* T1 DIFFUSE0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBump PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBump PixT1BumpND LD* T1 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBump PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 INSTANCED DEFINE:HKG_INSTANCING

//:STYLE VertOneLightBump PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBump PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBump PixT1BumpND LD* T1 NORMAL0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBump PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertOneLightBump PixT1Bump LD* T2 DIFFUSE0 NORMAL1 DEFINE:TWO_TCOORDS
//:STYLE VertOneLightBump PixShadowSceneT1Bump LD* T2 SHADOWMAP DIFFUSE0 NORMAL1 DEFINE:TWO_TCOORDS
//:STYLE VertOneLightBump PixT1Bump LD* T2 DIFFUSE0 NORMAL1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertOneLightBump PixShadowSceneT1Bump LD* T2 SHADOWMAP DIFFUSE0 NORMAL1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS


#include "CommonHeader.hlslh"


// extra matrices
float4x4 g_mWorldInv;
float4x4 g_mWorldView		: WorldView;
float4x4 g_mProj			: Proj;
float4x4 g_mViewInv			: ViewInverse;
 
// Vertex Shaders
#ifdef TWO_TCOORDS
vertexOutputT2B VertOneLightBump( vertexInputT2B In )
{
	vertexOutputT2B Out;
#else
vertexOutputT1B VertOneLightBump( vertexInputT1B In )
{
	vertexOutputT1B Out;
#endif


#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2;
   	//world[3] = In.transformRow3;
   	float3 worldVertPos = mul(world , float4(In.position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
			toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
}
	float3 lightVec = mul( toLight0, (float3x3)world ); 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)world );  // rev mult order 
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = mul(eyeVec, (float3x3) world );  // transform back to object space	
	
	float3 normal =  In.normal;
	
#else

    float3 position = In.position.xyz;
    float3 normal = In.normal;
    
#ifdef HKG_SKINNING   
    float blendWeightsArray[4] = (float[4])In.blendWeights;    
	#if defined(HKG_DX10)
		int   indexArray[4] = (int[4])In.blendIndices;    
	#else
		int4  indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
		int   indexArray[4] = (int[4])indexVector;    
	#endif
    skinPositionNormal( In.position.xyz, In.normal.xyz, blendWeightsArray, indexArray, position, normal );     
#endif 

	float3 worldVertPos = mul(float4(position, 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);	
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
		toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
	float3 lightVec = mul( toLight0, (float3x3)g_mWorldInv ); 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)g_mWorldInv ).xyz;  
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = mul(eyeVec, (float3x3) g_mWorldInv );  // transform back to object space
	
#endif

	
	// transform position to clip space
	Out.position = mul( viewPos, g_mProj);
  
	// compute the 3x3 tranform from object space to tangent space
	float3x3 objToTangentSpace;
	float bumpHeight = 1.0f;
	objToTangentSpace[0] = In.tangent * bumpHeight;
	objToTangentSpace[1] = In.binormal * bumpHeight;
	objToTangentSpace[2] = normal;
	
    // light vector
	Out.toLightDir0TS = mul( objToTangentSpace, lightVec ).xyz; // transform from object to tangent space
	Out.toLightDir1TS = 0;
	if (g_iNumLights > 1)
	{
		Out.toLightDir1TS = mul( objToTangentSpace, lightVec1 ).xyz; // transform from object to tangent space
	}

	// eye vector
	Out.eyeDirTS = mul( objToTangentSpace, eyeVec );
	Out.posView = viewPos.xyz;
	
		// copy texture coordinates
#ifdef TWO_TCOORDS
    Out.texCoord01.xy = In.texCoord0.xy;
	Out.texCoord01.zw = In.texCoord1.xy;
#else
	Out.texCoord0 = In.texCoord0;
#endif
	
	return Out;
}


	
//////////////////////////////////////////////////////////////////
//
// Pixel Shaders
//


// Pixel shaders
#ifdef TWO_TCOORDS
pixelOutput PixT1Bump( vertexOutputT2B In )
{
#else
pixelOutput PixT1Bump( vertexOutputT1B In )
{
#endif

	float4 ColorMap = float4(1,1,1,1);
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP
	#ifdef TWO_TCOORDS
		 ColorMap = _sample0( In.texCoord01.xy);
	#else
		 ColorMap = _sample0( In.texCoord0.xy);
	#endif	
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		#ifdef TWO_TCOORDS
			N = _sample1(In.texCoord01.zw).xyz*2.0 - 1.0;
		#else
			N = _sample1(In.texCoord0.xy).xyz*2.0 - 1.0;
		#endif
		N = normalize(N);
	#endif
#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	Output.color.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}

// Pixel shaders
pixelOutput PixT1BumpND( vertexOutputT1B In )
{

	float4 ColorMap = g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float3 N = float3(0,0,1); 
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample0(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#endif
#endif
	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	Output.color.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}
 
#ifdef TWO_TCOORDS
pixelOutput PixShadowSceneT1Bump( vertexOutputT2B In )
{
#else
pixelOutput PixShadowSceneT1Bump( vertexOutputT1B In )
{
#endif
	pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
		
	float4 ColorMap = float4(1,1,1,1);
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP
	#ifdef TWO_TCOORDS
		ColorMap = _sample4(In.texCoord01.xy);
	#else
		ColorMap = _sample4(In.texCoord0);
	#endif
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		#ifdef TWO_TCOORDS
			N = _sample5(In.texCoord01.zw).xyz*2.0 - 1.0;
		#else
			N = _sample5(In.texCoord0).xyz*2.0 - 1.0;
		#endif	
		N = normalize(N);
	#endif
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixShadowSceneT1BumpND( vertexOutputT1B In )
{
	pixelOutput Output;
    
    float lightAmount = getLightAmountShadow( In.posView );
    	
	float4 ColorMap = g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float3 N = float3(0,0,1); 
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample4(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#endif
#endif

	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
