/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//:STYLE VertOneLightDoubleBumpT2 PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0
//:STYLE VertOneLightDoubleBumpT2 PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0
//:STYLE VertOneLightDoubleBumpT2 PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1
//:STYLE VertOneLightDoubleBumpT2 PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1

//:STYLE VertOneLightDoubleBumpT2 PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightDoubleBumpT2 PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightDoubleBumpT2 PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightDoubleBumpT2 PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertOneLightDoubleBumpT2 PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightDoubleBumpT2 PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightDoubleBumpT2 PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightDoubleBumpT2 PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 INSTANCED DEFINE:HKG_INSTANCING



#include "CommonHeader.hlslh"

// Matrices
float4x4 g_mWorldInv;
float4x4 g_mWorldView		: WorldView;
float4x4 g_mProj			: Proj;
float4x4 g_mViewInv			: ViewInverse;


// Vertex Shaders
vertexOutputT2B VertOneLightDoubleBumpT2( vertexInputT2B In )
{
	vertexOutputT2B Out;

	    
#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2;
   	//world[3] = In.transformRow3;
   	float3 worldVertPos = mul(world , float4(In.position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
			toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
	float3 lightVec = mul( toLight0, (float3x3)world ); 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)world );  // rev mult order 
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = mul(eyeVec, (float3x3) world );  // transform back to object space
	
    float3 normal = In.normal;

#else
	
	float3 position = In.position.xyz;
    float3 normal = In.normal;

#ifdef HKG_SKINNING   
    float blendWeightsArray[4] = (float[4])In.blendWeights;    
	#if defined(HKG_DX10)
		int   indexArray[4] = (int[4])In.blendIndices;    
	#else
		int4  indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
		int   indexArray[4] = (int[4])indexVector;    
	#endif
    skinPositionNormal( In.position, In.normal, blendWeightsArray, indexArray, position, normal );     
#endif 

	float3 worldVertPos = mul(float4(position , 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
		toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
	float3 lightVec = mul( toLight0, (float3x3)g_mWorldInv ); float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)g_mWorldInv );  
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = mul(eyeVec, (float3x3) g_mWorldInv );  // transform back to object space
	
#endif
	
	// copy texture coordinates
    Out.texCoord01.xy = In.texCoord0;
	Out.texCoord01.zw = In.texCoord1;
	
	// transform position to clip space
	Out.position = mul( viewPos, g_mProj);
	
	// compute the 3x3 tranform from object space to tangent space
	float3x3 objToTangentSpace;
	float bumpHeight = 1.0f;
	objToTangentSpace[0] = In.tangent * bumpHeight;
	objToTangentSpace[1] = In.binormal * bumpHeight;
	objToTangentSpace[2] = normal;
	
    // light vector
	Out.toLightDir0TS = mul( objToTangentSpace, lightVec ).xyz; // transform from object to tangent space
	Out.toLightDir1TS = 0;
	if (g_iNumLights > 1)
	{
		Out.toLightDir1TS = mul( objToTangentSpace, lightVec1 ).xyz; // transform from object to tangent space
	}

	// eye vector
	Out.eyeDirTS = mul( objToTangentSpace, eyeVec );
	Out.posView = viewPos.xyz;

	return Out;
}




// Pixel Shaders

// Pixel shaders
pixelOutput PixT2DoubleBump( vertexOutputT2B In )
{
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP
    ColorMap = _sample0(In.texCoord01.xy);
#endif
	
#if ENABLE_NORMAL_MAP
	float3 N0 = _sample1(In.texCoord01.xy).xyz*4.0 - 2.0;
	float3 N1 = _sample2(In.texCoord01.zw).xyz*2.0 - 1.0;
	N = normalize(N0+N1);
#endif

#if ENABLE_SPEC_MAP
	SpecMap *= _sample3(In.texCoord01.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;

	pixelOutput Output;	
	Output.color.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap;

	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;
    
	return Output; 
}

pixelOutput PixT2DoubleBumpNS( vertexOutputT2B In )
{
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP
    ColorMap = _sample0(In.texCoord01.xy);
#endif
	
#if ENABLE_NORMAL_MAP
	float3 N0 = _sample1( In.texCoord01.xy).xyz*4.0 - 2.0;
	float3 N1 = _sample2( In.texCoord01.zw).xyz*2.0 - 1.0;
	N = normalize(N0+N1);
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;

	pixelOutput Output;
	Output.color.rgb = negLight.rgb*g_cAmbientColor.rgb*ColorMap.rgb + totalLight.rgb*ColorMap.rgb + light0.www*g_cSpecularColor.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}


pixelOutput PixShadowSceneT2DoubleBump( vertexOutputT2B In )
{
    pixelOutput Output;
    
  float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord01.xy);
#endif
		
#if ENABLE_NORMAL_MAP
	float3 N0 = _sample5(In.texCoord01.xy).xyz*4.0 - 2.0;
	float3 N1 = _sample6(In.texCoord01.zw).xyz*2.0 - 1.0;
	N = normalize(N0+N1);
#endif

#if ENABLE_SPEC_MAP
	SpecMap *= _sample7(In.texCoord01.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);

	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}


pixelOutput PixShadowSceneT2DoubleBumpNS( vertexOutputT2B In )
{
    pixelOutput Output;
    
  float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord01.xy);
#endif
		
#if ENABLE_NORMAL_MAP
	float3 N0 = _sample5( In.texCoord01.xy).xyz*4.0 - 2.0;
	float3 N1 = _sample6( In.texCoord01.zw).xyz*2.0 - 1.0;
	N = normalize(N0+N1);
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
