/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertOneLightBumpT1 PixT1BumpND LD* T1 NORMAL0 SPECULAR0 
//:STYLE VertOneLightBumpT1 PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0
//:STYLE VertOneLightBumpT1 PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0
//:STYLE VertOneLightBumpT2 PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0
//:STYLE VertOneLightBumpT1 PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 DEFINE:DECAL DEFINE:NO_SPEC
//:STYLE VertOneLightBumpT2 PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 
//:STYLE VertOneLightBumpT1 PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 DEFINE:DECAL
//:STYLE VertOneLightBumpT2 PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0
//:STYLE VertOneLightBumpT2 PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0
//:STYLE VertOneLightBumpT2 PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0
//:STYLE VertOneLightBumpT1 PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 SPECULAR0
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 DEFINE:DECAL DEFINE:NO_SPEC
//:STYLE VertOneLightBumpT2 PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 DEFINE:DECAL
//:STYLE VertOneLightBumpT2 PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0
//:STYLE VertOneLightBumpT2 PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0
//:STYLE VertOneLightBumpT2 PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0
//:STYLE VertOneLightBumpT2 PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0

//:STYLE VertOneLightBumpT1 PixT1BumpND LD* T1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT1 PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT1 PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT2 PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT1 PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SKINNED DEFINE:HKG_SKINNING DEFINE:DECAL DEFINE:NO_SPEC
//:STYLE VertOneLightBumpT2 PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT1 PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:DECAL 
//:STYLE VertOneLightBumpT2 PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT2 PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT2 PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SKINNED DEFINE:HKG_SKINNING DEFINE:DECAL DEFINE:NO_SPEC 
//:STYLE VertOneLightBumpT2 PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:DECAL 
//:STYLE VertOneLightBumpT2 PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT2 PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT2 PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT2 PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING


//:STYLE VertOneLightBumpT1 PixT1BumpND LD* T1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT1 PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT1 PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT2 PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT1 PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:DECAL DEFINE:NO_SPEC
//:STYLE VertOneLightBumpT2 PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT1 PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:DECAL 
//:STYLE VertOneLightBumpT2 PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT2 PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT2 PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:DECAL DEFINE:NO_SPEC 
//:STYLE VertOneLightBumpT2 PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT1 PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:DECAL 
//:STYLE VertOneLightBumpT2 PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT2 PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT2 PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT2 PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING


#include "CommonHeader.hlslh"
#include "CommonSampleHeader.hlslh"

// Matrices
float4x4 g_mWorldInv;
float4x4 g_mWorldView		: WorldView;
float4x4 g_mProj			: Proj;
float4x4 g_mViewInv			: ViewInverse;

// Vertex Shaders
vertexOutputT2B VertOneLightBumpT2( vertexInputT2B In )
{
	vertexOutputT2B Out;

#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2;
   	//world[3] = In.transformRow3;
   	float3 worldVertPos = mul(world , float4(In.position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
		toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
	float3 lightVec = mul( toLight0, (float3x3)world ); 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)world );  // rev mult order 
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = mul(eyeVec, (float3x3) world );  // transform back to object space
	
    float3 normal = In.normal;

#else
	
	float3 position = In.position.xyz;
    float3 normal = In.normal;

#ifdef HKG_SKINNING   
    float blendWeightsArray[4] = (float[4])In.blendWeights;    
	#if defined(HKG_DX10)
		int   indexArray[4] = (int[4])In.blendIndices;    
	#else
		int4  indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
		int   indexArray[4] = (int[4])indexVector;    
	#endif
    skinPositionNormal( In.position.xyz, In.normal.xyz, blendWeightsArray, indexArray, position, normal );     
#endif 

	float3 worldVertPos = mul(float4(position, 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
		toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
	float3 lightVec = mul( toLight0, (float3x3)g_mWorldInv ); 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)g_mWorldInv );  
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = mul(eyeVec, (float3x3) g_mWorldInv );  // transform back to object space	
#endif
	
	// copy texture coordinates
	    
    Out.texCoord01.xy = In.texCoord0.xy;
	Out.texCoord01.zw = In.texCoord1.xy;
	
	// transform position to clip space
	Out.position = mul( viewPos, g_mProj);
   
	// compute the 3x3 tranform from object space to tangent space
	float3x3 objToTangentSpace;
	float bumpHeight = 1.0f;
	objToTangentSpace[0] = In.tangent * bumpHeight;
	objToTangentSpace[1] = In.binormal * bumpHeight;
	objToTangentSpace[2] = normal;
	
    // light vector
	Out.toLightDir0TS = mul( objToTangentSpace, lightVec ).xyz; // transform from object to tangent space
	Out.toLightDir1TS = 0;
	if (g_iNumLights > 1)
	{
		Out.toLightDir1TS = mul( objToTangentSpace, lightVec1 ).xyz; // transform from object to tangent space
	}

	// eye vector
	Out.eyeDirTS = mul( objToTangentSpace, eyeVec );
	Out.posView = viewPos.xyz;

	return Out;
}

vertexOutputT1B VertOneLightBumpT1( vertexInputT1B In )
{
	vertexOutputT1B Out;

#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2;
   	//world[3] = In.transformRow3;
   	float3 worldVertPos = mul(world , float4(In.position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
		toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
	float3 lightVec = mul( toLight0, (float3x3)world );  // rev mult order 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)world );  // rev mult order 
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = mul(eyeVec, (float3x3) world );  // transform back to object space
	
    float3 normal = In.normal;

#else
	
	float3 position = In.position.xyz;
    float3 normal = In.normal;

#if HKG_SKINNING
    float blendWeightsArray[4] = (float[4])In.blendWeights;    
	#if defined(HKG_DX10)
		int   indexArray[4] = (int[4])In.blendIndices;    
	#else
		int4  indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
		int   indexArray[4] = (int[4])indexVector;    
	#endif
    skinPositionNormal( In.position.xyz, In.normal.xyz, blendWeightsArray, indexArray, position, normal );     
#endif

	float3 worldVertPos = mul(float4(position, 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
		toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
	float3 lightVec = mul( toLight0, (float3x3)g_mWorldInv ); 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)g_mWorldInv );
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = mul(eyeVec, (float3x3) g_mWorldInv );  // transform back to object space
#endif

	
	// copy texture coordinates
	    
    Out.texCoord0 = In.texCoord0;
	
	// transform position to clip space
    Out.position = mul( viewPos, g_mProj);
   
	// compute the 3x3 tranform from object space to tangent space
	float3x3 objToTangentSpace;
	float bumpHeight = 1.0f;
	objToTangentSpace[0] = In.tangent * bumpHeight;
	objToTangentSpace[1] = In.binormal * bumpHeight;
	objToTangentSpace[2] = normal;
	
    // light vector
	Out.toLightDir0TS = mul( objToTangentSpace, lightVec ).xyz; // transform from object to tangent space
	Out.toLightDir1TS = 0;
	if (g_iNumLights > 1)
	{
		Out.toLightDir1TS = mul( objToTangentSpace, lightVec1 ).xyz; // transform from object to tangent space
	}

	// eye vector
	Out.eyeDirTS = mul( objToTangentSpace, eyeVec );
	Out.posView = viewPos.xyz;

	return Out;
}
// Pixel Shaders

// Pixel shaders
pixelOutput PixT2Bump( vertexOutputT2B In )
{
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample0(In.texCoord01.xy);
#endif

#if ENABLE_DIFFUSE_MAP1
	#if ENABLE_DIFFUSE_MAP0
		ColorMap = ColorMap + (_sample1(In.texCoord01.zw) * 0.6);
	#else
		ColorMap = _sample1(In.texCoord01.zw);
	#endif
#endif
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample2( In.texCoord01.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample2(In.texCoord01.xy);
	#endif
#endif

#ifndef NO_SPEC
	SpecMap *= _sample3( In.texCoord01.xy).rgb;
#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	Output.color.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
	}

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}


// Pixel shaders
pixelOutput PixT2BumpLM( vertexOutputT2B In )
{
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 LightMap = float3(1,1,1);
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample0( In.texCoord01.xy);
#endif

#if ENABLE_LIGHT_MAP
	LightMap = _sample1( In.texCoord01.zw).rgb;
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample2(In.texCoord01.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample2(In.texCoord01.xy);
	#endif
#endif

#ifndef NO_SPEC
	SpecMap *= _sample3(In.texCoord01.xy).rgb;
#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );


	// Green == 59% of the perceived luminosity, while the red and blue channels account for just 30% and 11%
	float luminosity = (LightMap.r*0.33 + LightMap.g*0.59 + LightMap.b*0.11);
	luminosity = saturate( luminosity );
	
	float lightMapShadow = 1 - (luminosity * 0.5); // 1 when in dark areas
	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	light0 *= luminosity;
	
	pixelOutput Output;
	Output.color.rgb = (1-lightMapShadow)*ColorMap.rgb*LightMap.rgb*0.3 + lightMapShadow*ColorMap.rgb*LightMap.rgb + (light0.www*lightMapShadow*SpecMap.rgb);
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}
 
 // Pixel shaders
pixelOutput PixT1Bump( vertexOutputT1B In )
{
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = 0;
	float3 N = float3(0,0,1); 
	
    ColorMap = _sample0(In.texCoord0);
	float4 DecalMap = 1;

#ifdef DECAL

	DecalMap = _sample1(In.texCoord0);

	N = _sample2(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC
	SpecMap = _sample3(In.texCoord0).rgb * g_cSpecularColor.rgb;
#endif

#else

	N = _sample1(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC
	SpecMap = _sample2(In.texCoord0).rgb * g_cSpecularColor.rgb;
#endif
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;

	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	Output.color.rgb = (negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap) * ( DecalMap.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	//Output.color = float4(1,1,0,1);
	
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

	 return Output; 
}

 // Pixel shaders
pixelOutput PixT1BumpND( vertexOutputT1B In )
{
	float4 ColorMap = g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample0( In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap *= _sample0( In.texCoord0);
	#endif
#endif



#ifndef NO_SPEC
	SpecMap *= _sample1(In.texCoord0).rgb;
#endif

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;

	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	Output.color.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}


pixelOutput PixShadowSceneT2Bump( vertexOutputT2B In )
{
    pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord01.xy);
#endif

#if ENABLE_DIFFUSE_MAP1
	#if ENABLE_DIFFUSE_MAP0
		ColorMap = ColorMap + (_sample5(In.texCoord01.zw) * 0.6);
	#else
		ColorMap = _sample5(In.texCoord01.zw);
	#endif
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample6(In.texCoord01.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample6( In.texCoord01.xy);
	#endif
#endif

#ifndef NO_SPEC
	SpecMap *= _sample7(In.texCoord01.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output;
}


pixelOutput PixShadowSceneT1Bump( vertexOutputT1B In )
{
    pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
		
	float3 N = float3(0,0,1); 
	
    float3 SpecMap = 0;

#ifdef DECAL
	
	float4 DecalMap = _sample5(In.texCoord0);
	float4 ColorMap = _sample4(In.texCoord0);
	
	N = _sample6(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC
	SpecMap = _sample7(In.texCoord0).rgb * g_cSpecularColor.rgb;
#endif

#else
	float4 DecalMap = 1;
	float4 ColorMap = _sample4(In.texCoord0);

	N = _sample5(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC
	SpecMap = _sample6(In.texCoord0).rgb * g_cSpecularColor.rgb;
#endif

#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = ((1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap )) * DecalMap.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}


pixelOutput PixShadowSceneT1BumpND( vertexOutputT1B In )
{
    pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
			
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample4(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap *= _sample4(In.texCoord0);
	#endif
#endif

#ifndef NO_SPEC
	SpecMap *= _sample5(In.texCoord0).rgb;
#endif

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}



pixelOutput PixShadowSceneT2BumpLM( vertexOutputT2B In )
{
    pixelOutput Output;
    
	float shadowAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 LightMap = float3(1,1,1);
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord01.xy);
#endif

#if ENABLE_LIGHT_MAP
    LightMap = _sample5(In.texCoord01.zw).rgb;
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample6(In.texCoord01.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample6( In.texCoord01.xy);
	#endif
#endif

#ifndef NO_SPEC
	SpecMap *= _sample7( In.texCoord01.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	// Green == 59% of the perceived luminosity, while the red and blue channels account for just 30% and 11%
	float luminosity = (LightMap.r*0.33 + LightMap.g*0.59 + LightMap.b*0.11);
	luminosity = saturate( luminosity );
	
	float lightMapShadow = 1 - (luminosity * 0.5); // 1 when in dark areas
	shadowAmount = max( shadowAmount, lightMapShadow ); // don't have dark shadows in dark lightmap areas
	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	// Discard normal map and spec map in darker areas
	light0 *= luminosity; // don't want spec etc in dark areas
		
	Output.color.rgb = (1-shadowAmount)*ColorMap.rgb*LightMap.rgb*0.3 + shadowAmount*ColorMap.rgb*LightMap.rgb + (light0.www*SpecMap*shadowAmount);
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
   
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
