
/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//:STYLE VertVel PixVel LD* T* VELOCITY 

#include "CommonHeader.hlslh"

vertexOutputVel VertVel( vertexInputVel In)
{
	vertexOutputVel Output;
	
	float3 curWorldVertPos;
	float3 prevWorldVertPos;
	
	#ifdef HKG_INSTANCING
		
		float3x4 curWorld;
		float3x4 prevWorld;
		curWorld[0] = In.transformRow0;
		curWorld[1] = In.transformRow1;
		curWorld[2] = In.transformRow2;
		prevWorld[0] = In.prevTransformRow0;
		prevWorld[1] = In.prevTransformRow1;
		prevWorld[2] = In.prevTransformRow2;
	
		curWorldVertPos = mul(curWorld , float4(In.position, 1) );
		prevWorldVertPos = mul(prevWorld , float4(In.position, 1) );
	 
	#elif defined(HKG_SKINNING) && defined(HKG_VELOCITY_SHADER)
	
		float blendWeightsArray[4] = (float[4])In.blendWeights;    
		#ifdef HKG_DX10
			int  indexArray[4] = (int[4])In.blendIndices;
		#else
			int4 indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
			int  indexArray[4] = (int[4])indexVector;
		#endif
		
		float3 curLocalVertPos;
		float3 prevLocalVertPos;
		
		skinPosition( In.position, blendWeightsArray, indexArray, curLocalVertPos );   
		curWorldVertPos = mul( float4(curLocalVertPos, 1), g_mWorld ).xyz;
		#ifdef HKG_DX10
			skinPrevPosition( In.position, blendWeightsArray, indexArray, prevLocalVertPos );   
			prevWorldVertPos = mul( float4(prevLocalVertPos, 1), g_mPrevWorld ).xyz;
		#else // not enough constants, would need to make the mesh sections very small (<32)
			prevWorldVertPos = mul( float4(curLocalVertPos, 1), g_mPrevWorld ).xyz;
		#endif

	#else // rigid (could be CPU skinned or cloth etc thouigh, so see if it has a dynamic vb)
		
		curWorldVertPos = mul(float4(In.position,1), g_mWorld).xyz;
		
		#ifdef HKG_DYNAMIC_VB // CPU skinned or cloth etc
			prevWorldVertPos = mul(float4(In.prevPosition,1), g_mPrevWorld).xyz;
		#else
			prevWorldVertPos = mul(float4(In.position,1), g_mPrevWorld).xyz;
		#endif
	
	#endif
	
	Output.position = mul(float4(curWorldVertPos,1), g_mViewProj); 
	Output.wpCur = Output.position; //SM3.0..
	Output.wpPrev = mul(float4(prevWorldVertPos,1), g_mPrevViewProj);

	return Output;
}

float4 PixVel( vertexOutputVel In ) : SV_Target0
{
	float2 curP  = In.wpCur.xy / In.wpCur.w; 
	float2 prevP = In.wpPrev.xy / In.wpPrev.w; 
	float2 velocityXY;
	velocityXY = curP - prevP;
	velocityXY /= 2;
	
	return float4(velocityXY,0,1);
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
