
/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//:STYLE VertShadowDepth PixShadowDepth LD* T* SHADOWDEPTH 

#include "CommonHeader.hlslh"

#ifdef HKG_SHADOWS_VSM

	vertexOutputShadowDepthVSM VertShadowDepth( vertexInputShadowDepth In)
	{
		vertexOutputShadowDepthVSM Output;
		
		#ifdef HKG_INSTANCING
			float3x4 world;
   			world[0] = In.transformRow0;
   			world[1] = In.transformRow1;
   			world[2] = In.transformRow2;
   			float3 worldVertPos = mul(world , float4(In.position, 1) );
		#elif defined(HKG_SKINNING)   
			float blendWeightsArray[4] = (float[4])In.blendWeights;    
			#ifdef HKG_DX10
				int  indexArray[4] = (int[4])In.blendIndices;
			#else
				int4 indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
				int  indexArray[4] = (int[4])indexVector;
			#endif
			float3 localPosition;
			skinPosition( In.position, blendWeightsArray, indexArray, localPosition );   
			float3 worldVertPos = mul(float4(localPosition, 1), g_mWorld).xyz;
		#else // a standard obj: 
			float3 worldVertPos = mul(float4(In.position,1), g_mWorld).xyz;
		#endif
		
		Output.position = mul(float4(worldVertPos,1), g_mViewProj); // Light VP in this case
		Output.texCoord0 = In.texCoord0;
		Output.posWorld = worldVertPos;
		return Output;
	}

	float4 PixShadowDepth( vertexOutputShadowDepthVSM In ) : SV_Target0
	{
	    #ifdef HKG_ALPHATEST_SHADOWS
	    if (g_iDepthParams.g > 0)
	    {
			float4 tex = _sample0( In.texCoord0 );
			clip(tex.a - 0.25); // will be neg for <25 and will discard pixel
	    }
	    #endif
	    
		float4 depth;
		if (lightZeroIsDirectional()) // projected dist
		{
			float3 lightDir = g_vLightShadowStartPosWorld.xyz - In.posWorld.xyz;
			depth.x = dot(lightDir.xyz,g_vLightDir.xyz) / g_fShadowMapDistance; 
		}
		else
		{
			float3 lightDir = g_vLightPos.xyz - In.posWorld.xyz;
			depth.x = length(lightDir.xyz) / g_fShadowMapDistance; 
		}		
		depth.y = depth.x * depth.x;
		
		#ifdef HKG_SHADOWS_DISTRIBUTE_16F_OUTPUTS 
			depth.ba = frac(depth.rg * SHADOW_16F_DISTRIBUTE_FACTOR);
			depth.rg = depth.rg - (depth.ba / SHADOW_16F_DISTRIBUTE_FACTOR);
		#else
			depth.ba = depth.rg;
		#endif
		
		return depth;
	}
	
#else

	// Vertex transform only, with tcoord0 the enough to work out the transformed depth (no bias)
	vertexOutputShadowDepth VertShadowDepth( vertexInputShadowDepth In)
	{
		vertexOutputShadowDepth Output;
		#ifdef HKG_INSTANCING
			float3x4 world;
   			world[0] = In.transformRow0;
   			world[1] = In.transformRow1;
   			world[2] = In.transformRow2;
   			float3 worldVertPos = mul(world , float4(In.position, 1) );
		#elif defined(HKG_SKINNING)   
			float blendWeightsArray[4] = (float[4])In.blendWeights;    
			#ifdef HKG_DX10
				int  indexArray[4] = (int[4])In.blendIndices;
			#else
				int4 indexVector = D3DCOLORtoUBYTE4(In.blendIndices);
				int  indexArray[4] = (int[4])indexVector;
			#endif
			float3 localPosition;
			skinPosition( In.position, blendWeightsArray, indexArray, localPosition );   
			float3 worldVertPos = mul(float4(localPosition, 1), g_mWorld ).xyz;
		#else // a standard obj: 
			float3 worldVertPos = mul(float4(In.position,1), g_mWorld).xyz;
		#endif
			
		Output.position = mul(float4(worldVertPos,1), g_mViewProj); // Light VP in this case
		Output.depthZZZW = float4(Output.position.zzz, Output.position.w);
		Output.texCoord0 = In.texCoord0;
		
		return Output;
	}
	
	float4 PixShadowDepth( vertexOutputShadowDepth In ) : SV_Target0
	{
		#ifdef HKG_ALPHATEST_SHADOWS
	    if (g_iDepthParams.g)
	    {
			float4 tex = _sample0( In.texCoord0 );
			clip( tex.a - 0.25 );
	    }
	    #endif
	    
		float depth = (In.depthZZZW.b / In.depthZZZW.a);
		return float4( depth.xxx, 1.0f );
	}

#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
