/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

//:STYLE VertShadowDepth PixShadowDepth LD* T* SHADOWDEPTH 

#pragma include("CommonHeader.glslh")

#ifdef HKG_SHADOWS_VSM

	#ifdef ENTRYPOINT_VertShadowDepth
	attribute HIGHP vec4 InPosition;  
	#ifdef ENABLE_ALPHA_SHADOWS
		attribute HIGHP vec2 InTexCoord0;
		varying HIGHP vec2 VOutTexCoord0;
	#endif
	varying HIGHP vec3 VOutTexCoord1;
	
	void main()
	{
		vec4 worldVertPos = g_mWorld * vec4(InPosition.xyz,1);
		gl_Position = g_mViewProj * worldVertPos; // Light VP in this case
		#ifdef ENABLE_ALPHA_SHADOWS
			 VOutTexCoord0 = InTexCoord0;
		#endif
		VOutTexCoord1.xyz = worldVertPos.xyz;
	}
	#endif

	#ifdef ENTRYPOINT_PixShadowDepth
	#ifdef ENABLE_ALPHA_SHADOWS
		varying HIGHP vec2 VOutTexCoord0;
	#endif
	varying HIGHP vec3 VOutTexCoord1;
	void main()
	{
	    #ifdef ENABLE_ALPHA_SHADOWS
	    if (g_fShadowMapDistance < 100.0)
	    {
			vec4 tex = texture2D( g_sSamplerZero,  VOutTexCoord0 );
			if (tex.a < 0.75)
				discard;
	    }
	    #endif
	    
		vec4 depth;
		vec3 lightDir = g_vLightShadowStartPos - VOutTexCoord1;
		depth.x = dot(lightDir,g_vLightDir) / g_fShadowMapDistance; 
		depth.y = depth.x * depth.x;
		#ifdef HKG_SHADOWS_DISTRIBUTE_16F_OUTPUTS 
			depth.zw = fract(depth.xy * SHADOW_16F_DISTRIBUTE_FACTOR);
			depth.xy = depth.xy - (depth.zw / SHADOW_16F_DISTRIBUTE_FACTOR);
		#else
			depth.zw = depth.xy;
		#endif
		
		gl_FragColor = depth;
	}
	#endif
	
#else

	// Vertex transform only, with tcoord0 the enough to work out the transformed depth (no bias)
	#ifdef ENTRYPOINT_VertShadowDepth
	attribute HIGHP vec4 InPosition;  
	#ifdef ENABLE_ALPHA_SHADOWS
		attribute HIGHP vec2 InTexCoord0;
		varying HIGHP vec2 VOutTexCoord0;
	#endif
	varying HIGHP vec4 VOutTexCoord1;
	void main()
	{
		vec4 pos = g_mWorldViewProj * vec4(InPosition.xyz,1.0); // Light WVP in this case
		gl_Position = pos;
		VOutTexCoord1 = vec4(pos.zzz, pos.w);
		#ifdef ENABLE_ALPHA_SHADOWS
			VOutTexCoord0 = InTexCoord0;
		#endif
	}
	#endif
	
	#ifdef ENTRYPOINT_PixShadowDepth
	#ifdef ENABLE_ALPHA_SHADOWS
		varying HIGHP vec2 VOutTexCoord0;
	#endif
	varying HIGHP vec4 VOutTexCoord1;
	void main()
	{
		#ifdef ENABLE_ALPHA_SHADOWS
	    if (g_fShadowMapDistance < 100.0)
	    {
			vec4 tex = texture2D( g_sSamplerZero, VOutTexCoord0.xy );
			if (tex.a < 0.75)
				discard;
	    }
	    #endif
	    
		float depth = (VOutTexCoord1.r / VOutTexCoord1.a);
		gl_FragColor = vec4( depth, depth, depth, 1.0 );
	}
	#endif
	
#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
