/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */
//ver 120 needed for mat4->mat3 casts

#ifdef HKG_OGLES2
#	define LOWP lowp
#	define MEDIUMP mediump
#	define HIGHP highp
precision mediump int;
precision highp float;

#else
#	define LOWP 
#	define MEDIUMP 
#	define HIGHP 
#endif

#define SHADOW_EPSILON 0.0001
#define SHADOW_VSM_EPSILON 0.001
#define SHADOW_VSM_BIAS   0.0001 

//
// Matrices
//
uniform HIGHP mat4 g_mWorld;			
uniform HIGHP mat4 g_mWorldInv;
uniform HIGHP mat4 g_mWorldView;
uniform HIGHP mat4 g_mProj;
uniform HIGHP mat4 g_mView;
uniform HIGHP mat4 g_mViewProj;
uniform HIGHP mat4 g_mWorldViewProj;
uniform HIGHP mat4 g_mWorldInvTranspose;
uniform HIGHP mat4 g_mViewInv;
uniform HIGHP mat4 g_mViewToLightProj; 

 
//
// Textures, set assignment so that the behaviour is the same no mater what shader is using it 
//
//semantic g_sSamplerZero : TEXUNIT0
//semantic g_sSamplerOne  : TEXUNIT1
//semantic g_sSamplerTwo  : TEXUNIT2

uniform sampler2D g_sSamplerZero;    // Shadow Map, or T0
uniform sampler2D g_sSamplerOne;     // T0 if shadows, otherwise T1
uniform sampler2D g_sSamplerTwo; // T1 if shadows

//
// Lights 
//
uniform HIGHP   vec3   g_vLightShadowStartPos; 
uniform MEDIUMP vec3   g_vLightDir;
uniform MEDIUMP vec3   g_cLightColor;

// 
// Material
//
uniform MEDIUMP vec4   g_cAmbientColor;	
uniform MEDIUMP vec4   g_cDiffuseColor;
uniform MEDIUMP vec4   g_cSpecularColor;
uniform MEDIUMP float  g_cSpecularPower;

uniform MEDIUMP float  g_iShadowMapSize;
uniform HIGHP   float  g_fShadowMapDistance; 
uniform MEDIUMP float  g_fShadowVsmEpsilon; 
uniform MEDIUMP float  g_fShadowVsmBias;   
uniform HIGHP   vec4   g_iVertexParams;

//////////////////////////////////////////////////////////////
// 
// Vertex Shaders
//


 
// No lighting, just transform and pass on texture (and material as diffuse)
#ifdef ENTRYPOINT_VertNoLight
attribute HIGHP vec4 InPosition;  
attribute MEDIUMP vec2 InTexCoord0;
attribute MEDIUMP vec2 InTexCoord1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{
    gl_Position = g_mWorldViewProj * vec4(InPosition.xyz , 1.0);
    VOutColor0 = g_cDiffuseColor;
    VOutTexCoord0 = InTexCoord0.xy;
	VOutTexCoord1 = InTexCoord1.xy;
	VOutColor1 = vec4(0,0,0,0);
}
#endif

// No lighting, just transform and pass on texture (and material as diffuse)
#ifdef ENTRYPOINT_VertNoLightShadowProj
attribute vec4 InPosition;  
attribute vec2 InTexCoord0;
attribute vec2 InTexCoord1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord2;
#ifdef HKG_SHADOWS_VSM
	varying HIGHP vec3 VOutTexCoord3;
#endif
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{
    vec4 viewPos =  g_mWorldView * vec4(InPosition.xyz, 1.0);
    gl_Position = g_mProj * viewPos;
    VOutColor0 = g_cDiffuseColor;
    VOutTexCoord0 = InTexCoord0.xy;
    VOutTexCoord1 = InTexCoord1.xy;
    VOutColor1 = vec4(0,0,0,0);
    
    	// project pos into light space
    VOutTexCoord2 = g_mViewToLightProj * viewPos;

    #ifdef HKG_SHADOWS_VSM
           VOutTexCoord3 = ( g_mWorld * vec4(InPosition.xyz, 1.0) ).xyz;
	#endif
  
}
#endif

// No lighting, just transform and pass on texture (and vertex color as diffuse)
#ifdef ENTRYPOINT_VertNoLightVC
attribute vec4 InPosition;  
attribute vec2 InTexCoord0;
attribute vec2 InTexCoord1;
attribute vec4 InColor;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{
    gl_Position = g_mWorldViewProj * vec4(InPosition.xyz , 1.0);
	VOutColor0 = InColor;
    VOutTexCoord0 = InTexCoord0.xy;
	VOutTexCoord1 = InTexCoord1.xy;
	VOutColor1 = vec4(0,0,0,0);
 
}
#endif

// No lighting, just transform and pass on texture (and vertex color as diffuse)
// but with transformed view pos wrt shadow map too (for prelit shadow recvs in the scene)
#ifdef ENTRYPOINT_VertNoLightVCShadowProj
attribute vec4 InPosition;  
attribute vec2 InTexCoord0;
attribute vec2 InTexCoord1;
attribute vec4 InColor;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord2;
#ifdef HKG_SHADOWS_VSM
	varying HIGHP vec3 VOutTexCoord3;
#endif
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{
    vec4 viewPos =  g_mWorldView * vec4(InPosition.xyz, 1.0);
    
    gl_Position = g_mProj * viewPos;
    VOutTexCoord0 = InTexCoord0.xy;
    VOutTexCoord1 = InTexCoord1.xy;
    
	// project pos into light space
    VOutTexCoord2 =  g_mViewToLightProj * viewPos;
    
    #ifdef HKG_SHADOWS_VSM
        VOutTexCoord3 =  ( g_mWorld * vec4(InPosition.xyz, 1.0) ).xyz;
	#endif
  
    VOutColor0 = InColor;
    VOutColor1 = vec4(0,0,0,0);

}
#endif

vec4 LightVertex( vec3 vert, vec3 objectNormal, vec3 eye )
{
	if (g_iVertexParams.x == 4.0)
	{
		objectNormal *= 2.0;
		objectNormal -= 1.0;
	}

	vec3 N = normalize( mat3(g_mWorldInvTranspose) * objectNormal ); //normal vector
    vec3 E = normalize( eye - vert ); //eye vector
    vec3 L = g_vLightDir.xyz; //light vector
    vec3 H = normalize( E + L ); //half angle vector

	//calculate the diffuse and specular contributions
    float  diff = max(0.0, dot(N,L));
    float  spec = pow( max(0.0 , dot(N,H) ), g_cSpecularPower);
    if (diff <= 0.0)
    {
		spec = 0.0;
    }
	return vec4( diff, diff, diff, spec );
}

void MaterialContribution( vec4 vertexColor, vec4 lightDiffuseAndSpec, out vec4 diff, out vec4 spec )
{
	vec3 ambColor = vertexColor.rgb * g_cDiffuseColor.rgb * g_cAmbientColor.rgb;
    vec3 diffColor = vertexColor.rgb * g_cDiffuseColor.rgb * lightDiffuseAndSpec.rgb * g_cLightColor.rgb;
    
    diff.rgb = diffColor.rgb + ambColor.rgb;
    diff.a = vertexColor.a * g_cDiffuseColor.a; 
    
	spec.rgb = g_cSpecularColor.rgb * g_cLightColor.rgb * lightDiffuseAndSpec.w;
    spec.a = 0.0;
}

// Vertex based lighting (with specular)
#ifdef ENTRYPOINT_VertOneLight
attribute vec4 InPosition;  
attribute vec3 InNormal;
attribute vec2 InTexCoord0;
attribute vec2 InTexCoord1;

varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;

void main() 
{
    gl_Position = g_mWorldViewProj * vec4(InPosition.xyz , 1.0);
    VOutTexCoord0 = InTexCoord0.xy;
	VOutTexCoord1 = InTexCoord1.xy;

	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
    vec3 worldVertPos = ( g_mWorld * vec4(InPosition.xyz,1) ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	MaterialContribution(vec4(1,1,1,1), light, VOutColor0, VOutColor1);
	
}
#endif

// Vertex based lighting (with specular), also projects the position into the shadow map space
#ifdef ENTRYPOINT_VertOneLightShadowProj
attribute vec4 InPosition;  
attribute vec3 InNormal;
attribute vec2 InTexCoord0;
attribute vec2 InTexCoord1;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord2;
#ifdef HKG_SHADOWS_VSM
	varying HIGHP vec3 VOutTexCoord3;
#endif
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{
    vec4 viewPos = g_mWorldView * vec4(InPosition.xyz, 1.0);
    
    gl_Position = g_mProj * viewPos;
    VOutTexCoord0 = InTexCoord0.xy;
    VOutTexCoord1 = InTexCoord1.xy;
    
	// project pos into light space
    VOutTexCoord2 = g_mViewToLightProj * viewPos;
    
     #ifdef HKG_SHADOWS_VSM
          VOutTexCoord3 =  ( g_mWorld * vec4(InPosition.xyz, 1.0) ).xyz;
	#endif
  
    // Lighting:
    
	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
    vec3 worldVertPos = ( g_mWorld * vec4(InPosition.xyz,1) ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	MaterialContribution(vec4(1,1,1,1), light, VOutColor0, VOutColor1);
	
}
#endif

// Vertex based lighting (with specular)
#ifdef ENTRYPOINT_VertOneLightVC
attribute vec4 InPosition;  
attribute vec3 InNormal;
attribute vec2 InTexCoord0;
attribute vec2 InTexCoord1;
attribute vec4 InColor;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{

    gl_Position = g_mWorldViewProj * vec4(InPosition.xyz , 1.0);
    VOutTexCoord0 = InTexCoord0.xy;
	VOutTexCoord1 = InTexCoord1.xy;

	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
    vec3 worldVertPos = ( g_mWorld * vec4(InPosition.xyz,1) ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	MaterialContribution(InColor, light, VOutColor0, VOutColor1);
	
}
#endif

// Vertex based lighting (with specular), also projects the position into the shadow map space
#ifdef ENTRYPOINT_VertOneLightVCShadowProj
attribute vec4 InPosition;  
attribute vec3 InNormal;
attribute vec2 InTexCoord0;
attribute vec2 InTexCoord1;
attribute vec4 InColor;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord2;
#ifdef HKG_SHADOWS_VSM
	varying HIGHP vec3 VOutTexCoord3;
#endif
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{

    vec4 viewPos = g_mWorldView * vec4(InPosition.xyz, 1.0);
    
    gl_Position = g_mProj * viewPos;
    VOutTexCoord0 = InTexCoord0.xy;
    VOutTexCoord1 = InTexCoord1.xy;
    
	// project pos into light space
    VOutTexCoord2 = g_mViewToLightProj * viewPos;
    
    #ifdef HKG_SHADOWS_VSM
          VOutTexCoord3 = (g_mWorld * vec4(InPosition.xyz, 1.0) ).xyz;
	#endif
  
    // Lighting:
    
	//calculate our vectors N, E, L, and H
	vec3 worldEyePos = g_mViewInv[3].xyz;
    vec3 worldVertPos = ( g_mWorld * vec4(InPosition.xyz,1) ).xyz;
	vec4 light = LightVertex(worldVertPos, InNormal, worldEyePos);
	MaterialContribution(InColor, light, VOutColor0, VOutColor1);
		
}
#endif

#ifdef ENTRYPOINT_VertOneLightBump
attribute vec4 InPosition;  
attribute vec3 InNormal;
attribute vec2 InTexCoord0;
attribute vec3 InTangent;
attribute vec3 InBinormal;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;

void main() 
{


	// copy texture coordinates
	VOutTexCoord0 = InTexCoord0.xy;
					
	// transform position to clip space
	gl_Position = g_mWorldViewProj * vec4(InPosition.xyz,1);

  
	// compute the 3x3 tranform from object space to tangent space
	vec3 tb = InTangent.xyz;
	vec3 bb = InBinormal.xyz;
	vec3 n = InNormal;
	if ((g_iVertexParams.z <= 8.0) && (g_iVertexParams.w == 0.0) ) // Need rescale on texcoord based channels using Shorts and Bytes, but not Halfs
	{
		float scale =  g_iVertexParams.x == 8.0 ? 32767.0 : 127.0;
		tb /= scale;
		bb /= scale;
		
		if (g_iVertexParams.z == 4.0)
		{
			n *= 2.0;
			n -= 1.0;
			tb -= 1.0;
			bb -= 1.0;
		}
	}	
	float bumpHeight = 1.0;
	mat3 objToTangentSpace;
	objToTangentSpace[0] = tb * bumpHeight;
	objToTangentSpace[1] = bb * bumpHeight;
	objToTangentSpace[2] = n;
	
    vec4 vertexPos = g_mWorld * vec4(InPosition.xyz, 1); // world space position

	// light vector
	vec3 lightVec = mat3(g_mWorldInv) * g_vLightDir.xyz;  // transform back to object space
	VOutTexCoord4.xyz =  lightVec * objToTangentSpace; // transform from object to tangent space
	
	// eye vector
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 eyeVec = worldEyePos - vertexPos.xyz; // world space eye vector
	eyeVec = mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	eyeVec = normalize(eyeVec);
	
	// half-angle vector
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord5.xyz = H * objToTangentSpace;	// transform to tangent space

}
#endif

// Vertex based lighting (with specular), also projects the position into the shadow map space
#ifdef ENTRYPOINT_VertOneLightBumpShadowProj
attribute vec4 InPosition;  
attribute vec3 InNormal;
attribute vec2 InTexCoord0;
attribute vec4 InColor;
attribute vec3 InTangent;
attribute vec3 InBinormal;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord2;
#ifdef HKG_SHADOWS_VSM
varying HIGHP vec3 VOutTexCoord3;
#endif
varying HIGHP vec3 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;

varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{
 
    vec4 viewPos =  g_mWorldView *  vec4(InPosition.xyz, 1.0);
    
    gl_Position = g_mProj * viewPos;
    
    VOutTexCoord0 = InTexCoord0.xy;
					
		// project pos into light space
    VOutTexCoord2 = g_mViewToLightProj * viewPos;
    
    #ifdef HKG_SHADOWS_VSM
            VOutTexCoord3 = ( g_mWorld * vec4(InPosition.xyz, 1.0) ).xyz;
    #endif
    
	// compute the 3x3 tranform from object space to tangent space
	vec3 tb = InTangent.xyz;
	vec3 bb = InBinormal.xyz;
	if ((g_iVertexParams.z <= 8.0) && (g_iVertexParams.w == 0.0) ) // Need rescale on texcoord based channels using Shorts and Bytes, but not Halfs
	{
		float scale =  g_iVertexParams.x == 8.0 ? 32767.0 : 127.0;
		tb /= scale;
		bb /= scale;
	}	
	mat3 objToTangentSpace;
	float bumpHeight = 1.0;
	objToTangentSpace[0] = tb * bumpHeight;
	objToTangentSpace[1] = bb * bumpHeight;
	objToTangentSpace[2] = InNormal;
	
    vec4 vertexPos = g_mWorld * vec4(InPosition.xyz,1); // world space position

	// light vector
	vec3 lightVec =  mat3(g_mWorldInv) * g_vLightDir.xyz;  // transform back to object space
	VOutTexCoord4.xyz = lightVec * objToTangentSpace; // transform from object to tangent space
	
	// eye vector
	vec3 worldEyePos = g_mViewInv[3].xyz;
	vec3 eyeVec = worldEyePos - vertexPos.xyz; // world space eye vector
	eyeVec = mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	eyeVec = normalize(eyeVec);
	
	// half-angle vector
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord5.xyz = H * objToTangentSpace;	// transform to tangent space

}
#endif

#ifdef HKG_SHADOWS_VSM

	#ifdef ENTRYPOINT_VertShadowDepth
	attribute vec4 InPosition;  
	varying HIGHP vec3 VOutTexCoord0;
	void main() 
	{
		vec3 worldVertPos = ( g_mWorld * vec4(InPosition.xyz,1)).xyz;
		gl_Position = g_mViewProj * vec4(worldVertPos,1); // Light VP in this case
		VOutTexCoord0 = worldVertPos;
	}
	#endif

#else

	// Vertex transform only, with tcoord0 the enough to work out the transformed depth (no bias)
	#ifdef ENTRYPOINT_VertShadowDepth
	attribute vec4 InPosition;  
	varying HIGHP vec4 VOutTexCoord0;
	void main() 
	{
		gl_Position = g_mWorldViewProj * vec4(InPosition.xyz,1); // Light WVP in this case
		VOutTexCoord0 = vec4(gl_Position.zzz, gl_Position.w);
	}
	#endif

#endif

	
//////////////////////////////////////////////////////////////////
//
// Pixel Shaders
//

// No per pixel lighting, just add the input color with the specular, no texture loookup
#ifdef ENTRYPOINT_PixT0
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{ 
    gl_FragColor = VOutColor0 + VOutColor1;
}
#endif

// No per pixel lighting, just modulate the input color with the texture and add specular (afterwards)
#ifdef ENTRYPOINT_PixT1
varying HIGHP vec2 VOutTexCoord0;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main()  
{ 
    gl_FragColor = texture2D(g_sSamplerZero, VOutTexCoord0.xy) * VOutColor0; // +VOutColor1;
}
#endif

#ifdef ENTRYPOINT_PixT2
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main() 
{ 
    gl_FragColor = texture2D(g_sSamplerZero, VOutTexCoord0.xy) * texture2D(g_sSamplerOne, VOutTexCoord1.xy) * VOutColor0 + VOutColor1;
}
#endif

#ifdef HKG_SHADOWS_VSM

	#ifdef ENTRYPOINT_PixShadowMap
	varying HIGHP vec3 VOutTexCoord0;
	void main()
	{
		vec2 depth;
		vec3 lightDir = g_vLightShadowStartPos.xyz - VOutTexCoord0;
		depth.x = dot(lightDir,g_vLightDir.xyz) / g_fShadowMapDistance; 
		depth.y = depth.x * depth.x; 
		gl_FragColor = vec4(depth.x,0,0,depth.y);
	}
	#endif
	
#else // standard shadow maps
   
	#ifdef ENTRYPOINT_PixShadowMap
	varying HIGHP vec4 VOutTexCoord0;
	void main()
	{
		float depth = (VOutTexCoord0.b / VOutTexCoord0.a);
		gl_FragColor = vec4( depth, depth, depth, 1.0 );
	}
	#endif
	
#endif


// Blinn/Phong lighting model
vec4 Phong(in vec2 dots) 
{
	float NdotL = dots.x;
	float NdotH = dots.y;
	float diffuse = max(NdotL, 0.0);
	float specular = pow(NdotH, g_cSpecularPower);
	if (NdotL <= 0.0) specular = 0.0;
	return vec4(diffuse, diffuse, diffuse, specular);
}

// Pixel shaders
#ifdef ENTRYPOINT_PixT1Bump
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;
void main()
{
	vec4 colorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	vec3 N = texture2D(g_sSamplerOne, VOutTexCoord0.xy).xyz * 2.0 - 1.0;

	N = normalize(N);

	float NdotL = dot(N, VOutTexCoord4.xyz);
	float NdotH = dot(N, VOutTexCoord5.xyz);
	vec4 light = Phong(vec2(NdotL, NdotH));
	
	gl_FragColor = vec4( g_cAmbientColor.rgb*colorMap.rgb +light.rgb*g_cDiffuseColor.rgb*colorMap.rgb + light.w*g_cSpecularColor.rgb, g_cDiffuseColor.a) ;
}
#endif
 
///
/// ATI style shadow map lookup
///


float getLightAmountNoHW( in vec4 posLight )
{
	vec2 shadowTexCoord = posLight.xy / posLight.w;
	float  shadowTestDepth = (posLight.z / posLight.w) - SHADOW_EPSILON; //-->make it a bit closer, only use if no way to use _proper_ depth bias etc
				
    // transform to texel space
    vec2 texelpos = g_iShadowMapSize * shadowTexCoord;
        
    // Determine the mix amounts           
    vec2 mixs = fract( texelpos );

    //read in bimix stamp, doing the shadow checks
    float sourcevals[4];
    float oneTexel = 1.0/g_iShadowMapSize;
    
    sourcevals[0] = (texture2D( g_sSamplerZero, shadowTexCoord ).r < shadowTestDepth)? 0.0: 1.0;  
    sourcevals[1] = (texture2D( g_sSamplerZero, shadowTexCoord + vec2(oneTexel, 0) ).r < shadowTestDepth)? 0.0: 1.0;  
    sourcevals[2] = (texture2D( g_sSamplerZero, shadowTexCoord + vec2(0, oneTexel) ).r < shadowTestDepth)? 0.0: 1.0;  
    sourcevals[3] = (texture2D( g_sSamplerZero, shadowTexCoord + vec2(oneTexel, oneTexel) ).r < shadowTestDepth)? 0.0: 1.0;  
        
    // mix between the shadow values to calculate our light amount
    float lightAmount = mix( mix( sourcevals[0], sourcevals[1], mixs.x ),
                                mix( sourcevals[2], sourcevals[3], mixs.x ),
                                mixs.y );

	return lightAmount;                                                       
}

float getLightAmountVSM( in vec4 posLight, in vec3 posWorld )
{
	vec2 shadowTexCoord = posLight.xy / posLight.w;
	
	// Lookup assumes Bil. filtering supported on the float textures
	#ifdef HKG_NO_FLOATBLENDING 
	
		vec2 texelpos = g_iShadowMapSize * shadowTexCoord;
		vec2 mixs = fract( texelpos );
		vec4 sourcevals[4];
		float oneTexel = 1.0/g_iShadowMapSize;
	    
		sourcevals[0] = texture2D( g_sSamplerZero, shadowTexCoord );  
		sourcevals[1] = texture2D( g_sSamplerZero, shadowTexCoord + vec2(oneTexel, 0) );  
		sourcevals[2] = texture2D( g_sSamplerZero, shadowTexCoord + vec2(0, oneTexel) );  
		sourcevals[3] = texture2D( g_sSamplerZero, shadowTexCoord + vec2(oneTexel, oneTexel) );  
	        
		// mix between the shadow values to calculate our light amount
		vec4 moments = mix( mix( sourcevals[0], sourcevals[1], mixs.x ),
									mix( sourcevals[2], sourcevals[3], mixs.x ),
									mixs.y );

	#else
	
	   vec4 moments = texture2D(g_sSamplerZero, shadowTexCoord);

	#endif

	// Rescale light distance and check if we're in shadow
	
	vec3 lightDir = g_vLightShadowStartPos.xyz - posWorld ;
	float distFromLight = dot(lightDir,g_vLightDir.xyz); 
	float rescaledDistToLight = distFromLight / g_fShadowMapDistance; 
	rescaledDistToLight -= g_fShadowVsmBias; 
	bool litFactor = (moments.x > 0.9999) || (moments.x > rescaledDistToLight); // || (moments.x > 0.95); // if moment.x (depth) > rescaled, then not in shadow. May add check here for detecting 'off the edge of map'(always lit in our demos)
	
	// Variance shadow mapping
	float E_x2 = moments.a; // Use lumancealpha (so R and A) or RGBA, so alpha holds the second part 
	float Ex_2 = moments.r * moments.r;
	float variance = max(E_x2 - Ex_2, 0.0) + g_fShadowVsmEpsilon;
	variance = min(variance, 1.0);
	float m_d = (moments.x - rescaledDistToLight);
	float p = variance / (variance + (m_d * m_d));

	return max(float(litFactor), p);
}
	
// Pixel shader to use a float based shadow map, will modulate with vertex lit color 
// (does not do per pixel lighting, uses vertex color)	
#ifdef ENTRYPOINT_PixShadowSceneT0
varying HIGHP vec4 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main()
{
    #ifdef HKG_SHADOWS_VSM 
		float lightAmount = getLightAmountVSM( VOutTexCoord2 /*posLight*/,  VOutTexCoord3.xyz /*posWorld*/ );
   #else
		float lightAmount = getLightAmountNoHW( VOutTexCoord2 /*posLight*/ ); 
	#endif
	
	gl_FragColor.rgb = (1.0-lightAmount)*VOutColor0.rgb*0.3 + lightAmount*VOutColor0.rgb + (lightAmount * VOutColor1.rgb); // modulate rgb wrt shadow.
    gl_FragColor.a = VOutColor0.a; // modulate alpha as is, shadow doesn't affect it.

}
#endif

// Pixel shader to use a float based shadow map, will modulate with vertex lit color 
// (does not do per pixel lighting, uses vertex color)
#ifdef ENTRYPOINT_PixShadowSceneT1
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec4 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main()
{
    #ifdef HKG_SHADOWS_VSM 
		float lightAmount = getLightAmountVSM( VOutTexCoord2 /*posLight*/,  VOutTexCoord3.xyz /*posWorld*/);
 	#else
		float lightAmount = getLightAmountNoHW( VOutTexCoord2 /*posLight*/ ); 
	#endif
	
	vec4 texel = texture2D( g_sSamplerOne,  VOutTexCoord0.xy );
	texel.rgb *= VOutColor0.rgb;
    gl_FragColor.rgb = (1.0-lightAmount)*texel.rgb*0.3 + lightAmount*texel.rgb + (lightAmount * VOutColor1.rgb); // modulate rgb wrt shadow.
    gl_FragColor.a = texel.a * VOutColor0.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

// Pixel shader to use a float based shadow map, will modulate with vertex lit color 
// (does not do per pixel lighting, uses vertex color)
#ifdef ENTRYPOINT_PixShadowSceneT2
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main()
{
    #ifdef HKG_SHADOWS_VSM
		float lightAmount = getLightAmountVSM( VOutTexCoord2 /*posLight*/, VOutTexCoord3.xyz /*posWorld*/ );
 	#else
		float lightAmount = getLightAmountNoHW( VOutTexCoord2 /*posLight*/ ); 
	#endif
	
//	vec4 diffuse = vec4(((1 - lightAmount)*g_cAmbientColor.rgb),1) + (lightAmount * VOutColor0.rgba);
	vec4 texel0 = texture2D( g_sSamplerOne,  VOutTexCoord0.xy);
    vec4 texel1 = texture2D( g_sSamplerTwo,  VOutTexCoord1.xy);
    vec3 texelTotal = (texel0.rgb * texel1.rgb) * VOutColor0.rgb;    
    gl_FragColor.rgb = (1.0-lightAmount)*texelTotal*0.3 + lightAmount*texelTotal.rgb + (lightAmount * VOutColor1.rgb); // modulate rgb wrt shadow.
    gl_FragColor.a = texel0.a * VOutColor0.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1Bump
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;
varying HIGHP vec4 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
varying HIGHP vec3 VOutTexCoord4;
varying HIGHP vec3 VOutTexCoord5;
varying MEDIUMP vec4 VOutColor0;
varying MEDIUMP vec4 VOutColor1;
void main()
{
    #ifdef HKG_SHADOWS_VSM
		float lightAmount = getLightAmountVSM( VOutTexCoord2 /*posLight*/, VOutTexCoord3.xyz /*posWorld*/ );
  #else
		float lightAmount = getLightAmountNoHW( VOutTexCoord2 /*posLight*/ ); 
	#endif
		
    vec4 colorMap = texture2D(g_sSamplerOne, VOutTexCoord0.xy);
	vec3 N = texture2D(g_sSamplerTwo,  VOutTexCoord0.xy).xyz * 2.0 - 1.0;

	N = normalize(N);

	float NdotL = dot(N, VOutTexCoord4.xyz);
	float NdotH = dot(N, VOutTexCoord5.xyz);
	vec4 light = lightAmount * Phong(vec2(NdotL, NdotH));
	
	gl_FragColor.rgb = g_cAmbientColor.rgb*colorMap.rgb +light.rgb*g_cDiffuseColor.rgb*colorMap.rgb + light.w*g_cSpecularColor.rgb ;
	gl_FragColor.a = colorMap.a * g_cDiffuseColor.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
