/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifdef HKG_OGLES2
#	define LOWP lowp
#	define MEDIUMP mediump
#	define HIGHP highp
precision mediump int;
precision highp float;

#else
#	define LOWP 
#	define MEDIUMP 
#	define HIGHP 
#endif

#define MAX_MATRICES 20
uniform HIGHP mat4x4  g_mLocalMatrixArray[MAX_MATRICES]; // a row is wasted here per matrix, todo: use mat4x3

uniform HIGHP mat4    g_mWorld;
uniform HIGHP mat4    g_mWorldViewProj;
uniform HIGHP mat4    g_mWorldInvTranspose;

// support for one dir light
uniform HIGHP vec3 g_vLightDir;
uniform LOWP  vec3 g_cLightColor;

// support for diffuse mat
uniform LOWP vec4 g_cAmbientColor;
uniform LOWP vec4 g_cDiffuseColor;

// Support for one diffuse tex at time, no shadows
uniform sampler2D g_sSamplerZero;   

#ifdef ENTRYPOINT_mainVS
attribute HIGHP vec4 InPosition;
attribute HIGHP vec3 InNormal;
attribute HIGHP vec4 InBlendIndices;
attribute HIGHP vec3 InBlendWeights;
attribute HIGHP vec2 InTexCoord0;
varying HIGHP vec2 VOutTexCoord0;
varying MEDIUMP vec4 VOutColor0;
void main()
{
    ivec4 indices = ivec4(InBlendIndices);
    
	// 4 bones
	vec4 Pos = (g_mLocalMatrixArray[indices.x] * InPosition ) * InBlendWeights.x;
    vec3 Normal = (mat3(g_mLocalMatrixArray[indices.x]) * InNormal) * InBlendWeights.x;
    
	Pos += (g_mLocalMatrixArray[indices.y] * InPosition) * InBlendWeights.y;
    Normal += (mat3(g_mLocalMatrixArray[indices.y]) * InNormal) * InBlendWeights.y;
    
    Pos += (g_mLocalMatrixArray[indices.z] * InPosition) * InBlendWeights.z;
    Normal += (mat3(g_mLocalMatrixArray[indices.z]) * InNormal) * InBlendWeights.z;
 
	float LastWeight = 1.0f;; - InBlendWeights.x - InBlendWeights.y - InBlendWeights.z; 
    Pos += (g_mLocalMatrixArray[indices.w] * InPosition) * LastWeight;
    Normal += (mat3(g_mLocalMatrixArray[indices.w]) * InNormal) * LastWeight;

	// transform position from world space into view and then projection space
    gl_Position = g_mWorldViewProj * Pos;

    // normalize normals
    Normal = mat3(g_mWorldInvTranspose) * Normal.xyz;
    Normal = normalize(Normal);

    // Shade (Ambient + etc.)
    vec3 diffuseLight = max(0.0f, dot(Normal, g_vLightDir.xyz)) * g_cLightColor;
 
    VOutColor0.rgb = g_cAmbientColor.rgb + ( diffuseLight.rgb * g_cDiffuseColor.rgb );
    VOutColor0.a = g_cDiffuseColor.a;
    
    // copy the input texture coordinate through
    VOutTexCoord0 = InTexCoord0;
}
#endif

#ifdef ENTRYPOINT_mainPS
varying HIGHP vec2 VOutTexCoord0;
varying MEDIUMP vec4 VOutColor0;
void main() 
{ 
    gl_FragColor.rgba = texture2D(g_sSamplerZero, VOutTexCoord0) * VOutColor0; 
}
#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
