/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#include <Demos/demos.h>

#include <Physics/Dynamics/Phantom/hkpPhantom.h>
#include <Common/Visualize/hkDebugDisplay.h>

#include <Demos/Physics/UseCase/TriggerVolume/TriggerVolumeComparison/TriggerVolumeComparisonDemo.h>

TriggerVolumeComparisonDemo::DemoPhantomCallbackShape::DemoPhantomCallbackShape()
: hkpPhantomCallbackShape()
{
	// Set colours
	m_colourHit   = hkColor::semiTransparent( hkColor::RED );
	m_colourNoHit = hkColor::semiTransparent( hkColor::GREEN );

	// Initialize result data
	m_resultBits = new hkBitField(14);
	m_resultBits->assignAll(0);
	m_lastEnterEvent = 0;
	m_lastLeaveEvent = 0;
}

TriggerVolumeComparisonDemo::DemoPhantomCallbackShape::~DemoPhantomCallbackShape()
{
	delete m_resultBits;
}

void TriggerVolumeComparisonDemo::DemoPhantomCallbackShape::phantomEnterEvent( const hkpCollidable* phantomColl, const hkpCollidable* otherColl, const hkpCollisionInput& env )
{
	// Register collision in result bitField
	TriggerVolumeComparisonDemo::EntityType volTypeID = ENTITY_TYPE_INVALID;
	hkpRigidBody* rb = hkpGetRigidBody( otherColl );
	hkpPhantom* ph = hkpGetPhantom( otherColl );
	if ( rb != HK_NULL )
	{
		volTypeID = (TriggerVolumeComparisonDemo::EntityType)rb->getUserData();
	}
	if ( ph != HK_NULL )
	{
		volTypeID = (TriggerVolumeComparisonDemo::EntityType)ph->getUserData();
	}
	addResultToBitField( volTypeID, COLLISION_PHASE_NARROWPHASE, m_resultBits );

	// Set timestamp
	m_lastEnterEvent = reinterpret_cast<hkpWorld*>(m_userData)->getCurrentTime();

	// Change colour
	hkpRigidBody* owner = hkpGetRigidBody( phantomColl );
	HK_SET_OBJECT_COLOR((hkUlong)owner->getCollidable(), m_colourHit);
}

void TriggerVolumeComparisonDemo::DemoPhantomCallbackShape::phantomLeaveEvent( const hkpCollidable* phantomColl, const hkpCollidable* otherColl )
{
	// Set timestamp
	m_lastLeaveEvent = reinterpret_cast<hkpWorld*>(m_userData)->getCurrentTime();

	// Change colour
	hkpRigidBody* owner = hkpGetRigidBody(phantomColl);
	HK_SET_OBJECT_COLOR((hkUlong)owner->getCollidable(), m_colourNoHit);
}

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
