/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */

#ifndef HK_STAIRCLIMBING_RB_DEMO_H
#define HK_STAIRCLIMBING_RB_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>

extern const class hkClass StairClimbingRbDemoOptionsClass;

class hkLoader;
class hkpShape;
class hkpCharacterRigidBody;
class hkpCharacterContext;

class StairClimbingRbDemo : public hkDefaultPhysicsDemo
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		StairClimbingRbDemo( hkDemoEnvironment* env );
		~StairClimbingRbDemo();
		virtual hkDemo::Result stepDemo();

		struct Options
		{
			HK_DECLARE_REFLECTION();

			Options()
			:	m_worldCollisionTolerance( 0.1f ),
				m_characterCylinderHeight( 0.8f	),
				m_characterRadius( 0.6f ),
				m_allowedPenetrationDepth( -0.1f ),
				m_supportDistance( 0.1f ),
				m_hardSupportDistance( 0.0f ),
				m_maxSlope( HK_REAL_PI * 0.333f ),
				m_numStaircases( 5 ),
				m_numStepsStart( 5 ),
				m_numStepsIncrement( 4 ),
				m_stairsRun( 5.0f ),
				m_stairsRise( 3.0f ),
				m_stepConvexRadius( hkConvexShapeDefaultRadius )
			{
			}
			
			hkReal m_worldCollisionTolerance; //+default(0.1f) +absmin(0.0) +absmax(1.0f)
				/// The tolerance used by the demo tolerance hack.
			hkReal m_characterCylinderHeight; //+default(0.8f) +absmin(0.1f) +absmax(20.0f)
			hkReal m_characterRadius; //+default(0.6f) +absmin(0.1f) +absmax(20.0f)
			hkReal m_allowedPenetrationDepth; //+default(-0.1f) +absmin(-5.0f) +absmax(5.0f)
			hkReal m_supportDistance; //+default(0.1f) +absmin(0.0) +absmax(1.0f)
			hkReal m_hardSupportDistance; //+default(0.0f) +absmin(-0.1f) +absmax(1.0f)
			hkReal m_maxSlope; //+default(1.05f) +absmin(0.5f) +absmax(1.57f)
			int m_numStaircases; //+default(5) +absmin(2) +absmax(20)
			int m_numStepsStart; //+default(5) +absmin(2) +absmax(40)
			int m_numStepsIncrement; //+default(4) +absmin(1) +absmax(40)
				/// The angle at which to tilt the left half of the floor in radians.
			hkReal m_stairsRun; //+default(5.f) +absmin(0.5f) +absmax(20.f)
			hkReal m_stairsRise; //+default(3.f) +absmin(0.5f) +absmax(20.f)
			hkReal m_stepConvexRadius; //+default(0.05f) +absmin(0.0) +absmax(1.0)
		};

		DEMO_OPTIONS_DECLARE(Options);
 
	private:
		hkLoader* m_loader;

		hkpShape* m_standShape;
		hkpShape* m_newShape;

		hkpCharacterRigidBody* m_characterRigidBody;
		hkpCharacterContext* m_characterContext;
		static void HK_CALL getUserInputForCharacter( hkDemoEnvironment* env, float& posX, float& posY, hkBool& wantJump );

		hkInt32 m_supportHistory;
};

#endif // HK_TESTING_TOLERANCES_H

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
