/* 
 * 
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Level 2 and Level 3 source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2010 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 * 
 */


#ifndef HK_BroadphaseAddRemoveDemo_H
#define HK_BroadphaseAddRemoveDemo_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

class BroadphaseAddRemoveDemo : public hkDefaultPhysicsDemo
{

public:

	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	enum BroadphaseConfig
	{
		NONE,
		KD_TREE,
		HYBRID
	};

	struct Variant
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO,Variant);

		const char*			m_name;
		const char*			m_details;
		BroadphaseConfig	m_broadphase;
		int					m_maxObjects;
		hkReal				m_damping;
		hkBool				m_mixedShape;
		hkBool				m_stopWhenFull;
	};			

		BroadphaseAddRemoveDemo(hkDemoEnvironment* env);
		~BroadphaseAddRemoveDemo();

		Result stepDemo();
		void	spawnFirework();
		void	flushFirework();

	protected:
		const Variant*				m_variant;
		hkArray<hkpRigidBody*>		m_bodies;
		hkPseudoRandomGenerator		m_rndgen;
		BroadphaseConfig			m_bpConfig;
		hkpShape*					m_shapes[2];
		int							m_count;
		int							m_maxbodies;
		bool						m_useBatch;
		bool						m_draw;
		bool						m_stop;
};

#endif

/*
* Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20101115)
* 
* Confidential Information of Havok.  (C) Copyright 1999-2010
* Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
* Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
* rights, and intellectual property rights in the Havok software remain in
* Havok and/or its suppliers.
* 
* Use of this software for evaluation purposes is subject to and indicates
* acceptance of the End User licence Agreement for this product. A copy of
* the license is included with this software and is also available at www.havok.com/tryhavok.
* 
*/
